# Geo-Ranking Tables WordPress Plugin - Complete Package

## 🎯 What This Plugin Does

This WordPress plugin creates **geo-targeted ranking tables for gambling sites** that automatically filter based on the user's location. Perfect for affiliate marketing and gambling review sites.

### Key Features:
- ✅ **Site Blocks**: Manage gambling sites with ratings, descriptions, and accepted states
- ✅ **Gutenberg Integration**: Easy-to-use blocks for creating ranking tables
- ✅ **Geo-Filtering**: Automatic IP-based location detection
- ✅ **Responsive Design**: Beautiful tables that work on all devices
- ✅ **Admin Dashboard**: Complete management interface
- ✅ **Fallback System**: Handle users from restricted locations

## 📁 Plugin Structure

```
geo-ranking-tables/
├── geo-ranking-tables.php          # Main plugin file
├── README.md                       # Documentation
├── includes/                       # Core functionality
│   ├── class-site-blocks.php       # Site management
│   ├── class-table-blocks.php      # Gutenberg blocks
│   ├── class-admin.php             # Admin interface
│   ├── class-frontend.php          # Frontend display
│   ├── class-geo-detector.php      # Location detection
│   └── sample-data.php             # Sample data creation
└── assets/                         # CSS/JS files
    ├── css/
    │   ├── frontend.css             # Public styles
    │   └── admin.css                # Admin styles
    └── js/
        ├── frontend.js              # Public JavaScript
        ├── block-editor.js          # Gutenberg block
        └── admin.js                 # Admin JavaScript
```

## 🚀 Installation Instructions

### Step 1: Upload Plugin
1. Copy the entire `geo-ranking-tables` folder to `/wp-content/plugins/`
2. Activate the plugin in WordPress admin under **Plugins > Installed Plugins**

### Step 2: Initial Setup
1. Go to **Geo Rankings** in your WordPress admin menu
2. Click **Create Sample Data** to add 10 demo gambling sites
3. Go to **Geo Rankings > Settings** to configure (optional API key)

### Step 3: Create Your First Table
1. Edit any page in Gutenberg editor
2. Add **Geo Ranking Table** block
3. Select which sites to include
4. Configure display options
5. Publish the page

## 🎮 How It Works

### For Site Owners:
1. **Create Site Blocks**: Add gambling sites with details like ratings, bonuses, accepted states
2. **Build Tables**: Use Gutenberg blocks to create ranking tables on any page
3. **Configure Display**: Choose what information to show (ratings, bonuses, licenses)

### For Visitors:
1. **Automatic Detection**: Plugin detects user's location via IP
2. **Filtered Results**: Only shows gambling sites available in their state
3. **Responsive Display**: Beautiful, mobile-friendly ranking tables
4. **Fallback Handling**: Shows appropriate message if no sites available

## 🔧 Configuration Options

### Site Block Fields:
- Site Name
- Description
- Star Rating (0-5)
- Accepted States (US state selection)
- Affiliate Link
- Bonus Information
- License Information

### Table Block Settings:
- Table Name/Title
- Maximum sites to display
- Show/hide ratings
- Show/hide bonus info
- Show/hide license info
- Site selection

### Plugin Settings:
- IP Geolocation API Key (optional)
- Cache duration for location data
- Fallback table options

## 🌍 Geo-Location Features

### IP Detection Services:
1. **IP-API.com** (Free, no key required)
2. **IPInfo.io** (Free tier)
3. **IPGeolocation.io** (Free with API key - recommended)

### Location Caching:
- Caches location data for 1 hour by default
- Reduces API calls and improves performance
- Configurable cache duration (5 minutes to 24 hours)

## 💡 Example Use Cases

### Scenario 1: Sports Betting Review Site
- Create site blocks for major sportsbooks
- Set accepted states for each (NJ, PA, MI, etc.)
- User from New Jersey sees only NJ-licensed sites
- User from Utah sees "not available" message

### Scenario 2: Casino Affiliate Site
- Add 20+ online casinos as site blocks
- Create separate tables for different categories
- "Best Slots Sites", "Live Dealer Casinos", etc.
- Each table filters by user location automatically

### Scenario 3: Multi-State Comparison
- Compare gambling options across states
- Show availability and licensing info
- Track clicks for affiliate commissions
- Responsive design for mobile users

## 🎨 Customization

### CSS Classes Available:
```css
.grt-ranking-table-wrapper  /* Main container */
.grt-table-header           /* Title and location info */
.grt-site-row              /* Individual site row */
.grt-site-name             /* Site name styling */
.grt-stars                 /* Star ratings */
.grt-visit-site-btn        /* Action button */
```

### JavaScript Hooks:
```javascript
// Refresh all tables
window.grtRefreshTables();

// Custom tracking
grt.trackClick(rank, siteName, url);
```

## 🔒 Security & Performance

- ✅ All inputs sanitized and validated
- ✅ CSRF protection with WordPress nonces
- ✅ Capability checks for admin functions
- ✅ Efficient database queries
- ✅ Conditional script loading
- ✅ Location data caching

## 📊 Database Structure

### Custom Tables Created:
- `wp_grt_sites`: Site block data
- `wp_grt_table_blocks`: Table configurations

### WordPress Integration:
- Custom post type: `grt_site_block`
- Custom meta fields for all site data
- Gutenberg block registration
- Admin menu integration

## 🐛 Troubleshooting

### Common Issues:

**Location not detected?**
- Check server allows outbound HTTP requests
- Verify API key if using IPGeolocation.io
- Check browser console for errors

**Sites not showing?**
- Ensure site blocks are published
- Check state selection matches user location
- Verify block configuration

**Block not appearing?**
- Ensure Gutenberg is enabled
- Check for JavaScript conflicts
- Clear browser cache

## 📈 Performance Tips

1. **Use API Key**: Get free IPGeolocation.io key for better accuracy
2. **Optimize Cache**: Adjust cache duration based on traffic
3. **Limit Sites**: Don't add more sites than needed per table
4. **Image Optimization**: Use properly sized logos/images

## 🎯 Next Steps

After installation, you can:

1. **Customize Styling**: Modify CSS to match your theme
2. **Add More Sites**: Expand your gambling site database
3. **Create Multiple Tables**: Different categories (slots, poker, sports)
4. **Track Performance**: Monitor which sites get clicked
5. **Optimize for SEO**: Add rich snippets and structured data

## 💼 Business Applications

Perfect for:
- Gambling affiliate sites
- Casino review platforms
- Sports betting comparison sites
- Multi-state gambling guides
- Regulatory compliance tools

---

**Ready to get started?** Upload the plugin files, activate, and click "Create Sample Data" to see it in action! 🚀