<?php
/**
 * GS Theme Template
 * GamblingSite.com style card layout replicating ftm-td homepage table design
 */

if (!defined('ABSPATH')) {
    exit;
}

class GRT_Theme_GSTheme extends GRT_Theme_Template {

    /**
     * Render a site row (card)
     *
     * @param array $site Site data
     * @param int $index Site index (0-based)
     * @param array $config Table configuration
     * @return string HTML output
     */
    public function render_site_row($site, $index, $config) {
        $rank = $index + 1;
        $show_ratings = isset($config['showRatings']) ? $config['showRatings'] : true;
        $show_bonuses = isset($config['showBonuses']) ? $config['showBonuses'] : true;
        $is_first = ($rank === 1);

        ob_start();
        ?>
        <div class="gs-site<?php echo $is_first ? ' gs-site-first' : ''; ?>" data-rank="<?php echo $rank; ?>" data-site-id="<?php echo esc_attr($site['id']); ?>">
            <?php if (!empty($site['affiliate_link'])): ?>
                <a href="<?php echo esc_url($site['affiliate_link']); ?>" target="_blank" rel="noopener noreferrer nofollow sponsored" class="gs-site-overlay"> </a>
            <?php endif; ?>

            <div class="gs-site-rank">#<?php echo $rank; ?></div>

            <div class="gs-site-logo">
                <?php echo $this->render_logo($site); ?>
            </div>

            <div class="gs-site-bonus">
                <?php if ($show_bonuses && !empty($site['bonus_info'])): ?>
                    <p><?php _e('Welcome Bonus', 'geo-ranking-tables'); ?></p>
                    <p><?php echo esc_html($site['bonus_info']); ?></p>
                <?php endif; ?>
            </div>

            <div class="gs-site-rating">
                <?php if (!empty($site['certified_badge'])): ?>
                    <div class="gs-rating-image">
                        <img src="<?php echo esc_url($site['certified_badge']); ?>" alt="<?php _e('Certified Stamp', 'geo-ranking-tables'); ?>" width="110" height="85" />
                    </div>
                <?php endif; ?>

                <?php if ($show_ratings && $site['rating'] > 0): ?>
                    <div class="gs-rating-stars">
                        <?php echo $this->render_percentage_stars($site['rating']); ?>
                    </div>
                <?php endif; ?>
            </div>

            <div class="gs-site-links">
                <?php if (!empty($site['affiliate_link'])): ?>
                    <a href="<?php echo esc_url($site['affiliate_link']); ?>" target="_blank" class="gs-visit-btn" rel="nofollow noopener">
                        <?php _e('Play Now', 'geo-ranking-tables'); ?>
                    </a>
                <?php endif; ?>

                <?php if (!empty($site['review_link'])): ?>
                    <a href="<?php echo esc_url($site['review_link']); ?>" class="gs-review-link">
                        <?php _e('Read Review', 'geo-ranking-tables'); ?>
                    </a>
                <?php endif; ?>
            </div>

            <div class="gs-site-pros">
                <?php if (!empty($site['pros']) && is_array($site['pros'])): ?>
                    <?php echo $this->render_pros_list_icons($site); ?>
                <?php endif; ?>
            </div>

            <div class="gs-site-cons">
                <?php if (!empty($site['cons']) && is_array($site['cons'])): ?>
                    <?php echo $this->render_cons_list_icons($site); ?>
                <?php endif; ?>
            </div>

            <div class="gs-site-keyfacts">
                <?php echo $this->render_key_facts_inline($site); ?>
            </div>

            <?php echo $this->render_disclaimer($site); ?>
        </div>
        <?php
        return ob_get_clean();
    }

    /**
     * Render the table header
     *
     * @param array $config Table configuration
     * @return string HTML output
     */
    public function render_table_header($config) {
        ob_start();
        ?>
        <div class="gs-header">
            <div class="gs-how-rate">
                <div class="gs-how-text"><?php _e('How We Rate', 'geo-ranking-tables'); ?></div>
                <div class="gs-trust-factor gs-icon-shield">
                    <p>
                        <span><?php _e('Safety & Security', 'geo-ranking-tables'); ?></span>
                        <?php _e('When reviewing online gambling apps, safety and security are paramount. This evaluation includes ensuring that the app operates under a legitimate gaming license, indicating regulatory oversight and legal operation. The app\'s security measures are scrutinized, focusing on the protection of user data and financial transactions, typically involving encryption technologies and secure payment methods. We also assess the app\'s commitment to responsible gambling practices, such as providing tools for self-exclusion and setting betting limits.', 'geo-ranking-tables'); ?>
                    </p>
                </div>
                <div class="gs-trust-factor gs-icon-gauge">
                    <p>
                        <span><?php _e('Payout Speed', 'geo-ranking-tables'); ?></span>
                        <?php _e('When ranking the best gambling apps, payout speed stands as a crucial factor. Quick access to winnings is not just a convenience but a significant marker of an app\'s reliability and customer service quality. We meticulously analyze each app\'s payout timelines, differentiating those that offer lightning-fast withdrawals from those that lag. This evaluation involves examining user feedback, testing transaction speeds firsthand, and verifying with the apps\' customer support teams. Our focus is on presenting you with options where you can enjoy your winnings almost as fast as you earn them, ensuring a seamless and satisfying gambling experience.', 'geo-ranking-tables'); ?>
                    </p>
                </div>
                <div class="gs-trust-factor gs-icon-star">
                    <p>
                        <span><?php _e('Features', 'geo-ranking-tables'); ?></span>
                        <?php _e('The evaluation of an app\'s features is a key aspect and includes examining the variety and quality of games offered, such as slots, table games, and live dealer options. User interface and experience are critically assessed for ease of navigation, speed, and overall aesthetics. We also consider the availability and functionality of mobile compatibility, ensuring a seamless experience across different devices. The presence of additional features like in-app support, customizable settings, and social interaction tools are evaluated for enhancing user engagement.', 'geo-ranking-tables'); ?>
                    </p>
                </div>
                <div class="gs-trust-factor gs-icon-dollar">
                    <p>
                        <span><?php _e('Bonuses', 'geo-ranking-tables'); ?></span>
                        <?php _e('We closely analyze the types and generosity of bonuses offered, including welcome bonuses, free spins, loyalty rewards, and special promotions. The focus is not just on the size of the bonuses but also on their accessibility and the fairness of their terms and conditions, such as wagering requirements, time limits, and game restrictions. We consider how these bonuses add value to the user experience and whether they cater to both new and existing players. The clarity and transparency of the bonus terms are also assessed to ensure users can understand and utilize these offers effectively.', 'geo-ranking-tables'); ?>
                    </p>
                </div>
            </div>
        </div>
        <div class="gs-body-wrapper">
            <div class="gs-body-header">
                <div class="gs-tab active"><?php _e('Best Overall', 'geo-ranking-tables'); ?></div>
            </div>
            <div class="gs-sites-container">
        <?php
        return ob_get_clean();
    }

    /**
     * Render the table footer
     *
     * @param array $config Table configuration
     * @return string HTML output
     */
    public function render_table_footer($config) {
        ob_start();
        ?>
            </div><!-- .gs-sites-container -->
            <div class="gs-footer">
                <a href="/reviews/"><?php _e('See All Reviews', 'geo-ranking-tables'); ?></a>
            </div>
        </div><!-- .gs-body-wrapper -->
        <?php
        return ob_get_clean();
    }

    /**
     * Render percentage-based star rating (overlay technique)
     *
     * @param float $rating Rating value (0-5)
     * @return string HTML output
     */
    protected function render_percentage_stars($rating) {
        $percentage = ($rating / 5) * 100;

        ob_start();
        ?>
        <div class="gs-star-over" style="width: <?php echo esc_attr($percentage); ?>%"></div>
        <div class="gs-star-under"></div>
        <?php
        return ob_get_clean();
    }

    /**
     * Render pros list with icon font classes
     *
     * @param array $site Site data
     * @return string HTML output
     */
    protected function render_pros_list_icons($site) {
        if (empty($site['pros']) || !is_array($site['pros'])) {
            return '';
        }

        ob_start();
        ?>
        <ul class="gs-pro-list">
            <?php foreach ($site['pros'] as $pro): ?>
                <li class="icon-ok-circled"><?php echo esc_html($pro); ?></li>
            <?php endforeach; ?>
        </ul>
        <?php
        return ob_get_clean();
    }

    /**
     * Render cons list with icon font classes
     *
     * @param array $site Site data
     * @return string HTML output
     */
    protected function render_cons_list_icons($site) {
        if (empty($site['cons']) || !is_array($site['cons'])) {
            return '';
        }

        ob_start();
        ?>
        <ul class="gs-con-list">
            <?php foreach ($site['cons'] as $con): ?>
                <li class="icon-cancel-circled"><?php echo esc_html($con); ?></li>
            <?php endforeach; ?>
        </ul>
        <?php
        return ob_get_clean();
    }

    /**
     * Render key facts section in inline format
     *
     * @param array $site Site data
     * @return string HTML output
     */
    protected function render_key_facts_inline($site) {
        $has_facts = !empty($site['payout_speed']) || !empty($site['compatibility']) || !empty($site['payout_percentage']);

        if (!$has_facts) {
            return '';
        }

        ob_start();
        ?>
        <p><?php _e('Key Facts:', 'geo-ranking-tables'); ?></p>
        <div class="gs-keyfacts-details">
            <?php if (!empty($site['payout_speed'])): ?>
                <p><strong><?php _e('Payout Speed:', 'geo-ranking-tables'); ?></strong> <?php echo esc_html($site['payout_speed']); ?></p>
            <?php endif; ?>

            <?php if (!empty($site['compatibility']) && is_array($site['compatibility'])): ?>
                <p><strong><?php _e('Compatibility:', 'geo-ranking-tables'); ?></strong> <?php echo esc_html($this->format_compatibility($site['compatibility'])); ?></p>
            <?php endif; ?>

            <?php if (!empty($site['payout_percentage'])): ?>
                <p><strong><?php _e('Payout Percentage:', 'geo-ranking-tables'); ?></strong> <?php echo esc_html($site['payout_percentage']); ?></p>
            <?php endif; ?>
        </div>
        <?php
        return ob_get_clean();
    }
}
