# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.

## Plugin Overview

Geo-Ranking Tables is a WordPress plugin that creates geo-targeted ranking tables for gambling sites. It automatically filters displayed sites based on the user's detected US state location via IP geolocation.

## Architecture

### Core Plugin Structure

- **geo-ranking-tables.php** - Main plugin file, singleton pattern `GeoRankingTables` class
  - Registers custom post types (`grt_site_block`, `grt_managed_table`)
  - Registers the Gutenberg block `geo-ranking-tables/ranking-table`
  - Provides template functions: `grt_display_table()`, `grt_get_table()`, `grt_display_table_by_slug()`, `grt_get_table_by_slug()`

### PHP Classes (includes/)

| Class | Purpose |
|-------|---------|
| `GRT_SiteBlocks` | Manages gambling site entries (CPT with meta boxes for ratings, states, affiliate links) |
| `GRT_TableBlocks` | Handles Gutenberg block editor integration and AJAX filtering |
| `GRT_ManagedTables` | Centralized table configurations stored as a CPT, reusable across pages |
| `GRT_TableRenderer` | Unified rendering engine for both block and shortcode output |
| `GRT_GeoDetector` | IP-based location detection using multiple API services (ip-api.com, ipinfo.io, ipgeolocation.io) |
| `GRT_Admin` | Admin dashboard, settings page, and troubleshooting tools |
| `GRT_Frontend` | Frontend asset loading |

### JavaScript Files (assets/js/)

- **block-editor.js** - Gutenberg block registration and editor UI
- **frontend.js** - Client-side geo-detection and AJAX table population
- **admin.js** - Admin dashboard functionality (sample data management)

### Data Flow

1. Page loads with `grt-ranking-table-wrapper` containers
2. `frontend.js` detects user location via AJAX (`grt_detect_location` action)
3. Location is used to filter sites via AJAX (`grt_get_filtered_sites` action)
4. HTML is populated client-side with geo-filtered results

### Two Table Modes

1. **Custom/Local Mode** - Sites selected directly in the Gutenberg block
2. **Managed Mode** - References a `grt_managed_table` post, allowing centralized table configuration

## Key Meta Fields

### Site Blocks (`grt_site_block`)
- `_grt_site_name` - Display name
- `_grt_star_rating` - Rating 0-5
- `_grt_states_accepted` - Array of US state codes (e.g., `['NJ', 'PA', 'MI']`)
- `_grt_affiliate_link`, `_grt_bonus_info`, `_grt_license_info`

### Managed Tables (`grt_managed_table`)
- `_grt_managed_sites` - Array of site post IDs
- `_grt_managed_max_display`, `_grt_managed_table_name`
- `_grt_managed_show_ratings`, `_grt_managed_show_bonuses`, `_grt_managed_show_licenses`, `_grt_managed_show_debug`
- `_grt_managed_slug` - URL-friendly identifier

## Testing Geo-Location

Use the `ftm-ip` URL parameter to force a specific IP for testing:
```
https://yoursite.com/page-with-table/?ftm-ip=8.8.8.8
```

This bypasses normal IP detection and queries the geo-API with the specified IP.

## AJAX Endpoints

| Action | Handler | Purpose |
|--------|---------|---------|
| `grt_detect_location` | `GRT_GeoDetector::ajax_detect_location` | Detect user's US state |
| `grt_get_filtered_sites` | `GRT_TableBlocks::ajax_get_filtered_sites` | Get sites for user's state |
| `grt_lookup_ip` | `GRT_Admin::ajax_lookup_ip` | Admin IP lookup tool |
| `grt_create_sample_data` | `GRT_Admin::ajax_create_sample_data` | Create demo sites |
| `grt_delete_sample_data` | `GRT_Admin::ajax_delete_sample_data` | Remove demo sites |

## Plugin Constants

- `GRT_PLUGIN_URL` - Plugin URL path
- `GRT_PLUGIN_PATH` - Plugin filesystem path
- `GRT_VERSION` - Current version string

## CSS Classes for Customization

- `.grt-ranking-table-wrapper` - Main container
- `.grt-table-header`, `.grt-table-title` - Header elements
- `.grt-site-row`, `.grt-site-name`, `.grt-stars` - Site row elements
- `.grt-visit-site-btn` - CTA button

## Database Tables

Plugin creates two tables on activation:
- `{prefix}grt_sites` - Site block data (legacy, CPT is primary)
- `{prefix}grt_table_blocks` - Table configurations (legacy, CPT is primary)
