<?php
/**
 * Review Style Theme Template
 * Card-based layout with pros/cons, key facts, and badges
 */

if (!defined('ABSPATH')) {
    exit;
}

class GRT_Theme_ReviewStyle extends GRT_Theme_Template {

    /**
     * Render a site row (card)
     *
     * @param array $site Site data
     * @param int $index Site index (0-based)
     * @param array $config Table configuration
     * @return string HTML output
     */
    public function render_site_row($site, $index, $config) {
        $rank = $index + 1;
        $show_ratings = isset($config['showRatings']) ? $config['showRatings'] : true;
        $show_bonuses = isset($config['showBonuses']) ? $config['showBonuses'] : true;

        ob_start();
        ?>
        <div class="grt-site-card" data-rank="<?php echo $rank; ?>" data-site-id="<?php echo esc_attr($site['id']); ?>">
            <?php if ($rank === 1): ?>
                <div class="grt-card-badge grt-badge-best"><?php _e('BEST OVERALL', 'geo-ranking-tables'); ?></div>
            <?php endif; ?>

            <div class="grt-card-rank">#<?php echo $rank; ?></div>

            <div class="grt-card-content">
                <div class="grt-card-logo">
                    <?php echo $this->render_logo($site); ?>
                </div>

                <div class="grt-card-middle">
                    <?php if (!empty($site['pros']) && is_array($site['pros'])): ?>
                        <div class="grt-card-pros">
                            <?php echo $this->render_pros_list($site); ?>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($site['cons']) && is_array($site['cons'])): ?>
                        <div class="grt-card-cons">
                            <?php echo $this->render_cons_list($site); ?>
                        </div>
                    <?php endif; ?>
                </div>

                <div class="grt-card-right">
                    <?php if (!empty($site['certified_badge'])): ?>
                        <div class="grt-certified-badge">
                            <img src="<?php echo esc_url($site['certified_badge']); ?>" alt="<?php _e('Certified', 'geo-ranking-tables'); ?>" />
                        </div>
                    <?php endif; ?>

                    <?php if ($show_ratings && $site['rating'] > 0): ?>
                        <div class="grt-card-rating">
                            <?php echo $this->render_star_rating($site['rating']); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="grt-card-footer">
                <?php echo $this->render_key_facts($site); ?>

                <div class="grt-card-bonus-section">
                    <?php if ($show_bonuses && !empty($site['bonus_info'])): ?>
                        <div class="grt-card-bonus">
                            <span class="grt-bonus-label"><?php _e('WELCOME BONUS', 'geo-ranking-tables'); ?></span>
                            <span class="grt-bonus-value"><?php echo esc_html($site['bonus_info']); ?></span>
                        </div>
                    <?php endif; ?>

                    <div class="grt-card-actions">
                        <?php if (!empty($site['affiliate_link'])): ?>
                            <a href="<?php echo esc_url($site['affiliate_link']); ?>" target="_blank" class="grt-play-now-btn" rel="nofollow noopener">
                                <?php _e('Play Now', 'geo-ranking-tables'); ?>
                            </a>
                        <?php endif; ?>

                        <?php if (!empty($site['review_link'])): ?>
                            <a href="<?php echo esc_url($site['review_link']); ?>" class="grt-read-review-link">
                                <?php _e('READ REVIEW', 'geo-ranking-tables'); ?>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>

                <?php echo $this->render_disclaimer($site); ?>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }

    /**
     * Render the table header
     *
     * @param array $config Table configuration
     * @return string HTML output
     */
    public function render_table_header($config) {
        $table_name = isset($config['tableName']) ? $config['tableName'] : __('Top Gambling Sites', 'geo-ranking-tables');

        ob_start();
        ?>
        <div class="grt-review-header">
            <div class="grt-header-top">
                <div class="grt-how-we-rate">
                    <span class="grt-rate-text"><?php _e('How We Rate', 'geo-ranking-tables'); ?></span>
                    <span class="grt-rate-icons">
                        <span class="grt-rate-icon grt-icon-shield" title="<?php _e('Security', 'geo-ranking-tables'); ?>">&#128274;</span>
                        <span class="grt-rate-icon grt-icon-chart" title="<?php _e('Performance', 'geo-ranking-tables'); ?>">&#128200;</span>
                        <span class="grt-rate-icon grt-icon-star" title="<?php _e('Rating', 'geo-ranking-tables'); ?>">&#9733;</span>
                        <span class="grt-rate-icon grt-icon-money" title="<?php _e('Value', 'geo-ranking-tables'); ?>">&#128176;</span>
                    </span>
                </div>
            </div>
            <div class="grt-location-info">
                <span class="grt-location-text">
                    <?php _e('Showing sites available in:', 'geo-ranking-tables'); ?>
                    <strong class="grt-user-location"><?php _e('Detecting location...', 'geo-ranking-tables'); ?></strong>
                </span>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }

    /**
     * Render the table footer
     *
     * @param array $config Table configuration
     * @return string HTML output
     */
    public function render_table_footer($config) {
        ob_start();
        ?>
        <div class="grt-review-footer">
            <a href="#" class="grt-see-all-reviews">
                <?php _e('See All Reviews', 'geo-ranking-tables'); ?>
            </a>
        </div>
        <?php
        return ob_get_clean();
    }
}
