
(function(blocks, element, components, blockEditor, i18n){
    var el = element.createElement;
    var __ = i18n.__;
    var TextControl = components.TextControl;
    var TextareaControl = components.TextareaControl;
    var RangeControl = components.RangeControl;
    var PanelBody = components.PanelBody;
    var ToggleControl = components.ToggleControl;
    var SelectControl = components.SelectControl;
    var ColorPicker = components.ColorPicker;
    var MediaUpload = blockEditor.MediaUpload;
    var MediaUploadCheck = blockEditor.MediaUploadCheck;
    var InspectorControls = blockEditor.InspectorControls;
    var Button = components.Button;

    // Starter presets (add more on request)
    var PRESETS = {
        MLB: {
            'Tampa Bay Rays': '#092C5C',
            'New York Yankees': '#0C2340',
            'Boston Red Sox': '#BD3039',
            'New York Mets': '#002D72',
            'Los Angeles Dodgers': '#005A9C',
            'Chicago Cubs': '#0E3386',
            'Atlanta Braves': '#CE1141',
            'Houston Astros': '#002D62',
            'San Francisco Giants': '#FD5A1E',
            'St. Louis Cardinals': '#C41E3A'
        },
        NFL: {
            'New England Patriots': '#002244',
            'Dallas Cowboys': '#041E42',
            'Green Bay Packers': '#203731',
            'Kansas City Chiefs': '#E31837',
            'San Francisco 49ers': '#AA0000',
            'Buffalo Bills': '#00338D',
            'Philadelphia Eagles': '#004C54',
            'Pittsburgh Steelers': '#FFB612'
        },
        NBA: {
            'Los Angeles Lakers': '#552583',
            'Boston Celtics': '#007A33',
            'Golden State Warriors': '#1D428A',
            'Miami Heat': '#98002E',
            'New York Knicks': '#006BB6',
            'Chicago Bulls': '#CE1141'
        },
        NHL: {
            'New York Rangers': '#0038A8',
            'Boston Bruins': '#FFB81C',
            'Chicago Blackhawks': '#CF0A2C',
            'Detroit Red Wings': '#CE1126',
            'Toronto Maple Leafs': '#00205B',
            'Tampa Bay Lightning': '#002868'
        }
    };

    function leagueOptions(){
        return Object.keys(PRESETS).map(function(k){ return { label:k, value:k }; });
    }
    function teamOptions(league){
        var obj = PRESETS[league] || {};
        return [{label:'— Select —', value:''}].concat(Object.keys(obj).sort().map(function(name){
            return { label: name, value: name };
        }));
    }

    blocks.registerBlockType('gsm/matchup-predictor', {
        title: __('GamblingSite: Matchup Predictor', 'gsm'),
        description: __('Matchup predictor card with donut chart. Tip: type /matchup.', 'gsm'),
        icon: 'chart-pie',
        category: 'design',
        keywords: ['matchup','picks','odds','betting','sports','gambling'],
        supports: { html:false, inserter:true },
        attributes: {
            teamAName: { type:'string', default:'Team A' },
            teamBName: { type:'string', default:'Team B' },
            teamALogoUrl: { type:'string', default:'' },
            teamBLogoUrl: { type:'string', default:'' },
            winA: { type:'number', default:55 },
            winB: { type:'number', default:45 },
            mlA: { type:'string', default:'' },
            mlB: { type:'string', default:'' },
            spreadA: { type:'string', default:'' },
            spreadB: { type:'string', default:'' },
            total: { type:'string', default:'' },
            book: { type:'string', default:'' },
            kickoff: { type:'string', default:'' },
            location: { type:'string', default:'' },
            note: { type:'string', default:'' },
            teamAColor: { type:'string', default:'#2e7dff' },
            teamBColor: { type:'string', default:'#f5b700' },
            ringWidth: { type:'number', default:36 },
            showDivider: { type:'boolean', default:true },
            animateDraw: { type:'boolean', default:true },
            showHeader: { type:'boolean', default:true },
            headerText: { type:'string', default:'Prediction Breakdown' },
            league: { type:'string', default:'MLB' },
            teamAKey: { type:'string', default:'' },
            teamBKey: { type:'string', default:'' },
        },
        edit: function(props){
            var atts = props.attributes;
            function clamp(v){ v = Number(v)||0; return Math.max(0, Math.min(100,v)); }
            function setWinA(v){ v = clamp(v); props.setAttributes({ winA:v, winB:100-v }); }
            function setWinB(v){ v = clamp(v); props.setAttributes({ winB:v, winA:100-v }); }

            function applyPresetA(v){
                props.setAttributes({ teamAKey:v, teamAName: v || atts.teamAName });
                var col = (PRESETS[atts.league]||{})[v];
                if (col) props.setAttributes({ teamAColor: col });
            }
            function applyPresetB(v){
                props.setAttributes({ teamBKey:v, teamBName: v || atts.teamBName });
                var col = (PRESETS[atts.league]||{})[v];
                if (col) props.setAttributes({ teamBColor: col });
            }

            return el('div', { className:'gsm-mp-editor' },
                el(InspectorControls, {},
                    el(PanelBody, { title: __('Header', 'gsm'), initialOpen: true },
                        el(ToggleControl, { label: __('Show "Prediction Breakdown" header','gsm'), checked: !!atts.showHeader, onChange: function(v){ props.setAttributes({ showHeader:v }); } }),
                        el(TextControl, { label: __('Header text','gsm'), value: atts.headerText, onChange: function(v){ props.setAttributes({ headerText:v }); }, help: __('Leave default or customize','gsm') })
                    ),
                    el(PanelBody, { title: __('League & Team Presets','gsm'), initialOpen: true },
                        el(SelectControl, { label: __('League','gsm'), value: atts.league, options: leagueOptions(), onChange: function(v){ props.setAttributes({ league:v, teamAKey:'', teamBKey:'' }); } }),
                        el(SelectControl, { label: __('Team A (preset)','gsm'), value: atts.teamAKey, options: teamOptions(atts.league), onChange: applyPresetA }),
                        el(SelectControl, { label: __('Team B (preset)','gsm'), value: atts.teamBKey, options: teamOptions(atts.league), onChange: applyPresetB })
                    ),
                    el(PanelBody, { title: __('Matchup Details','gsm'), initialOpen: true },
                        el(TextControl, { label: __('Team A Name','gsm'), value: atts.teamAName, onChange: function(v){ props.setAttributes({ teamAName:v }); } }),
                        el(MediaUploadCheck, {},
                            el(MediaUpload, { onSelect: function(m){ if(m&&m.url) props.setAttributes({ teamALogoUrl:m.url }); },
                                allowedTypes:['image'],
                                render: function(obj){ return el(Button, { onClick: obj.open, isSecondary:true }, atts.teamALogoUrl?__('Change Team A Logo','gsm'):__('Upload Team A Logo','gsm')); } })
                        ),
                        el(TextControl, { label: __('Moneyline A','gsm'), value: atts.mlA, onChange: function(v){ props.setAttributes({ mlA:v }); } }),
                        el(TextControl, { label: __('Spread A','gsm'), value: atts.spreadA, onChange: function(v){ props.setAttributes({ spreadA:v }); } }),
                        el(RangeControl, { label: __('Win % A','gsm'), value: atts.winA, onChange: setWinA, min:0, max:100 }),

                        el('hr'),
                        el(TextControl, { label: __('Team B Name','gsm'), value: atts.teamBName, onChange: function(v){ props.setAttributes({ teamBName:v }); } }),
                        el(MediaUploadCheck, {},
                            el(MediaUpload, { onSelect: function(m){ if(m&&m.url) props.setAttributes({ teamBLogoUrl:m.url }); },
                                allowedTypes:['image'],
                                render: function(obj){ return el(Button, { onClick: obj.open, isSecondary:true }, atts.teamBLogoUrl?__('Change Team B Logo','gsm'):__('Upload Team B Logo','gsm')); } })
                        ),
                        el(TextControl, { label: __('Moneyline B','gsm'), value: atts.mlB, onChange: function(v){ props.setAttributes({ mlB:v }); } }),
                        el(TextControl, { label: __('Spread B','gsm'), value: atts.spreadB, onChange: function(v){ props.setAttributes({ spreadB:v }); } }),
                        el(RangeControl, { label: __('Win % B','gsm'), value: atts.winB, onChange: setWinB, min:0, max:100 })
                    ),
                    el(PanelBody, { title: __('Chart Styling','gsm'), initialOpen: true },
                        el('div', {style:{marginBottom:'8px'}}, __('Team A Color','gsm')),
                        el(ColorPicker, { color: atts.teamAColor, onChange: function(c){ props.setAttributes({ teamAColor:c }); } }),
                        el('div', {style:{height:'8px'}}),
                        el('div', {style:{marginBottom:'8px'}}, __('Team B Color','gsm')),
                        el(ColorPicker, { color: atts.teamBColor, onChange: function(c){ props.setAttributes({ teamBColor:c }); } }),
                        el(RangeControl, { label: __('Ring Width (px)','gsm'), value: atts.ringWidth, min:16, max:60, onChange: function(v){ props.setAttributes({ ringWidth:v }); } }),
                        el(ToggleControl, { label: __('Show Center Divider','gsm'), checked: !!atts.showDivider, onChange: function(v){ props.setAttributes({ showDivider:v }); } }),
                        el(ToggleControl, { label: __('Animate on Load','gsm'), checked: !!atts.animateDraw, onChange: function(v){ props.setAttributes({ animateDraw:v }); } })
                    )
                ),
                el('div', { className:'gsm-mp-preview-card' },
                    el('div', { className:'gsm-mp-toprow' },
                        el('div', { className:'gsm-mp-team gsm-mp-left' },
                            atts.teamALogoUrl ? el('img', { className:'gsm-mp-logo', src: atts.teamALogoUrl, alt: atts.teamAName+' logo' }) : null,
                            el('h3', { className:'gsm-mp-teamname' }, atts.teamAName),
                            el('div', { className:'gsm-mp-pill' }, ['Win: ', el('strong', null, atts.winA + '%') ]),
                            atts.mlA ? el('div', { className:'gsm-mp-pill' }, ['ML: ', el('strong', null, atts.mlA)]) : null,
                            atts.spreadA ? el('div', { className:'gsm-mp-pill' }, ['Spread: ', el('strong', null, atts.spreadA)]) : null
                        ),
                        el('div', { className:'gsm-mp-center' },
                            el('div', { className:'gsm-mp-canvas-placeholder' }, __('Donut renders on the front end','gsm'))
                        ),
                        el('div', { className:'gsm-mp-team gsm-mp-right' },
                            atts.teamBLogoUrl ? el('img', { className:'gsm-mp-logo', src: atts.teamBLogoUrl, alt: atts.teamBName+' logo' }) : null,
                            el('h3', { className:'gsm-mp-teamname' }, atts.teamBName),
                            el('div', { className:'gsm-mp-pill' }, ['Win: ', el('strong', null, atts.winB + '%') ]),
                            atts.mlB ? el('div', { className:'gsm-mp-pill' }, ['ML: ', el('strong', null, atts.mlB)]) : null,
                            atts.spreadB ? el('div', { className:'gsm-mp-pill' }, ['Spread: ', el('strong', null, atts.spreadB)]) : null
                        )
                    ),
                    el('div', { className:'gsm-mp-bottomrow' },
                        atts.total ? el('div', { className:'gsm-mp-pill'}, ['Total: ', el('strong', null, atts.total)]) : null,
                        atts.book ? el('div', { className:'gsm-mp-pill'}, ['Book: ', el('strong', null, atts.book)]) : null,
                        atts.kickoff ? el('div', { className:'gsm-mp-pill'}, ['Start: ', el('strong', null, atts.kickoff)]) : null,
                        atts.location ? el('div', { className:'gsm-mp-pill'}, ['Venue: ', el('strong', null, atts.location)]) : null,
                        atts.note ? el('div', { className:'gsm-mp-note'}, atts.note) : null
                    )
                )
            );
        },
        save: function(){ return null; }
    });
})(window.wp.blocks, window.wp.element, window.wp.components, window.wp.blockEditor, window.wp.i18n);
