(function(blocks, element, components, blockEditor, i18n){
var el=element.createElement,__=i18n.__;
var TextControl=components.TextControl,TextareaControl=components.TextareaControl,RangeControl=components.RangeControl,PanelBody=components.PanelBody,ToggleControl=components.ToggleControl,SelectControl=components.SelectControl,ColorPicker=components.ColorPicker;
var MediaUpload=blockEditor.MediaUpload,MediaUploadCheck=blockEditor.MediaUploadCheck,InspectorControls=blockEditor.InspectorControls,Button=components.Button;
var PRESETS={MLB:{'Tampa Bay Rays':'#092C5C','New York Yankees':'#0C2340','Boston Red Sox':'#BD3039','New York Mets':'#002D72','Los Angeles Dodgers':'#005A9C','Chicago Cubs':'#0E3386','Atlanta Braves':'#CE1141','Houston Astros':'#002D62','San Francisco Giants':'#FD5A1E','St. Louis Cardinals':'#C41E3A'},NFL:{'New England Patriots':'#002244','Dallas Cowboys':'#041E42','Green Bay Packers':'#203731','Kansas City Chiefs':'#E31837','San Francisco 49ers':'#AA0000','Buffalo Bills':'#00338D','Philadelphia Eagles':'#004C54','Pittsburgh Steelers':'#FFB612'},NBA:{'Los Angeles Lakers':'#552583','Boston Celtics':'#007A33','Golden State Warriors':'#1D428A','Miami Heat':'#98002E','New York Knicks':'#006BB6','Chicago Bulls':'#CE1141'},NHL:{'New York Rangers':'#0038A8','Boston Bruins':'#FFB81C','Chicago Blackhawks':'#CF0A2C','Detroit Red Wings':'#CE1126','Toronto Maple Leafs':'#00205B','Tampa Bay Lightning':'#002868'}};
function leagueOptions(){return Object.keys(PRESETS).map(function(k){return{label:k,value:k};});}
function teamOptions(l){var o=PRESETS[l]||{};return[{label:'— Select —',value:''}].concat(Object.keys(o).sort().map(function(n){return{label:n,value:n};}));}
blocks.registerBlockType('gsm/matchup-predictor',{title:__('GamblingSite: Matchup Predictor','gsm'),icon:'chart-pie',category:'design',keywords:['matchup','picks','odds','betting','sports','gambling'],supports:{html:false,inserter:true},attributes:{teamAName:{type:'string',default:'Team A'},teamBName:{type:'string',default:'Team B'},teamALogoUrl:{type:'string',default:''},teamBLogoUrl:{type:'string',default:''},winA:{type:'number',default:55},winB:{type:'number',default:45},mlA:{type:'string',default:''},mlB:{type:'string',default:''},spreadA:{type:'string',default:''},spreadB:{type:'string',default:''},total:{type:'string',default:''},book:{type:'string',default:''},kickoff:{type:'string',default:''},location:{type:'string',default:''},note:{type:'string',default:''},teamAColor:{type:'string',default:'#2e7dff'},teamBColor:{type:'string',default:'#f5b700'},ringWidth:{type:'number',default:36},showDivider:{type:'boolean',default:true},animateDraw:{type:'boolean',default:true},showHeader:{type:'boolean',default:true},headerText:{type:'string',default:'Prediction Breakdown'},league:{type:'string',default:'MLB'},teamAKey:{type:'string',default:''},teamBKey:{type:'string',default:''},flipArcs:{type:'boolean',default:false},rotation:{type:'number',default:0}},edit:function(p){var a=p.attributes;function clamp(v){v=Number(v)||0;return Math.max(0,Math.min(100,v));}function setWinA(v){v=clamp(v);p.setAttributes({winA:v,winB:100-v});}function setWinB(v){v=clamp(v);p.setAttributes({winB:v,winA:100-v});}function applyPresetA(v){p.setAttributes({teamAKey:v,teamAName:v||a.teamAName});var c=(PRESETS[a.league]||{})[v];if(c)p.setAttributes({teamAColor:c});}function applyPresetB(v){p.setAttributes({teamBKey:v,teamBName:v||a.teamBName});var c=(PRESETS[a.league]||{})[v];if(c)p.setAttributes({teamBColor:c});}
return el('div',{className:'gsm-mp-editor'},el(InspectorControls,{},el(PanelBody,{title:__('Header','gsm'),initialOpen:true},el(ToggleControl,{label:__('Show \"Prediction Breakdown\" header','gsm'),checked:!!a.showHeader,onChange:function(v){p.setAttributes({showHeader:v});}}),el(TextControl,{label:__('Header text','gsm'),value:a.headerText,onChange:function(v){p.setAttributes({headerText:v});}})),el(PanelBody,{title:__('League & Team Presets','gsm'),initialOpen:true},el(SelectControl,{label:__('League','gsm'),value:a.league,options:leagueOptions(),onChange:function(v){p.setAttributes({league:v,teamAKey:'',teamBKey:''});}}),el(SelectControl,{label:__('Team A (preset)','gsm'),value:a.teamAKey,options:teamOptions(a.league),onChange:applyPresetA}),el(SelectControl,{label:__('Team B (preset)','gsm'),value:a.teamBKey,options:teamOptions(a.league),onChange:applyPresetB})),el(PanelBody,{title:__('Matchup Details','gsm'),initialOpen:true},el(TextControl,{label:__('Team A Name','gsm'),value:a.teamAName,onChange:function(v){p.setAttributes({teamAName:v});}}),el(MediaUploadCheck,{},el(MediaUpload,{onSelect:function(m){if(m&&m.url)p.setAttributes({teamALogoUrl:m.url});},allowedTypes:['image'],render:function(o){return el(Button,{onClick:o.open,isSecondary:true},a.teamALogoUrl?__('Change Team A Logo','gsm'):__('Upload Team A Logo','gsm'));}})),el(TextControl,{label:__('Moneyline A','gsm'),value:a.mlA,onChange:function(v){p.setAttributes({mlA:v});}}),el(TextControl,{label:__('Spread A','gsm'),value:a.spreadA,onChange:function(v){p.setAttributes({spreadA:v});}}),el(RangeControl,{label:__('Win % A','gsm'),value:a.winA,onChange:setWinA,min:0,max:100}),el('hr'),el(TextControl,{label:__('Team B Name','gsm'),value:a.teamBName,onChange:function(v){p.setAttributes({teamBName:v});}}),el(MediaUploadCheck,{},el(MediaUpload,{onSelect:function(m){if(m&&m.url)p.setAttributes({teamBLogoUrl:m.url});},allowedTypes:['image'],render:function(o){return el(Button,{onClick:o.open,isSecondary:true},a.teamBLogoUrl?__('Change Team B Logo','gsm'):__('Upload Team B Logo','gsm'));}})),el(TextControl,{label:__('Moneyline B','gsm'),value:a.mlB,onChange:function(v){p.setAttributes({mlB:v});}}),el(TextControl,{label:__('Spread B','gsm'),value:a.spreadB,onChange:function(v){p.setAttributes({spreadB:v});}}),el(RangeControl,{label:__('Win % B','gsm'),value:a.winB,onChange:setWinB,min:0,max:100})),el(PanelBody,{title:__('Chart Styling','gsm'),initialOpen:true},el('div',null,__('Team A Color','gsm')),el(ColorPicker,{color:a.teamAColor,onChange:function(c){p.setAttributes({teamAColor:c});}}),el('div',{style:{height:'8px'}}),el('div',null,__('Team B Color','gsm')),el(ColorPicker,{color:a.teamBColor,onChange:function(c){p.setAttributes({teamBColor:c});}}),el(RangeControl,{label:__('Ring Width (px)','gsm'),value:a.ringWidth,min:16,max:60,onChange:function(v){p.setAttributes({ringWidth:v});}}),el(ToggleControl,{label:__('Show Center Divider','gsm'),checked:!!a.showDivider,onChange:function(v){p.setAttributes({showDivider:v});}}),el(ToggleControl,{label:__('Animate on Load','gsm'),checked:!!a.animateDraw,onChange:function(v){p.setAttributes({animateDraw:v});}}),el(ToggleControl,{label:__('Flip A/B arcs (if colors look swapped)','gsm'),checked:!!a.flipArcs,onChange:function(v){p.setAttributes({flipArcs:v});}}),el(SelectControl,{label:__('Chart rotation','gsm'),value:String(a.rotation),options:[{label:'0°',value:'0'},{label:'90°',value:'90'},{label:'180°',value:'180'},{label:'270°',value:'270'}],onChange:function(v){p.setAttributes({rotation:parseInt(v,10)||0});}}))),el('div',{className:'gsm-mp-preview-card'},el('div',{className:'gsm-mp-toprow'},el('div',{className:'gsm-mp-team gsm-mp-left'},a.teamALogoUrl?el('img',{className:'gsm-mp-logo',src:a.teamALogoUrl,alt:a.teamAName+' logo'}):null,el('h3',{className:'gsm-mp-teamname'},a.teamAName),el('div',{className:'gsm-mp-pill'},['Win: ',el('strong',null,a.winA+'%')]),a.mlA?el('div',{className:'gsm-mp-pill'},['ML: ',el('strong',null,a.mlA)]):null,a.spreadA?el('div',{className:'gsm-mp-pill'},['Spread: ',el('strong',null,a.spreadA)]):null),el('div',{className:'gsm-mp-center'},el('div',{className:'gsm-mp-canvas-placeholder'},__('Donut renders on the front end','gsm'))),el('div',{className:'gsm-mp-team gsm-mp-right'},a.teamBLogoUrl?el('img',{className:'gsm-mp-logo',src:a.teamBLogoUrl,alt:a.teamBName+' logo'}):null,el('h3',{className:'gsm-mp-teamname'},a.teamBName),el('div',{className:'gsm-mp-pill'},['Win: ',el('strong',null,a.winB+'%')]),a.mlB?el('div',{className:'gsm-mp-pill'},['ML: ',el('strong',null,a.mlB)]):null,a.spreadB?el('div',{className:'gsm-mp-pill'},['Spread: ',el('strong',null,a.spreadB)]):null))))},save:function(){return null;}});
})(window.wp.blocks,window.wp.element,window.wp.components,window.wp.blockEditor,window.wp.i18n);