<?php
/**
 * Plugin Name: GamblingSite Matchup Predictor (Canvas)
 * Description: Matchup predictor block with donut chart, team presets, and styling options.
 * Version: 1.1.2
 * Author: FT Media + ChatGPT
 * License: GPLv2 or later
 */
if ( ! defined( 'ABSPATH' ) ) { exit; }
define('GSM_MP_VERSION','1.1.2');

add_action('init','gsm_mp_register_block');
function gsm_mp_register_block(){
    wp_register_script('gsm-mp-editor', plugins_url('editor.js', __FILE__), array('wp-blocks','wp-element','wp-components','wp-block-editor','wp-i18n'), GSM_MP_VERSION, true);
    wp_register_script('gsm-mp-frontend', plugins_url('frontend.js', __FILE__), array(), GSM_MP_VERSION, true);
    wp_register_style('gsm-mp-style', plugins_url('style.css', __FILE__), array(), GSM_MP_VERSION);

    register_block_type('gsm/matchup-predictor', array(
        'editor_script'   => 'gsm-mp-editor',
        'style'           => 'gsm-mp-style',
        'render_callback' => 'gsm_mp_render',
        'attributes'      => array(
            'teamAName'=>array('type'=>'string','default'=>'Team A'),
            'teamBName'=>array('type'=>'string','default'=>'Team B'),
            'teamALogoUrl'=>array('type'=>'string','default'=>''),
            'teamBLogoUrl'=>array('type'=>'string','default'=>''),
            'winA'=>array('type'=>'number','default'=>55),
            'winB'=>array('type'=>'number','default'=>45),
            'mlA'=>array('type'=>'string','default'=>''),
            'mlB'=>array('type'=>'string','default'=>''),
            'spreadA'=>array('type'=>'string','default'=>''),
            'spreadB'=>array('type'=>'string','default'=>''),
            'total'=>array('type'=>'string','default'=>''),
            'book'=>array('type'=>'string','default'=>''),
            'kickoff'=>array('type'=>'string','default'=>''),
            'location'=>array('type'=>'string','default'=>''),
            'note'=>array('type'=>'string','default'=>''),
            'teamAColor'=>array('type'=>'string','default'=>'#2e7dff'),
            'teamBColor'=>array('type'=>'string','default'=>'#f5b700'),
            'ringWidth'=>array('type'=>'number','default'=>36),
            'showDivider'=>array('type'=>'boolean','default'=>true),
            'animateDraw'=>array('type'=>'boolean','default'=>true),
            'showHeader'=>array('type'=>'boolean','default'=>true),
            'headerText'=>array('type'=>'string','default'=>'Prediction Breakdown'),
            'league'=>array('type'=>'string','default'=>'MLB'),
            'teamAKey'=>array('type'=>'string','default'=>''),
            'teamBKey'=>array('type'=>'string','default'=>''),
            'flipArcs'=>array('type'=>'boolean','default'=>false),
            'rotation'=>array('type'=>'number','default'=>0)
        )
    ));
}

function gsm_mp_s( $v ){ return is_scalar($v) ? $v : ''; }

function gsm_mp_render($a){
    if ( defined('REST_REQUEST') && REST_REQUEST && ! is_admin() ) return '';
    if ( ! is_admin() ){ wp_enqueue_script('gsm-mp-frontend'); wp_enqueue_style('gsm-mp-style'); }
    $d = wp_parse_args( is_array($a)?$a:array(), array(
        'teamAName'=>'Team A','teamBName'=>'Team B','teamALogoUrl'=>'','teamBLogoUrl'=>'',
        'winA'=>55,'winB'=>45,'mlA'=>'','mlB'=>'','spreadA'=>'','spreadB'=>'',
        'total'=>'','book'=>'','kickoff'=>'','location'=>'','note'=>'',
        'teamAColor'=>'#2e7dff','teamBColor'=>'#f5b700','ringWidth'=>36,'showDivider'=>true,
        'animateDraw'=>true,'showHeader'=>true,'headerText'=>'Prediction Breakdown',
        'flipArcs'=>false,'rotation'=>0
    ));
    $d['teamAName'] = sanitize_text_field(gsm_mp_s($d['teamAName']));
    $d['teamBName'] = sanitize_text_field(gsm_mp_s($d['teamBName']));
    $d['teamALogoUrl'] = esc_url_raw(gsm_mp_s($d['teamALogoUrl']));
    $d['teamBLogoUrl'] = esc_url_raw(gsm_mp_s($d['teamBLogoUrl']));
    $d['winA'] = floatval($d['winA']); $d['winB'] = floatval($d['winB']);
    if ( is_numeric($d['winA']) && ( !is_numeric($d['winB']) || $d['winB']==='' ) ) $d['winB'] = max(0,min(100,100-$d['winA']));
    elseif ( is_numeric($d['winB']) && ( !is_numeric($d['winA']) || $d['winA']==='' ) ) $d['winA'] = max(0,min(100,100-$d['winB']));
    $aColor = preg_match('/^#([0-9a-f]{3}|[0-9a-f]{6})$/i', $d['teamAColor']) ? $d['teamAColor'] : '#2e7dff';
    $bColor = preg_match('/^#([0-9a-f]{3}|[0-9a-f]{6})$/i', $d['teamBColor']) ? $d['teamBColor'] : '#f5b700';
    $ringW = max(16, min(60, intval($d['ringWidth'])));
    $rotation = intval($d['rotation']) % 360;
    ob_start(); ?>
    <div class="gsm-mp-card gsm-mp-elevated" role="group" aria-label="Matchup Predictor">
        <?php if ( !empty($d['showHeader']) ) : ?><div class="gsm-mp-header"><?php echo esc_html($d['headerText']); ?></div><?php endif; ?>
        <div class="gsm-mp-toprow">
            <div class="gsm-mp-team gsm-mp-left">
                <?php if ( !empty($d['teamALogoUrl']) ) : ?><img src="<?php echo esc_url($d['teamALogoUrl']); ?>" alt="<?php echo esc_attr($d['teamAName']); ?> logo" class="gsm-mp-logo" /><?php endif; ?>
                <h3 class="gsm-mp-teamname"><?php echo esc_html($d['teamAName']); ?></h3>
                <div class="gsm-mp-pill">Win: <strong><?php echo esc_html(round($d['winA'],1)); ?>%</strong></div>
                <?php if ($d['mlA']!=='') : ?><div class="gsm-mp-pill">ML: <strong><?php echo esc_html($d['mlA']); ?></strong></div><?php endif; ?>
                <?php if ($d['spreadA']!=='') : ?><div class="gsm-mp-pill">Spread: <strong><?php echo esc_html($d['spreadA']); ?></strong></div><?php endif; ?>
            </div>
            <div class="gsm-mp-center">
                <canvas class="gsm-mp-canvas" width="360" height="360"
                    data-teama="<?php echo esc_attr($d['teamAName']); ?>"
                    data-teamb="<?php echo esc_attr($d['teamBName']); ?>"
                    data-wina="<?php echo esc_attr($d['winA']); ?>"
                    data-winb="<?php echo esc_attr($d['winB']); ?>"
                    data-colora="<?php echo esc_attr($aColor); ?>"
                    data-colorb="<?php echo esc_attr($bColor); ?>"
                    data-ringw="<?php echo esc_attr($ringW); ?>"
                    data-divider="<?php echo esc_attr(!empty($d['showDivider'])?'1':'0'); ?>"
                    data-animate="<?php echo esc_attr(!empty($d['animateDraw'])?'1':'0'); ?>"
                    data-flip="<?php echo esc_attr(!empty($d['flipArcs'])?'1':'0'); ?>"
                    data-rotation="<?php echo esc_attr($rotation); ?>"
                    aria-label="Win probability donut chart" role="img"></canvas>
                <div class="gsm-mp-vs">VS</div>
            </div>
            <div class="gsm-mp-team gsm-mp-right">
                <?php if ( !empty($d['teamBLogoUrl']) ) : ?><img src="<?php echo esc_url($d['teamBLogoUrl']); ?>" alt="<?php echo esc_attr($d['teamBName']); ?> logo" class="gsm-mp-logo" /><?php endif; ?>
                <h3 class="gsm-mp-teamname"><?php echo esc_html($d['teamBName']); ?></h3>
                <div class="gsm-mp-pill">Win: <strong><?php echo esc_html(round($d['winB'],1)); ?>%</strong></div>
                <?php if ($d['mlB']!=='') : ?><div class="gsm-mp-pill">ML: <strong><?php echo esc_html($d['mlB']); ?></strong></div><?php endif; ?>
                <?php if ($d['spreadB']!=='') : ?><div class="gsm-mp-pill">Spread: <strong><?php echo esc_html($d['spreadB']); ?></strong></div><?php endif; ?>
            </div>
        </div>
        <div class="gsm-mp-bottomrow">
            <?php if ($d['total']!=='') : ?><div class="gsm-mp-pill">Total: <strong><?php echo esc_html($d['total']); ?></strong></div><?php endif; ?>
            <?php if ($d['book']!=='') : ?><div class="gsm-mp-pill">Book: <strong><?php echo esc_html($d['book']); ?></strong></div><?php endif; ?>
            <?php if ($d['kickoff']!=='') : ?><div class="gsm-mp-pill">Start: <strong><?php echo esc_html($d['kickoff']); ?></strong></div><?php endif; ?>
            <?php if ($d['location']!=='') : ?><div class="gsm-mp-pill">Venue: <strong><?php echo esc_html($d['location']); ?></strong></div><?php endif; ?>
            <?php if ($d['note']!=='') : ?><div class="gsm-mp-note"><?php echo esc_html($d['note']); ?></div><?php endif; ?>
        </div>
    </div>
    <?php return ob_get_clean();
}
