# Hot or Not - Daily Betting Picks WordPress Plugin

Transform your WordPress site into a community-driven betting platform where users vote on daily sports picks powered by AI insights and live odds.

## 🎯 Features

### Core Functionality
- **Real Sports Data**: Live games and odds from The Odds API
- **AI-Powered Insights**: GPT-4 generated betting insights for each pick
- **Community Voting**: Users vote "Hot" 🔥 or "Not" ❌ on picks
- **Auto-Generation**: Automatically creates picks from real games twice daily
- **Multi-Sport Coverage**: NFL, NBA, MLB, NHL, MLS, Tennis
- **Responsive Design**: Beautiful dark theme works on all devices

### WordPress Integration
- **Shortcode Display**: `[hot_or_not_picks]` to show picks anywhere
- **Admin Dashboard**: Full WordPress admin integration
- **Settings Panel**: Easy configuration of API keys and options
- **Analytics**: Track votes, picks, and user engagement
- **Automatic Updates**: Picks refresh automatically via WordPress cron

## 📋 Requirements

- **WordPress**: 5.0 or higher
- **PHP**: 7.4 or higher
- **MySQL**: 5.6 or higher

### API Keys Required
1. **The Odds API Key** - Get from [the-odds-api.com](https://the-odds-api.com/)
2. **OpenAI API Key** - Get from [platform.openai.com](https://platform.openai.com/api-keys)

## 🚀 Installation

### Method 1: WordPress Admin (Recommended)
1. Download the plugin ZIP file
2. Go to **WordPress Admin → Plugins → Add New**
3. Click **Upload Plugin**
4. Choose the ZIP file and click **Install Now**
5. Click **Activate Plugin**

### Method 2: Manual Installation
1. Download and extract the plugin ZIP file
2. Upload the `hot-or-not-betting-picks` folder to `/wp-content/plugins/`
3. Activate the plugin through the **Plugins** menu in WordPress

## ⚙️ Setup & Configuration

### 1. Configure API Keys
1. Go to **Hot or Not Picks → Settings** in WordPress admin
2. Enter your **The Odds API Key**
3. Enter your **OpenAI API Key**
4. Save settings

### 2. Test API Connections
- The settings page will show connection status for both APIs
- Green checkmarks = successful connections
- Red X = connection issues (check your API keys)

### 3. Enable Auto-Generation
1. In settings, check **"Enable Auto-Generation"**
2. Choose frequency: Hourly, Twice Daily, or Daily
3. Set maximum picks per generation (recommended: 6)
4. Select which sports to include

### 4. Display Picks on Your Site
Add the shortcode anywhere you want picks to appear:
```
[hot_or_not_picks]
```

#### Shortcode Options:
- `[hot_or_not_picks limit="6"]` - Limit number of picks shown
- `[hot_or_not_picks sport="NBA"]` - Show only specific sport
- `[hot_or_not_picks show_voting="false"]` - Hide voting buttons
- `[hot_or_not_picks show_time="false"]` - Hide game times

## 🎮 Usage

### For Site Visitors
1. **View Picks**: See today's betting picks with AI insights
2. **Vote on Picks**: Click 🔥 "Hot" or ❌ "Not" buttons
3. **See Community Opinion**: View real-time vote percentages
4. **Game Times**: Know exactly when games are happening

### For Administrators

#### Auto-Generate Picks
- **Automatic**: Enabled in settings, runs via WordPress cron
- **Manual**: Click "🎲 Auto-Generate Picks" in admin dashboard
- Creates picks from real games happening today/soon

#### Manage Picks
- **View All Picks**: See complete list with vote counts
- **Toggle Status**: Activate/deactivate picks
- **Delete Picks**: Remove unwanted picks
- **Clean Up**: Remove test data and duplicates

#### Analytics
- **Platform Stats**: Total picks, votes, engagement metrics
- **Sports Performance**: See which sports perform best
- **Recent Activity**: Track user voting patterns
- **Export Data**: Download pick data as CSV

## 🎨 Customization

### Styling
The plugin includes beautiful default styling but can be customized:
- Override CSS classes in your theme
- Modify colors and fonts to match your brand
- All styles are responsive and mobile-friendly

### Sports Selection
Choose which sports to include:
- NBA (Basketball)
- NFL (Football)
- MLB (Baseball)
- NHL (Hockey)
- MLS (Soccer)
- Tennis

### Display Options
Control what information shows:
- AI insights on/off
- Game times on/off
- Voting buttons on/off
- Vote percentages

## 📊 Analytics & Reporting

### Built-in Analytics
- Total picks created
- Total community votes
- Active picks count
- Vote percentages per pick
- Sports performance metrics

### Export Capabilities
- Export all pick data to CSV
- Include vote counts and percentages
- Perfect for external analysis

## 🛠️ Troubleshooting

### Common Issues

#### "No picks showing"
1. Check API keys in settings
2. Verify APIs are connected (green checkmarks)
3. Try manual "Auto-Generate Picks"
4. Check if auto-generation is enabled

#### "API connection failed"
1. Verify API key format:
   - Odds API: Standard alphanumeric key
   - OpenAI: Starts with "sk-"
2. Check account status on API provider sites
3. Ensure sufficient API credits/quota

#### "Voting not working"
1. Check if voting is enabled in settings
2. Clear browser cache
3. Check for JavaScript errors in browser console

#### "Automatic picks not generating"
1. Verify auto-generation is enabled
2. Check WordPress cron is working: `wp cron event list`
3. Manually trigger: **WP Admin → Tools → Cron Events**

### Performance Optimization

#### For High Traffic Sites
1. **Caching**: Use caching plugins but exclude voting AJAX
2. **API Limits**: Monitor API usage to avoid rate limits
3. **Database**: Regularly clean up old picks and votes

#### API Usage Tips
1. **The Odds API**: Free tier has 500 requests/month
2. **OpenAI API**: Pay-per-use, optimize insight generation
3. **Caching**: Plugin caches API responses when possible

## 🔒 Security & Privacy

### Data Protection
- User votes tied to IP addresses (anonymized)
- No personal data collection required
- GDPR compliant voting system

### Security Features
- WordPress nonce verification
- Sanitized input/output
- SQL injection prevention
- XSS protection

## 🆕 Updates & Maintenance

### Automatic Updates
- Plugin updates through WordPress admin
- Database schema updates handled automatically
- Settings preserved during updates

### Manual Maintenance
- Clean up old picks regularly
- Monitor API usage
- Review vote patterns for anomalies

## 🎯 Advanced Features

### Developer Hooks
```php
// Customize pick generation
add_filter('hon_generate_pick_insight', 'custom_insight_function');

// Modify display template
add_filter('hon_pick_card_template', 'custom_template_function');

// Add custom sports
add_filter('hon_available_sports', 'add_custom_sports');
```

### Custom Templates
Override plugin templates in your theme:
1. Create folder: `your-theme/hot-or-not-betting-picks/`
2. Copy template files from plugin
3. Customize as needed

## 📞 Support

### Documentation
- Plugin settings include help text
- Shortcode examples provided
- API status indicators show connection health

### Troubleshooting
1. Check WordPress error logs
2. Enable WordPress debug mode
3. Verify API key permissions
4. Test with default WordPress theme

## 🎉 Go Live Checklist

- [ ] API keys configured and tested
- [ ] Auto-generation enabled
- [ ] Shortcode added to desired pages
- [ ] Test voting functionality
- [ ] Monitor API usage
- [ ] Set up regular maintenance

---

**Turn your WordPress site into a thriving betting community where fans vote on the hottest picks powered by real data and AI insights!** 🔥⚡

For support, feature requests, or custom development, contact the plugin developer.