<?php

if (!defined('ABSPATH')) {
    exit;
}

$pick_manager = new HON_Pick_Manager();
$analytics = $pick_manager->get_analytics();
$sports_stats = $pick_manager->get_sports_stats();
$recent_votes = $pick_manager->get_recent_votes(20);

?>
<div class="wrap">
    <h1><?php _e('Hot or Not - Analytics', 'hot-or-not-betting-picks'); ?></h1>
    
    <!-- Overview Stats -->
    <div class="hon-admin-stats">
        <div class="hon-stat-card">
            <h3><?php echo esc_html($analytics['total_picks']); ?></h3>
            <p><?php _e('Total Picks', 'hot-or-not-betting-picks'); ?></p>
        </div>
        <div class="hon-stat-card">
            <h3><?php echo esc_html($analytics['active_picks']); ?></h3>
            <p><?php _e('Active Picks', 'hot-or-not-betting-picks'); ?></p>
        </div>
        <div class="hon-stat-card">
            <h3><?php echo esc_html($analytics['total_votes']); ?></h3>
            <p><?php _e('Total Votes', 'hot-or-not-betting-picks'); ?></p>
        </div>
        <div class="hon-stat-card">
            <h3><?php echo esc_html(count($sports_stats)); ?></h3>
            <p><?php _e('Sports Covered', 'hot-or-not-betting-picks'); ?></p>
        </div>
    </div>
    
    <!-- Sports Performance -->
    <div class="hon-analytics-section">
        <h2><?php _e('Sports Performance', 'hot-or-not-betting-picks'); ?></h2>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th><?php _e('Sport', 'hot-or-not-betting-picks'); ?></th>
                    <th><?php _e('Total Picks', 'hot-or-not-betting-picks'); ?></th>
                    <th><?php _e('Total Votes', 'hot-or-not-betting-picks'); ?></th>
                    <th><?php _e('Avg Hot %', 'hot-or-not-betting-picks'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($sports_stats as $stat): ?>
                    <tr>
                        <td><span class="hon-sport-badge"><?php echo esc_html($stat['sport']); ?></span></td>
                        <td><?php echo esc_html($stat['total_picks']); ?></td>
                        <td><?php echo esc_html($stat['total_votes']); ?></td>
                        <td><?php echo esc_html(round($stat['avg_hot_percentage'], 1)); ?>%</td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    
    <!-- Top Performing Picks -->
    <div class="hon-analytics-section">
        <h2><?php _e('Top Performing Picks', 'hot-or-not-betting-picks'); ?></h2>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th><?php _e('Matchup', 'hot-or-not-betting-picks'); ?></th>
                    <th><?php _e('Pick', 'hot-or-not-betting-picks'); ?></th>
                    <th><?php _e('Sport', 'hot-or-not-betting-picks'); ?></th>
                    <th><?php _e('Total Votes', 'hot-or-not-betting-picks'); ?></th>
                    <th><?php _e('Hot %', 'hot-or-not-betting-picks'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($analytics['top_picks'] as $pick): 
                    $total_votes = $pick['hot_votes'] + $pick['not_votes'];
                    $hot_percentage = $total_votes > 0 ? round(($pick['hot_votes'] / $total_votes) * 100, 1) : 0;
                ?>
                    <tr>
                        <td><?php echo esc_html($pick['matchup']); ?></td>
                        <td><?php echo esc_html($pick['pick_text']); ?></td>
                        <td><span class="hon-sport-badge"><?php echo esc_html($pick['sport']); ?></span></td>
                        <td><?php echo esc_html($total_votes); ?></td>
                        <td><?php echo esc_html($hot_percentage); ?>%</td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    
    <!-- Recent Voting Activity -->
    <div class="hon-analytics-section">
        <h2><?php _e('Recent Voting Activity', 'hot-or-not-betting-picks'); ?></h2>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th><?php _e('Time', 'hot-or-not-betting-picks'); ?></th>
                    <th><?php _e('Matchup', 'hot-or-not-betting-picks'); ?></th>
                    <th><?php _e('Vote', 'hot-or-not-betting-picks'); ?></th>
                    <th><?php _e('Sport', 'hot-or-not-betting-picks'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($recent_votes as $vote): ?>
                    <tr>
                        <td><?php echo esc_html(human_time_diff(strtotime($vote['voted_at']), current_time('timestamp')) . ' ago'); ?></td>
                        <td><?php echo esc_html($vote['matchup']); ?></td>
                        <td>
                            <span class="hon-vote-<?php echo esc_attr($vote['vote_type']); ?>">
                                <?php echo $vote['vote_type'] === 'hot' ? '🔥 Hot' : '❌ Not'; ?>
                            </span>
                        </td>
                        <td><span class="hon-sport-badge"><?php echo esc_html($vote['sport']); ?></span></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<style>
.hon-analytics-section {
    margin-top: 30px;
}

.hon-analytics-section h2 {
    margin-bottom: 15px;
    color: #0073aa;
}

.hon-vote-hot {
    color: #dc3232;
    font-weight: bold;
}

.hon-vote-not {
    color: #666;
    font-weight: bold;
}
</style>