<?php

if (!defined('ABSPATH')) {
    exit;
}

// Admin utility functions

function hon_get_current_tab() {
    return isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'dashboard';
}

function hon_admin_tabs($current_tab = 'dashboard') {
    $tabs = array(
        'dashboard' => __('Dashboard', 'hot-or-not-betting-picks'),
        'settings' => __('Settings', 'hot-or-not-betting-picks'),
        'analytics' => __('Analytics', 'hot-or-not-betting-picks')
    );
    
    echo '<nav class="nav-tab-wrapper">';
    foreach ($tabs as $tab => $name) {
        $class = ($tab === $current_tab) ? ' nav-tab-active' : '';
        echo '<a class="nav-tab' . $class . '" href="?page=hot-or-not-picks&tab=' . $tab . '">' . $name . '</a>';
    }
    echo '</nav>';
}

function hon_format_date($date) {
    return date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($date));
}

function hon_get_sport_color($sport) {
    $colors = array(
        'NBA' => '#FFA500',
        'NFL' => '#0066CC',
        'MLB' => '#FF0000',
        'NHL' => '#000080',
        'MLS' => '#00FF00',
        'Tennis' => '#800080'
    );
    
    return isset($colors[$sport]) ? $colors[$sport] : '#0073aa';
}

function hon_admin_notice($message, $type = 'success') {
    $class = $type === 'error' ? 'notice-error' : 'notice-success';
    echo '<div class="notice ' . $class . ' is-dismissible"><p>' . esc_html($message) . '</p></div>';
}

function hon_export_picks_csv() {
    if (!current_user_can('manage_options')) {
        wp_die(__('Insufficient permissions', 'hot-or-not-betting-picks'));
    }
    
    $pick_manager = new HON_Pick_Manager();
    $picks = $pick_manager->get_picks(1000); // Get more picks for export
    
    $filename = 'hot-or-not-picks-' . date('Y-m-d') . '.csv';
    
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    
    $output = fopen('php://output', 'w');
    
    // CSV headers
    fputcsv($output, array(
        'Pick ID',
        'Matchup',
        'Pick Text',
        'Sport',
        'Game Time',
        'Hot Votes',
        'Not Votes',
        'Total Votes',
        'Hot Percentage',
        'Insight',
        'Status',
        'Created At'
    ));
    
    // CSV data
    foreach ($picks as $pick) {
        $total_votes = $pick['hot_votes'] + $pick['not_votes'];
        $hot_percentage = $total_votes > 0 ? round(($pick['hot_votes'] / $total_votes) * 100, 1) : 0;
        
        fputcsv($output, array(
            $pick['pick_id'],
            $pick['matchup'],
            $pick['pick_text'],
            $pick['sport'],
            $pick['game_time'],
            $pick['hot_votes'],
            $pick['not_votes'],
            $total_votes,
            $hot_percentage . '%',
            $pick['insight'],
            $pick['is_active'] ? 'Active' : 'Inactive',
            $pick['created_at']
        ));
    }
    
    fclose($output);
    exit;
}

// Handle CSV export
if (isset($_GET['action']) && $_GET['action'] === 'export_csv' && isset($_GET['page']) && $_GET['page'] === 'hot-or-not-picks') {
    hon_export_picks_csv();
}