document.addEventListener('DOMContentLoaded', function () {
  document.getElementById('kelly-form').addEventListener('submit', function (e) {
    e.preventDefault();

    const format = document.getElementById('odds-format').value;
    const oddsInput = document.getElementById('odds').value.trim();
    const prob = parseFloat(document.getElementById('win-prob').value) / 100;
    const bankroll = parseFloat(document.getElementById('bankroll').value) || 0;
    const explanationBox = document.getElementById('kelly-explanation');
    const message = document.getElementById('kelly-message');

    let decimalOdds;

    if (format === 'american') {
      const odds = parseFloat(oddsInput);
      decimalOdds = odds > 0 ? (odds / 100 + 1) : (100 / Math.abs(odds) + 1);
    } else if (format === 'fractional') {
      const parts = oddsInput.split('/');
      if (parts.length === 2) {
        decimalOdds = (parseFloat(parts[0]) / parseFloat(parts[1])) + 1;
      } else {
        alert('Invalid fractional odds');
        return;
      }
    } else {
      decimalOdds = parseFloat(oddsInput);
    }

    const b = decimalOdds - 1;
    const q = 1 - prob;
    const kelly = (b * prob - q) / b;

    if (kelly <= 0) {
      document.getElementById('kelly-results').style.display = 'block';
      document.getElementById('kelly-percent').textContent = '0%';
      document.getElementById('bet-full').textContent = '0.00';
      document.getElementById('bet-half').textContent = '0.00';
      document.getElementById('bet-quarter').textContent = '0.00';
      document.getElementById('ev-result').textContent = 'No (Negative Edge)';
      explanationBox.style.display = 'block';
      explanationBox.style.borderLeftColor = '#cc0000';
      message.textContent = "Your estimated win probability isn't high enough to justify this bet. The expected value is negative — consider skipping this wager.";
      return;
    }

    const percent = (kelly * 100).toFixed(2);
    const betFull = (kelly * bankroll).toFixed(2);
    const betHalf = (0.5 * kelly * bankroll).toFixed(2);
    const betQuarter = (0.25 * kelly * bankroll).toFixed(2);

    document.getElementById('kelly-percent').textContent = percent + '%';
    document.getElementById('bet-full').textContent = betFull;
    document.getElementById('bet-half').textContent = betHalf;
    document.getElementById('bet-quarter').textContent = betQuarter;
    document.getElementById('ev-result').textContent = 'Yes';
    explanationBox.style.display = 'block';
    explanationBox.style.borderLeftColor = '#00cc66';
    message.textContent = `Based on your inputs, this bet has a positive expected value. A Full Kelly stake of ${percent}% maximizes long-term bankroll growth while minimizing risk.`;

    document.getElementById('kelly-results').style.display = 'block';
    // Visual Meter
    document.getElementById('kelly-visual-meter').style.display = 'block';
    document.getElementById('meter-full').style.width = Math.min(kelly * 100, 100) + '%';
    document.getElementById('meter-half').style.width = Math.min(kelly * 50, 100) + '%';
    document.getElementById('meter-quarter').style.width = Math.min(kelly * 25, 100) + '%';

    document.getElementById('label-full').textContent = percent + '%';
    document.getElementById('label-half').textContent = (kelly * 50).toFixed(2) + '%';
    document.getElementById('label-quarter').textContent = (kelly * 25).toFixed(2) + '%';
  });
});
