document.addEventListener('DOMContentLoaded', () => {
  if (!window.matchupData) return;

  window.matchupData.forEach(entry => {
    const ctx = document.getElementById(entry.id).getContext('2d');
    new Chart(ctx, {
      type: 'doughnut',
      data: {
        labels: [entry.team2, entry.team1],
        datasets: [{
          data: [entry.team2Pct, entry.team1Pct],
          backgroundColor: [entry.team2Color, entry.team1Color],
          borderWidth: 0
        }]
      },
      options: {
        cutout: '70%',
        plugins: {
          legend: { display: false },
          tooltip: {
            enabled: true,
            callbacks: {
              label: function(context) {
                const label = context.chart.data.labels[context.dataIndex] || '';
                const value = context.dataset.data[context.dataIndex];
                return `${label}: ${value}%`;
              }
            }
          }
        },
        elements: {
          arc: {
            borderWidth: 0
          }
        }
      }
    });

    const canvas = document.getElementById(entry.id);
    const overlay = document.createElement('div');
    overlay.style.position = 'absolute';
    overlay.style.width = '1px';
    overlay.style.height = '60%';
    overlay.style.backgroundColor = '#444';
    overlay.style.top = '20%';
    overlay.style.left = '50%';
    overlay.style.transform = 'translateX(-1px)';
    overlay.style.zIndex = 1;
    canvas.parentNode.appendChild(overlay);
  });
});