<?php
/*
Plugin Name: Matchup Predictor
Description: Adds a matchup prediction gauge using a shortcode.
Version: 1.0
*/

function matchup_predictor_assets() {
    wp_enqueue_style('matchup-style', plugins_url('/css/style.css', __FILE__));
    wp_enqueue_script('chart-lib', 'https://cdn.jsdelivr.net/npm/chart.js', [], null, true);
    wp_enqueue_script('matchup-script', plugins_url('/js/render.js', __FILE__), ['chart-lib'], null, true);
}
add_action('wp_enqueue_scripts', 'matchup_predictor_assets');

function matchup_predictor_shortcode($atts) {
    $a = shortcode_atts([
        'team1' => 'Team A',
        'team1_logo' => '',
        'team1_pct' => 50,
        'team1_color' => '#2e7d32', // default green
        'team2' => 'Team B',
        'team2_logo' => '',
        'team2_pct' => 50,
        'team2_color' => '#1e88e5'  // default blue
    ], $atts);

    $id = uniqid("matchup_");

    return "
    <div class='matchup-widget'>
        <h3>Prediction Breakdown</h3>
        <div class='chart-wrapper'>
            <canvas id='{$id}' width='200' height='200'></canvas>
        </div>
        <div class='matchup-details'>
            <div class='team'>
                <img src='" . plugins_url('/assets/' . $a['team1_logo'], __FILE__) . "' alt='{$a['team1']}' onerror=\"this.style.display='none'\" />
                <span>{$a['team1_pct']}%</span>
            </div>
            <div class='team'>
                <img src='" . plugins_url('/assets/' . $a['team2_logo'], __FILE__) . "' alt='{$a['team2']}' onerror=\"this.style.display='none'\" />
                <span>{$a['team2_pct']}%</span>
            </div>
        </div>
        <p class='source'>According to GamblingSite.com</p>
        <script>
          window.matchupData = window.matchupData || [];
          window.matchupData.push({
            id: '{$id}',
            team1Pct: {$a['team1_pct']},
            team2Pct: {$a['team2_pct']},
            team1Color: '{$a['team1_color']}',
            team2Color: '{$a['team2_color']}'
          });
        </script>
    </div>
    ";
}
add_shortcode('matchup_predictor', 'matchup_predictor_shortcode');
