document.addEventListener('DOMContentLoaded', function () {
    function toDecimal(odds, format) {
        if (format === 'american') {
            odds = parseFloat(odds);
            return odds > 0 ? (odds / 100) + 1 : (100 / Math.abs(odds)) + 1;
        } else if (format === 'fractional') {
            const parts = odds.split('/');
            return (parseFloat(parts[0]) / parseFloat(parts[1])) + 1;
        }
        return parseFloat(odds);
    }

    document.getElementById('add-leg').addEventListener('click', function () {
    const container = document.createElement('div');
    container.classList.add('bet-leg');

    container.innerHTML = `
        <select class="odds-format">
            <option value="decimal">Decimal</option>
            <option value="american">American</option>
            <option value="fractional">Fractional</option>
        </select>
        <input type="text" class="odds-value" placeholder="Enter odds">
        <button type="button" class="remove-leg" title="Remove this leg">❌</button>
    `;

    document.getElementById('odds-inputs').appendChild(container);
});

document.getElementById('odds-inputs').addEventListener('click', function (e) {
    if (e.target.classList.contains('remove-leg')) {
        e.target.parentElement.remove();
    }
});

    document.getElementById('parlay-form').addEventListener('submit', function (e) {
        e.preventDefault();

        const oddsElements = document.querySelectorAll('.bet-leg');
        let totalOdds = 1;
        for (let el of oddsElements) {
            const format = el.querySelector('.odds-format').value;
            const value = el.querySelector('.odds-value').value;
            const decimal = toDecimal(value, format);
            if (isNaN(decimal)) {
                alert('Please enter valid odds.');
                return;
            }
            totalOdds *= decimal;
        }

        const wager = parseFloat(document.getElementById('wager').value);
        if (isNaN(wager) || wager <= 0) {
            alert('Please enter a valid wager amount.');
            return;
        }

        const payout = (wager * totalOdds).toFixed(2);
        const profit = (payout - wager).toFixed(2);

        document.getElementById('total-odds').textContent = totalOdds.toFixed(2);
        document.getElementById('payout').textContent = payout;
        document.getElementById('profit').textContent = profit;
        const resultsEl = document.getElementById('results');
        resultsEl.style.display = 'block';
        resultsEl.classList.add('show');
    });
});
