<?php
/**
 * Plugin Name: Parlay Calculator
 * Description: A simple parlay calculator for sports betting.
 * Version: 1.2
 * Author: GamblingSite.com
 */

function parlay_calculator_enqueue_scripts() {
    wp_enqueue_style('parlay-calculator-style', plugin_dir_url(__FILE__) . 'css/style.css');
    wp_enqueue_script('parlay-calculator-script', plugin_dir_url(__FILE__) . 'js/script.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'parlay_calculator_enqueue_scripts');

function parlay_calculator_shortcode() {
    ob_start(); ?>
    <div id="parlay-calculator">
        <h2>Parlay Calculator</h2>
        <form id="parlay-form">
            <div id="odds-inputs">
                <div class="bet-leg">
                    <select class="odds-format">
                        <option value="decimal">Decimal</option>
                        <option value="american">American</option>
                        <option value="fractional">Fractional</option>
                    </select>
                    <input type="text" class="odds-value" placeholder="Enter odds">
                </div>
            </div>
            <button type="button" id="add-leg">+ Add Bet Leg</button><br><br>
            <label>Wager Amount ($):</label>
            <input type="number" id="wager" min="1" step="0.01"><br><br>
            <button type="submit">Calculate</button>
        </form>
        <div id="results" style="display:none;">
            <h3>Results</h3>
            <p><strong>Total Decimal Odds:</strong> <span id="total-odds"></span></p>
            <p><strong>Potential Payout:</strong> $<span id="payout"></span></p>
            <p><strong>Net Profit:</strong> $<span id="profit"></span></p>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('parlay_calculator', 'parlay_calculator_shortcode');
