<?php
$action         = (isset($_GET['action'])) ? sanitize_text_field($_GET['action']) : '';
$heading        = '';
$loader_iamge   = '';
$id             = (isset($_GET['poll_formfield'])) ? absint(intval($_GET['poll_formfield'])) : null;
$poll_formfield = [
	'id'        => '',
	'name'      => '',
	'type'      => '',
	'published' => '',
    'sendgrid'  => '',
];
switch ( $action ) {
	case 'add':
		$heading     = __('Add new Attribute', $this->plugin_name);
		$new_slug_id = $this->formfields_obj->get_new_slug_id($id);
		break;
	case 'edit':
		$heading        = __('Edit Attribute', $this->plugin_name);
		$poll_formfield = $this->formfields_obj->get_formfield_by_id($id);
		break;
}
$loader_iamge = "<span class='display_none'><img src=".POLL_MAKER_AYS_ADMIN_URL."/images/loaders/loading.gif></span>";
if (isset($_POST['ays_submit'])) {
	$result = $this->formfields_obj->add_edit_poll_formfield($_POST, $id);
} elseif (isset($_POST['ays_apply'])) {
	$this->formfields_obj->add_edit_poll_formfield($_POST, $id, "apply");
}

$sendgrid_enabled = false;
$sendgrid_api = $this->settings_obj->ays_get_setting('sendgrid');
$sendgrid          = json_decode($sendgrid_api, true);
$sendgrid_api_key  = isset($sendgrid['apiKey']) ? $sendgrid['apiKey'] : '';
if($sendgrid_api_key != ''){
    $sendgrid_templates = $this->ays_poll_sendgrid_templates($sendgrid_api_key);
    $sendgrid_enabled = array_key_exists('errors', $sendgrid_templates) ? false : true;    
}

// SendGrid subtitution tags 
$poll_formfield_sendgrid = (isset($poll_formfield['sendgrid']) && $poll_formfield['sendgrid'] != '' ) ? stripslashes( htmlentities( $poll_formfield['sendgrid']) ) : '';
?>

<div class="wrap">
    <div class="container-fluid">
        <h1><?= $heading; ?></h1>
        <hr/>
        <form class="ays-poll-formfield-form" id="ays-poll-formfield-form" method="post">
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for='ays-formfield-name'><?= __('Name', $this->plugin_name); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                           title="<?= __('Write the name of the form custom field.', $this->plugin_name); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <input class='ays-text-input' id='ays-formfield-name' name='ays_name' required type='text'
                           value='<?= (isset($poll_formfield['name'])) ? stripslashes(htmlentities($poll_formfield['name'])) : ''; ?>'>
                </div>
            </div>

            <hr/>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for="ays-formfield-slug"><?= __('Slug', $this->plugin_name); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                           title="<?= __('The slug of form custom field. This is an alias of the field.', $this->plugin_name); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <input class='ays-text-input' id='ays-formfield-slug' name='ays_slug' required readonly type='text'
                           data-new-id='<?= isset($poll_formfield['slug']) ? 0 : $new_slug_id; ?>'
                           value='<?= (isset($poll_formfield['slug'])) ? stripslashes(htmlentities($poll_formfield['slug'])) : "apm_attr_$new_slug_id"; ?>'>
                </div>
            </div>
            <hr/>
            <?php if($sendgrid_enabled) :?>
                <div class="form-group row">
                    <div class="col-sm-3">
                        <label for="ays_sendgrid_subtitution_tags"><?php echo __('SendGrid subtitution tags', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __('The name of subtitution for custom field (wirte without lines)', $this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-9">
                        <input type='text' class='ays-text-input' id='ays_sendgrid_subtitution_tags' name='ays_sendgrid_subtitution_tags' value='<?php echo $poll_formfield_sendgrid; ?>'>
                    </div>
                </div>
                <hr/>
            <?php endif; ?>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for="ays-formfield-type"><?= __('Type', $this->plugin_name); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                           title="<?= __('Choose the type of the custom field.', $this->plugin_name); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-3">
                    <select class='ays-select ays-select-search' id='ays-formfield-type'
                            name='ays_poll_formfield_type'>
                        <option value="0" selected disabled><?= __("Select field type", $this->plugin_name) ?></option>
                        <option value="text" <?= (isset($poll_formfield['type']) && $poll_formfield['type'] == 'text') ? 'selected' : ''; ?>><?= __('Text', $this->plugin_name); ?></option>
                        <option value="textarea" <?= (isset($poll_formfield['type']) && $poll_formfield['type'] == 'textarea') ? 'selected' : ''; ?>><?= __('Textarea', $this->plugin_name); ?></option>
                        <option value="email" <?= (isset($poll_formfield['type']) && $poll_formfield['type'] == 'email') ? 'selected' : ''; ?>><?= __('E-Mail', $this->plugin_name); ?></option>
                        <option value="number" <?= (isset($poll_formfield['type']) && $poll_formfield['type'] == 'number') ? 'selected' : ''; ?>><?= __('Number', $this->plugin_name); ?></option>
                        <option value="tel" <?= (isset($poll_formfield['type']) && $poll_formfield['type'] == 'tel') ? 'selected' : ''; ?>><?= __('Telephone', $this->plugin_name); ?></option>
                        <option value="url" <?= (isset($poll_formfield['type']) && $poll_formfield['type'] == 'url') ? 'selected' : ''; ?>><?= __('URL', $this->plugin_name); ?></option>
                        <option value="date" <?= (isset($poll_formfield['type']) && $poll_formfield['type'] == 'date') ? 'selected' : ''; ?>><?= __('Date', $this->plugin_name); ?></option>
                        <option value="color" <?= (isset($poll_formfield['type']) && $poll_formfield['type'] == 'color') ? 'selected' : ''; ?>><?= __('Color', $this->plugin_name); ?></option>
                        <option value="checkbox" <?= (isset($poll_formfield['type']) && $poll_formfield['type'] == 'checkbox') ? 'selected' : ''; ?>><?= __('Checkbox', $this->plugin_name); ?></option>
                    </select>
                </div>
                <div class="col-sm-6 ays_attr_description" <?php echo (!isset($poll_formfield['type']) || $poll_formfield['type'] != "checkbox") ? 'style="display:none"' : ''; ?> >
                    <div class="form-group row">
                        <div class="col-sm-3">
                            <label for="ays_poll_attr_option">Description                       
                            <a class="ays_help" data-toggle="tooltip" title="" data-original-title="Please write any text, email or link">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                            </label>
                        </div>
                        <div class="col-sm-9">
                            <input type="text" name="ays_poll_attr_description" id="ays_poll_attr_option" class="ays-text-input" value="<?php echo (isset($poll_formfield['options']) && $poll_formfield['type'] == "checkbox") ? stripslashes($poll_formfield['options']) : ''; ?>" placeholder="Accept <a href='#'>Terms</a>">
                        </div>
                    </div>
                </div>
            </div>
            <hr/>
            <div class="form-group row">
                <div class="col-sm-3">
                    <label><?= __('Custom field status', $this->plugin_name); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                           title="<?= __('Choose whether the custom field is active or not. If you choose an unpublished option, the field won’t be shown in the Information Form. (You do not need to remove it from the given poll(s)).', $this->plugin_name); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>

                <div class="col-sm-9">
                    <div class="form-check form-check-inline">
                        <input type="radio" id="ays-publish" name="ays_publish"
                               value="1" <?= ($poll_formfield["published"] == '') ? "checked" : ""; ?> <?= ($poll_formfield['published'] == '1') ? 'checked' : ''; ?> />
                        <label class="form-check-label"
                               for="ays-publish"> <?= __('Published', $this->plugin_name); ?> </label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input type="radio" id="ays-unpublish" name="ays_publish"
                               value="0" <?= ($poll_formfield['published'] == '0') ? 'checked' : ''; ?> />
                        <label class="form-check-label"
                               for="ays-unpublish"> <?= __('Unpublished', $this->plugin_name); ?> </label>
                    </div>
                </div>
            </div>
            <hr/>

			<?php
			wp_nonce_field('poll_formfield_action', 'poll_formfield_action');
			$other_formfields = array();
			submit_button(__('Save Attribute', $this->plugin_name), 'primary ays-button ays-loader-banner', 'ays_submit', false, $other_formfields);
			if ($id != null) {
				submit_button(__('Apply Attribute', $this->plugin_name), 'ays-button ays-loader-banner', 'ays_apply', false, $other_formfields);
			}
            echo $loader_iamge;
			?>
        </form>
    </div>
</div>