<div id="tab2" class="ays-poll-tab-content <?= $active_tab == 'tab2' ? 'ays-poll-tab-content-active' : ''; ?>">
    <p class="ays-subtitle"><?= __('Styling options', $this->plugin_name); ?></p>
    <hr>
    <div class="form-group row">
        <div class="col-sm-1">
            <label for='ays-poll-theme'>
                <?= __('Theme', $this->plugin_name); ?>
                <a  class="ays_help"  data-toggle="tooltip" data-placement="top" title="<?= __("Choose your preferred, ready to use template and customize it with the options below.", $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-11 apm-themes-row d-flex" data-themeid="<?php echo $poll['theme_id']; ?>">
            <div class="ays_poll_theme_image_div col">
                <label for="theme_minimal" class="ays-poll-theme-item <?php echo ($poll_theme_id == 7) ? 'apm_active_theme' : ''; ?>">
                    <p><?php echo __('Minimal', $this->plugin_name); ?></p>
                    <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL . '/images/themes/minimal.png'; ?>" alt="<?php echo __('Minimal', $this->plugin_name); ?>">
                </label>
                <input type="radio" name="ays_poll_theme" id="theme_minimal" value="7" <?php echo ($poll_theme_id == 7) ? 'checked' : ''; ?>>
            </div>
            <div class="ays_poll_theme_image_div col">
                <label for="theme_classic_light" class="ays-poll-theme-item <?php echo ($poll_theme_id <= 1) ? 'apm_active_theme' : ''; ?>">
                    <p><?php echo __('Classic Light', $this->plugin_name); ?></p>
                    <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL . '/images/themes/ClassicLight.png'; ?>" alt="<?php echo __('Classic Light', $this->plugin_name); ?>">
                </label>
                <input type="radio" name="ays_poll_theme" id="theme_classic_light" value="1" <?php echo ($poll_theme_id <= 1) ? 'checked' : ''; ?>>
            </div>
            <div class="ays_poll_theme_image_div col">
                <label for="theme_classic_dark" class="ays-poll-theme-item <?php echo ($poll_theme_id == 2) ? 'apm_active_theme' : ''; ?>">
                    <p><?php echo __('Classic Dark', $this->plugin_name); ?></p>
                    <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL . '/images/themes/ClassicDark.png'; ?>" alt="<?php __('Classic Dark', $this->plugin_name); ?>">
                </label>
                <input type="radio" name="ays_poll_theme" id="theme_classic_dark" value="2" <?php echo ($poll_theme_id == 2) ? 'checked' : '' ?>>
            </div>
            <div class="ays_poll_theme_image_div col">
                <label for="theme_light_shape" class="ays-poll-theme-item <?php echo ($poll_theme_id == 3) ? 'apm_active_theme' : ''; ?>">
                    <p><?php echo __('Light Shape', $this->plugin_name); ?></p>
                    <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL . '/images/themes/LightShape.png'; ?>" alt="<?php echo __('Light Shape', $this->plugin_name); ?>">
                </label>
                <input type="radio" name="ays_poll_theme" id="theme_light_shape" value="3" <?php echo ($poll_theme_id == 3) ? 'checked' : ''; ?>>
            </div>
            <div class="ays_poll_theme_image_div col">
                <label for="theme_dark_shape" class="ays-poll-theme-item <?php echo ($poll_theme_id == 4) ? 'apm_active_theme' : ''; ?>">
                    <p><?php echo __('Dark Shape', $this->plugin_name); ?></p>
                    <img src="<?= POLL_MAKER_AYS_ADMIN_URL . '/images/themes/DarkShape.png' ?>" alt="<?php echo __('Dark Shape', $this->plugin_name); ?>">
                </label>
                <input type="radio" name="ays_poll_theme" id="theme_dark_shape" value="4" <?php echo ($poll_theme_id == 4) ? 'checked' : '' ?>>
            </div>
            <div class="ays_poll_theme_image_div col">
                <label for="theme_coffee_fluid" class="ays-poll-theme-item <?php echo ($poll_theme_id == 5) ? 'apm_active_theme' : ''; ?>">
                    <p><?php echo __('Coffee Fluid', $this->plugin_name); ?></p>
                    <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL . '/images/themes/CoffeeFluid.png'; ?>" alt="<?php echo __('Coffee Fluid', $this->plugin_name); ?>">
                </label>
                <input type="radio" name="ays_poll_theme" id="theme_coffee_fluid" value="5" <?php echo ($poll_theme_id == 5) ? 'checked' : ''; ?>>
            </div>
            <div class="ays_poll_theme_image_div col">
                <label for="theme_aquamarine" class="ays-poll-theme-item <?php echo ($poll_theme_id == 6) ? 'apm_active_theme' : ''; ?>" >
                    <p><?php echo __("Aquamarine", $this->plugin_name); ?></p>
                    <img src="<?= POLL_MAKER_AYS_ADMIN_URL . '/images/themes/Aquamarine.png' ?>" alt="<?php echo __("Aquamarine", $this->plugin_name); ?>">
                </label>
                <input type="radio" name="ays_poll_theme" id="theme_aquamarine" value="6" <?php echo ($poll_theme_id == 6) ? 'checked' : '' ?>>
            </div>
        </div>
    </div> <!-- Theme -->
    <hr>
    <div class="form-group row">
      <div class="col-sm-12">
        <div class="row">
            <div class="col-lg-6 col-sm-12">
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for='ays-poll-main-color'>
                            <?= __('Main Color', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Specify the color of the poll's main attributes. It includes border color, the color of the rate percentage and the background color of the vote button.", $this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <input type="text" class="ays-text-input" id='ays-poll-main-color' name='ays_poll_main_color' data-alpha="true" value="<?= (isset($options['main_color'])) ? $options['main_color'] : '#0C6291'; ?>"/>
                    </div>
                </div> <!-- Main Color -->
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for='ays-poll-text-color'>
                            <?= __('Text Color', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" 
                            data-placement="top" title="<?= __("Specify the color of the text written inside the poll.", $this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <input type="text" class="ays-text-input" id='ays-poll-text-color'
                               name='ays_poll_text_color' data-alpha="true"
                               value="<?= (isset($options['text_color'])) ? $options['text_color'] : '#0C6291'; ?>"/>
                    </div>
                </div> <!-- Text Color -->
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for='ays-poll-icon-color'>
                            <?= __('Icons Color', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Specify the icon color in voting and rating types.", $this->plugin_name); ?>"><i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <input type="text" class="ays-text-input" id='ays-poll-icon-color' name='ays_poll_icon_color' data-alpha="true" value="<?= (isset($options['icon_color'])) ? $options['icon_color'] : '#0C6291'; ?>"/>
                    </div>
                </div> <!-- Icons Color -->
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for='ays-poll-bg-color'>
                            <?= __('Background Color', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("
                                Specify the background color of the poll.", $this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <input type="text" class="ays-text-input" id='ays-poll-bg-color' name='ays_poll_bg_color' data-alpha="true" value="<?= (isset($options['bg_color'])) ? $options['bg_color'] : '#FBFEF9'; ?>"/>
                    </div>
                </div> <!-- Background Color -->
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for='ays-poll-bg-image'>
                            <?= __('Background Image', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Add a background image to the poll. If you add a background image, the background color will not be applied.", $this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <a href="javascript:void(0)" class="add-bg-image button">
                            <?= $image_text_bg; ?>                                        
                        </a>
                        <div class="col-sm-12" style="<?= $style_bg; ?>">
                            <div class="ays-poll-bg-image-container">
                                <span class="ays-remove-bg-img"></span>
                                <img src="<?= isset($options['bg_image']) ? $options['bg_image'] : ""; ?>" id="ays-poll-bg-img"/>
                                <input type="hidden" name="ays_poll_bg_image" id="ays-poll-bg-image" value="<?= isset($options['bg_image']) ? $options['bg_image'] : ""; ?>"/>
                                <input type="hidden" name="ays_poll_bg_image-pos" id="ays-poll-bg-image-pos" value="<?= isset($options['poll_bg_image_position']) ? $options['poll_bg_image_position'] : ""; ?>"/>
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-12">
                                <label for="ays_poll_bg_image_position">
                                    <?php echo __( "Background image position", $this->plugin_name ); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('The position of background image of the polls',$this->plugin_name); ?>">
                                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                    </a>
                                </label>
                                <select id="ays_poll_bg_image_position" name="ays_poll_bg_image_position" class="ays-text-input ays-text-input-short ays_poll_aysDropdown" style="display:inline-block;">
                                    <option value="left top" <?php echo $poll_bg_image_position == "left top" ? "selected" : ""; ?>><?php echo __( "Left Top", $this->plugin_name ); ?></option>
                                    <option value="left center" <?php echo $poll_bg_image_position == "left center" ? "selected" : ""; ?>><?php echo __( "Left Center", $this->plugin_name ); ?></option>
                                    <option value="left bottom" <?php echo $poll_bg_image_position == "left bottom" ? "selected" : ""; ?>><?php echo __( "Left Bottom", $this->plugin_name ); ?></option>
                                    <option value="center top" <?php echo $poll_bg_image_position == "center top" ? "selected" : ""; ?>><?php echo __( "Center Top", $this->plugin_name ); ?></option>
                                    <option value="center center" <?php echo $poll_bg_image_position == "center center" ? "selected" : ""; ?>><?php echo __( "Center Center", $this->plugin_name ); ?></option>
                                    <option value="center bottom" <?php echo $poll_bg_image_position == "center bottom" ? "selected" : ""; ?>><?php echo __( "Center Bottom", $this->plugin_name ); ?></option>
                                    <option value="right top" <?php echo $poll_bg_image_position == "right top" ? "selected" : ""; ?>><?php echo __( "Right Top", $this->plugin_name ); ?></option>
                                    <option value="right center" <?php echo $poll_bg_image_position == "right center" ? "selected" : ""; ?>><?php echo __( "Right Center", $this->plugin_name ); ?></option>
                                    <option value="right bottom" <?php echo $poll_bg_image_position == "right bottom" ? "selected" : ""; ?>><?php echo __( "Right Bottom", $this->plugin_name ); ?></option>
                                </select>
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-8">
                                <label for="ays_poll_bg_img_in_finish_page">
                                    <?php echo __( "Hide background image on result page", $this->plugin_name ); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('If this option is enabled background image of poll will disappear on the result page.',$this->plugin_name); ?>">
                                        <i class="ays_fa ays_fa_info_circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-4">
                                <input type="checkbox" class="ays_toggle ays_toggle_slide" id="ays_poll_bg_img_in_finish_page" name="ays_poll_bg_img_in_finish_page" <?php echo ($poll_bg_img_in_finish_page) ? 'checked' : ''; ?>/>
                                <label for="ays_poll_bg_img_in_finish_page" style="display:inline-block;margin-left:10px;" class="ays_switch_toggle">Toggle</label>
                            </div>
                        </div>
                    </div>                            
                </div> <!-- Background Image -->
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_poll_show_answers_icon">
                            <?php echo __('Answer icon',$this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Choose your preferred icon for the answers.',$this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <input type="checkbox" class="ays_toggle ays_toggle_slide" id="ays_poll_show_answers_icon" name="ays_poll_show_answers_icon" <?php echo ($show_answers_icon) ? 'checked' : ''; ?> />
                        <label for="ays_poll_show_answers_icon" class="ays_switch_toggle" style="margin-bottom: 15px;">Toggle</label>
                        <div class="col-sm-12 ays_toggle_target ays_divider_top <?php echo ($show_answers_icon) ? '' : 'display_none'; ?>" style="padding-top: 10px;">
                            <div class="form-check form-check-inline">
                                <label class="form-check-label ays_poll_answer_icon" for="poll_answer_icon_radio"> 
                                    <input type="radio" class="ays_poll_answ_icon" id="poll_answer_icon_radio" name="ays_poll_answer_icon" value="radio" <?= (isset($options['answers_icon']) && $options['answers_icon'] == 'radio') ? 'checked' : ''; ?> />
                               </label>
                            </div>
                            <div class="form-check form-check-inline">
                               <label class="form-check-label ays_poll_answer_icon" for="poll_answer_icon_checkbox"> 
                                    <input type="radio" class="ays_poll_answ_icon" id="poll_answer_icon_checkbox" name="ays_poll_answer_icon" value="checkbox" <?= (isset($options['answers_icon']) && $options['answers_icon'] == 'checkbox') ? 'checked' : ''; ?> />
                               </label>
                            </div>
                        </div>
                    </div>
                </div> <!-- Answer icon -->
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for='ays-poll-title-bg-color'>
                            <?= __('Title Background Color', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Specify the background color of the title.", $this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <input type="text" class="ays-text-input" id='ays-poll-title-bg-color' name='ays_poll_title_bg_color' data-alpha="true" value="<?= !empty($title_bg_color_s) ? $title_bg_color_s : $bg_color_s; ?>"/>
                    </div>
                </div> <!-- Title Background Color -->
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for='ays_poll_title_font_size'>
                            <?= __('Title font size', $this->plugin_name); ?>
                            <a class="ays_help"
                                data-toggle="tooltip"
                                data-placement="top"
                                title="<?= __("Specify the font size of the title.", $this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <div class="row">
                            <div class="col-sm-5">
                                <label for='ays_poll_title_font_size'>
                                    <?php echo __('On PC', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the font size for PC devices.',$this->plugin_name)?>">
                                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-7">
                                <input type="number" class="ays-text-input ays-text-input-short" id='ays_poll_title_font_size' name='ays_poll_title_font_size' value="<?= $poll_title_font_size ?>"/>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-sm-5">
                                <label for='ays_poll_title_font_size_mobile'>
                                    <?php echo __('On mobile', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the font size for mobile devices.',$this->plugin_name)?>">
                                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-7">
                                <input type="number" class="ays-text-input ays-text-input-short" name="ays_poll_title_font_size_mobile" id="ays_poll_title_font_size_mobile" value="<?php echo $poll_title_font_size_mobile;?>">
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for='ays_poll_title_alignment'>
                            <?= __('Title alignment', $this->plugin_name); ?>
                            <a class="ays_help"
                                data-toggle="tooltip"
                                data-placement="top"
                                title="<?= __("Specify the alignment of the title.", $this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <select id="ays_poll_title_alignment" name="ays_poll_title_alignment" class="ays_poll_aysDropdown">
                            <option value="left" <?php echo ($poll_title_alignment == "left") ? "selected" : "";?>><?php echo __("Left" , $this->plugin_name); ?></option>
                            <option value="center" <?php echo ($poll_title_alignment == "center") ? "selected" : "";?>><?php echo __("Center" , $this->plugin_name); ?></option>
                            <option value="right" <?php echo ($poll_title_alignment == "right") ? "selected" : "";?>><?php echo __("Right" , $this->plugin_name); ?></option>
                        </select>
                    </div>
                </div>
                <hr>
                <!-- title text shadow start -->
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_poll_enable_title_text_shadow">
                            <?php echo __('Title text shadow',$this->plugin_name)?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Add text shadow for the poll title.',$this->plugin_name)?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">

                        <input type="checkbox" class="ays_toggle ays_toggle_slide" id="ays_poll_enable_title_text_shadow" name="ays_poll_enable_title_text_shadow" <?php echo ($enable_poll_title_text_shadow) ? 'checked' : ''; ?>/>

                        <label for="ays_poll_enable_title_text_shadow" class="ays_switch_toggle">Toggle</label>

                        <div class="row ays_toggle_target <?php echo ($enable_poll_title_text_shadow) ? '' : 'ays_poll_display_none' ?>" style="margin: 10px 0 0 0; padding-top: 10px;">
                            <div class="col-sm-12 ays_divider_top" style="margin-top: 10px; padding-top: 10px;">
                                <label for='ays_poll_title_text_shadow_color'>
                                    <?php echo __('Color', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Specify text shadow color.',$this->plugin_name)?>">
                                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                    </a>
                                </label>
                                <input type="text" class="ays-text-input" id='ays_poll_title_text_shadow_color' data-alpha="true" name='ays_poll_title_text_shadow_color' value="<?php echo $poll_title_text_shadow; ?>"/>
                            </div>
                            <!---->
                            <hr class="ays_toggle_target" style="<?= $enable_poll_title_text_shadow ? '' : 'display:none'; ?>">
                                <div class="form-group row ays_toggle_target" style="<?= $enable_poll_title_text_shadow ? '' : 'display:none' ?>">
                                    <div class="col-sm-12">
                                        <div class="col-sm-3" style="display: inline-block;">
                                            <input type="number" class="ays-text-input ays-text-input-90-width ays-title-text-shadow-coord-change" id='ays_poll_title_text_shadow_x_offset' name='ays_poll_title_text_shadow_x_offset' value="<?php echo $poll_title_text_shadow_x_offset; ?>" />
                                            <span class="ays_poll_small_hint_text"><?php echo __('X', $this->plugin_name); ?></span>
                                        </div>
                                        <div class="col-sm-3 ays_divider_left" style="display: inline-block;">
                                            <input type="number" class="ays-text-input ays-text-input-90-width ays-title-text-shadow-coord-change" id='ays_poll_title_text_shadow_y_offset' name='ays_poll_title_text_shadow_y_offset' value="<?php echo $poll_title_text_shadow_y_offset; ?>" />
                                            <span class="ays_poll_small_hint_text"><?php echo __('Y', $this->plugin_name); ?></span>
                                        </div>
                                        <div class="col-sm-3 ays_divider_left" style="display: inline-block;">
                                            <input type="number" class="ays-text-input ays-text-input-90-width ays-title-text-shadow-coord-change" id='ays_poll_title_text_shadow_z_offset' name='ays_poll_title_text_shadow_z_offset' value="<?php echo $poll_title_text_shadow_z_offset; ?>" />
                                            <span class="ays_poll_small_hint_text"><?php echo __('Z', $this->plugin_name); ?></span>
                                        </div>
                                    </div>
                                </div>
                            <!---->
                        </div>
                    </div>
                </div><!-- title text shadow end -->
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for='ays-poll-icon-size'>
                            <?= __('Icon size (px)', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Specify the size of the icons in rating and voting types of the poll in pixels. It should be 10 and more.", $this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <input type="number" class="ays-text-input ays-text-input-short" id='ays-poll-icon-size' name='ays_poll_icon_size' value="<?= (isset($options['icon_size'])) ? $options['icon_size'] : '24'; ?>"/>
                    </div>
                </div> <!-- Icon size (px) -->
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for='ays-poll-width'>
                            <?= __('Width (px)', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Specify the width of the poll in pixels. If you put 0, the width will be 100%.", $this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                       <div>
                            <div class="col-sm-5">
                                <label for='ays_poll_width'>
                                    <?php echo __('On PC', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the width for PC devices.',$this->plugin_name)?>">
                                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-7">
                                <input type="number" min="0" class="ays-text-input ays-text-input-short" id='ays-poll-width' name='ays_poll_width' value="<?= (isset($options['width'])) ? $options['width'] : '0'; ?>"/>
                            </div>
                        </div>
                        <hr>
                        <div>
                            <div class="col-sm-5">
                                <label for='ays_poll_width_for_mobile'>
                                    <?php echo __('On mobile', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the width for mobile devices.',$this->plugin_name)?>">
                                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-7">
                                <input type="number"  class="ays-text-input ays-text-input-short" id='ays_poll_width_for_mobile' name='ays_poll_width_for_mobile' value="<?= $width_for_mobile ?>"/>
                            </div>
                        </div>
                    </div>
                </div> <!-- Width (px) -->
                <hr/>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for='ays_poll_min_height'>
                            <?php echo __('Min-height', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Set the poll minimum height by entering a numeric value.',$this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <input type="number" class="ays-text-input ays-text-input-short" id='ays_poll_min_height' name='ays_poll_min_height' value="<?php echo $poll_min_height; ?>"/>
                    </div>
                </div> <!-- Min-height -->
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for='ays-poll-border-style'>
                            <?= __('Border style', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Choose your preferred style of the border.", $this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <select name="ays_poll_border_style" id="ays-poll-border-style" class="ays-select ays_poll_aysDropdown">
                            <option value="solid"  <?= $border_s == "solid" ? 'selected' : ''; ?>><?= __("Solid", $this->plugin_name); ?></option>
                            <option value="dashed" <?= $border_s == "dashed" ? 'selected' : ''; ?>><?= __("Dashed", $this->plugin_name); ?></option>
                            <option value="dotted" <?= $border_s == "dotted" ? 'selected' : ''; ?>><?= __("Dotted", $this->plugin_name); ?></option>
                            <option value="double" <?= $border_s == "double" ? 'selected' : ''; ?>><?= __("Double", $this->plugin_name); ?></option>
                            <option value="groove" <?= $border_s == "groove" ? 'selected' : ''; ?>><?= __("Groove", $this->plugin_name); ?></option>
                            <option value="ridge"  <?= $border_s == "ridge" ? 'selected' : ''; ?>><?= __("Ridge", $this->plugin_name); ?></option>
                            <option value="inset"  <?= $border_s == "inset" ? 'selected' : ''; ?>><?= __("Inset", $this->plugin_name); ?></option>
                            <option value="outset" <?= $border_s == "outset" ? 'selected' : ''; ?>><?= __("Outset", $this->plugin_name); ?></option>
                            <option value="none"   <?= $border_s == "none" ? 'selected' : ''; ?>><?= __("None", $this->plugin_name); ?></option>
                        </select>
                    </div>
                </div> <!-- Border style -->
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for='ays-poll-border-radius'><?= __('Border radius', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Define the radius of the corners of the poll container. Allows adding rounded corners to it.", $this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <input type="number" min="0" class="ays-text-input ays-text-input-short" id='ays-poll-border-radius' name='ays_poll_border_radius' value="<?= (isset($options['border_radius']) && $options['border_radius']) ? $options['border_radius'] : '0'; ?>"/>
                    </div>
                </div> <!-- Border radius -->
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for='ays-poll-border-width'><?= __('Border width', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Specify the width of the border. For the Coffee Fluid theme, border-width will always be 1px.", $this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <input type="number" min="0" class="ays-text-input ays-text-input-short" id='ays-poll-border-width' name='ays_poll_border_width' value="<?= isset($options['border_width']) && $options['border_width'] != '' ? $options['border_width'] : 2; ?>"/>
                    </div>
                </div> <!-- Border width -->
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for='ays_poll_enable_box_shadow'><?= __('Box shadow', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Add a shadow to your poll container. Moreover, you can choose the color of it.", $this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <input type="checkbox" class="ays_toggle ays_toggle_slide" id="ays_poll_enable_box_shadow" name="ays_poll_enable_box_shadow" <?= (isset($options['enable_box_shadow']) && $options['enable_box_shadow'] == 'on') ? 'checked' : ''; ?>>
                        <label for="ays_poll_enable_box_shadow" class="ays_switch_toggle">Toggle</label>
                        <div class="col-sm-12 ays_toggle_target ays_divider_top <?php echo $enable_box_shadow_box?>"
                             style="margin-top: 10px; padding-top: 10px;">
                            <label for="ays-poll-box-shadow-color">
                                <?= __('Box shadow color', $this->plugin_name); ?>
                                <a class="ays_help" data-toggle="tooltip"
                                   title="<?= __('The shadow color of Poll container', $this->plugin_name); ?>">
                                    <i class="ays_fa ays_fa_info_circle"></i>
                                </a>
                            </label>
                            <input type="text" class="ays-shadow-input" id='ays-poll-box-shadow-color' name='ays_poll_box_shadow_color' data-alpha="true" value="<?= (isset($options['box_shadow_color']) && !empty($options['box_shadow_color'])) ? $options['box_shadow_color'] : ''; ?>"/>
                        </div>
                    </div>
                </div> <!-- Box shadow -->
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays-enable-background-gradient">
                            <?php echo __('Background Gradient',$this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Add a color gradient background in the poll. Moreover, you can choose Color 1, Color 2 and the direction of the gradient.',$this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <input type="checkbox" class="ays_toggle ays_toggle_slide" id="ays-enable-background-gradient" name="ays_enable_background_gradient"
                                <?php echo ($enable_background_gradient) ? 'checked' : ''; ?>/>
                        <label for="ays-enable-background-gradient" class="ays_switch_toggle">Toggle</label>
                        <div class="row ays_toggle_target" style="margin: 10px 0 0 0; padding-top: 10px; <?php echo ($enable_background_gradient) ? '' : 'display:none;' ?>">
                            <div class="col-sm-12 ays_divider_top" style="margin-top: 10px; padding-top: 10px;">
                                <label for='ays-background-gradient-color-1'>
                                    <?php echo __('Color 1', $this->plugin_name); ?>
                                </label>
                                <input type="text" class="ays-text-input" id='ays-background-gradient-color-1' name='ays_background_gradient_color_1' data-alpha="true" value="<?php echo $background_gradient_color_1; ?>"/>
                            </div>
                            <div class="col-sm-12 ays_divider_top" style="margin-top: 10px; padding-top: 10px;">
                                <label for='ays-background-gradient-color-2'>
                                    <?php echo __('Color 2', $this->plugin_name); ?>
                                </label>
                                <input type="text" class="ays-text-input" id='ays-background-gradient-color-2' name='ays_background_gradient_color_2' data-alpha="true" value="<?php echo $background_gradient_color_2; ?>"/>
                            </div>
                            <div class="col-sm-12 ays_divider_top" style="margin-top: 10px; padding-top: 10px;">
                                <label for="ays_poll_gradient_direction">
                                    <?php echo __('Gradient direction',$this->plugin_name)?>
                                </label>
                                <select id="ays_poll_gradient_direction" name="ays_poll_gradient_direction" class="ays-text-input">
                                    <option <?php echo ($poll_gradient_direction == 'vertical') ? 'selected' : ''; ?> value="vertical"><?php echo __( 'Vertical', $this->plugin_name); ?></option>
                                    <option <?php echo ($poll_gradient_direction == 'horizontal') ? 'selected' : ''; ?> value="horizontal"><?php echo __( 'Horizontal', $this->plugin_name); ?></option>
                                    <option <?php echo ($poll_gradient_direction == 'diagonal_left_to_right') ? 'selected' : ''; ?> value="diagonal_left_to_right"><?php echo __( 'Diagonal left to right', $this->plugin_name); ?></option>
                                    <option <?php echo ($poll_gradient_direction == 'diagonal_right_to_left') ? 'selected' : ''; ?> value="diagonal_right_to_left"><?php echo __( 'Diagonal right to left', $this->plugin_name); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div> <!-- Background Gradient -->
                <hr/>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_poll_background_size">
                            <?php echo __('Answer image object fit' , $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Specify how an answers’ images should be resized to fit its container.',$this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <select id="ays_poll_background_size" name="ays_poll_background_size" class="ays-select ays_poll_aysDropdown">
                            <option <?php echo ($background_size == 'cover') ? 'selected' : ''; ?> value="cover"><?php echo __( 'Cover', $this->plugin_name); ?></option>
                            <option <?php echo ($background_size == 'contain') ? 'selected' : ''; ?> value="contain"><?php echo __( 'Contain', $this->plugin_name); ?></option>
                        </select>
                    </div>
                </div> <!-- Answer image object fit -->
                <hr/>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_disable_answer_hover">
                            <?= __('Disable answers hover', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Disable the hover effect for answers.", $this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <input type="checkbox" name="ays_disable_answer_hover" class="ays_toggle ays_toggle_slide" id="ays_disable_answer_hover" value="on" <?php echo ($dis_answer_hover_s == 1) ? 'checked' : ''; ?> >
                        <label for="ays_disable_answer_hover" class="ays_switch_toggle">Toggle</label>
                    </div>
                </div> <!-- Disable answers hover -->
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_disable_answer_hover">
                            <?= __('Poll Logo', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip"
                               data-placement="top"
                               title="<?= __("Add logo image for poll. Advisable size for image is 50x50", $this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <a href="javascript:void(0)" class="add-logo-image button"><?= $image_text_logo; ?></a>                                    
                            </div>
                            <div class="col-sm-8 ays_logo_image_remove ays_divider_left" style="<?= $style_logo; ?>">
                                <div class="ays-poll-logo-image-container">
                                    <img src="<?php echo $poll_logo_image; ?>"
                                        id="ays-poll-logo-img"/>
                                    <input type="hidden" name="ays_poll_logo_image" id="ays-poll-logo-image"
                                        value="<?php echo $poll_logo_image; ?>"/>                                            
                                    <div class="ays-poll-logo-image-remove-box">
                                        <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL . '/images/remove-normal.png'?>" id="ays-poll-logo-image-remover">                                             
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr class="<?php echo !$style_logo_check ? "display_none" : "";?> ays-poll-logo-url-disable">
                        <div class="form-group row ays-poll-logo-url-disable ays-poll-toggle-image-url-box <?php echo !$style_logo_check ? "display_none" : "";?>">
                            <div class="col-sm-4 ">
                                <label for="ays_disable_answer_hover">
                                    <?= __('Logo URL', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip"
                                    data-placement="top"
                                    title="<?= __("Add a URL link to the poll's logo image.", $this->plugin_name); ?>">
                                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                    </a>
                                </label>                                   
                            </div>
                            <div class="col-sm-8 ays_divider_left">
                                <input type="checkbox"
                                        name="ays_poll_logo_enable_image_url"
                                        id="ays_poll_logo_enable_image_url"
                                        value="on" class="ays_toggle ays_toggle_slide" <?php echo $poll_logo_image_url_check ? "checked" : ""; ?>>
                                <label for="ays_poll_logo_enable_image_url" class="ays_switch_toggle"></label>
                                <hr class="ays_toggle_target <?php echo $poll_logo_image_url_check ? "" : "display_none"; ?>">
                                <div class="row ays_toggle_target <?php echo $poll_logo_image_url_check ? "" : "display_none"; ?>" style="padding:0 15px;" >
                                    <input type="text" name="ays_poll_logo_image_url" id="ays_poll_logo_image_url" value="<?php echo $poll_logo_image_url; ?>" style="width: 100%;" class="ays-text-input" placeholder="URL">
                                </div>
                                <hr class="ays_toggle_target <?php echo $poll_logo_image_url_check ? "" : "display_none"; ?>">
                                <div class="row ays_toggle_target ays-poll-logo-open-close <?php echo $poll_logo_image_url_check ? "" : "display_none"; ?>">
                                    <div class="col-sm-6">
                                        <label for="ays_poll_logo_enable_image_url_new_tab">
                                            <?= __('Open in a new tab', $this->plugin_name); ?>
                                            <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Activate this option, if you want to open the URL in a new tab.", $this->plugin_name); ?>">
                                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                            </a>
                                        </label> 
                                    </div>
                                    <div class="col-sm-6 ays_divider_left">
                                        <input type="checkbox" name="ays_poll_logo_enable_image_url_new_tab" id="ays_poll_logo_enable_image_url_new_tab" value="on" class="ays_toggle ays_toggle_slide " <?php echo $poll_logo_image_url_check_new_tab; ?>>
                                        <label for="ays_poll_logo_enable_image_url_new_tab" class="ays_switch_toggle"></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> <!-- Poll Logo -->
                <hr>                                
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for='ays_questions_font_size'>
                            <?php echo __('Question font size', $this->plugin_name); ?> (px)
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Specify the font size of the questions( only for <p> tag ). It accepts only numerical values.',$this->plugin_name)?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <div>
                            <div class="col-sm-5">
                                <label for='ays_poll_answers_font_size_pc'>
                                    <?php echo __('On PC', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the font size for PC devices.',$this->plugin_name)?>">
                                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-7">
                                <input type="number" class="ays-text-input ays-poll-question-font-size-all ays-text-input-short" id='ays_poll_answers_font_size_pc' name='ays_poll_answers_font_size_pc' value="<?php echo $question_font_size; ?>" />
                            </div>
                        </div>
                        <hr>
                        <div>
                            <div class="col-sm-5">
                                <label for='ays_poll_answers_font_size_mobile'>
                                    <?php echo __('On mobile', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the font size for mobile devices.',$this->plugin_name)?>">
                                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-7">
                                <input type="number" class="ays-text-input ays-poll-question-font-size-all ays-text-input-short" name="ays_poll_answers_font_size_mobile" id="ays_poll_answers_font_size_mobile" value="<?php echo $question_font_size_mobile;?>">
                            </div>
                        </div>
                    </div>
                </div><!-- Question font size -->  
                <hr/>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for='ays_poll_question_image_height'><?= __('Question image height', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" data-placement="top"
                                title="<?= __("Specify the height of question image of the Poll.", $this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <input type="number"
                                class="ays-text-input ays-text-input-short"
                                id='ays_poll_question_image_height' name='ays_poll_question_image_height'
                                value="<?php echo $poll_question_image_height; ?>"/>
                    </div>
                </div><!-- Question image height -->
                <hr/>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for='ays_poll_mobile_max_width'>
                            <?php echo __('Poll max-width for mobile', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __('Poll container max-width for mobile in percentage. This option will work for the screens with less than 640 pixels width.',$this->plugin_name)?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <input type="number" class="ays-text-input ays-text-input-short" id='ays_poll_mobile_max_width'
                            name='ays_poll_mobile_max_width' style="display: inline-block;"
                            value="<?php echo $poll_mobile_max_width; ?>"/> %
                            <span class="ays_poll_small_hint_text"><?php echo __("For 100% leave blank", $this->plugin_name);?></span>
                    </div>
                </div> <!-- Poll max-width for mobile -->
                <hr/>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_poll_custom_class">
                            <?php echo __('Custom class for poll container',$this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Use your custom HTML class for adding your custom styles to the poll container.',$this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-8 ays_divider_left">
                        <input type="text" class="ays-text-input" name="ays_poll_custom_class" id="ays_poll_custom_class" placeholder="myClass myAnotherClass..." value="<?php echo $custom_class; ?>">
                    </div>
                </div> <!-- Custom class for poll container -->
            </div>
            <div class="col-lg-6 col-sm-12 ays_divider_left" style="position: relative;">
                <!-- <style id='ays-poll-custom-css'>
                    <?=$poll['custom_css']?>
                </style> -->
                <?php $content = "
                    <div class='box-apm-scroll'>
                        <div class='box-apm $poll_theme {$poll['type']}-poll ".$poll_logo_for_live_container."' id=''>
                            <div class='apm-title-box'>
                                <h5>{$poll['title']}</h5>
                            </div>";

                $content .= "<div class='ays_question'>" . stripslashes($poll['question']) . "</div>
                                    <div class='apm-img-box'>";
                            // <div class=' ays_question'>" . stripslashes($poll['question']) . "</div>            
                            // <div class='apm-img-box'>";
                $content .= !empty($poll['image']) ? "<img class='ays-poll-img' src='{$poll['image']}'>" : "";
                $checking_answer_hover = ($dis_answer_hover_s == 1) ? 'disable_hover' : 'ays_enable_hover';
                $content .= "
                            </div>";
                $minimalTheme = ($poll['theme_id'] == 7) ? 'ays_poll_minimal_theme' : '' ;
                $minimalThemeBtn = ($poll['theme_id'] == 7) ? 'ays_poll_minimal_theme_btn' : '' ;
                if ($show_answers_icon && $poll['theme_id'] != 7 && $poll['view_type'] != 'grid' && $poll_theme != 'ays-aqua-theme') {
                    switch ($options['answers_icon']) {
                        case 'radio':
                            $answer_icon_class = 'ays_poll_answer_icon_radio';
                            break;
                        case 'checkbox':
                            $answer_icon_class = 'ays_poll_answer_icon_checkbox';
                            break;                                      
                        default:
                            $answer_icon_class = '';
                            break;
                    }
                }else{
                    $answer_icon_class = '';
                }

                switch ( $poll['type'] ) {
                    case 'choosing':
                        $content .= "<div class='apm-answers $without_vote " . ($poll['view_type'] == 'grid' ? "apm-grid" : "") . "'>";
                        foreach ( $poll['answers'] as $index => $answer ) {
                            $content .= "<div class='apm-choosing answer- ".$minimalTheme." '>
                                            <input type='radio' name='answer' id='radio-$index-' value='{$answer['id']}'>
                                            <label for='radio-$index-' class='ays_label_poll ".$answer_icon_class." ".$checking_answer_hover." " . (!empty($answer['answer_img']) && $poll['view_type'] == 'grid' ? " apm-label-with-bg " : "") . "' " . (!empty($answer['answer_img']) && $poll['view_type'] == 'grid' ? " style='background-image:url({$answer['answer_img']})'" : "") . "><span class='ays_grid_answer_span'>" . stripcslashes($answer['answer']) . "</span></label>
                                        </div>";
                        }
                        $content .= "</div>";
                        break;
                    case 'versus':
                        $vs_icon_type = isset($options['versus_icon_type']) ? $options['versus_icon_type'] : "";
                        $vs_icon_pos  = isset($options['versus_icon_position']) ? $options['versus_icon_position'] : "";
                        $content      .= "<div class='apm-answers $without_vote apm-versus {$poll['view_type']} vs-$vs_icon_type vs-icon-$vs_icon_pos'>";
                        foreach ( $poll['answers'] as $index => $answer ) {
                            $content .= "
                                        <div class='apm-versus-answer answer-'>
                                            <input type='radio' name='answer' id='radio-$index-' value='{$answer['id']}'>
                                            <label for='radio-$index-' " . (!empty($answer['answer_img']) ? "class='apm-label-with-bg' style='background-image:url({$answer['answer_img']})'" : "class='apm-simple-label'") . ">
                                                " . ((isset($options['versus_answers_label']) && $options['versus_answers_label']) || empty($answer['answer_img']) ? "<span>" . stripcslashes(html_entity_decode($answer['answer'])) . "</span>" : "") . "
                                            </label>
                                        </div>
                                    ";
                        }
                        $content .= "</div>";
                        break;
                    case 'voting':
                        $content .= "<div class='apm-answers $without_vote'>";
                        switch ( $poll['view_type'] ) {
                            case 'hand':
                                foreach ( $poll['answers'] as $index => $answer ) {
                                    $content .= "<div class='apm-voting answer-'><input type='radio' name='answer' id='radio-$index-' value='{$answer['id']}'>
                                                    <label for='radio-$index-'>";
                                    $content .= ((int) $answer['answer'] > 0 ? "<i class='ays_poll_far ays_poll_fa-thumbs-up'></i>" : "<i class='ays_poll_far ays_poll_fa-thumbs-down'></i>") . "</label></div>";
                                }
                                break;
                            case 'emoji':
                                foreach ( $poll['answers'] as $index => $answer ) {
                                    $content .= "<div class='apm-voting answer-'><input type='radio' name='answer' id='radio-$index-' value='{$answer['id']}'>
                                                    <label for='radio-$index-'>";
                                    $content .= ((int) $answer['answer'] > 0 ? $emoji[1] : $emoji[3]) . "</label></div>";
                                }
                                break;
                        }
                        $content .= "</div>";
                        break;
                    case 'rating':
                        $content .= "<div class='apm-answers $without_vote'>";
                        switch ( $poll['view_type'] ) {
                            case 'star':
                                foreach ( $poll['answers'] as $index => $answer ) {
                                    $content .= "<div class='apm-rating answer-'><input type='radio' name='answer' id='radio-$index-' value='{$answer['id']}'>
                                                    <label for='radio-$index-'><i class='ays_poll_far ays_poll_fa-star'></i></label></div>";
                                }
                                break;
                            case 'emoji':
                                foreach ( $poll['answers'] as $index => $answer ) {
                                    $content .= "<div class='apm-rating answer-'><input type='radio' name='answer' id='radio-$index-' value='{$answer['id']}'>
                                                    <label class='emoji' for='radio-$index-'>" . $emoji[(count($poll['answers']) / 2 - $index + 1.5)] . "</label></div>";
                                }
                                break;
                        }
                        $content .= "</div>";
                        break;
                    case 'dropdown':
                            $content .= "<div class='apm-answers ".$without_vote."' style='text-align:center'>";
                            $content .= "<select class='apm-dropdown answer- ".$minimalTheme."' id='apm_dropdown_answers' name='answer'>"; 
                            $content .= "<option value=''>".__('Select an answer', $this->plugin_name)."</option>";
                            foreach ( $poll['answers'] as $index => $answer ) {
                                $content .= "<option value='{$answer['id']}'>".stripcslashes(html_entity_decode($answer['answer']))."</option>";
                            }
                            $content .=  "</select>
                                </div>";
                        break;
                    case 'text':
                        $poll_view_type_text = isset($poll['view_type']) && $poll['view_type'] != "" ? $poll['view_type'] : "short_text";
                        switch ( $poll_view_type_text ) {
                            case 'short_text':
                                $content .= "<div class='ays-poll-maker-text-live-preview'>
                                                <input type='text' id='ays_poll_text_type_short_live' readonly class='ays-poll-text-type-fields'>
                                                <label for='ays_poll_text_type_short_live'></label>
                                            </div>";											
                                break;
                            case 'paragraph':
                                $content .= "<div class='ays-poll-maker-text-live-preview'>
                                                <textarea id='ays_poll_text_type_paragraph_live' readonly class='ays-poll-text-type-fields'></textarea>
                                                <label for='ays_poll_text_type_paragraph_live'></label>
                                            </div>";
                                break;
                            default:										
                                break;
                        }
                        break;	


                }
                $content .= "
                            <div class='apm-button-box'>
                                <input type='button' name='ays_finish_poll' class='btn ays-poll-btn {$poll['type']}-btn ".$minimalThemeBtn." ' data-form='' " . 'value="' . $vote_button . '">
                            </div>';
                            $content .= "<div class='".$poll_logo_img." ays_live_logo_container'>";
                if($poll_check_logo){
                    $content .= "<img src=".$poll_logo_image." width='55' height='55'>";
                }        
                $content .= "</div>";
                        
                $content .='</div>
                </div>';
                print $content;
                ?>
            </div>
        </div>
      </div>
    </div>
    <hr/>
    <div class="form-group row">
        <div class="col-sm-2">
            <label for='<?php echo $ays_poll_enable_answer_style_type != "" ? : "ays_poll_enable_answer_style"; ?>' style="font-size:18px;"><?= __('Answer styles', $this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Highlight the background of the answers' boxes. The option works only with choosing type.", $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-10 ays_divider_left">
            <input type="checkbox" class="ays_toggle ays_toggle_slide" id="ays_poll_enable_answer_style" name="ays_poll_enable_answer_style" <?= ($options['enable_answer_style'] == 'on') ? 'checked' : ''; ?>>
            <label for="ays_poll_enable_answer_style" class="ays_switch_toggle <?php echo $ays_poll_enable_answer_style_type; ?>" >Toggle</label>
        </div>
    </div>
    <!-- <p class="ays-subtitle" style="margin-top:0;"><#?php echo __('Answers Styles',$this->plugin_name)?></p> -->
    <hr/>
    <div class="form-group row">
        <div class="col-lg-6 col-sm-12 ays_answer_styles_main">
            <!-- <div class="form-group row">
                <div class="col-sm-5">
                    <label for='ays_poll_enable_answer_style'><#?= __('Answer styles', $this->plugin_name); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<#?= __("Highlight the background of the answers' boxes. The option works only with choosing type.", $this->plugin_name); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div> -->
                <!-- <div class="col-sm-7 ays_divider_left">
                    <input type="checkbox" class="ays_toggle ays_toggle_slide" id="ays_poll_enable_answer_style" name="ays_poll_enable_answer_style" <#?= ($options['enable_answer_style'] == 'on') ? 'checked' : ''; ?>>
                    <label for="ays_poll_enable_answer_style" class="ays_switch_toggle">Toggle</label>
                </div>
            </div> --> <!-- Answer styles -->
            <hr>
            <div class="form-group row">
                <div class="col-sm-5">
                    <label for='ays_answers_font_size' class="ays_enable_answer_style">
                        <?php echo __('Answer font size', $this->plugin_name); ?> (px)
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('The font size of the answers in pixels in the poll. It accepts only numeric values.',$this->plugin_name)?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-7 ays_divider_left">
                    <input type="number" class="ays-text-input ays-text-input-short ays_enable_answer_field" id='ays_answers_font_size' name='ays_answers_font_size' value="<?php echo $answers_font_size; ?>" min="0"/>
                </div>
            </div> <!-- Answers font size -->
            <hr>
            <div class="form-group row">
                <div  class="col-sm-5">
                    <label for='ays_poll_answer_font_size_mobile'>
                            <?= __('Answer font size for mobile', $this->plugin_name); ?>
                            <a class="ays_help"
                            data-toggle="tooltip"
                            data-placement="top"
                            title="<?= __("Choose your preferred size for the font of the answers on mobile devies. Size should be not less than 5 and not higher than 90", $this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                    </label>                                        
                </div>                                        
                <div class="col-sm-7 ays_divider_left">
                    <input type="number" class="ays-text-input ays-text-input-short ays-poll-answer-font-size-all" name="ays_poll_answer_font_size_mobile" id="ays_poll_answer_font_size_mobile" data-device="mobile" value="<?php echo $poll_answer_font_size_mobile;?>">
                </div>
            </div><!-- Answer font size on mobile -->
            <hr/>
            <div class="form-group row">
                <div class="col-sm-5">
                    <label for="ays_answers_view" class="ays_enable_answer_style">
                        <?php echo __('Answer view',$this->plugin_name)?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Specify the design of the answers of question.',$this->plugin_name)?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-7">
                    <div class="form-group row">
                        <div class="col-sm-8 ays_divider_left">
                            <select class="ays-text-input ays-text-input-short ays_enable_answer_field ays_poll_aysDropdown" id="ays_answers_view" name="ays_poll_choose_answer_type">
                                <option value="list" <?php echo (isset($poll['view_type']) && $poll['view_type'] == 'list') ? 'selected' : ''; ?>>
                                    <?php echo __('List',$this->plugin_name)?>
                                </option>
                                <option value="grid" <?php echo (isset($poll['view_type']) && $poll['view_type'] == 'grid') ? 'selected' : ''; ?>>
                                    <?php echo __('Grid',$this->plugin_name)?>
                                </option>
                            </select>
                        </div>
                        <div class="col-sm-4 grid_column_count" style="display:<?#php echo $dispaly_prop_grid; ?>">
                            <select class="ays-text-input ays-text-input-short ays_enable_answer_field" id="ays_answers_grid_column" name="ays_answers_grid_column" style="width: 70px;">
                                <option value='2' <?php echo ($answers_grid_column == '2') ? 'selected' : ''; ?>>
                                    <?php echo __('2',$this->plugin_name)?>
                                </option>
                                <option value='3' <?php echo ($answers_grid_column == '3') ? 'selected' : ''; ?>>
                                    <?php echo __('3',$this->plugin_name)?>
                                </option>
                                <option value='4' <?php echo ($answers_grid_column == '4') ? 'selected' : ''; ?>>
                                    <?php echo __('4',$this->plugin_name)?>
                                </option>
                            </select>
                        </div>
                    </div>
                </div>
            </div> <!-- Answers view --> 
            <hr/>
            <div class="form-group row">
                <div class="col-sm-5">
                    <label for="ays_answers_object_fit" class="ays_enable_answer_style">
                        <?php echo __('Answer object fit',$this->plugin_name)?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Choose the fit of the images in the answers in the questions.',$this->plugin_name)?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-7 ays_divider_left">
                    <select class="ays-text-input ays-text-input-short ays_enable_answer_field ays_poll_aysDropdown" id="ays_answers_object_fit" name="ays_answers_object_fit">
                        <option value="cover" <?php echo (isset($options['answers_object_fit']) && $options['answers_object_fit'] == 'cover') ? 'selected' : ''; ?>>
                            <?php echo __('Cover',$this->plugin_name)?>
                        </option>
                        <option value="fill" <?php echo (isset($options['answers_object_fit']) && $options['answers_object_fit'] == 'fill') ? 'selected' : ''; ?>>
                            <?php echo __('Fill',$this->plugin_name)?>
                        </option>
                        <option value="contain" <?php echo (isset($options['answers_object_fit']) && $options['answers_object_fit'] == 'contain') ? 'selected' : ''; ?>>
                            <?php echo __('Contain',$this->plugin_name)?>
                        </option>
                        <option value="scale-down" <?php echo (isset($options['answers_object_fit']) && $options['answers_object_fit'] == 'scale-down') ? 'selected' : ''; ?>>
                            <?php echo __('Scale-down',$this->plugin_name)?>
                        </option>
                        <option value="none" <?php echo (isset($options['answers_object_fit']) && $options['answers_object_fit'] == 'none') ? 'selected' : ''; ?>>
                            <?php echo __('None',$this->plugin_name)?>
                        </option>
                    </select>
                </div>
            </div> <!-- Answers Object fit -->
            <hr/>
            <div class="form-group row">
                <div class="col-sm-5">
                    <label for="ays_answers_padding" class="ays_enable_answer_style">
                        <?php echo __('Answer padding (px)',$this->plugin_name)?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Padding of answers.',$this->plugin_name)?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-7 ays_divider_left">
                    <input type="number" class="ays-text-input ays-text-input-short ays_enable_answer_field" id='ays_answers_padding' name='ays_answers_padding' value="<?php echo $answers_padding; ?>" min="0"/>
                </div>
            </div> <!-- Answers padding -->
            <hr/>
            <div class="form-group row">
                <div class="col-sm-5">
                    <label for="ays_answers_margin" class="ays_enable_answer_style">
                        <?php echo __('Answer gap (px)',$this->plugin_name)?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Gap between answers.',$this->plugin_name)?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-7 ays_divider_left">
                    <input type="number" class="ays-text-input ays-text-input-short ays_enable_answer_field" id='ays_answers_margin' name='ays_answers_margin' value="<?php echo $answers_margin; ?>" min="0"/>
                </div>
            </div> <!-- Answers gap -->
            <hr/>
            <div class="form-group row">
                <div class="col-sm-5">
                    <label for="ays_answers_border_radius" class="ays_enable_answer_style">
                        <?php echo __('Answer border radius',$this->plugin_name)?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Gap between answers.',$this->plugin_name)?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-7 ays_divider_left">
                    <input type="number" class="ays-text-input ays-text-input-short ays_enable_answer_field" id='ays_answers_border_radius' name='ays_answers_border_radius' value="<?php echo $answers_border_radius; ?>" min="0"/>
                </div>
            </div> <!-- Answers border radius -->
            <hr/>
            <div class="form-group row">
                <div class="col-sm-5">
                    <label for="ays_answers_border" class="ays_enable_answer_style">
                        <?php echo __('Answer border',$this->plugin_name)?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Allow answer border',$this->plugin_name); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-7 ays_divider_left">
                    <input type="checkbox" class="ays_toggle ays_toggle_slide" id="ays_answers_border" name="ays_answers_border" value="on"
                        <?php echo ($answers_border) ? 'checked' : ''; ?>/>
                    <label for="ays_answers_border" class="ays_switch_toggle">Toggle</label>
                    <div class="col-sm-12 ays_toggle_target ays_divider_top" style="margin-top: 10px; padding-top: 10px; <?php echo ($answers_border) ? '' : 'display:none;' ?>">
                        <label for='ays-poll-border-side'>
                            <?= __('Border side', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Choose your preferred style for the border of the answers' boxes.", $this->plugin_name); ?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                        <select name="ays_poll_border_side" id="ays-poll-border-side" class="ays-text-input ays_enable_answer_field ays_poll_aysDropdown">
                            <option value="all_sides" <?= isset($options['answer_border_side']) && $options['answer_border_side'] == "all_sides" ? 'selected' : ''; ?>><?= __("All sides", $this->plugin_name); ?></option>
                            <option value="none" <?= isset($options['answer_border_side']) && $options['answer_border_side'] == "none" ? 'selected' : ''; ?>><?= __("None", $this->plugin_name); ?></option>
                            <option value="top" <?= isset($options['answer_border_side']) && $options['answer_border_side'] == "top" ? 'selected' : ''; ?>><?= __("Top", $this->plugin_name); ?></option>
                            <option value="bottom" <?= isset($options['answer_border_side']) && $options['answer_border_side'] == "bottom" ? 'selected' : ''; ?>><?= __("Bottom", $this->plugin_name); ?></option>
                            <option value="left" <?= isset($options['answer_border_side']) && $options['answer_border_side'] == "left" ? 'selected' : ''; ?>><?= __("Left", $this->plugin_name); ?></option>
                            <option value="right" <?= isset($options['answer_border_side']) && $options['answer_border_side'] == "right" ? 'selected' : ''; ?>><?= __("Right", $this->plugin_name); ?></option>
                        </select>
                    </div><!-- Answers border side -->
                    <div class="col-sm-12 ays_toggle_target ays_divider_top" style="margin-top: 10px; padding-top: 10px; <?php echo ($answers_border) ? '' : 'display:none;' ?>">
                        <label for="ays_answers_border_width">
                            <?php echo __('Border width',$this->plugin_name)?> (px)
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('The width of answers border',$this->plugin_name)?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                        <input type="number" class="ays-text-input ays_enable_answer_field" id='ays_answers_border_width' name='ays_answers_border_width'
                            value="<?php echo $answers_border_width; ?>" min="0"/>
                    </div>
                    <div class="col-sm-12 ays_toggle_target ays_divider_top" style="margin-top: 10px; padding-top: 10px; <?php echo ($answers_border) ? '' : 'display:none;' ?>">
                        <label for="ays_answers_border_style">
                            <?php echo __('Border style',$this->plugin_name)?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('The style of answers border',$this->plugin_name)?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                        <select id="ays_answers_border_style" name="ays_answers_border_style" class="ays-text-input ays_enable_answer_field ays_poll_aysDropdown">
                            <option <?php echo ($answers_border_style == 'solid') ? 'selected' : ''; ?> value="solid">Solid</option>
                            <option <?php echo ($answers_border_style == 'dashed') ? 'selected' : ''; ?> value="dashed">Dashed</option>
                            <option <?php echo ($answers_border_style == 'dotted') ? 'selected' : ''; ?> value="dotted">Dotted</option>
                            <option <?php echo ($answers_border_style == 'double') ? 'selected' : ''; ?> value="double">Double</option>
                            <option <?php echo ($answers_border_style == 'groove') ? 'selected' : ''; ?> value="groove">Groove</option>
                            <option <?php echo ($answers_border_style == 'ridge') ? 'selected' : ''; ?> value="ridge">Ridge</option>
                            <option <?php echo ($answers_border_style == 'inset') ? 'selected' : ''; ?> value="inset">Inset</option>
                            <option <?php echo ($answers_border_style == 'outset') ? 'selected' : ''; ?> value="outset">Outset</option>
                            <option <?php echo ($answers_border_style == 'none') ? 'selected' : ''; ?> value="none">None</option>
                        </select>
                    </div>
                    <div class="col-sm-12 ays_toggle_target ays_divider_top" style="margin-top: 10px; padding-top: 10px; <?php echo ($answers_border) ? '' : 'display:none;' ?>">
                        <label for="ays_answers_border_color">
                            <?php echo __('Border color',$this->plugin_name)?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('The color of the answers border',$this->plugin_name)?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                        <input id="ays_answers_border_color" class="ays-text-input wp-color-picker ays_enable_answer_field" type="text" data-alpha="true" name='ays_answers_border_color'
                            value="<?php echo $answers_border_color; ?>" data-default-color="#000000">
                    </div>
                </div>
            </div> <!-- Answers border -->
            <hr/>
            <div class="form-group row">
                <div class="col-sm-5">
                    <label for="ays_answers_box_shadow" class="ays_enable_answer_style">
                        <?php echo __('Answer box shadow',$this->plugin_name)?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Allow answer container box shadow',$this->plugin_name)?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-7 ays_divider_left">
                    <input type="checkbox" class="ays_toggle ays_toggle_slide" id="ays_answers_box_shadow" name="ays_answers_box_shadow" <?php echo ($answers_box_shadow) ? 'checked' : ''; ?>/>
                    <label for="ays_answers_box_shadow" class="ays_switch_toggle">Toggle</label>
                    <div class="col-sm-12 ays_toggle_target ays_divider_top <?php  echo $answers_box_shadow_box?>" style="margin-top: 10px; padding-top: 10px;">
                        <label for="ays_answers_box_shadow_color">
                            <?php echo __('Answer shadow color',$this->plugin_name)?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('The shadow color of answers container',$this->plugin_name)?>">
                                <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                            </a>
                        </label>
                        <input type="text" class="ays-text-input ays_enable_answer_field" id='ays_answers_box_shadow_color'
                            name='ays_answers_box_shadow_color' data-alpha="true" data-default-color="#000000"
                            value="<?php echo $answers_box_shadow_color; ?>"/>
                    </div>
                    <!---->
                    <hr class="ays_toggle_target" style="<?= $answers_box_shadow ? '' : 'display:none'; ?>">
                    <div class="form-group row ays_toggle_target" style="<?= $answers_box_shadow ? '' : 'display:none' ?>">
                        <div class="col-sm-12">
                            <div class="col-sm-3" style="display: inline-block;">
                                <input type="number" class="ays-text-input ays-text-input-90-width ays-title-text-shadow-coord-change" id='ays_poll_answer_box_shadow_x_offset' name='ays_poll_answer_box_shadow_x_offset' value="<?php echo $poll_answer_box_shadow_x_offset; ?>" />
                                <span class="ays_poll_small_hint_text"><?php echo __('X', $this->plugin_name); ?></span>
                            </div>
                            <div class="col-sm-3 ays_divider_left" style="display: inline-block;">
                                <input type="number" class="ays-text-input ays-text-input-90-width ays-title-text-shadow-coord-change" id='ays_poll_answer_box_shadow_y_offset' name='ays_poll_answer_box_shadow_y_offset' value="<?php echo $poll_answer_box_shadow_y_offset; ?>" />
                                <span class="ays_poll_small_hint_text"><?php echo __('Y', $this->plugin_name); ?></span>
                            </div>
                            <div class="col-sm-3 ays_divider_left" style="display: inline-block;">
                                <input type="number" class="ays-text-input ays-text-input-90-width ays-title-text-shadow-coord-change" id='ays_poll_answer_box_shadow_z_offset' name='ays_poll_answer_box_shadow_z_offset' value="<?php echo $poll_answer_box_shadow_z_offset; ?>" />
                                <span class="ays_poll_small_hint_text"><?php echo __('Z', $this->plugin_name); ?></span>
                            </div>
                        </div>
                    </div>
                    <!---->
                </div>
            </div> <!-- Answers box shadow -->
            <hr/>
            <div class="form-group row">
                <div class="col-sm-5">
                    <label for="ays-poll-box-shadow-color" class="ays_enable_answer_style">
                        <?= __('Answers Background Color', $this->plugin_name); ?>
                        <a class="ays_help" data-toggle="tooltip" title="<?= __('Specify the background color of the answers\' boxes.', $this->plugin_name); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label> 
                </div>
                <div class="col-sm-7 ays_divider_left">
                    <input type="text" class="ays-text-input" id='ays-poll-answer-bg-color' name='ays_poll_answer_bg_color' data-alpha="true" value="<?= isset($options['answer_bg_color']) && !empty($options['answer_bg_color']) ? $options['answer_bg_color'] : 'rgba(255,255,255,0)'; ?>"/>
                </div>
            </div> <!-- Answers background color -->
            <hr/>
            <div class="form-group row">
                <div class="col-sm-5">
                    <label for="ays_ans_img_height" class="ays_enable_answer_style">
                        <?php echo __('Answer image height (px)',$this->plugin_name)?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Height of answers images.',$this->plugin_name)?>">
                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-7 ays_divider_left">
                    <input type="number" class="ays-text-input ays-text-input-short ays_enable_answer_field" id='ays_ans_img_height' name='ays_ans_img_height' value="<?php echo $ans_img_height; ?>" min="0"/>
                </div>
            </div> <!-- Answers image height -->
            <hr/>
            <div class="form-group row">
                <div class="col-sm-5">
                    <label for="ays_poll_answer_image_height_for_mobile" class="ays_enable_answer_style">
                        <?php echo __('Answer image height for mobile (px)',$this->plugin_name)?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Height of answers images on the mobile devices.',$this->plugin_name)?>">
                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-7 ays_divider_left">
                    <input type="number" class="ays-text-input ays-text-input-short ays_enable_answer_field" id='ays_poll_answer_image_height_for_mobile' name='ays_poll_answer_image_height_for_mobile' value="<?php echo $poll_answer_image_height_for_mobile; ?>" />
                </div>
            </div> <!-- Answers image height for mobile-->
            <hr/>
            <div class="form-group row ays_grid_show">
                <div class="col-sm-5">
                    <label for="ays_poll_show_answers_caption" class="ays_enable_answer_style">
                        <?php echo __('Show answer caption',$this->plugin_name)?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Show answers caption near the answer image. This option will be work only when answer has image.',$this->plugin_name); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-7 ays_divider_left">
                    <input type="checkbox" class="ays_toggle ays_toggle_slide" id="ays_poll_show_answers_caption" name="ays_poll_show_answers_caption" <?php echo ($show_answers_caption) ? 'checked' : ''; ?> value='on'/>
                    <label for="ays_poll_show_answers_caption" class="ays_switch_toggle">Toggle</label>
                </div>
            </div> <!-- Show answers caption -->
            <hr/>
            <div class="form-group row">
                <div class="col-sm-5">
                    <label for="ays_ans_img_caption_style" class="ays_enable_answer_style">
                        <?php echo __('Answer image caption style',$this->plugin_name)?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Choose the preferred view of answers in relation to images attached to them.',$this->plugin_name)?>">
                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-7 ays_divider_left">
                    <select id="ays_ans_img_caption_style" name="ays_ans_img_caption_style" class="ays-text-input ays-text-input-short ays_enable_answer_field ays_poll_aysDropdown">
                        <option <?php echo ($ans_img_caption_style == 'outside') ? 'selected' : ''; ?> value="outside"><?php echo __('Outside', $this->plugin_name); ?></option>
                        <option <?php echo ($ans_img_caption_style == 'inside') ? 'selected' : ''; ?> value="inside"><?php echo __('Inside', $this->plugin_name); ?></option>
                    </select>
                </div>
            </div> <!-- Answers image caption style -->
            <hr/>
            <div class="form-group row">
                <div class="col-sm-5">
                    <label for="ays_ans_img_caption_position" class="ays_enable_answer_style">
                        <?php echo __('Answers image caption position',$this->plugin_name)?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Choose the preferred position of answers in relation to images attached to them.',$this->plugin_name)?>">
                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-7 ays_divider_left">
                    <select id="ays_ans_img_caption_position" name="ays_ans_img_caption_position" class="ays-text-input ays-text-input-short ays_enable_answer_field ays_poll_aysDropdown">
                        <option <?php echo ($ans_img_caption_position == 'top') ? 'selected' : ''; ?> value="top"><?php echo __('Top', $this->plugin_name); ?></option>
                        <option <?php echo ($ans_img_caption_position == 'bottom') ? 'selected' : ''; ?> value="bottom"><?php echo __('Bottom', $this->plugin_name); ?></option>
                    </select>
                </div>
            </div> <!-- Answers image caption position -->
            <hr>
        </div>

        <div class="col-lg-6 col-sm-12 ays_divider_left" style="position:relative;">
            <div style="position:sticky;top:90px; margin:auto;">
                <div class='answer_style_content' style='position: relative;margin-top:40px;'>
                    <div class="box-apm poll_answers_container ays-poll-live-container-answers <?php echo $poll_theme; ?> choosing-poll" style="overflow:initial;">
                        <div class='answers-with'>
                            <div class="nav-answers-tab-wrapper">
                                <a href="#step1" class="nav-tab nav-tab-active">
                                    <?php echo __("Without images", $this->plugin_name);?>
                                </a>
                                <a href="#step2" class="nav-tab">
                                    <?php echo __("With images", $this->plugin_name);?>
                                </a>
                            </div>
                        </div>
                        <div id="step1" class="step active-step">
                            <div class="ays_poll_answers_live">
                                <div class='apm-title-box ays_question'>
                                    <?php echo stripslashes($poll['question']) ?>   
                                </div>
                                <div class="ays-poll-answers ays_list_view_container apm-answers">
                                    <div class="ays-field ays_list_view_item apm-choosing ">
                                        <input type="radio" name="ays_questions[ays-question-74]" id="ays-answer-72-19" value="72">
                                        <label class="ays_label_poll <?php echo $checking_answer_hover; ?>" for="ays-answer-72-19"><span class="ays_grid_answer_span">Mark Zuckerberg</span></label>
                                    </div>
                                    <div class="ays-field ays_list_view_item apm-choosing ">
                                        <input type="radio" name="ays_questions[ays-question-74]" id="ays-answer-73-19" value="73">
                                        <label class="ays_label_poll <?php echo $checking_answer_hover; ?>" for="ays-answer-73-19"><span class="ays_grid_answer_span">Elon Musk</span></label>
                                    </div>
                                    <div class="ays-field ays_list_view_item apm-choosing ">
                                        <input type="radio" name="ays_questions[ays-question-74]" id="ays-answer-74-19" value="74">
                                        <label class="ays_label_poll <?php echo $checking_answer_hover; ?>" for="ays-answer-74-19"><span class="ays_grid_answer_span">Bill Gates</span></label>
                                    </div>
                                    <div class="ays-field ays_list_view_item apm-choosing ">
                                        <input type="radio" name="ays_questions[ays-question-74]" id="ays-answer-75-19" value="75">
                                        <label class="ays_label_poll <?php echo $checking_answer_hover; ?>" for="ays-answer-75-19"><span class="ays_grid_answer_span">Steve Jobs</span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="step2" class="step">
                            <div class="ays-abs-fs answers-image-container">
                                <div class="ays-poll-answers ays_list_view_container ays_poll_answers_live apm-answers">
                                    <div class="ays-field ays_list_view_item apm-choosing">
                                        <input type="radio" name="ays_questions[ays-question-124]" id="ays-answer-245-1" value="245">
                                        <div class="ays_label_poll ays_answer_image ays_empty_before_content ays_answer_live_label <?php echo $checking_answer_hover; ?> ays-container-only-images">
                                            <div>
                                                <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/live-preview/416x416.jpg" alt="answer_image" class="ays-answer-image" style="width: 100%;max-width:100%;">
                                            </div>  
                                            <p>Mark Zuckerberg</p>
                                        </div>
                                    </div>
                                    <div class="ays-field ays_list_view_item apm-choosing">
                                        <input type="radio" name="ays_questions[ays-question-124]" id="ays-answer-249-1" value="249">
                                        <div class="ays_label_poll ays_answer_image ays_empty_before_content ays_answer_live_label <?php echo $checking_answer_hover; ?> ays-container-only-images">
                                            <div>
                                                <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/live-preview/416x416-1.jpg" alt="answer_image" class="ays-answer-image" style="width: 100%;max-width:100%;">
                                            </div>
                                            <p>Elon Musk</p>
                                        </div>
                                    </div>
                                    <div class="ays-field ays_list_view_item apm-choosing">
                                        <input type="radio" name="ays_questions[ays-question-124]" id="ays-answer-248-1" value="248">
                                        <div class="ays_label_poll ays_answer_image ays_empty_before_content ays_answer_live_label <?php echo $checking_answer_hover; ?> ays-container-only-images">
                                            <div>
                                                <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/live-preview/416x416-2.jpg" alt="answer_image" class="ays-answer-image" style="width: 100%;max-width:100%;">
                                            </div>
                                            <p>Bill Gates</p>
                                        </div>
                                    </div>
                                    <div class="ays-field ays_list_view_item apm-choosing">
                                        <input type="radio" name="ays_questions[ays-question-124]" id="ays-answer-250-1" value="249">
                                        <div class="ays_label_poll ays_answer_image ays_empty_before_content ays_answer_live_label <?php echo $checking_answer_hover; ?> ays-container-only-images">
                                            <div>
                                                <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/live-preview/416x416-3.jpg" alt="answer_image" class="ays-answer-image" style="width: 100%;max-width:100%;">
                                            </div>
                                            <p>Steve Jobs</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div> <!-- Answer styles Live Preview -->
    </div><!-- Answers Styles End -->
    <hr>
    <p class="ays-subtitle" style="margin-top:0;"><?php echo __('Button Styles',$this->plugin_name); ?></p>
    <hr/>
    <!-- Buttons Styles Start -->
    <div class="form-group row">
        <div class="col-lg-6 col-sm-12">
            <div class="form-group row">
                <div class="col-sm-4">
                    <label for="ays_buttons_size">
                        <?php echo __('Buttons Size',$this->plugin_name); ?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Select the size of the button(s) inside the poll.',$this->plugin_name); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-8 ays_divider_left">
                    <select class="ays-text-input ays-text-input-short ays_poll_aysDropdown" id="ays_buttons_size" name="ays_buttons_size">
                        <option value="small" <?php echo (isset($options['buttons_size']) && $options['buttons_size'] == 'small') ? 'selected' : ''; ?>><?php echo __('Small',$this->plugin_name); ?></option>
                        <option value="medium" <?php echo ( (isset($options['buttons_size']) && $options['buttons_size'] == 'medium') || !isset($options['buttons_size']) ) ? 'selected' : ''; ?>><?php echo __('Medium',$this->plugin_name); ?></option>
                        <option value="large" <?php echo (isset($options['buttons_size']) && $options['buttons_size'] == 'large') ? 'selected' : ''; ?>><?php echo __('Large',$this->plugin_name); ?></option>
                    </select>
                </div>
            </div> <!-- Buttons Size -->
            <hr>
            <div class="form-group row">
                <div class="col-sm-4">
                    <label for='ays_buttons_font_size'>
                        <?php echo __('Buttons font size', $this->plugin_name); ?> (px)
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the size of the button(s) inside the poll in pixels.',$this->plugin_name); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-8 ays_divider_left">
                    <input type="number" class="ays-text-input ays-text-input-short" id='ays_buttons_font_size' name='ays_buttons_font_size' value="<?php echo $buttons_font_size; ?>"/>
                </div>
            </div> <!-- Buttons font size -->
            <hr>
            <div class="form-group row">
                <div class="col-sm-4">
                    <label for='ays_poll_buttons_mobile_font_size'>
                        <?php echo __('Buttons mobile font size', $this->plugin_name); ?> (px)
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the size of the button(s) inside the poll in pixels for mobile devices.',$this->plugin_name); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-8 ays_divider_left">
                    <input type="number" class="ays-text-input ays-text-input-short" id='ays_poll_buttons_mobile_font_size' name='ays_poll_buttons_mobile_font_size' value="<?php echo $poll_buttons_mobile_font_size; ?>"/>
                </div>
            </div> <!-- Buttons font size -->
            <hr>
            <div class="form-group row">
                <div class="col-sm-4">
                    <label for="ays_buttons_padding">
                        <?php echo __('Buttons padding (px)',$this->plugin_name); ?>
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the distance between the text and the border of the button in pixels․',$this->plugin_name); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-8 ays_divider_left">
                    <div class="col-sm-4" style="display: inline-block; padding-left: 0;">
                        <input type="number" class="ays-text-input ays_buttons_padding" id='ays_buttons_left_right_padding' name='ays_buttons_left_right_padding' value="<?php echo $buttons_left_right_padding; ?>" style="width: 100px;" />
                         <span class="ays_poll_small_hint_text"><?php echo __('Left / Right',$this->plugin_name); ?></span>
                    </div>
                    <div class="col-sm-4 ays_divider_left" style="display: inline-block;">
                        <input type="number" class="ays-text-input ays_buttons_padding" id='ays_buttons_top_bottom_padding' name='ays_buttons_top_bottom_padding' value="<?php echo $buttons_top_bottom_padding; ?>" style="width: 100px;" />
                        <span class="ays_poll_small_hint_text"><?php echo __('Top / Bottom',$this->plugin_name); ?></span>
                    </div>
                </div>
            </div> <!-- Buttons padding -->
            <div class="form-group row">
                <div class="col-sm-4">
                    <label for="ays_buttons_border_radius">
                        <?php echo __('Buttons border radius',$this->plugin_name); ?> (px)
                        <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Define the radius of the corners of the button. Allows adding rounded corners to the button.',$this->plugin_name); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-8 ays_divider_left">
                    <input type="number" class="ays-text-input ays-text-input-short" id="ays_buttons_border_radius" name="ays_buttons_border_radius" value="<?php echo $buttons_border_radius; ?>"/>
                </div>
            </div> <!-- Buttons border radius -->
            <hr/>
        </div> 
        <hr/>                    
        <div class="col-lg-6 col-sm-12 ays_divider_left" style="position:relative;">
            <div id="ays_buttons_styles_tab" style="position:sticky;top:50px; margin: 0 auto;" class="box-apm <?php echo $poll_theme;?>">
                <div class="ays_buttons_div apm-button-box" style="justify-content: center; overflow:hidden;">
                    <input type="button" name="next" class='btn ays-poll-btn <?php echo $poll['type'].'-btn';?> ' value="<?php echo __( "Vote", $this->plugin_name ); ?>">
                </div>
            </div>
        </div><!-- Buttons Styles Live -->
    </div><!-- Buttons Styles End -->
    <hr/>
    <div class="form-group row">
        <div class="col-sm-2">
            <label for="ays_custom_css">
                <?php echo __("Custom CSS", $this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("In this field, you can write your own CSS code. For example: p{color:red !important}", $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
            <br>
        </div>
        <div class="col-sm-10 ays_divider_left">
            <textarea class="ays-textarea" id="ays_custom_css" name="ays_custom_css" cols="30" rows="10"><?= (isset($poll['custom_css']) && '' != $poll['custom_css']) ? $poll['custom_css'] : ''; ?></textarea>
        </div>
    </div> <!-- Custom CSS -->
</div>