<div id="tab3" class="ays-poll-tab-content <?= $active_tab == 'tab3' ? 'ays-poll-tab-content-active' : ''; ?>">
    <p class="ays-subtitle"><?= __('Feature options', $this->plugin_name); ?></p>
    <hr>
    <div class="form-group row">
        <div class="col-sm-3">
            <label>
                <?= __('Status', $this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip" data-placement="top"
                   title="<?= __('Choose whether the poll is active or not. If you choose an unpublished option, the poll won’t be shown anywhere on your website. (You do not need to remove shortcodes).', $this->plugin_name) ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9">
            <div class="d-flex">
                <div class="form-check form-check-inline ays_poll_loader">
                    <input type="radio" id="ays-publish" name="ays_publish"
                           value="1" <?= ($published == 1) ? 'checked' : ''; ?> />
                    <label class="form-check-label"
                           for="ays-publish"> <?= __('Published', $this->plugin_name); ?> </label>
                </div>
                <div class="form-check form-check-inline ays_poll_loader">
                    <input type="radio" id="ays-unpublish" name="ays_publish"
                           value="0" <?= ($published == 0) ? 'checked' : ''; ?> />
                    <label class="form-check-label"
                           for="ays-unpublish"> <?= __('Unpublished', $this->plugin_name); ?> </label>
                </div>
            </div>
        </div>
    </div> <!-- Status -->
    <hr>
    <div class="form-group row">
        <div class="col-sm-3">
            <label for="ays_poll_enable_copy_protection">
                <?php echo __('Enable copy protection',$this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Disable copy functionality in poll page(CTRL+C) and Right-click',$this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9">
            <input type="checkbox" class="ays-enable-timer1" id="ays_poll_enable_copy_protection" name="ays_poll_enable_copy_protection" value="on" <?php echo ($poll_enable_copy_protection == 'on') ? 'checked' : ''; ?>/>
        </div>
    </div> <!-- Enable copy protection | Developer Package -->
    <hr/>
    <div class="form-group row ays_toggle_parent">
        <div class="col-sm-3">
            <label for='ays_allow_multivote'>
                <?= __('Allow multivote', $this->plugin_name); ?>
                <a  class="ays_help" data-toggle="tooltip" data-placement="top" title="<?= __("Allow users to choose more than one answer. It will work with choosing type.",$this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                 </a>
            </label>
        </div>
        <div class="col-sm-1">
            <input type="checkbox" name="ays_poll_allow_multivote" id="ays_allow_multivote" class="ays-enable-timer1 ays_toggle_checkbox" value="on" <?php echo $enable_multivote_answer ? 'checked' : '';?> />
        </div>
        <div class="col-sm-8 ays_toggle_target ays_divider_left <?php echo $enable_multivote_answer ? '' : 'display_none'; ?>">
            <div class="row">
                <div class="col-sm-3">
                    <label for='ays_poll_multivote_min_count'>
                        <?= __('Min', $this->plugin_name); ?>
                        <a  class="ays_help" 
                            data-toggle="tooltip"
                            data-placement="top"
                            title="<?= __("Indicate the minimum count of answers.", $this->plugin_name); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <input type="number" name="ays_poll_multivote_min_count" id="ays_poll_multivote_min_count" class="ays-text-input ays-text-input-short" value="<?php echo $poll_multivote_min_count; ?>">
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="col-sm-3">
                    <label for='ays_poll_multivote_max_count'>
                        <?= __('Max', $this->plugin_name); ?>
                        <a  class="ays_help" 
                            data-toggle="tooltip"
                            data-placement="top"
                            title="<?= __("Indicate the maximum count of answers.", $this->plugin_name); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <input type="number" name="ays_poll_multivote_max_count" id="ays_poll_multivote_max_count" class="ays-text-input ays-text-input-short" value="<?php echo $multivote_answer_count; ?>">
                </div>
            </div>
        </div>
    </div> <!-- Allow multivote -->
    <hr>
    <div class="form-group row">
        <div class="col-sm-3">
            <label for='show-title'>
                <?= __('Show Title', $this->plugin_name); ?>
                <a  class="ays_help" 
                    data-toggle="tooltip"
                    data-placement="top"
                    title="<?= __("Enable to show the title as a headline inside the poll.", $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a></label>
        </div>
        <div class="col-sm-9">
            <input type="checkbox" name="ays_poll_show_title" id="show-title"
                   value="show" <?= $poll['show_title'] ? 'checked' : ''; ?>>
        </div>
    </div> <!-- Show Title -->
    <hr>
    <div class="form-group row">
        <div class="col-sm-3">
            <label>
                <?= __('Alignment', $this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip" data-placement="top"
                   title="<?= __('Choose the alignment of the content of the poll.', $this->plugin_name) ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9">
            <div class="d-flex">
                <div class="form-check form-check-inline ays_poll_loader">
                    <input type="radio" id="apm-dir-ltr" name="ays_poll_direction"
                           value="ltr" <?= ($poll_direction== 'ltr') ? 'checked' : ''; ?> />
                    <label class="form-check-label"
                           for="apm-dir-ltr"> <?= __('Left', $this->plugin_name); ?> </label>
                </div>
                <div class="form-check form-check-inline ays_poll_loader">
                    <input type="radio" id="apm-dir-center" name="ays_poll_direction"
                           value="center" <?= ($poll_direction == 'center') ? 'checked' : ''; ?> />
                    <label class="form-check-label"
                           for="apm-dir-center"> <?= __('Center', $this->plugin_name); ?> </label>
                </div>
                <div class="form-check form-check-inline ays_poll_loader">
                    <input type="radio" id="apm-dir-rtl" name="ays_poll_direction"
                           value="rtl" <?= ($poll_direction == 'rtl') ? 'checked' : ''; ?> />
                    <label class="form-check-label"
                           for="apm-dir-rtl"> <?= __('Right', $this->plugin_name); ?> </label>
                </div>
            </div>
        </div>
    </div> <!-- Alignment -->             
    <hr>                
    <div class="form-group row">
        <div class="col-sm-3">
            <label for='ays-poll-allow-anonymity'>
                <?= __('Allow anonymity', $this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip"
                   data-placement="top"
                   title="<?= __("It allows participants to respond to your polls without ever revealing their identities, even if they are registered on your website. After enabling the option, the WP User and User IP will not be stored in the database. Also note that the limitations connected with WP User and User IP will not work.", $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9">
            <input type="checkbox" name="ays_allow_anonymity" id="ays-poll-allow-anonymity"
                   value="1" <?= $allow_anonymity ? 'checked' : '' ?> >
        </div>
    </div> <!-- Allow anonymity -->
    <hr>
    <div class="form-group row">
        <div class="col-sm-3">
            <label for='show-poll-create-dates'>
                <?= __('Show creation date', $this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip"
                   data-placement="top"
                   title="<?= __("Enable to show the creation date inside the poll.", $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9">
            <input type="checkbox" name="show_poll_creation_date" id="show-poll-create-dates"
                   value="1" <?= $show_create_date ? 'checked' : '' ?> >
        </div>
    </div> <!-- Show creation date -->
    <hr>
    <div class="form-group row">
        <div class="col-sm-3">
            <label for='show-poll-author'>
                <?= __('Show author', $this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip"
                   data-placement="top"
                   title="<?= __("Enable to show the author inside the poll.", $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9">
            <input type="checkbox" name="show_poll_author" id="show-poll-author" value="1" <?= $show_author ? 'checked' : '' ?> >
        </div>
    </div> <!-- Show author -->
    <hr>                
    <div class="form-group row ays_toggle_parent">
        <div class="col-sm-3">
            <label for="active_date_check">
                <?php echo __('Schedule', $this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip" data-placement="top"
                   title="<?php echo __('Specify the period of time when the poll will be active. Choose the start and the end date and write the pre-start and expiration messages.', $this->plugin_name) ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
                <p class="ays_poll_small_hint_text_for_message_variables">
                    <span><?php echo __( "To change your GMT " , $this->plugin_name ); ?></span>
                    <a href="<?php echo $wp_general_settings_url; ?>" target="_blank"><?php echo __( "click here" , $this->plugin_name ); ?></a>
                </p>
            </label>
        </div>
        <div class="col-sm-1">                                
            <input  type="checkbox" id="active_date_check" class="active_date_check ays_toggle_checkbox" name="active_date_check" <?php echo ( $active_date_check ) ? 'checked' : '' ?>>
        </div>
        <div class="col-sm-8 ays_toggle_target ays_divider_left" style="display:  <?php echo ($active_date_check) ? 'block' : 'none' ?>">
            <div class="row">
                <div class="col-sm-12 active_date">
                    <!-- -1- -->                                 
                     <div class="form-group">
                         <div class="row">  
                            <div class="col-sm-3">
                                 <label class="form-check-label" for="ays-active"> <?php echo __('Start date:', $this->plugin_name); ?> </label>
                            </div>
                            <div class="col-sm-9">
                                <div class="input-group mb-3">
                                    <input type="text" class="ays-text-input ays-text-input-short ays_actDect" id="ays-active" name="ays-active" value="<?php echo $activePoll; ?>" placeholder="<?php echo current_time( 'mysql' ); ?>">
                                    <div class="input-group-append" style="display: block">
                                        <label for="ays-active" class="input-group-text">
                                            <span><i class="ays_fa ays_fa_calendar"></i></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- -2- -->
                    <div class="form-group">
                        <div class="row">  
                            <div class="col-sm-3">
                                 <label class="form-check-label" for="ays-deactive"> <?php echo __('End date:', $this->plugin_name); ?> </label>
                            </div>
                            <div class="col-sm-9">
                                <div class="input-group mb-3">
                                    <input type="text" class="ays-text-input ays-text-input-short ays_actDect" id="ays-deactive" name="ays-deactive"
                                       value="<?php echo $deactivePoll; ?>" placeholder="<?php echo current_time( 'mysql' ); ?>">
                                    <div class="input-group-append">
                                        <label for="ays-deactive" class="input-group-text">
                                            <span><i class="ays_fa ays_fa_calendar"></i></span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row">
                        <div class="col-sm-3">
                            <label for='ays_poll_show_timer'>
                                <?= __('Show timer', $this->plugin_name); ?>
                                <a class="ays_help" data-toggle="tooltip"
                                   data-placement="top"
                                   title="<?= __("Enable to show the countdown or the end date in the poll, when it is scheduled.", $this->plugin_name); ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-1">
                            <input type="checkbox" name="ays_poll_show_timer" id="ays_poll_show_timer"
                                   value="1" <?= $schedule_show_timer ? 'checked' : '' ?> >
                        </div>
                        <div class="col-sm-8">
                            <div class="ays_show_time" style="display:  <?php echo $schedule_show_timer ? 'block;' : 'none;'; ?>">
                                <div class="d-flex">
                                    <div class="form-check form-check-inline ays_poll_loader">
                                        <input type="radio" id="show_time_countdown" name="ays_show_timer_type"
                                               value="countdown" <?= $show_timer_type == 'countdown' ? 'checked' : ''; ?> />
                                        <label class="form-check-label"
                                               for="show_time_countdown"> <?= __('Show countdown', $this->plugin_name); ?> </label>
                                    </div>
                                    <div class="form-check form-check-inline ays_poll_loader">
                                        <input type="radio" id="show_time_enddate" name="ays_show_timer_type"
                                               value="enddate" <?= $show_timer_type == 'enddate' ? 'checked' : ''; ?> />
                                        <label class="form-check-label"
                                               for="show_time_enddate"> <?= __('Show start date', $this->plugin_name); ?> </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group">
                        <div class="row">  
                            <div class="col-sm-3">
                                 <label class="form-check-label"
                                   for="active_date_message"><?= __("Pre-start message:", $this->plugin_name) ?></label>
                            </div>
                            <div class="col-sm-9">
                                <div class="editor">
                                    <?php
                                    $content   = !empty($options['active_date_message_soon']) ? stripslashes($options['active_date_message_soon']) : stripslashes($default_options['active_date_message_soon']);
                                    $editor_id = 'active_date_message_soon';
                                    $settings  = array(
                                        'editor_height'  => $poll_wp_editor_height,
                                        'textarea_name'  => 'active_date_message_soon',
                                        'editor_class'   => 'ays-textarea',
                                        'media_elements' => false
                                    );
                                    wp_editor($content, $editor_id, $settings);
                                    ?>
                                </div>
                            </div>                                        
                        </div>
                    </div>
                    <hr>
                    <div class="form-group">
                        <div class="row">  
                            <div class="col-sm-3">
                                 <label class="form-check-label"
                                   for="active_date_message"><?= __("Expiration message:", $this->plugin_name) ?></label>
                            </div>
                            <div class="col-sm-9">
                                <div class="editor">
                                    <?php
                                    $content   = !empty($options['active_date_message']) ? stripslashes($options['active_date_message']) : stripslashes($default_options['active_date_message']);
                                    $editor_id = 'active_date_message';
                                    $settings  = array(
                                        'editor_height'  => $poll_wp_editor_height,
                                        'textarea_name'  => 'active_date_message',
                                        'editor_class'   => 'ays-textarea',
                                        'media_elements' => false
                                    );
                                    wp_editor($content, $editor_id, $settings);
                                    ?>
                                </div>
                            </div>                                        
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row">
                        <div class="col-sm-3">
                            <label for='show_result_btn_schedule'>
                                <?= __('Show Results button', $this->plugin_name); ?>
                                <a class="ays_help" data-toggle="tooltip"
                                   data-placement="top"
                                   title="<?= __("Enable to show the result button after the schedule.", $this->plugin_name); ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-9">
                            <input type="checkbox" name="show_result_btn_schedule" id="show_result_btn_schedule"
                                   value="1" <?= $showresbtnschedule ? 'checked' : '' ?> >
                        </div>
                    </div> 
                    <hr>
                    <div class="form-group row">
                        <div class="col-sm-3">
                            <label for='ays_show_poll_container'>
                                <?= __("Don't show poll", $this->plugin_name); ?>
                                <a class="ays_help" data-toggle="tooltip"
                                    data-placement="top"
                                    title="<?= __("Do not show the poll container on the front-end at all when it is expired or has not started yet.", $this->plugin_name); ?>">
                                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                                </a>
                            </label>
                        </div>
                        <div class="col-sm-9">
                            <input type="checkbox" name="ays_show_poll_container" id="ays_show_poll_container"
                                    value="on" <?php echo $poll_check_exp_cont; ?> >
                        </div>
                    </div><!-- Show nothing if expired -->
                </div>
            </div>
        </div>
    </div> <!-- Schedule -->
    <hr>
    <div class="form-group row">
        <div class="col-sm-3">
            <label for="randomize-answers">
                <?= __('Randomize Answers', $this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip"
                   data-placement="top"
                   title="<?= __("Enable to show the answers of the poll in a random sequence.", $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9">
            <input type="checkbox"
                   name="randomize_answers"
                   id="randomize-answers"
                   value="on"
                <?php echo $randomize_answers ? 'checked' : ''; ?>
            />
        </div>
    </div> <!-- Randomize Answers -->
    <hr>
    <div class="form-group row ays_toggle_parent">
        <div class="col-sm-3" style="padding-right: 0px;">
            <label for="ays_enable_asnwers_sound">
                <?php echo __('Enable answers sound',$this->plugin_name)?>
                <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Enable to play a sound when the user clicks on one of the answers. To select a sound, go to the Poll answers sound option in the General Settings page.',$this->plugin_name)?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-1">
            <input type="checkbox" id="ays_enable_asnwers_sound"
                   name="ays_poll_enable_asnwers_sound" class="ays_toggle_checkbox"
                   value="on" <?php echo $enable_asnwers_sound ? 'checked' : ''; ?>/>
        </div>
        <div class="col-sm-8 if_answer_sound ays_toggle_target ays_divider_left" style="<?php echo $enable_asnwers_sound ? '' : 'display:none;' ?>">
            <?php if($answers_sound_status): ?>
            <blockquote class=""><?php echo __('Sound are selected. For change sounds go to', $this->plugin_name); ?> <a href="?page=poll-maker-ays-settings" target="_blank"><?php echo __('General options', $this->plugin_name); ?></a> <?php echo __('page', $this->plugin_name); ?></blockquote>
            <?php else: ?>
            <blockquote class=""><?php echo __('Sound are not selected. For selecting sounds go to', $this->plugin_name); ?> <a href="?page=poll-maker-ays-settings" target="_blank"><?php echo __('General options', $this->plugin_name); ?></a> <?php echo __('page', $this->plugin_name); ?></blockquote>
            <?php endif; ?>
        </div>
    </div> <!-- Enable answers sound -->
    <hr>
    <div class="form-group row">
        <div class="col-sm-3">
            <label for='ays-poll-allow-not-vote'>
                <?= __('Allow not to vote', $this->plugin_name); ?>
                <a class="ays_help"
                   data-toggle="tooltip"
                   data-placement="top"
                   title="<?= __("Allow the user to directly see the results without participating in the vote. If the option is checked, it is impossible to hide the results.", $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-1">
            <input type="checkbox" name="ays-poll-allow-not-vote" id="ays-poll-allow-not-vote" value="allow"
                <?= isset($options['allow_not_vote']) && $options['allow_not_vote'] ? 'checked' : ''; ?>>
        </div>
        <div class="col-sm-2 ays_divider_left">
            <label for="ays-poll-res-btn-text">
                <?= __("Results button text", $this->plugin_name); ?>
                <a class="ays_help"
                   data-toggle="tooltip"
                   data-placement="top"
                   title="<?= __("Write the text of the button, which shows results.", $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-6">
            <input type="text" class="ays-text-input ays-text-input-short"
                   id="ays-poll-res-btn-text" name="ays_poll_res_btn_text"
                   value="<?= (isset($options['see_res_btn_text']) && '' != $options['see_res_btn_text']) ? stripslashes($options['see_res_btn_text']) : __("See Results", $this->plugin_name); ?>"/>
        </div>
    </div> <!-- Allow not to vote -->
    <hr>
    <div class="form-group row">
        <div class="col-sm-3" style="padding-right: 0px;">
            <label for="ays_enable_pass_count">
                <?php echo __('Show passed users count', $this->plugin_name) ?>
                <a class="ays_help" data-toggle="tooltip" data-placement="top"
                   title="<?php echo __('Show how many users have passed the poll. It will be shown at the bottom right corner inside the poll.', $this->plugin_name) ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9">
            <input type="checkbox" id="ays_enable_pass_count"
                   name="ays_enable_pass_count"
                   value="on" <?php echo ($enable_pass_count == 'on') ? 'checked' : ''; ?>/>
        </div>
    </div> <!-- Show passed users count -->
    <hr>
    <div class="form-group row">
        <div class="col-sm-3">
            <label for="ays_redirect_after_vote">
                <?= __('Redirect after voting', $this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip" data-placement="top"
                   title="<?= __('Enable redirection to the custom URL after the user votes the poll.', $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-1">
            <input type="checkbox" id="ays_redirect_after_vote" name="ays_redirect_after_vote" value="on"
                <?= ((isset($options['redirect_users']) && $options['redirect_users'] == 1)) ? 'checked' : ''; ?>/>
        </div>
        <div class="if-redirect-after-vote col-sm-8">
            <div class="row">
                <div class="col-sm-2 ays_divider_left">
                    <label for="redirection_url">
                        <?= __('URL', $this->plugin_name); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                           title="<?= __('Choose the Redirection URL for redirecting after the user takes the poll.', $this->plugin_name); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-5">
                    <input type="text" name="redirection_url" id="redirection_url"
                           value="<?= isset($options['redirect_after_vote_url']) && !empty($options['redirect_after_vote_url']) ? $options['redirect_after_vote_url'] : ""; ?>"
                           size="25">
                </div>
                <div class="col-sm-2">
                    <label for="redirectio_delay">
                        <?= __('Delay', $this->plugin_name); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top"
                           title="<?= __('Choose the redirection delay in seconds after the user votes the poll.', $this->plugin_name); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-3">
                    <input type="text" name="redirection_delay" id="redirectio_delay"
                           value="<?= isset($options['redirect_after_vote_delay']) && !empty($options['redirect_after_vote_delay']) ? $options['redirect_after_vote_delay'] : "0"; ?>"
                           size="15">
                </div>
            </div>
        </div>
    </div> <!-- Redirect after voting -->
    <hr>
    <div class="form-group row">
        <div class="col-sm-3">
            <label for='ays-poll-reason'>
                <?= __('Vote Reason', $this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip"
                   data-placement="top"
                   title="<?= __("Allow users to add their vote reason (description).", $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9">
            <input type="checkbox" name="ays-poll-reason" id="ays-poll-reason"
                   value="show" <?= isset($options['vote_reason'])
                                    && $options['vote_reason'] ? 'checked' : ''; ?>>
        </div>
    </div> <!-- Vote Reason -->
    <hr>
    <div class="form-group row">
        <div class="col-sm-3">
            <label for="ays_enable_vote_button">
                <?= __('Enable Vote button', $this->plugin_name) ?>
                <a class="ays_help" data-toggle="tooltip"
                   title="<?= __('Show the vote button during the vote. If this option is disabled, then the user needs to click on the answer to vote without a chance of changing it.', $this->plugin_name) ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-1">
            <input type="checkbox" id="ays_enable_vote_button"
                   name="ays_enable_vote_button"
                   value="1" <?= (isset($options['enable_vote_btn']) && $options['enable_vote_btn'] == 0) ? '' : 'checked' ?>/>
        </div>
        <div class="col-sm-2 ays_divider_left">
            <label for="ays-poll-btn-text">
                <?= __("Vote button text", $this->plugin_name); ?>
                <a class="ays_help"
                   data-toggle="tooltip"
                   data-placement="top"
                   title="<?= __("Write the text of the vote button.", $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-6">
            <input type="text" class="ays-text-input ays-text-input-short"
                   id="ays-poll-btn-text" name="ays_poll_btn_text"
                   value="<?= (isset($options['btn_text']) && '' != $options['btn_text'])
                       ? stripslashes($options['btn_text'])
                       : __("Vote", $this->plugin_name); ?>"/>
        </div>
    </div> <!-- Enable Vote button -->
    <hr>
    <div class="form-group row ays_toggle_parent">
        <div class="col-sm-3">
            <label for="ays_enable_view_more_button">
                <?= __('Enable View more button', $this->plugin_name) ?>
                <a class="ays_help" data-toggle="tooltip"
                   title="<?php echo __('Show only part of the answers and show the rest of the answers only when the user clicks on this button. It works only with the choosing type of polls.', $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-1">
            <input type="checkbox" class="ays_toggle_checkbox" id="ays_enable_view_more_button" name="ays_enable_view_more_button"
                   value="on" <?php echo ($enable_view_more_button) ? 'checked' : ''; ?> />
        </div>
        <div class="col-sm-8 ays_divider_left ays_toggle_target" style="<?php echo ($enable_view_more_button) ? '' : 'display: none'; ?>">
            <div class="form-group row">
                <div class="col-sm-3">
                    <label for="ays_poll_view_more_button_count">
                        <?php echo __("Count", $this->plugin_name); ?>
                        <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __("Indicate the number of answers which will be shown in the first place.", $this->plugin_name); ?>">
                            <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                        </a>
                    </label>
                </div>
                <div class="col-sm-9">
                    <input type="text" class="ays-text-input ays-text-input-short" id="ays_poll_view_more_button_count" name="ays_poll_view_more_button_count" value="<?php echo $poll_view_more_button_count; ?>"/>
                </div>
            </div>
        </div>
    </div> <!-- Enable View more button -->
    <hr>                
    <div class="form-group row ays-poll-answer-sorting-box">
        <div class="col-sm-3">
            <label for="ays_answers_sort_select">
                <?php echo __('Answers sorting', $this->plugin_name) ?>
                <a class="ays_help" data-toggle="tooltip" data-html="true" data-placement="top"
                   title="<?php
                    echo __("Select the way of arrangement of the answers on the voting page of the poll. This works only with the Choosing type.", $this->plugin_name) .
                        "<ul style='list-style-type: circle;padding-left: 20px;'>".
                            "<li>". __('Ascending - the sort is alphabetical from A to Z.',$this->plugin_name) ."</li>".
                            "<li>". __('Descending - the sort is alphabetical from Z to A.',$this->plugin_name) ."</li>".
                            "<li>". __('Most voted - by most votes',$this->plugin_name) ."</li>".
                            "<li>". __('Least voted - by less votes',$this->plugin_name) ."</li>".
                            "<li>". __('Default - upon your preferences',$this->plugin_name) ."</li>".
                        "</ul>";
                ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9">
            <select name="ays_answers_sort_select" id="ays_answers_sort_select" class="ays-select ays_poll_aysDropdown">
                <option value="default"    <?= isset($options['answer_sort_type']) && $options['answer_sort_type'] == "default" ? 'selected' : ''; ?>><?php echo __('Default', $this->plugin_name) ?></option>
                <option value="ascending"  <?= isset($options['answer_sort_type']) && $options['answer_sort_type'] == "ascending" ? 'selected' : ''; ?>><?php echo __('Ascending', $this->plugin_name) ?></option>
                <option value="descending" <?= isset($options['answer_sort_type']) && $options['answer_sort_type'] == "descending" ? 'selected' : ''; ?>><?php echo __('Descending', $this->plugin_name) ?></option>
                <option value="votes_asc"  <?= isset($options['answer_sort_type']) && $options['answer_sort_type'] == "votes_asc" ? 'selected' : ''; ?>><?php echo __('Most Voted', $this->plugin_name) ?></option>
                <option value="votes_desc" <?= isset($options['answer_sort_type']) && $options['answer_sort_type'] == "votes_desc" ? 'selected' : ''; ?>><?php echo __('Least voted', $this->plugin_name) ?></option>
            </select>
        </div>
    </div>  <!-- Answers sorting -->
    <hr>
    <div class="form-group row">
        <div class="col-sm-3">
            <label>
                <?php echo __('Answers numbering',$this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Assign numbering to each answer in ascending sequential order. Choose your preferred type from the list.',$this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9">
            <select class="ays_poll_aysDropdown ays-text-input ays-text-input-short" name="ays_poll_show_answers_numbering" style="width: 200px;">
                <option <?php echo $show_answers_numbering == "none" ? "selected" : ""; ?> value="none"><?php echo __( "None", $this->plugin_name); ?></option>
                <option <?php echo $show_answers_numbering == "1." ? "selected" : ""; ?> value="1."><?php echo __( "1.", $this->plugin_name); ?></option>
                <option <?php echo $show_answers_numbering == "1)" ? "selected" : ""; ?> value="1)"><?php echo __( "1)", $this->plugin_name); ?></option>
                <option <?php echo $show_answers_numbering == "A." ? "selected" : ""; ?> value="A."><?php echo __( "A.", $this->plugin_name); ?></option>
                <option <?php echo $show_answers_numbering == "A)" ? "selected" : ""; ?> value="A)"><?php echo __( "A)", $this->plugin_name); ?></option>
                <option <?php echo $show_answers_numbering == "a." ? "selected" : ""; ?> value="a."><?php echo __( "a.", $this->plugin_name); ?></option>
                <option <?php echo $show_answers_numbering == "a)" ? "selected" : ""; ?> value="a)"><?php echo __( "a)", $this->plugin_name); ?></option>
            </select>
        </div>
    </div> <!-- Show answers numbering -->
    <hr>
    <div class="form-group row ays_toggle_parent">
        <div class="col-sm-3">
            <label for="ays_show_votes_before_voting">
                <?= __('Show votes count per answer before voting', $this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip" data-placement="top"
                   title="<?= __('Display the votes count per answer to the poll participants beforehand. It will show the last result. There are two ways to represent the votes count: by count and by percentage.', $this->plugin_name) ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-1">
            <input type="checkbox" class="ays_toggle_checkbox" id="ays_show_votes_before_voting" name="ays_show_votes_before_voting"
                   value="on" <?php echo ($show_votes_before_voting) ? 'checked' : ''; ?> />
        </div>
        <div class="col-sm-8 ays_divider_left ays_toggle_target" style="<?php echo ($show_votes_before_voting) ? '' : 'display: none'; ?>">
            <div class="d-flex">
                <div class="form-check-inline ays_poll_loader">
                    <label class="form-check-label">
                        <input type="radio" name="ays_show_votes_before_voting_by" value="by_count" <?php echo ($show_votes_before_voting_by == 'by_count') ? 'checked' : ''; ?> />
                        <span><?= __('By count', $this->plugin_name); ?></span>
                    </label>
                </div>
                <div class="form-check-inline ays_poll_loader">
                    <label class="form-check-label">
                        <input type="radio" name="ays_show_votes_before_voting_by" value="by_percentage" <?php echo ($show_votes_before_voting_by == 'by_percentage') ? 'checked' : ''; ?> />
                        <span><?= __('By percentage', $this->plugin_name); ?></span>
                    </label>
                </div>
            </div>
        </div>
    </div> <!-- Status -->
    <hr>
   <div class="form-group row">
        <div class="col-sm-3">
            <label for="ays_poll_create_author">
                <?php echo __('Change the author of the current poll',$this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip" title="<?php echo __('You can change the author who created the current poll to your preferred one. You need to write the User ID here. Please note, that in case you write an ID, by which there are no users found, the changes will not be applied and the previous author will remain the same.',$this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9">
            <input type="number" class="ays-text-input ays-text-input-short" id='ays_poll_create_author'name='ays_poll_create_author' value="<?php echo $change_poll_create_author; ?>"/>
        </div>
    </div> 
    <!-- Change the author of the current poll -->
    <hr>
    <div class="form-group row">
        <div class="col-sm-3">
            <label for='ays_poll_change_creation_date'>
                <?= __('Change current poll creation date', $this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip"
                    data-placement="top"
                    title="<?= __("Choose your preferred creation date.", $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9 row" style="margin-left:2px;">
            <input type="text" class="ays-text-input ays-text-input-short ays-poll-date-create" id="ays_poll_change_creation_date" name="ays_poll_change_creation_date"
                value="<?php echo $change_creation_date; ?>" placeholder="<?php echo current_time( 'mysql' ); ?>">
            <div class="input-group-append ays-poll-change-creation-date">
                <label for="ays_poll_change_creation_date" class="input-group-text">
                    <span><i class="ays_fa ays_fa_calendar"></i></span>
                </label>
            </div>
        </div>
    </div>
</div>