<div id="tab6" class="ays-poll-tab-content <?= $active_tab == 'tab6' ? 'ays-poll-tab-content-active' : ''; ?>">
    <p class="ays-subtitle"><?= __('User Data Settings', $this->plugin_name); ?></p>
    <hr/>
    <div class="form-group row">
        <div class="col-sm-3">
            <label for='ays_poll_info_form'>
                <?= __('Enable Information Form', $this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip"
                   data-placement="top"
                   title="<?= __("After enabling this option, the user will have to fill out the information form (data form for the user’s personal information) after submitting the poll.", $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-2">
            <input type="checkbox" name="ays_poll_info_form" id="ays_poll_info_form"
                   value="on" <?= $options['info_form'] == 1 ? 'checked' : ''; ?>>
        </div>
        <div class="col-sm-7 ays_divider_left ays_toggle_target_inverse <?php echo (isset($options['info_form']) && $options['info_form'] == 1) ? 'display_none' : ''; ?>">
            <label for="ays_allow_collecting_logged_in_users_data" style="margin-right:20px;">
                <?php echo __('Allow collecting information of logged in users',$this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Allow collecting information from logged in users. Email and name of users will be stored in the database. Email options will be work for these users.', $this->plugin_name)?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
            <input type="checkbox" id="ays_allow_collecting_logged_in_users_data" name="ays_allow_collecting_logged_in_users_data" value="on" <?php echo $poll_allow_collect_info; ?>>
        </div> <!-- Allow collecting information of logged in users -->
    </div> <!-- Enable Information Form -->
    <hr>
    <div class="form-group row ays-poll-if-form-on">
        <div class="col-sm-3">
            <label>
                <?= __('Select fields', $this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip" data-placement="top"
                   title="<?= __("Select which fields the user should fill out.", $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9">
            <div class="ays-poll-sel-fields">
                <?php foreach ( $all_fields as $field ): ?>
                    <div class="ays-poll-check-box">
                        <input type="checkbox" name="ays-poll-form-fields[]" value="<?= $field['slug']; ?>"
                               id="ays-poll-form-field-<?= $field['slug']; ?>"
                            <?= (array_search($field['slug'], array_column($fields, 'slug')) !== false) ? "checked" : ""; ?>>
                        <label for="ays-poll-form-field-<?= $field['slug']; ?>">
                            <?= ucfirst($field['name']); ?></label>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div> <!-- Select fields -->
    <hr class="ays-poll-if-form-on">
    <div class="form-group row ays-poll-if-form-on">
        <div class="col-sm-3">
            <label>
                <?= __('Select required fields', $this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip" data-placement="top"
                   title="<?= __("Select which fields are required.", $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9">
            <div class="ays-poll-req-fields">
                <?php foreach ( $all_fields as $field ): ?>
                    <div class="ays-poll-check-box"
                         id="ays-poll-box-rfield-<?= $field['slug']; ?>" <?= (array_search($field,
                            $fields) === false) ? "style='display:none'" : ""; ?>>
                        <input type="checkbox" name="ays-poll-form-required-fields[]"
                               value="<?= $field['slug']; ?>"
                               id="ays-poll-form-rfield-<?= $field['slug']; ?>" <?= (array_search($field['slug'],
                                array_column($required_fields, 'slug')) !== false) ? "checked" : ""; ?>>
                        <label for="ays-poll-form-rfield-<?= $field['slug']; ?>">
                            <?= ucfirst($field['name']); ?></label>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div> <!-- Select required fields -->
    <hr class="ays-poll-if-form-on">
    <div class="form-group row ays-poll-if-form-on">
        <div class="col-sm-3">
            <label>
                <?= __('Information form title', $this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip" data-placement="top"
                   title="<?= __("Write the title of the Information Form which will be shown at the top of the Form Fields.", $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9">
            <?php
            $content   = isset($options['info_form_title']) ? stripslashes($options['info_form_title']) : "<h5>" . __("Please fill out the form:", $this->plugin_name) . "</h5>";
            $editor_id = 'ays-poll-info-form-text';
            $settings  = array(
                'editor_height'  => $poll_wp_editor_height,
                'textarea_name'  => 'ays-poll-info-form-text',
                'editor_class'   => 'ays-textarea',
                'media_elements' => false
            );
            wp_editor($content, $editor_id, $settings);
            ?>
        </div>
    </div> <!-- Information form title -->
    <hr class="ays-poll-if-form-on">
    <div class="form-group row ays-poll-if-form-on">
        <div class="col-sm-3">
            <label>
                <?php echo __('Custom fields',$this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip" data-placement="top"
                   title="<?= __("You can create custom fields with the following types: text, textarea, number, telephone, date, e-mail, URL, color, checkbox.", $this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9">
            <blockquote>
                <?php echo __("For creating custom fields click ", $this->plugin_name); ?>
                <a href="?page=<?php echo $this->plugin_name; ?>-formfields" target="_blank" ><?php echo __("here", $this->plugin_name); ?></a>
            </blockquote>
        </div>
    </div> <!-- Custom fields -->
    <hr class="ays-poll-if-form-on">
    <div class="form-group row ays-poll-if-form-on">
        <div class="col-sm-3">
            <label for="ays_poll_display_fields_labels">
                <?php echo __('Display form fields with labels',$this->plugin_name); ?>
                <a class="ays_help" data-toggle="tooltip" title="<?php echo esc_attr__('Show labels of form fields on the top of each field. Texts of labels will be taken from the "Fields placeholder" section on the General setting page.',$this->plugin_name); ?>">
                    <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                </a>
            </label>
        </div>
        <div class="col-sm-9">
            <div class="information_form_settings">
                <input type="checkbox" id="ays_poll_display_fields_labels" name="ays_poll_display_fields_labels" value="on" <?php echo $display_fields_labels ? "checked" : ""; ?>>
            </div>
        </div>
    </div>
    <hr class="ays-poll-if-form-on">
</div>