<div id="tab8" class="ays-poll-tab-content <?= $active_tab == 'tab8' ? 'ays-poll-tab-content-active' : ''; ?>">
    <p class="ays-subtitle"><?= __('Integrations Settings', $this->plugin_name) ?></p>
    <hr/>
    <fieldset>
        <legend>
            <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/mailchimp_logo.png" alt="">
            <h5><?php echo __('MailChimp Settings',$this->plugin_name)?></h5>
        </legend>
        <?php
        if(count($mailchimp) > 0):
        ?>
        <?php
        if($mailchimp_username == "" || $mailchimp_api_key == ""):
            ?>
            <blockquote class="error_message">
                <?php echo __(
                    sprintf(
                        __("For enabling this option, please go to ",$this->plugin_name)." %s ". __("page and fill all options.",$this->plugin_name),
                        "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>".__("this",$this->plugin_name)."</a>"
                    ),
                    $this->plugin_name );
                ?>
            </blockquote>
        <?php
        else:
        ?>
        <div class="form-group row">
            <div class="col-sm-4">
                <label for="ays_enable_mailchimp">
                    <?php echo __('Enable MailChimp',$this->plugin_name)?>
                </label>
            </div>
            <div class="col-sm-1">
                <input type="checkbox" class="ays-enable-timer1" id="ays_enable_mailchimp"
                       name="ays_enable_mailchimp"
                       value="on"
                    <?php
                    if($mailchimp_username == "" || $mailchimp_api_key == ""){
                        echo "disabled";
                    }else{
                        echo ($enable_mailchimp == 'on') ? 'checked' : '';
                    }
                    ?>/>
            </div>
        </div>
            <hr>
            <div class="form-group row">
                <div class="col-sm-4">
                    <label for="ays_mailchimp_list">
                        <?php echo __('MailChimp list',$this->plugin_name)?>
                    </label>
                </div>
                <div class="col-sm-8">
                    <?php if(is_array($mailchimp_select)): ?>
                        <select name="ays_mailchimp_list" id="ays_mailchimp_list"
                            <?php
                            if($mailchimp_username == "" || $mailchimp_api_key == ""){
                                echo 'disabled';
                            }
                            ?>>
                            <option value="" disabled selected>Select list</option>
                            <?php foreach($mailchimp_select as $mlist): ?>
                                <option <?php echo ($mailchimp_list == $mlist['listId']) ? 'selected' : ''; ?>
                                        value="<?php echo $mlist['listId']; ?>"><?php echo $mlist['listName']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    <?php else: ?>
                        <span><?php echo $mailchimp_select; ?></span>
                    <?php endif; ?>
                </div>
            </div>
        <?php
        endif;
            ?>
        <?php
        else:
            ?>
            <blockquote class="error_message">
                <?php echo __(
                    sprintf(
                        __("For enabling this option, please go to ",$this->plugin_name)." %s ". __("page and fill all options.",$this->plugin_name),
                        "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>".__("this",$this->plugin_name)."</a>"
                    ),
                    $this->plugin_name );
                ?>
            </blockquote>
        <?php
        endif;
        ?>
    </fieldset> <!-- MailChimp Settings -->
    <hr/>
    <fieldset>
        <legend>
            <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/campaignmonitor_logo.png" alt="">
            <h5><?php echo __('Campaign Monitor Settings', $this->plugin_name) ?></h5>
        </legend>
        <?php
        if (count($monitor) > 0):
            ?>
            <?php
            if ($monitor_client == "" || $monitor_api_key == ""):
                ?>
                <blockquote class="error_message">
                    <?php echo __(
                        sprintf(
                            __("For enabling this option, please go to ",$this->plugin_name)." %s ". __("page and fill all options.",$this->plugin_name),
                            "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>".__("this",$this->plugin_name)."</a>"
                        ),
                        $this->plugin_name);
                    ?>
                </blockquote>
            <?php
            else:
                ?>
                <hr/>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_enable_monitor">
                            <?php echo __('Enable Campaign Monitor', $this->plugin_name) ?>
                        </label>
                    </div>
                    <div class="col-sm-1">
                        <input type="checkbox" class="ays-enable-timer1" id="ays_enable_monitor"
                               name="ays_enable_monitor"
                               value="on"
                            <?php
                            if ($monitor_client == "" || $monitor_api_key == "") {
                                echo "disabled";
                            } else {
                                echo ($enable_monitor == 'on') ? 'checked' : '';
                            }
                            ?>/>
                    </div>
                </div>
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_monitor_list">
                            <?php echo __('Campaign Monitor list', $this->plugin_name) ?>
                        </label>
                    </div>
                    <div class="col-sm-8">
                        <?php if (is_array($monitor_select)): ?>
                            <select name="ays_monitor_list" id="ays_monitor_list"
                                <?php
                                if ($monitor_client == "" || $monitor_api_key == "") {
                                    echo 'disabled';
                                }
                                ?>>
                                <option value="" disabled selected><?= __("Select List", $this->plugin_name) ?></option>
                                <?php foreach ( $monitor_select as $mlist ): ?>
                                    <option <?= ($monitor_list == $mlist['ListID']) ? 'selected' : ''; ?>
                                            value="<?= $mlist['ListID']; ?>"><?php echo $mlist['Name']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        <?php else: ?>
                            <span><?php echo $monitor_select; ?></span>
                        <?php endif; ?>
                    </div>
                </div>
            <?php
            endif;
            ?>
        <?php
        else:
            ?>
            <blockquote class="error_message">
                <?php echo __(
                    sprintf(
                        __("For enabling this option, please go to ",$this->plugin_name)." %s ". __("page and fill all options.",$this->plugin_name),
                        "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>".__("this",$this->plugin_name)."</a>"
                    ),
                    $this->plugin_name);
                ?>
            </blockquote>
        <?php
        endif;
        ?>
    </fieldset> <!-- Campaign Monitor Settings -->
    <hr/>
    <fieldset>
        <legend>
            <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/zapier_logo.png" alt="">
            <h5><?php echo __('Zapier Integration Settings', $this->plugin_name) ?></h5>
        </legend>
        <?php
        if (count($zapier) > 0):
            ?>
            <?php
            if ($zapier_hook == ""):
                ?>
                <blockquote class="error_message">
                    <?php echo __(
                        sprintf(
                            __("For enabling this option, please go to ",$this->plugin_name)." %s ". __("page and fill all options.",$this->plugin_name),
                            "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>".__("this",$this->plugin_name)."</a>"
                        ),
                        $this->plugin_name);
                    ?>
                </blockquote>
            <?php else: ?>
                <hr/>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_enable_zapier">
                            <?php echo __('Enable Zapier Integration', $this->plugin_name) ?>
                        </label>
                    </div>
                    <div class="col-sm-1">
                        <input type="checkbox" class="ays-enable-timer1" id="ays_enable_zapier"
                               name="ays_enable_zapier"
                               value="on"
                            <?php
                            if ($zapier_hook == "") {
                                echo "disabled";
                            } else {
                                echo ($enable_zapier == 'on') ? 'checked' : '';
                            }
                            ?>/>
                    </div>
                    <div class="col-sm-3">
                        <button type="button"
                                data-url="<?= $zapier_hook ?>" <?= $zapier_hook ? "" : "disabled" ?>
                                id="testZapier"
                                class="btn btn-outline-secondary">
                            <?= __("Send test data", $this->plugin_name) ?>
                        </button>
                        <a class="ays_help" data-toggle="tooltip" style="font-size: 16px;"
                           title="<?= __('We will send you a test data, and you can catch it in your ZAP for configure it.', $this->plugin_name) ?>">
                            <i class="ays_fa ays_fa_info_circle"></i>
                        </a>
                    </div>
                </div>
                <div id="testZapierFields" class="d-none">
                    <input type="checkbox"
                           name="zapierTest[]"
                           value="ays_user_name" <?php echo (isset($options['form_name']) && $options['form_name'] == 'on') ? 'checked' : ''; ?>/>
                    <input type="checkbox"
                           name="zapierTest[]"
                           value="ays_user_email" <?php echo (isset($options['form_email']) && $options['form_email'] == 'on') ? 'checked' : ''; ?>/>
                    <input type="checkbox"
                           name="zapierTest[]"
                           value="ays_user_phone" <?php echo (isset($options['form_phone']) && $options['form_phone'] == 'on') ? 'checked' : ''; ?>/>
                    <?php
                    //                                foreach ( $all_attributes as $attribute ) {
                    ////                                    $checked = (in_array(strval($attribute['id']), $poll_attributes)) ? 'checked' : '';
                    ////                                    echo "<input type=\"checkbox\" name=\"zapierTest[]\"
                    ////                                                           value=\"" . $attribute['slug'] . "\" " . $checked . "/>";
                    ////                                }
                    ?>
                </div>
            <?php endif; ?>
        <?php
        else:
            ?>
            <blockquote class="error_message">
                <?php echo __(
                    sprintf(
                        __("For enabling this option, please go to ",$this->plugin_name)." %s ". __("page and fill all options.",$this->plugin_name),
                        "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>".__("this",$this->plugin_name)."</a>"
                    ),
                    $this->plugin_name);
                ?>
            </blockquote>
        <?php
        endif;
        ?>
    </fieldset> <!-- Zapier Integration Settings -->
    <hr/>
    <fieldset>
        <legend>
            <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/activecampaign_logo.png" alt="">
            <h5><?php echo __('ActiveCampaign Settings', $this->plugin_name) ?></h5>
        </legend>
        <?php
        if (count($active_camp) > 0):
            ?>
            <?php
            if ($active_camp_url == "" || $active_camp_api_key == ""):
                ?>
                <blockquote class="error_message">
                    <?php echo __(
                        sprintf(
                            __("For enabling this option, please go to ",$this->plugin_name)." %s ". __("page and fill all options.",$this->plugin_name),
                            "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>".__("this",$this->plugin_name)."</a>"
                        ),
                        $this->plugin_name);
                    ?>
                </blockquote>
            <?php
            else:
                ?>
                <hr/>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_enable_active_camp">
                            <?php echo __('Enable ActiveCampaign', $this->plugin_name) ?>
                        </label>
                    </div>
                    <div class="col-sm-1">
                        <input type="checkbox" class="ays-enable-timer1" id="ays_enable_active_camp"
                               name="ays_enable_active_camp"
                               value="on"
                            <?php
                            if ($active_camp_url == "" || $active_camp_api_key == "") {
                                echo "disabled";
                            } else {
                                echo ($enable_active_camp == 'on') ? 'checked' : '';
                            }
                            ?>/>
                    </div>
                </div>
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_active_camp_list">
                            <?php echo __('ActiveCampaign list', $this->plugin_name) ?>
                        </label>
                    </div>
                    <div class="col-sm-8">
                        <?php if (is_array($active_camp_list_select)): ?>
                            <select name="ays_active_camp_list" id="ays_active_camp_list"
                                <?php
                                if ($active_camp_url == "" || $active_camp_api_key == "") {
                                    echo 'disabled';
                                }
                                ?>>
                                <option value="" disabled
                                        selected><?= __("Select List", $this->plugin_name) ?></option>
                                <option value=""><?= __("Just create contact", $this->plugin_name) ?></option>
                                <?php foreach ( $active_camp_list_select as $list ): ?>
                                    <option <?= ($active_camp_list == $list['id']) ? 'selected' : ''; ?>
                                            value="<?= $list['id']; ?>"><?= $list['name']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        <?php else: ?>
                            <span><?php echo $active_camp_list_select; ?></span>
                        <?php endif; ?>
                    </div>
                </div>
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_active_camp_automation">
                            <?php echo __('ActiveCampaign automation', $this->plugin_name) ?>
                        </label>
                    </div>
                    <div class="col-sm-8">
                        <?php if (is_array($active_camp_automation_select)): ?>
                            <select name="ays_active_camp_automation" id="ays_active_camp_automation"
                                <?php
                                if ($active_camp_url == "" || $active_camp_api_key == "") {
                                    echo 'disabled';
                                }
                                ?>>
                                <option value="" disabled
                                        selected><?= __("Select List", $this->plugin_name) ?></option>
                                <option value=""><?= __("Just create contact", $this->plugin_name) ?></option>
                                <?php foreach ( $active_camp_automation_select as $automation ): ?>
                                    <option <?= ($active_camp_automation == $automation['id']) ? 'selected' : ''; ?>
                                            value="<?= $automation['id']; ?>"><?= $automation['name']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        <?php else: ?>
                            <span><?php echo $active_camp_automation_select; ?></span>
                        <?php endif; ?>
                    </div>
                </div>
            <?php
            endif;
            ?>
        <?php
        else:
            ?>
            <blockquote class="error_message">
                <?php echo __(
                    sprintf(
                        __("For enabling this option, please go to ",$this->plugin_name)." %s ". __("page and fill all options.",$this->plugin_name),
                        "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>".__("this",$this->plugin_name)."</a>"
                    ),
                    $this->plugin_name);
                ?>
            </blockquote>
        <?php
        endif;
        ?>
    </fieldset> <!-- ActiveCampaign Settings -->
    <hr/>
    <fieldset>
        <legend>
            <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/slack_logo.png" alt="">
            <h5><?php echo __('Slack Settings', $this->plugin_name) ?></h5>
        </legend>
        <?php
        if (count($slack) > 0):
            ?>
            <?php
            if ($slack_token == ""):
                ?>
                <blockquote class="error_message">
                    <?php echo __(
                        sprintf(
                            __("For enabling this option, please go to ",$this->plugin_name)." %s ". __("page and fill all options.",$this->plugin_name),
                            "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>".__("this",$this->plugin_name)."</a>"
                        ),
                        $this->plugin_name);
                    ?>
                </blockquote>
            <?php
            else:
                ?>
                <hr/>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_enable_slack">
                            <?php echo __('Enable Slack integration', $this->plugin_name) ?>
                        </label>
                    </div>
                    <div class="col-sm-1">
                        <input type="checkbox" class="ays-enable-timer1" id="ays_enable_slack"
                               name="ays_enable_slack"
                               value="on"
                            <?php
                            if ($slack_token == "") {
                                echo "disabled";
                            } else {
                                echo ($enable_slack == 'on') ? 'checked' : '';
                            }
                            ?>/>
                    </div>
                </div>
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_slack_conversation">
                            <?php echo __('Slack conversation', $this->plugin_name) ?>
                        </label>
                    </div>
                    <div class="col-sm-8">
                        <?php if (is_array($slack_select)): ?>
                            <select name="ays_slack_conversation" id="ays_slack_conversation"
                                <?php
                                if ($slack_token == "") {
                                    echo 'disabled';
                                }
                                ?>>
                                <option value="" disabled
                                        selected><?= __("Select Channel", $this->plugin_name) ?></option>
                                <?php foreach ( $slack_select as $conversation ): ?>
                                    <option <?= ($slack_conversation == $conversation['id']) ? 'selected' : ''; ?>
                                            value="<?= $conversation['id']; ?>"><?php echo $conversation['name']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        <?php else: ?>
                            <span><?php echo $slack_select; ?></span>
                        <?php endif; ?>
                    </div>
                </div>
            <?php
            endif;
            ?>
        <?php
        else:
            ?>
            <blockquote class="error_message">
                <?php echo __(
                    sprintf(
                        __("For enabling this option, please go to ",$this->plugin_name)." %s ". __("page and fill all options.",$this->plugin_name),
                        "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>".__("this",$this->plugin_name)."</a>"
                    ),
                    $this->plugin_name);
                ?>
            </blockquote>
        <?php
        endif;
        ?>
    </fieldset> <!-- Slack Settings -->
    <hr/>
    <fieldset>
        <legend>
            <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/sheets_logo.png" alt="">
            <h5><?php echo __('Google Sheet Settings', $this->plugin_name) ?></h5>
        </legend>
        <?php
        if (count($google) > 0):
            ?>
            <?php
            if ($google_token == ""):
                ?>
                <blockquote class="error_message">
                    <?php echo __(
                        sprintf(
                            __("For enabling this option, please go to ",$this->plugin_name)." %s ". __("page and fill all options.",$this->plugin_name),
                            "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>".__("this",$this->plugin_name)."</a>"
                        ),
                        $this->plugin_name);
                    ?>
                </blockquote>
            <?php
            else:
                ?>
                <hr/>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_poll_enable_google">
                            <?php echo __('Enable Google integration', $this->plugin_name) ?>
                        </label>
                    </div>
                    <div class="col-sm-1">
                        <input type="checkbox" class="ays-enable-timer1" id="ays_poll_enable_google"
                               name="ays_poll_enable_google"
                               value="on"
                            <?php
                            if ($google_token == "") {
                                echo "disabled";
                            } else {
                                echo ($enable_google_sheets == 'on') ? 'checked' : '';
                            }
                            ?>/>                        
                    </div>
                </div>
                <hr>
            <?php
            endif;
            ?>
        <?php
        else:
            ?>
            <blockquote class="error_message">
                <?php echo __(
                    sprintf(
                        __("For enabling this option, please go to ",$this->plugin_name)." %s ". __("page and fill all options.",$this->plugin_name),
                        "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>".__('this' , $this->plugin_name)."</a>"
                    ),
                    $this->plugin_name);
                ?>
            </blockquote>
        <?php
        endif;
        ?>
    </fieldset> <!-- Google Sheet Settings -->
    <hr>
    <fieldset>
        <legend>
            <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/mad-mimi-logo-min.png" alt="">
            <h5><?php echo __('Mad Mimi', $this->plugin_name) ?></h5>
        </legend>
        <?php
        if (count($mad_mimi) > 0):
            ?>
            <?php
            if ($mad_mimi_api_key == "" || $mad_mimi_user_name == ""):
                ?>
                <blockquote class="error_message">
                    <?php echo __(
                        sprintf(
                            __("For enabling this option, please go to ",$this->plugin_name)." %s ". __("page and fill all options.",$this->plugin_name),
                            "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>".__("this",$this->plugin_name)."</a>"
                        ),
                        $this->plugin_name);
                    ?>
                </blockquote>
            <?php
            else:
                ?>
                <hr/>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_poll_enable_mad_mimi">
                            <?php echo __('Enable Mad Mimi', $this->plugin_name) ?>
                        </label>
                    </div>
                    <div class="col-sm-1">
                        <input type="checkbox" class="ays-enable-timer1" id="ays_poll_enable_mad_mimi"
                               name="ays_poll_enable_mad_mimi"
                               value="on"
                            <?php
                            if ($mad_mimi_api_key == "") {
                                echo "disabled";
                            } else {
                                echo ($enable_mad_mimi) ? 'checked' : '';
                            }
                            ?>/>
                    </div>
                </div>
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_poll_mad_mimi_list">
                            <?php echo __('Select List', $this->plugin_name) ?>
                        </label>
                    </div>
                    <div class="col-sm-8">
                        <?php if(!empty($mad_mimi_lists)){
                            $mad_mimi_select  = "<select name='ays_poll_mad_mimi_list' id='ays_poll_mad_mimi_list'>";
                            $mad_mimi_select .= "<option value='' disabled>Select list</option>";
                            foreach($mad_mimi_lists as $key => $mad_mimi_list){
                                $list_name = isset($mad_mimi_list['name']) && $mad_mimi_list['name'] != "" ? esc_attr($mad_mimi_list['name']) : ""; 
                                $selected = isset($mad_mimi_db_list) && $mad_mimi_db_list == $list_name ? "selected" : "";
                                $mad_mimi_select .= "<option value='".$list_name."' ".$selected.">".$list_name."</option>";
                            }
                            $mad_mimi_select .= "</select>";
                            echo $mad_mimi_select;
                            }
                            else{
                                echo __("There are no lists" , $this->plugin_name);
                            }                        
                        ?>
                    </div>
                </div>
                <hr>
            <?php
            endif;
            ?>
        <?php
        else:
            ?>
            <blockquote class="error_message">
                <?php echo __(
                    sprintf(
                        __("For enabling this option, please go to ",$this->plugin_name)." %s ". __("page and fill all options.",$this->plugin_name),
                        "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>".__("this",$this->plugin_name)."</a>"
                    ),
                    $this->plugin_name);
                ?>
            </blockquote>
        <?php
        endif;
        ?>
    </fieldset> <!-- Mad Mimi -->
    <hr>
    <fieldset>
        <legend>
            <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/get_response.png" alt="">
            <h5><?php echo __('GetResponse Settings', $this->plugin_name) ?></h5>
        </legend>
        <?php
        if (count($getResponse) > 0):
            ?>
            <?php
            if ($getResponse_api_key == ""):
                ?>
                <blockquote class="error_message">
                    <?php echo __(
                        sprintf(
                            __("For enabling this option, please go to ",$this->plugin_name)." %s ". __("page and fill all options.",$this->plugin_name),
                            "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>".__("this",$this->plugin_name)."</a>"
                        ),
                        $this->plugin_name);
                    ?>
                </blockquote>
            <?php else: ?>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_poll_enable_getResponse">
                            <?php echo __('Enable GetResponse', $this->plugin_name) ?>
                        </label>
                    </div>
                    <div class="col-sm-8">
                        <input type="checkbox"
                               class="ays-enable-timer1"
                               id="ays_poll_enable_getResponse"
                               name="ays_poll_enable_getResponse"
                               value="on"
                            <?php
                            if (!$getResponse_status) {
                                echo "disabled";
                            } else {
                                echo ($enable_getResponse) ? 'checked' : '';
                            }
                            ?>/>
                    </div>                 
                </div>
                <hr>
                <div class="form-group row">
                    <div class="col-sm-4">
                        <label for="ays_poll_getResponse_list">
                            <?php echo __('GetResponse List', $this->plugin_name) ?>
                        </label>
                    </div>                                        
                    <div class="col-sm-8">
                        <?php if($getResponse_status): ?>
                        <select id="ays_poll_getResponse_list" name="ays_poll_getResponse_list">
                            <option value="" disabled selected>Select list</option>
                            <?php
                                $content = "";
                                foreach($getResponse_lists as $key => $getResponse_list){
                                    if(isset($getResponse_list) && is_array($getResponse_list)){
                                        $list_id   = isset($getResponse_list['campaignId']) && $getResponse_list['campaignId'] != "" ? esc_attr($getResponse_list['campaignId']) : "";
                                        $list_name = isset($getResponse_list['name']) && $getResponse_list['name'] != "" ? esc_attr($getResponse_list['name']) : "";
                                        $selected_list = ($list_id == $getResponse_db_list) ? "selected" : "";
                                        $content .= "<option value=".$list_id." ".$selected_list.">".$list_name."</option>";
                                    }
                                }      
                                echo $content;                      
                            ?>
                        </select>
                        <?php else: echo "<blockquote style='border-left:2px solid red;font-size: 16px;'>".$getResponse_message."</blockquote>"; ?>
                        <?php endif;?>
                    </div>   
                </div>
            <?php endif; ?>
        <?php
        else:
            ?>
            <blockquote class="error_message">
                <?php echo __(
                    sprintf(
                        __("For enabling this option, please go to ",$this->plugin_name)." %s ". __("page and fill all options.",$this->plugin_name),
                        "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>".__("this",$this->plugin_name)."</a>"
                    ),
                    $this->plugin_name);
                ?>
            </blockquote>
        <?php
        endif;
        ?>
    </fieldset> <!-- GetResponse Settings -->
    <hr/>
    <fieldset>
        <legend>
            <img class="ays_integration_logo" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/integrations/convertkit_logo.png" alt="">
            <h5><?php echo __('ConvertKit Settings',$this->plugin_name)?></h5>
        </legend>
        <?php
            if(isset($convertKit) && count($convertKit) > 0):
        ?>
            <?php
                if($convertKit_api_key == ""):
            ?>
            <blockquote class="error_message">
                <?php echo __(
                    sprintf(
                        __("For enabling this option, please go to ",$this->plugin_name)." %s ". __("page and fill all options.",$this->plugin_name),
                        "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>".__("this",$this->plugin_name)."</a>"
                    ),
                    $this->plugin_name);
                ?>
            </blockquote>
            <?php
                else:
            ?>
            <div class="form-group row">
                <div class="col-sm-4">
                    <label for="ays_poll_enable_convertkit">
                        <?php echo __('Enable ConvertKit',$this->plugin_name)?>
                    </label>
                </div>
                <div class="col-sm-1">
                    <input type="checkbox" class="ays-enable-timer1" id="ays_poll_enable_convertkit"
                           name="ays_poll_enable_convertkit"
                           value="on"
                           <?php
                                if(!$convertKit_response_status){
                                    echo "disabled";
                                }else{
                                    echo ($enable_convertKit) ? 'checked' : '';
                                }
                           ?>/>
                </div>
            </div>
            <hr>
            <div class="form-group row">
                <div class="col-sm-4">
                    <label for="ays_poll_convertKit_list">
                        <?php echo __('ConvertKit list',$this->plugin_name)?>
                    </label>
                </div>
                <div class="col-sm-8">
                    <?php if(isset($convertKit_forms) && !empty($convertKit_forms)): ?>
                        <?php if($convertKit_response_status):?>
                        <select name="ays_poll_convertKit_list" id="ays_poll_convertKit_list"
                           <?php
                                if(!$convertKit_response_status){
                                    echo 'disabled';
                                }
                            ?>>
                            <option value="" disabled selected>Select list</option>
                        <?php foreach($convertKit_forms_list as $key => $convertKit_form): ?>
                            <option <?php 
                                $response_form_id = isset($convertKit_form['id']) && $convertKit_form['id'] != "" ? $convertKit_form['id'] : "";
                                $response_form_name = isset($convertKit_form['name']) && $convertKit_form['name'] != "" ? $convertKit_form['name'] : "";
                                echo ($convertKit_form_id == $response_form_id) ? 'selected' : ''; ?>
                                value="<?php echo $response_form_id; ?>"><?php echo $response_form_name; ?></option>
                        <?php endforeach; ?>
                        </select>
                        <?php else: echo __("There are no forms" , $this->plugin_name);?>
                    <?php endif;?>
                    <?php else: ?>
                        <span><?php echo __("There are no forms" , $this->plugin_name); ?></span>
                    <?php endif; ?>
                </div>
            </div>
            <?php
                endif;
            ?>
        <?php
            else:
        ?>
            <blockquote class="error_message">
                <?php echo __(
                    sprintf(
                        __("For enabling this option, please go to ",$this->plugin_name)." %s ". __("page and fill all options.",$this->plugin_name),
                        "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=$this->plugin_name-settings&ays_poll_tab=tab2'>".__("this",$this->plugin_name)."</a>"
                    ),
                    $this->plugin_name);
                ?>
            </blockquote>
        <?php
            endif;
        ?>
    </fieldset> <!-- ConvertKit Settings -->


    <hr/>
</div>