<?php
    require_once(POLL_MAKER_ADMIN_PATH . "/partials/polls/actions/poll-maker-polls-actions-options.php");
?>
<style>
    /*save changing properties of poll in the css-variables*/
    :root {
        /*colors*/
        --theme-main-color: <?=$main_color_s?>;
        --theme-bg-color: <?=$bg_color_s?>;
        --theme-answer-bg-color: <?=$answer_bg_color_s?>;
        --theme-title-bg-color: <?=$title_bg_color_s?>;
        --theme-text-color: <?=$text_color_s?>;
        --theme-icon-color: <?=$text_color_s?>;
        /*only for coffee fluid theme*/
        --theme-text-color-a2: <?=$this->polls_obj->hex2rgba($text_color_s, 0.2)?>;
        --theme-text-color-a5: <?=$this->polls_obj->hex2rgba($text_color_s, 0.5)?>;
        --theme-text-color-a75: <?=$this->polls_obj->hex2rgba($text_color_s, 0.75)?>;
        /*end coffee fluid colors*/

        /*options*/
        --poll-width: <?=((int) $width_s  > 0 ? (int) $width_s  . "px" : "100%")?>;
        --poll-border-style: <?=$border_s?>;
        --poll-border-radius: <?=$border_radius_s?>;
        --poll-border-width: <?=$border_width_s?>;
        --poll-box-shadow: <?=$enable_box_shadow_s?>;
        --poll-bagckround-image: <?=$bg_image_s?>;
        --poll-icons-size: <?=absint($icon_size_s) >= 10 ? absint($icon_size_s) : 24 ?>px;
        --poll-display-title: <?=((1 == $poll['show_title']) ? "block" : "none")?>;
        --poll-display-image-box: <?=((!empty($poll['image'])) ? "block" : "none")?>;

    }

    input[type='button'].ays-poll-btn{
		font-size: <?php echo $buttons_font_size; ?>px;
		padding: <?php echo $buttons_top_bottom_padding."px ".$buttons_left_right_padding."px"; ?>;
		border-radius: <?php echo $buttons_border_radius; ?>px;
	}

</style>
<!--LIVE PREVIEW STYLES END-->
<div class="wrap">
    <div class="container-fluid">
        <form class="ays-poll-form <?= $color_class; ?>" id="ays-poll-form" method="post">
            <input type="hidden" name="ays_poll_active_tab" id="ays_poll_active_tab" value="<?= $active_tab ?>"/>
           	<input type="hidden" name="ays_poll_ctrate_date" value="<?php // echo $poll_create_date; ?>">
           	<!-- <input type="hidden" name="ays_poll_author" value="<?php //echo htmlentities(json_encode($poll_author)); ?>"> -->
            <input type="hidden"  id="poll_choose_type_first" value="<?php echo $poll['type']; ?>" >
           	<input type="hidden" name="ays_poll_author" value="<?php echo $poll_author; ?>">
            <div class="ays-poll-heading-box">
                <div class="ays-poll-wordpress-user-manual-box">
                    <a href="https://ays-pro.com/wordpress-poll-maker-user-manual" target="_blank"><?php echo __("View Documentation", $this->plugin_name); ?></a>
                </div>
            </div>
            <h1 class="wp-heading-inline">
				<?php
				echo "$heading ";
				$other_attributes = array();
				submit_button(__('Save Poll', $this->plugin_name), 'primary ays-button-top ays-loader-banner', 'ays_submit_top', false, $other_attributes);
				submit_button(__('Apply Poll', $this->plugin_name), 'ays-button-top ays-loader-banner ays-apply-all', 'ays_apply_top', false, $other_attributes);
				echo $loader_iamge;
				?>
            </h1>
            <div>
                <p class="ays-subtitle">
                    <strong class="ays_poll_title_in_top">
	                    <?php echo stripslashes(htmlentities($poll['title'])); ?>
                    </strong>
                </p>
                <?php if($id !== null): ?>
                <div class="row">
                    <div class="col-sm-3">
                        <label> <?php echo __( "Shortcode text for editor", $this->plugin_name ); ?> </label>
                    </div>
                    <div class="col-sm-9">
                        <p style="font-size:14px; font-style:italic;">
                            <?php echo __("To insert the Poll into a page, post or text widget, copy shortcode", $this->plugin_name); ?>
                            <strong class="ays-poll-shortcode-box" data-toggle="tooltip" title="<?php echo __('Click for copy.',$this->plugin_name);?>" onClick="selectElementContents(this)" style="font-size:16px; font-style:normal;"><?php echo "[ays_poll id=".$id."]"; ?></strong>
                            <?php echo " " . __( "and paste it at the desired place in the editor.", $this->plugin_name); ?>
                        </p>
                    </div>
                </div>
                <?php endif;?>
            </div>
            <hr>
            <div class="ays-top-menu-wrapper">
                <div class="ays_menu_left" data-scroll="0"><i class="ays_poll_fas ays_poll_fa-left"></i></div>
                <div class="ays-top-menu">
                    <div class="nav-tab-wrapper ays-top-tab-wrapper">
                        <a href="#tab1" data-title="tab1" class="nav-tab <?= $active_tab == 'tab1' ? 'nav-tab-active' : ''; ?>"><?= __('General', $this->plugin_name); ?></a>
                        <a href="#tab2" data-title="tab2" class="nav-tab <?= $active_tab == 'tab2' ? 'nav-tab-active' : ''; ?>"><?= __('Styles', $this->plugin_name); ?></a>
                        <a href="#tab3" data-title="tab3" class="nav-tab <?= $active_tab == 'tab3' ? 'nav-tab-active' : ''; ?>"><?= __('Settings', $this->plugin_name); ?></a>
                        <a href="#tab4" data-title="tab4" class="nav-tab <?= $active_tab == 'tab4' ? 'nav-tab-active' : ''; ?>"><?= __("Results Settings", $this->plugin_name); ?></a>
                        <a href="#tab5" data-title="tab5" class="nav-tab <?= $active_tab == 'tab5' ? 'nav-tab-active' : ''; ?>"><?= __("Limitations", $this->plugin_name); ?> </a>
                        <a href="#tab6" data-title="tab6" class="nav-tab <?= $active_tab == 'tab6' ? 'nav-tab-active' : ''; ?>"><?= __("User Data", $this->plugin_name); ?></a>
                        <a href="#tab7" data-title="tab7" class="nav-tab <?= $active_tab == 'tab7' ? 'nav-tab-active' : ''; ?>"><?= __("Email", $this->plugin_name); ?></a>                
                        <a href="#tab8" data-title="tab8" class="nav-tab <?= $active_tab == 'tab8' ? 'nav-tab-active' : ''; ?>"><?= __("Integrations", $this->plugin_name); ?></a>
                    </div>
                </div>
                <div class="ays_menu_right" data-scroll="-1"><i class="ays_poll_fas ays_poll_fa-right"></i></div>
            </div>

            <?php
                for($tab_ind = 1; $tab_ind <= 8; $tab_ind++){
                    require_once( POLL_MAKER_ADMIN_PATH . "/partials/polls/actions/partials/poll-maker-polls-actions-tab".$tab_ind.".php" );
                }
            ?>

			<?php
			wp_nonce_field('poll_action', 'poll_action');
			$other_attributes = array();
            ?>
            <div class="ays_save_buttons_content">
                <div class="ays_save_buttons_box">
                    <?php
                    submit_button(__('Save Poll', $this->plugin_name), 'primary ays-button ays-loader-banner', 'ays_submit', false, $other_attributes);
                    submit_button(__('Apply Poll', $this->plugin_name), 'ays-button ays-loader-banner', 'ays_apply', false, $other_attributes);
                    echo $loader_iamge;
                    // if ( $prev_poll_id != "" && !is_null( $prev_poll_id ) ) {

                    //     $other_attributes = array(
                    //         'id' => 'ays-polls-prev-button',
                    //         'data-message' => __( 'Are you sure you want to go to the previous poll page?', $this->plugin_name),
                    //         'href' => sprintf( '?page=%s&action=%s&poll=%d', esc_attr( $_REQUEST['page'] ), 'edit', absint( $prev_poll_id ) )
                    //     );
                    //     submit_button(__('Prev Poll', $this->plugin_name), 'button button-primary ays-button ays-poll-prev-poll-button ays-poll-next-prev-button-class', 'ays_poll_prev_button', false, $other_attributes);
                    // }

                    // if ( $next_poll_id != "" && !is_null( $next_poll_id ) ) {

                    //     $other_attributes = array(
                    //         'id' => 'ays-polls-next-button',
                    //         'data-message' => __( 'Are you sure you want to go to the next poll page?', $this->plugin_name),
                    //         'href' => sprintf( '?page=%s&action=%s&poll=%d', esc_attr( $_REQUEST['page'] ), 'edit', absint( $next_poll_id ) )
                    //     );
                    //     submit_button(__('Next Poll', $this->plugin_name), 'button button-primary ays-button ays-poll-next-prev-button-class', 'ays_poll_next_button', false, $other_attributes);
                    // }
                    ?>
                </div>
                <div class="ays_save_default_button_box">
                    <?php 
                        if ( $prev_poll_id != "" && !is_null( $prev_poll_id ) ) {

                            $other_attributes = array(
                                'id' => 'ays-polls-prev-button',
                                'data-message' => __( 'Are you sure you want to go to the previous poll page?', $this->plugin_name),
                                'href' => sprintf( '?page=%s&action=%s&poll=%d', esc_attr( $_REQUEST['page'] ), 'edit', absint( $prev_poll_id ) )
                            );
                            submit_button(__('Prev Poll', $this->plugin_name), 'button button-primary ays-button ays-poll-prev-poll-button ays-poll-next-prev-button-class', 'ays_poll_prev_button', false, $other_attributes);
                        }

                        if ( $next_poll_id != "" && !is_null( $next_poll_id ) ) {

                            $other_attributes = array(
                                'id' => 'ays-polls-next-button',
                                'data-message' => __( 'Are you sure you want to go to the next poll page?', $this->plugin_name),
                                'href' => sprintf( '?page=%s&action=%s&poll=%d', esc_attr( $_REQUEST['page'] ), 'edit', absint( $next_poll_id ) )
                            );
                            submit_button(__('Next Poll', $this->plugin_name), 'button button-primary ays-button ays_poll_next_poll_button ays-poll-next-prev-button-class', 'ays_poll_next_button', false, $other_attributes);
                        }
                    ?>
                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __( "Saves the assigned settings of the current poll as default. After clicking on this button, each time creating a new poll, the system will take the settings and styles of the current poll. If you want to change and renew it, please click on this button on another poll." , $this->plugin_name ); ?>">
                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                    </a>
                    <?php
                    $other_attributes = array( 'data-message' => __( 'Are you sure that you want to save these parameters as default?', $this->plugin_name ) );
                    submit_button(__('Save as default', $this->plugin_name), 'ays_default_btn', 'ays_default', false ,  $other_attributes);
                    echo $loader_iamge;
                    ?>
                </div>
            </div>
            <?php if($id === null): ?>
                <div class="ays_poll_layer_container">
                    <div class="ays_poll_layer_content">
                        <div class="ays-poll-close-type">
                            <a href="?page=poll-maker-ays">
                                <img src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/icons/cross.png">
                            </a>
                        </div>
                        <div class="ays_poll_layer_box">
                            <div class="ays-poll-close-layer">
                                <div class="ays-poll-choose-type">
                                    <p style="margin: 0;">Choose Your Poll Type</p>
                                </div>
                            </div>
                            <div class="ays_poll_layer_box_blocks">
                                <label class='ays-poll-dblclick-layer'>
                                    <input type="radio" class="ays-poll-content-type ays-poll-types" value="choosing" name="ays_poll_choose_poll_type_modal[]" <?= ($poll['type'] == 'choosing') ? 'checked' : '' ?>>                                        
                                    <div class="ays_poll_layer_item" >
                                        <div class="ays_poll_layer_item_logo" >
                                            <div class="ays_poll_layer_item_logo_overlay ays_poll_layer_item_logo_overlay_choosing" >
                                                <img src="<?= POLL_MAKER_AYS_ADMIN_URL . '/images/polls/choosing.png' ?>"
                                                alt="<?= __('Choosing', $this->plugin_name) ?>">
                                            </div>
                                        </div>
                                        <div class="ays_poll_layer_item_title">
                                            <p style="margin:0px;"><?php echo __('Choosing', $this->plugin_name) ?></p>
                                            <a class="ays_poll_view_demo_link" href="https://poll-plugin.com/image-choosing/" style="font-size:12px;" target="_blank">View demo</a>
                                            <i class="ays_poll_fas ays_poll_fa_play" aria-hidden="true"></i>
                                        </div>
                                        <div class="ays_poll_layer_item_description"></div>
                                    </div>
                                </label>
                                <label class='ays-poll-dblclick-layer'>
                                    <input type="radio" class="ays-poll-content-type ays-poll-types" value="rating" name="ays_poll_choose_poll_type_modal[]" <?= ($poll['type'] == 'rating') ? 'checked' : '' ?>>
                                    <div class="ays_poll_layer_item">
                                        <div class="ays_poll_layer_item_logo">
                                            <div class="ays_poll_layer_item_logo_overlay
                                            ays_poll_layer_item_logo_overlay_rating">
                                            <img src="<?= POLL_MAKER_AYS_ADMIN_URL . '/images/polls/rating.png' ?>"
                                            alt="<?= __('Rating', $this->plugin_name) ?>">
                                            </div>
                                        </div>
                                        <div class="ays_poll_layer_item_title">
                                            <p style="margin:0px;"><?php echo  __('Rating', $this->plugin_name) ?></p>
                                            <a class="ays_poll_view_demo_link" href="https://poll-plugin.com/rating-polls-rating-type/" style="font-size:12px;" target="_blank">View demo</a>
                                            <i class="ays_poll_fas ays_poll_fa_play" aria-hidden="true"></i>
                                        </div>
                                        <div class="ays_poll_layer_item_description"></div>
                                    </div>
                                </label>
                                <label class='ays-poll-dblclick-layer'>
                                    <input type="radio" class="ays-poll-content-type ays-poll-types" value="voting" name="ays_poll_choose_poll_type_modal[]" <?= ($poll['type'] == 'voting') ? 'checked' : '' ?>>
                                    <div class="ays_poll_layer_item">
                                        <div class="ays_poll_layer_item_logo">
                                            <div class="ays_poll_layer_item_logo_overlay ays_poll_layer_item_logo_overlay_voting" >
                                                <img src="<?= POLL_MAKER_AYS_ADMIN_URL . '/images/polls/voting.png' ?>" alt="<?= __('Voting', $this->plugin_name) ?>">
                                            </div>
                                        </div>
                                        <div class="ays_poll_layer_item_title">
                                            <p style="margin:0px;"><?php echo  __('Voting', $this->plugin_name) ?></p>
                                            <a class="ays_poll_view_demo_link" href="https://poll-plugin.com/voting-polls-voting-type/" style="font-size:12px;" target="_blank">View demo</a>
                                            <i class="ays_poll_fas ays_poll_fa_play" aria-hidden="true"></i>
                                        </div>
                                        <div class="ays_poll_layer_item_description"></div>  
                                    </div>
                                </label>
                            </div>         
                            <div class="ays_poll_layer_box_blocks">
                                <label class='ays-poll-dblclick-layer'>
                                    <input type="radio" class="ays-poll-content-type ays-poll-types" value="text" name="ays_poll_choose_poll_type_modal[]" <?= ($poll['type'] == 'text') ? 'checked' : '' ?>>
                                    <div class="ays_poll_layer_item">
                                        <div class="ays_poll_layer_item_logo">
                                            <div class="ays_poll_layer_item_logo_overlay ays_poll_layer_item_logo_overlay_text" >
                                                <img src="<?= POLL_MAKER_AYS_ADMIN_URL . '/images/polls/Text.png' ?>"
                                                alt="<?= __('Text', $this->plugin_name) ?>">
                                            </div>
                                        </div>
                                        <div class="ays_poll_layer_item_title">
                                            <p style="margin:0px;"><?php echo  __('Text', $this->plugin_name) ?></p>
                                            <!-- <a href="https://bit.ly/3P42n1R" style="font-size:12px;font-style: italic;" target="_blank">View demo</a> -->
                                            <a class="ays_poll_view_demo_link" href="https://poll-plugin.com/open-ended-question-polls-text-type/" style="font-size:12px;" target="_blank">View demo</a>
                                            <i class="ays_poll_fas ays_poll_fa_play" aria-hidden="true"></i>
                                        </div>
                                        <div class="ays_poll_layer_item_description"></div>  
                                    </div>
                                </label>
                                <label class='ays-poll-dblclick-layer'>
                                    <input type="radio" class="ays-poll-content-type ays-poll-types" value="dropdown" name="ays_poll_choose_poll_type_modal[]" <?= ($poll['type'] == 'dropdown') ? 'checked' : '' ?>>
                                    <div class="ays_poll_layer_item">
                                        <div class="ays_poll_layer_item_logo">
                                            <div class="ays_poll_layer_item_logo_overlay ays_poll_layer_item_logo_overlay_dropdown" >
                                                <img src="<?= POLL_MAKER_AYS_ADMIN_URL . '/images/polls/Dropdown.png' ?>" alt="<?= __('Dropdown', $this->plugin_name) ?>">
                                            </div>
                                        </div>
                                        <div class="ays_poll_layer_item_title">
                                            <p style="margin:0px;"><?php echo  __('Dropdown', $this->plugin_name) ?></p>
                                            <a class="ays_poll_view_demo_link" href="https://poll-plugin.com/anonymous-polls-dropdown-type/" style="font-size:12px;" target="_blank">View demo</a>
                                            <i class="ays_poll_fas ays_poll_fa_play" aria-hidden="true"></i>
                                        </div>
                                        <div class="ays_poll_layer_item_description"></div>  
                                    </div>
                                </label>
                                <label class='ays-poll-dblclick-layer'>
                                    <input type="radio" class="ays-poll-content-type ays-poll-types" value="versus" name="ays_poll_choose_poll_type_modal[]" <?= ($poll['type'] == 'versus') ? 'checked' : '' ?>>
                                    <div class="ays_poll_layer_item">
                                        <div class="ays_poll_layer_item_logo">
                                            <div class="ays_poll_layer_item_logo_overlay ays_poll_layer_item_logo_overlay_versus" >
                                                <span>VS</span>
                                            </div>
                                        </div>
                                        <div class="ays_poll_layer_item_title">
                                            <p style="margin:0px;"><?php echo  __('Versus', $this->plugin_name) ?></p>
                                            <a class="ays_poll_view_demo_link" href="https://poll-plugin.com/versus-poll-versus-type/" style="font-size:12px;" target="_blank">View demo</a>
                                            <i class="ays_poll_fas ays_poll_fa_play" aria-hidden="true"></i>
                                        </div>
                                        <div class="ays_poll_layer_item_description"></div>  
                                    </div>
                                </label>
                            </div>        
                            <div class="ays_poll_layer_box_blocks"> 
                                <label class='ays-poll-dblclick-layer'>
                                    <input type="radio" class="ays-poll-content-type ays-poll-types" value="range" name="ays_poll_choose_poll_type_modal[]" <?= ($poll['type'] == 'range') ? 'checked' : '' ?>>
                                    <div class="ays_poll_layer_item">
                                        <div class="ays_poll_layer_item_logo">
                                            <div class="ays_poll_layer_item_logo_overlay ays_poll_layer_item_logo_overlay_range" >
                                                <img src="<?= POLL_MAKER_AYS_ADMIN_URL . '/images/polls/range.png' ?>" alt="<?= __('Range', $this->plugin_name) ?>">
                                            </div>
                                        </div>
                                        <div class="ays_poll_layer_item_title">
                                            <p style="margin:0px;"><?php echo  __('Range', $this->plugin_name) ?></p>
                                            <a class="ays_poll_view_demo_link" href="https://poll-plugin.com/slider-rating-polls-slider-type/" style="font-size:12px;" target="_blank">View demo</a>
                                            <i class="ays_poll_fas ays_poll_fa_play" aria-hidden="true"></i>
                                        </div>
                                        <div class="ays_poll_layer_item_description"></div>  
                                    </div>
                                </label>          
                            </div>                   
                        </div>
                    </div>
                    <div class="ays_poll_select_button_layer">
                        <div class="ays_poll_select_button_item">
                            <input type="button" class="ays_poll_layer_button" name="" value="Select" data-type="<?php echo $poll['type']; ?>">
                            <input type="hidden"  name="ays-poll-type" id="poll_choose_type" value="<?php echo $poll['type']; ?>" >
                        </div>
                    </div>
                </div>
                <?php else: ?>
                   <input type="hidden"  name="ays-poll-type" id="poll_choose_type" value="<?php echo $poll['type']; ?>" >
            <?php endif; ?>
        </form>
    </div>
</div>