<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://ays-pro.com/
 * @since      1.0.0
 *
 * @package    Poll_Maker_Ays
 * @subpackage Poll_Maker_Ays/admin/partials
 */

$action = isset($_GET['action']) ? $_GET['action'] : '';
$id     = isset($_GET['poll']) ? absint($_GET['poll']) : null;
if ($action == 'duplicate' && $id != null) {
	$this->polls_obj->duplicate_poll($id);
}
$poll_max_id = Poll_Maker_Ays_Admin::get_max_id('polls');
?>

<div class="wrap">
    <div class="wp-heading-block">

        <h1 class="wp-heading-inline">
            <?php

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_FILES['import_csv']) && $_FILES['import_csv']['error'] == 0) {
        $this->polls_obj->apm_import_polls($_FILES);
    }
}

if ($action == 'export') {
    $path = POLL_MAKER_ADMIN_PATH . "/partials/";
    $file = $this->polls_obj->apm_export_polls($path);
    if (!isset($file['file'])) {
        echo "<div class='notice notice-{$file['status']} is-dismissible' style='margin-top:20px'>
                <p>{$file['message']}</p>
            </div>";
    } else {
        echo "<script>
                   jQuery(document).ready(function() {
                       window.location.href = jQuery('#download').attr('href');
                   });
            </script>
            <div class='notice notice-{$file['status']} is-dismissible' style='margin-top:20px'>
                <p>{$file['message']}</p>
            </div>";
    }
}
echo esc_html(get_admin_page_title());
echo sprintf('<a href="?page=%s&action=%s" class="page-title-action ays-poll-add-new-button">' . __('Add New', $this->plugin_name) . '</a>', esc_attr($_REQUEST['page']), 'add');
?>
    </h1>
    <div class="ays-poll-heading-box">
            <div class="ays-poll-wordpress-user-manual-box">
                <a href="https://ays-pro.com/wordpress-poll-maker-user-manual" target="_blank"><?php echo __("View Documentation", $this->plugin_name); ?></a>
            </div>
        </div>
    </div>
    <div class="create_quick_poll_container">
        <button class="create_quick_poll" id="ays_create_quick_poll" title="<?php echo __( "Create Quick Poll", $this->plugin_name ); ?>"><img src="<?php echo POLL_MAKER_AYS_ADMIN_URL . '/images/icons/icon-128x128.png' ?>" alt="Create Quick Poll"></button> 
    </div>
    <div class="apm-right-top">
        <?=sprintf('<a href="?page=%s&action=export" class="page-title-action" title="' . __("Export all your polls into a CSV file.", $this->plugin_name) . '">' . __('Export poll(s)', $this->plugin_name) . '</a>', esc_attr($_REQUEST['page']), 'add');?>
        <a href="<?=plugins_url() . '/poll-maker/admin/partials/exported_polls/exported_polls.csv';?>" download id="download"></a>
        <form action="<?php echo sprintf('?page=%s&action=import', esc_attr($_REQUEST['page']), "add");?>" method="post" enctype="multipart/form-data" id="import-poll-form">
            <input type="file" name="import_csv" id="import-csv" style='display:none'>
            <label for="import-csv" class="page-title-action" title="<?=__("Select CSV file from your computer. You can export your polls for get example CSV file.", $this->plugin_name);?>">
                <?=__("Import poll(s)", $this->plugin_name);?></label>
        </form>
    </div>
    <div class="ays_poll_modal" id="ays-poll-quick-create">
        <!-- Modal content -->
        <div class="ays_poll_modal_content ays-modal-content fadeInDown" id="ays-poll-quick-create-content">
            <div class="ays-modal-header">
                <h4><?php echo __('Build your poll in a few minutes', $this->plugin_name); ?></h4>
                <span class="ays-close-quick-create">&times;</span>
            </div> 
            <div class="ays-modal-quick-poll-content">
                <form method="POST" id="ays-quick-poll-form">
                    <!-- Title  -->
                    <div class="ays-modal-poll-title-add">
                        <span><label for="ays-quick-poll-title"><?php echo __('Poll Title', $this->plugin_name); ?></label></span>
                        <input type="text" name="ays-poll-title" id="ays-quick-poll-title" data-required="true">
                    </div>
                    <!-- Question -->
                    <div class="ays-modal-poll-question-add">
                        <span><label for="ays-quick-poll-question"><?php echo __('Question', $this->plugin_name); ?></label></span>
                        <textarea name="ays_poll_question" id="ays-quick-poll-question" placeholder="<?php echo __('Ask a question*', $this->plugin_name); ?>" rows="3"></textarea>
                    </div>
                    <!-- Answers -->
                    <div class="ays-modal-poll-answers-section">
                        <span><label for="quick_poll_answer-1"><?php echo __('Answers', $this->plugin_name); ?></label></span>
                        <div class="quick_poll_answer_box">
                            <input class="quick_poll_answer" name="ays-poll-answers[]" data-id="1" placeholder="<?php echo __('Option*', $this->plugin_name); ?>">
                            <button type="button" class="quick_poll_answer_remove"><img src="<?php echo (POLL_MAKER_AYS_ADMIN_URL . '/images/remove-normal.png')?>" alt="remove" width="20px"></button>
                        </div>
                        <div class="quick_poll_answer_box">
                            <input class="quick_poll_answer" name="ays-poll-answers[]" data-id="2" placeholder="<?php echo __('Option*', $this->plugin_name); ?>">
                            <button type="button" class="quick_poll_answer_remove"><img src="<?php echo (POLL_MAKER_AYS_ADMIN_URL . '/images/remove-normal.png')?>" alt="remove" width="20px"></button>
                        </div>
                        <div class="quick_poll_answer_box">
                            <input class="quick_poll_answer" name="ays-poll-answers[]" data-id="3" placeholder="<?php echo __('Option*', $this->plugin_name); ?>">
                            <button type="button" class="quick_poll_answer_remove"><img src="<?php echo (POLL_MAKER_AYS_ADMIN_URL . '/images/remove-normal.png')?>" alt="remove" width="20px"></button>
                        </div>
                        <button type="button" class="quick_poll_add_option"><div><span>+</span></div><?php echo __('Add an Option', $this->plugin_name); ?></button>
                    </div>
                    <div class="quick_poll_divider"></div>
                    <!-- Settings -->
                    <div class="quick_poll_settings">
                        <h4><?php echo __('Settings', $this->plugin_name); ?></h4>
                        <div>
                            <span><?php echo __('Allow anonymity', $this->plugin_name); ?></span>
                            <input type="checkbox" id="allow_anonimity_switch" name="allow_anonimity_switch">
                            <label for="allow_anonimity_switch">Toggle</label>
                        </div>
                        <div>
                            <span><?php echo __('Allow multivote', $this->plugin_name); ?></span>
                            <input type="checkbox" id="allow_multivote_switch" name="allow_multivote_switch">
                            <label for="allow_multivote_switch">Toggle</label>
                        </div>
                    </div>
                    <!-- Save -->
                    <div class="quick_poll_save">
                        <input type="button" id="ays-save-quick-poll" value="<?php echo __('Save', $this->plugin_name); ?>">
                    </div>
                    <!-- Multivote Settings -->
                    <div class="quick_poll_multivote_settings">
                        <input type="number" id="quick-poll-multivote-min-count" name="quick-poll-multivote-min-count" placeholder="<?php echo __('Min', $this->plugin_name); ?>">
                        <input type="number" id="quick-poll-multivote-max-count" name="quick-poll-multivote-max-count" placeholder="<?php echo __('Max', $this->plugin_name); ?>">
                    </div>
                </form>
            </div> 
        </div>
    </div>
    <div id="poststuff">
        <div id="post-body" class="metabox-holder">
            <div id="post-body-content">
                <div class="meta-box-sortables ui-sortable">
                    <form method="post">
                        <?php
                            $this->polls_obj->prepare_items();
                            $search = __("Search" , $this->plugin_name);
                            $this->polls_obj->search_box($search, $this->plugin_name);
                            $this->polls_obj->display();
                        ?>
                    </form>
                </div>
            </div>
        </div>
        <br class="clear">
    </div>
    <?php if($poll_max_id <= 2): ?>
        <div class="ays-poll-create-poll-video-box" style="margin: 80px auto 30px;">
            <div class="ays-poll-create-poll-title">
                <h4><?php echo __( "Create Your First Poll in Under One Minute", $this->plugin_name ); ?></h4>
            </div>
            <div class="ays-poll-create-poll-youtube-video">
                <iframe width="560" height="315" class="ays-poll-youtube-video-responsive" src="https://www.youtube.com/embed/0dfJQdAwdL4" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
            </div>
            <div class="ays-poll-create-poll-youtube-video-button-box">
                <?php echo sprintf( '<a href="?page=%s&action=%s" class="ays-poll-add-new-button-video">' . __('Add New', $this->plugin_name) . '</a>', esc_attr( $_REQUEST['page'] ), 'add');?>
            </div>
        </div>
    <?php else: ?>
        <div class="ays-poll-create-poll-video-box" style="margin: auto;">
            <div class="ays-poll-create-poll-youtube-video">
                <a href="https://www.youtube.com/embed/0dfJQdAwdL4" target="_blank" title="YouTube video player" >How to create a Poll in Under One Minute</a>
            </div>
            <div class="ays-poll-create-poll-youtube-video-button-box">
                <?php echo sprintf( '<a href="?page=%s&action=%s" class="ays-poll-add-new-button-video">' . __('Add New', $this->plugin_name) . '</a>', esc_attr( $_REQUEST['page'] ), 'add');?>
            </div>
        </div>
    <?php endif ?>
</div>