<?php 

global $wpdb;
$request_id = isset($_GET['poll']) ? intval($_GET['poll']) : null;
if($request_id === null){
    wp_redirect( admin_url('admin.php') . '?page=' . $this->plugin_name . '-ays-requests' );
}

$requests_table = $wpdb->prefix . 'ayspoll_requests';
$sql = "SELECT * FROM {$requests_table} WHERE id ={$request_id};";
$request = $wpdb->get_row( $sql, 'ARRAY_A' );

$poll_title = (isset($request['title']) && $request['title'] != '') ? $request['title'] : '';
$question   = (isset($request['question']) && $request['question'] != '') ? $request['question'] : '';
$answers    = (isset($request['answers']) && ! empty($request['answers'])) ? json_decode( $request['answers'] , true) : array();
if(! is_array($answers)){
    $answers = array();
}

?>
<div class="wrap">
    <div class="ays-poll-heading-box">
        <div class="ays-poll-wordpress-user-manual-box">
            <a href="https://ays-pro.com/wordpress-poll-maker-user-manual" target="_blank"><?php echo __("View Documentation", $this->plugin_name); ?></a>
        </div>
    </div>
    <h1 class="wp-heading-inline">
        <?php __(esc_html(get_admin_page_title()), $this->plugin_name);?>
    </h1>
    <div class="nav-tab-wrapper">
        <a href="#tab1" class="nav-tab nav-tab-active"><?= __('Request', $this->plugin_name); ?></a>
    </div>
    <div id="tab1" class="ays-poll-tab-content ays-poll-tab-content-active">
        <p class="ays-subtitle">
            <?php echo __('Poll options', $this->plugin_name); ?>
        </p>
        <hr>
        <div class="form-group row">
            <div class="col-sm-3">
                <label>
                    <?php echo __('Title', $this->plugin_name); ?>
                    <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __("The name of the poll", $this->plugin_name); ?>">
                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                    </a>
                </label>
            </div>
            <div class="col-sm-9">
                <h5>
                    <?php echo stripslashes(htmlentities($poll_title)); ?>
                </h5>
            </div>
        </div>
        <hr>
        <div class="form-group row">
            <div class="col-sm-3">
                <label>
                    <?php echo __('Question', $this->plugin_name); ?>
                    <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __("The question of the poll.", $this->plugin_name); ?>">
                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                    </a>
                </label>
            </div>
            <div class="col-sm-9">
                <h5>
                    <?php echo stripslashes(htmlentities($question)); ?>
                </h5>
            </div>
        </div>
        <hr>
        <div class="form-group row">
            <div class="col-sm-3">
                <label for='ays-poll-answers'>
                    <?php echo __('Answers', $this->plugin_name); ?>
                    <a class="ays_help" data-toggle="tooltip" data-placement="top" title="<?php echo __("Answers from which the choice is made.", $this->plugin_name); ?>">
                        <i class="ays_poll_fas ays_poll_fa-info-circle"></i>
                    </a>
                </label>
            </div>
            <div class="col-sm-9">
                <?php 
                    $content = '';

                    $content .= '<ul style="list-style-type: disc; list-style-position: inside;">';
                    foreach ($answers as $key => $answer) {
                        $content .= '<li>'. stripslashes(htmlentities($answer)) .'</li>';
                    }
                    $content .= '</ul>';

                    echo $content;

                ?>
            </div>
        </div>
        <hr>
        
    </div>
</div>

