<?php
    $tab = isset($_GET['tab']) ? $_GET['tab'] : '1';
    $tab_url = "?page=".$this->plugin_name."-results&tab=";

    $this_poll_id = (isset($_GET['filter_answer'])) ? esc_attr($_GET['filter_answer']) : '';
    $result_obj = $this->results_obj;
    $poll_cats = $result_obj->get_categories();
    // $answer_actions = $this->answer_results_obj;
    $polls = $result_obj->get_polls();
    $last_id = 0;
    $content = '';
    $disable_chart_filter = '';
    $selected_poll_title = array();
    $latest_poll_id = 0;
    if((!empty($polls) && $this_poll_id != "0" && strpos($_SERVER['REQUEST_URI'], 'filter_answer=') == false) || !empty($polls) && $this_poll_id == "0"){
        $content = '<div><blockquote style="font-size: 17px;border-color:#f3ca03;">'.__("There are no selected polls." , $this->plugin_name).'</blockquote></div>';
    } else if(!empty($polls) && $this_poll_id != "0"){
        foreach($polls as $p_key => $p_value){
            $this_poll_id       = isset($p_value['id']) && $p_value['id'] != "" ? esc_attr($p_value['id']) : ""; 
            $this_poll_title    = isset($p_value['title']) && $p_value['title'] != "" ? esc_attr($p_value['title']) : "";
            $selected_poll_title[$this_poll_id] = $this_poll_title;
            $last_id = $p_key;
        }
        $last_id = isset($this_poll_id) && $this_poll_id != '' ? $this_poll_id : $polls[$last_id]['id'];    
        $latest_poll_id = isset($_REQUEST['filter_answer']) && $_REQUEST['filter_answer'] != '' ? intval($_REQUEST['filter_answer']) : intval($last_id);
        $poll_answers = $result_obj->get_poll_answers($latest_poll_id);

        $all_answer_data = array();
        $votes_all_sum = 0;
        foreach($poll_answers as $a_key => $a_answers){
            $votes_all_sum += isset($a_answers['votes']) && $a_answers['votes'] != '' ? intval($a_answers['votes']) : 0;
        }
        $votes_sum = 0;
        foreach($poll_answers as $key => $answers){
            $answer_percent = "0";
            $votes = isset($answers['votes']) && $answers['votes'] != '' ? intval($answers['votes']) : 0;
            $votes_sum += $votes;
            if($votes_all_sum > 0 && $votes > 0){
                $answer_percent =  ceil(($votes * 100) / $votes_all_sum);
            }
            $all_answer_data[0] = array("Total votes" , "Total votes (".$votes_sum.")");
            $ans = ( isset($answers['answer']) && $answers['answer'] != '') ? strip_tags( stripslashes( $answers['answer'] ) ) : '';
            $all_answer_data[$key+1] = array( $ans." ". '('.$answer_percent . "%".')', $votes); 
        }
        $poll_js_title = $latest_poll_id > 0 ? $selected_poll_title[$latest_poll_id] : 0;
        wp_localize_script($this->plugin_name."-admin-js", 'pollAnswerChartObj', array(
            'answerData' => $all_answer_data,
            'pollTitle'  => $poll_js_title
        ) );
        
    }
    
    // elseif(!empty($polls) && $this_poll_id == "0"){
    //     $content = '<div><blockquote style="font-size: 17px;border-color:#f3ca03;">'.__("There are no selected polls." , $this->plugin_name).'</blockquote></div>';        
    // }
    else{
        $content = '<div><blockquote style="font-size: 17px;border-color:red;">'.__("There are no polls yet." , $this->plugin_name).'</blockquote></div>';
        $disable_chart_filter = "disabled";
    }
?>

<div class="wrap">
    <div class="ays-poll-heading-box">
        <div class="ays-poll-wordpress-user-manual-box">
            <a href="https://ays-pro.com/wordpress-poll-maker-user-manual" target="_blank"><?php echo __("View Documentation", $this->plugin_name); ?></a>
        </div>
    </div>
    <h1 class="wp-heading-inline">
        <?php echo __(esc_html(get_admin_page_title()), $this->plugin_name); ?>
    </h1>
    <div class="poll-action-butons">
        <a href="javascript:void(0)" class="ays-poll-export-filters page-title-action" style="float: right;"><?php echo __('Export', $this->plugin_name); ?></a>
    </div>
    <div class="nav-tab-wrapper">
        <a href="#tab1" class="nav-tab <?php echo ($tab == '1') ? 'nav-tab-active' : ''; ?>"><?= __('Results', $this->plugin_name); ?></a>
        <a href="#tab2" class="nav-tab <?php echo ($tab == '2') ? 'nav-tab-active' : ''; ?> ays_poll_answer_chart_active"><?= __('Answer Chart', $this->plugin_name); ?></a>
        <a href="#tab3" class="nav-tab <?php echo ($tab == '3') ? 'nav-tab-active' : ''; ?>"><?= __('Statistics', $this->plugin_name); ?></a>
        <a href="#tab4" class="nav-tab <?php echo ($tab == '4') ? 'nav-tab-active' : ''; ?>"><?php echo __('Global Leaderboard',$this->plugin_name)?></a>
        <a href="<?php echo "?page=".$this->plugin_name."-all-results"; ?>" class="no-js nav-tab <?php echo ($tab == '5') ? 'nav-tab-active' : ''; ?>"><?php echo __('All Results',$this->plugin_name)?></a>
    </div>
    <div id="tab1" class="ays-poll-tab-content <?php echo ($tab == '1') ? 'ays-poll-tab-content-active' : ''; ?>">
        <div id="poststuff">
            <div id="post-body" class="metabox-holder">
                <div id="post-body-content">
                    <div class="meta-box-sortables ui-sortable">
                        <form method="post">
                            <?php
                                $this->results_obj->ays_category_filter_content();
                                $statistic_polls = $this->results_obj->get_most_least_polls();
                                $this->results_obj->prepare_items();
                                $this->results_obj->display();
                            ?>
                        </form>
                    </div>
                </div>
            </div>
            <br class="clear">
        </div>
    </div>

    <div id="tab2" class="ays-poll-tab-content <?php echo ($tab == "2")  ? "ays-poll-tab-content-active" : ""; ?>">
        <div style="padding:10px 0;">                                
            <form method="get">
                <div>
                    <input type="hidden" name="page" value="poll-maker-ays-results">
                    <select name="filter_answer" <?php echo $disable_chart_filter; ?>>
                        <option value="0" <?php if(strpos($_SERVER['REQUEST_URI'], 'filter_answer=') == false) {echo "selected";} ?>><?php echo __("Select Poll", $this->plugin_name)?></option>
                        <?php
                            $selected_poll = "";
                            $opt_cont = "";
                            $selected_poll_title = array();
                            usort($polls, function($a,$b) {return strcmp(strtolower($a['title']),strtolower($b['title']));});
                            foreach($polls as $obj_key => $obj_value){
                                $poll_id       = isset($obj_value['id']) && $obj_value['id'] != "" ? esc_attr($obj_value['id']) : ""; 
                                if(strpos($_SERVER['REQUEST_URI'], 'filter_answer=') == true) {
                                    $selected_poll = ($latest_poll_id == intval($obj_value['id'])) ? "selected" : "";   
                                }
                                $poll_title    = isset($obj_value['title']) && $obj_value['title'] != "" ? esc_attr($obj_value['title']) : "";
                                
                                $opt_cont     .= "<option value=".$poll_id." ".$selected_poll.">".$poll_title."</option>";
                            }
                            echo $opt_cont;                            
                        ?>
                    </select>
                    <input type="submit" value="Filter" class="button action" <?php echo $disable_chart_filter; ?>>                          
                    <input type="hidden" name="tab" value="2">
                </div>
                <div id="ays_poll_answer_chart" style = "width: 100%;margin-top:15px;">
                    <?php echo $content; ?>
                </div>
            </form>
        </div>
    </div><!-- Answer chart tab -->


    <div id="tab3" class="ays-poll-tab-content <?php echo ($tab == '3') ? 'ays-poll-tab-content-active' : ''; ?>" style="padding-top: 1.5rem">
        <div class="row">
            <div class="col-8">
                <h5><?php echo __("Statistics Diagram", $this->plugin_name); ?></h5>
            </div>
            <div class="col-4">
                <h5><?php echo __("Statistics Signboard", $this->plugin_name); ?></h5>
            </div>
        </div>
        <div class="row">
            <div class="col-8">
                <?php
                    $stat_filter_id = isset($_REQUEST['orderbypoll']) ? absint($_REQUEST['orderbypoll']) : 0;
                    $all_data = $this->results_obj->get_poll_data_all($stat_filter_id);
                    $poll_data = !empty($all_data) ? json_encode($all_data, true) : 0;
                    $poll_pie_data = $stat_filter_id > 0 ? json_encode($this->results_obj->get_poll_data_pie($stat_filter_id), true) : 0;
                ?>
                <div id="chartdiv"></div>
                <script>
                    //Poll Data from PHP
                    var pollData = <?=$poll_data;?>;
                    var pollCount = pollData ? pollData.length : 0;
                    var pieData = <?=$poll_pie_data;?>;
                </script>
            </div>
            <div class="col-4">
                <div class="row">
                    <div class="col-6">
                        <h6>
                            <?php echo __("Your MOST popular poll", $this->plugin_name); ?>:</h6>
                        <p class="text-success">
                            <?php
                                $stats_most_title = "";
                                if(!empty($statistic_polls)){
                                    if(isset($statistic_polls['most'])){
                                        $stats_most_title = isset($statistic_polls['most']['title']) ? $statistic_polls['most']['title'] : "";
                                    }
                                }
                                echo $stats_most_title;
                                
                            ?>
                        </p>
                    </div>
                    <div class="col-6">
                        <h6>
                            <?php echo __("Your LEAST popular poll", $this->plugin_name); ?>:</h6>
                        <p class="text-danger">
                            <?php
                                $stats_least_title = "";
                                if(!empty($statistic_polls)){
                                    if(isset($statistic_polls['least'])){
                                        $stats_least_title = isset($statistic_polls['least']['title']) ? $statistic_polls['least']['title'] : "";
                                    }
                                }
                                echo $stats_least_title;
                            ?>
                        </p>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col">
                        <ul class="list-group list-group-flush">
                            <?php
                                $intervals = [1, 7, 15, 30, 120];
                                foreach ($intervals as $days) {
                                    $completed = $this->results_obj->get_votes_count_by_time_interval($days, $stat_filter_id);?>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <?=__("Polls completed in the last $days day(s)", $this->plugin_name);?>:
                                        <span class="badge <?=$completed > 0 ? " badge-success" : "badge-danger" ;?>
                                            badge-pill">
                                            <?=$completed;?>
                                        </span>
                                    </li>
                            <?php }
                            ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Global leaderboards start / Xcho -->

    <div id="tab4" class="ays-poll-tab-content <?php echo ($tab == '4') ? 'ays-poll-tab-content-active' : ''; ?>">
        <p class="ays-subtitle"><?php echo __('Leaderboard',$this->plugin_name)?></p>
        <hr>
        <?php
            global $wpdb;
            $user_id = get_current_user_id();
            $sql = "SELECT user_id,
                        COUNT(user_id) AS user_count,
                        other_info
                    FROM {$wpdb->prefix}ayspoll_reports
                    WHERE user_id != 0
                    GROUP BY user_id
                    ORDER BY user_count DESC
                    LIMIT 10";
            $result = $wpdb->get_results($sql, 'ARRAY_A');
            $user = false;
            $c = 1;
            $content = "<div class='ays_lb_container'>
            <ul class='ays_lb_ul' style='width: 100%;'>
                <li class='ays_lb_li'>
                    <div class='ays_lb_pos'>Pos.</div>
                    <div class='ays_lb_user'>".__("Name", $this->plugin_name)."</div>
                    <div class='ays_lb_score'>".__("Attempts", $this->plugin_name)."</div>
                </li>";
            foreach ($result as $val) {
                $user_id = intval($val['user_id']);
                $attempts = (isset($val['user_count']) && $val['user_count'] != '') ? round(floatval($val['user_count']), 2) : '0';
                $options = (isset($val['other_info']) && $val['other_info'] != '') ? json_decode($val['other_info'],true) : array();

                if ($user_id == 0) {
                    $user_name = (isset($options['Name']) && $options['Name'] != '') ? $options['Name'] : __('Guest', $this->plugin_name);
                }else{
                    $user_name = (isset($options['Name']) && $options['Name'] != '') ? $options['Name'] : '';
                    if($user_name == ''){
                        $user = get_user_by('id', $user_id);
                        $user_name = $user->data->display_name ? $user->data->display_name : $user->user_login;
                    }
                }
                if (isset($user) && $user !== false) {
                    $user_name = $user->data->display_name ? $user->data->display_name : $user->user_login;

                    $content .= "<li class='ays_lb_li'>
                                    <div class='ays_lb_pos'>".$c.".</div>
                                    <div class='ays_lb_user'>".$user_name."</div>
                                    <div class='ays_lb_score'>".$attempts."</div>
                                </li>";
                    $c++;
                }
            }
            $content .= "</ul>
            </div>";
            echo $content;
        ?>
    </div>

    <!-- Global leaderboards end / Xcho  -->

    <div class="ays-modal" id="poll_export_filters">
        <div class="ays-modal-content">
            <div class="ays-poll-preloader">
                <img class="loader" src="<?php echo POLL_MAKER_AYS_ADMIN_URL; ?>/images/loaders/tail-spin.svg">
            </div>
          <!-- Modal Header -->
            <div class="ays-modal-header">
                <span class="ays-close">&times;</span>
                <h2><?=__('Export Filter', $this->plugin_name)?></h2>
            </div>

          <!-- Modal body -->
            <div class="ays-modal-body">  
                <form method="post" id="ays_poll_export_answers_filter">              
                    <div class="filter-col">
                        <label for="poll_id-filter"><?php echo __("Polls", $this->plugin_name); ?></label>
                        <button type="button" class="ays_pollid_clear button button-small wp-picker-default"><?php echo __("Clear", $this->plugin_name); ?></button>
                        <select name="poll_id-select[]" id="poll_id-filter" multiple="multiple"></select>
                    </div>
                </form>
            </div>

          <!-- Modal footer -->
            <div class="ays-modal-footer">
                <div class="export_results_count">
                    <p>Matched <span></span> results</p>
                </div>
                <span><?php echo __('Export to', $this->plugin_name); ?></span>
                
                <?php
                    echo sprintf('<a href="javascript:void(0);" class="button button-primary page-title-action poll_results_export-action">' . __('CSV', $this->plugin_name) . '</a>', esc_attr($_REQUEST['page']), 'add');
                ?>
                <?php
                    echo sprintf('<a href="javascript:void(0);" class="button button-primary page-title-action poll_results_export-action-xlsx">' . __('XLSX', $this->plugin_name) . '</a>', esc_attr($_REQUEST['page']), 'add');
                ?>
                <a href="<?php echo plugins_url() . '/poll-maker/admin/partials/results/export_file/poll_results_export.csv';?>" download id="download" hidden></a>
                <a href="<?php echo plugins_url() . '/poll-maker/admin/partials/results/export_file/poll_results_export.xlsx';?>" download id="download" hidden></a>
            </div>

        </div>
    </div>
</div>

