<?php
class Poll_Maker_Settings_Actions {
    private $plugin_name;

    public function __construct($plugin_name) {
        $this->plugin_name = $plugin_name;
        // $this->check_setting_user_roles();
        // $this->check_setting_mailchimp();
        // $this->check_setting_monitor();
        // $this->check_setting_zapier();
        // $this->check_setting_active_camp();
        // $this->check_setting_slack();

    }

    public function store_data($data){
        global $wpdb;
        $settings_table = $wpdb->prefix . "ayspoll_settings";
        if( isset($data["settings_action"]) && wp_verify_nonce( $data["settings_action"], 'settings_action' ) ){
            $success = 0;
            $roles = (isset($data['ays_user_roles']) && !empty($data['ays_user_roles'])) ? array_map( 'sanitize_text_field', $data['ays_user_roles'] ) : array('administrator');
            $mailchimp_username = isset($data['ays_mailchimp_username']) ? stripslashes(sanitize_text_field( $data['ays_mailchimp_username'] )) : '';
            $mailchimp_api_key = isset($data['ays_mailchimp_api_key']) ? stripslashes(sanitize_text_field( $data['ays_mailchimp_api_key'] )) : '';
            $mailchimp = array(
                'username' => $mailchimp_username,
                'apiKey' => $mailchimp_api_key
            );

            $monitor_client  = isset($data['ays_monitor_client']) ? $data['ays_monitor_client'] : '';
            $monitor_api_key = isset($data['ays_monitor_api_key']) ? $data['ays_monitor_api_key'] : '';
            $monitor         = array(
                'client' => $monitor_client,
                'apiKey' => $monitor_api_key
            );

            $slack_client = isset($data['ays_slack_client']) ? $data['ays_slack_client'] : '';
            $slack_secret = isset($data['ays_slack_secret']) ? $data['ays_slack_secret'] : '';
            $slack_token  = !empty($data['ays_slack_token']) ? $data['ays_slack_token'] : '';
            $slack        = array(
                'client' => $slack_client,
                'secret' => $slack_secret,
                'token'  => $slack_token,
            );

            $active_camp_url     = isset($data['ays_active_camp_url']) ? $data['ays_active_camp_url'] : '';
            $active_camp_api_key = isset($data['ays_active_camp_api_key']) ? $data['ays_active_camp_api_key'] : '';
            $active_camp         = array(
                'url'    => $active_camp_url,
                'apiKey' => $active_camp_api_key
            );

            $zapier_hook = isset($data['ays_zapier_hook']) ? $data['ays_zapier_hook'] : '';
            $zapier      = array(
                'hook' => $zapier_hook
            );

            $ays_gleadboard_count      = isset($data['ays_gleadboard_count']) ? $data['ays_gleadboard_count'] : '5';
            $ays_gleadboard_width      = isset($data['ays_gleadboard_width']) ? $data['ays_gleadboard_width'] : '0';
            $ays_gleadboard_orderby    = isset($data['ays_gleadboard_orderby']) ? $data['ays_gleadboard_orderby'] : 'id';
            $ays_gleadboard_sort       = isset($data['ays_gleadboard_sort']) ? $data['ays_gleadboard_sort'] : 'avg';
            $ays_gleadboard_color      = isset($data['ays_gleadboard_color']) ? $data['ays_gleadboard_color'] : '#99BB5A';
            $ays_gleadboard_custom_css = isset($data['ays_gleadboard_custom_css']) ? stripslashes($data['ays_gleadboard_custom_css']) : '';

            $leaderboard = array(
                'global' => array(
                    'count'   => $ays_gleadboard_count,
                    'width'   => $ays_gleadboard_width,
                    'orderby' => $ays_gleadboard_orderby,
                    'sort'    => $ays_gleadboard_sort,
                    'color'   => $ays_gleadboard_color,
                    'gleadboard_custom_css' => $ays_gleadboard_custom_css,
                )
            );

            $show_result_view = isset($data['ays_poll_show_result_view_general']) ? $data['ays_poll_show_result_view_general'] : 'standart';

            $answer_default_count = isset($data['ays_answer_default_count']) && !empty($data['ays_answer_default_count']) ? $data['ays_answer_default_count'] : 2;

            $disable_ip_storing = isset($data['ays_disable_ip_storing']) && $data['ays_disable_ip_storing'] == 'on' ? $data['ays_disable_ip_storing'] : 'off';

            $show_cat_title = isset($data['ays_poll_show_cat_title']) && $data['ays_poll_show_cat_title'] == 'on' ? $data['ays_poll_show_cat_title'] : 'off';

            $answers_sound = isset($data['ays_poll_answers_sound']) ? $data['ays_poll_answers_sound'] : '';

            // Poll title length
            $poll_title_length = (isset($data['ays_poll_title_length']) && intval($data['ays_poll_title_length']) != 0) ? absint(intval($data['ays_poll_title_length'])) : 5;
            
            // Poll Category Title length
            $poll_category_title_length = (isset($data['ays_poll_category_title_length']) && intval($data['ays_poll_category_title_length']) != 0) ? absint(intval($data['ays_poll_category_title_length'])) : 5;

            // Poll Results Title length
            $poll_results_title_length = (isset($data['ays_poll_results_title_length']) && intval($data['ays_poll_results_title_length']) != 0) ? absint(intval($data['ays_poll_results_title_length'])) : 5;

            // Poll auto approve user request
            $enable_auto_approve = isset($data['ays_poll_auto_approve'])  && $data['ays_poll_auto_approve'] == 'on' ? $data['ays_poll_auto_approve'] : 'off';

            // Poll expired and unpublished message
            $all_shortcode_message = isset($data['ays_poll_all_polls_shortcodes']) && $data['ays_poll_all_polls_shortcodes'] != '' ? sanitize_text_field($data['ays_poll_all_polls_shortcodes']) : '';

            //email to admins
            $enable_email_to_admins = isset($data['ays_poll_email_to_admins'])  && $data['ays_poll_email_to_admins'] == 'on' ? $data['ays_poll_email_to_admins'] : 'off';
            $email_to_admins_session = isset($data['ays_poll_admin_email_session'])  && $data['ays_poll_admin_email_session'] != '' ? $data['ays_poll_admin_email_session'] : '';
            $admins_emails = isset($data['ays_poll_admins_emails']) && $data['ays_poll_admins_emails'] != '' ? sanitize_text_field(implode(',',$data['ays_poll_admins_emails'])) : '';

            // ==== Added new =====
            // Default Category for poll
            $ays_default_cat  = (isset($data['ays_poll_default_cat']) && !empty($data['ays_poll_default_cat'])) ? sanitize_text_field(implode("," , $data['ays_poll_default_cat'])) : "1";
            // Default Type for poll
            $ays_default_type = (isset($data['ays_poll_default_type']) && $data['ays_poll_default_type'] != "") ? sanitize_text_field($data['ays_poll_default_type']) : "choosing";

            // == Ani ==
            //Ays Poll Global Category Leaderboard
            $ays_poll_cat_gleadboard_count = (isset($data['ays_poll_cat_gleadboard_count']) && $data['ays_poll_cat_gleadboard_count'] != '') ? sanitize_text_field($data['ays_poll_cat_gleadboard_count']) : '5';
            $ays_poll_cat_gleadboard_width = (isset($data['ays_poll_cat_gleadboard_width']) && $data['ays_poll_cat_gleadboard_width'] != '') ? sanitize_text_field($data['ays_poll_cat_gleadboard_width']) : '0';
            $ays_poll_cat_gleadboard_orderby = (isset($data['ays_poll_cat_gleadboard_orderby']) && $data['ays_poll_cat_gleadboard_orderby'] != '') ? sanitize_text_field($data['ays_poll_cat_gleadboard_orderby']) : 'id';
            $ays_poll_cat_gleadboard_color = (isset($data['ays_poll_cat_gleadboard_color']) && $data['ays_poll_cat_gleadboard_color'] != '') ? sanitize_text_field($data['ays_poll_cat_gleadboard_color']) : '#99BB5A';
            $ays_poll_cat_gleadboard_custom_css = (isset($data['ays_poll_cat_gleadboard_custom_css']) && $data['ays_poll_cat_gleadboard_custom_css'] != '') ? stripslashes($data['ays_poll_cat_gleadboard_custom_css']) : '';

            $category_leaderboard = array(
                'cat_global' => array(
                    'cat_count'   => $ays_poll_cat_gleadboard_count,
                    'cat_width'   => $ays_poll_cat_gleadboard_width,
                    'cat_orderby' => $ays_poll_cat_gleadboard_orderby,
                    'cat_color'   => $ays_poll_cat_gleadboard_color,
                    'cat_gleadboard_custom_css' => $ays_poll_cat_gleadboard_custom_css,
                )
            );

            // User page columns
            $ays_poll_user_page_columns = (isset( $data['ays_poll_user_history_columns'] ) && !empty($data['ays_poll_user_history_columns'])) ? $data['ays_poll_user_history_columns'] : array();
            $ays_poll_user_page_columns_order = (isset( $data['ays_poll_user_history_columns_order'] ) && !empty($data['ays_poll_user_history_columns_order'])) ? $data['ays_poll_user_history_columns_order'] : array();
            // ==
            
            // ==== ====
            
            // Inherit From default poll
            $ays_poll_results_inherit = (isset( $data['ays_poll_shortcodes_by_id_inherit'] ) && $data['ays_poll_shortcodes_by_id_inherit'] == "on") ? "on" : "off";
            
            // Default cats for request form
            $ays_poll_request_default_cat  = (isset($data['ays_poll_default_cat_for_request']) && !empty($data['ays_poll_default_cat_for_request'])) ? sanitize_text_field(implode("," , $data['ays_poll_default_cat_for_request'])) : "1";

            // Fields placeholders
            $poll_fields_placeholder_name  = (isset($data['ays_poll_fields_placeholder_name']) && $data['ays_poll_fields_placeholder_name'] != '') ? sanitize_text_field( $data['ays_poll_fields_placeholder_name'] ) : 'Name' ;

            $poll_fields_placeholder_email = (isset($data['ays_poll_fields_placeholder_email']) && $data['ays_poll_fields_placeholder_email'] != '') ?  sanitize_text_field( $data['ays_poll_fields_placeholder_email'] )  : 'E-mail' ;

            $poll_fields_placeholder_phone = (isset($data['ays_poll_fields_placeholder_phone']) && $data['ays_poll_fields_placeholder_phone'] != '') ? stripslashes(sanitize_text_field( $data['ays_poll_fields_placeholder_phone'] )) : 'Phone' ;

            $poll_fields_label_name  = (isset($data['ays_poll_fields_label_name']) && $data['ays_poll_fields_label_name'] != '') ? stripslashes(sanitize_text_field( $data['ays_poll_fields_label_name'] )) : 'Name' ;    

            $poll_fields_label_email = (isset($data['ays_poll_fields_label_email']) && $data['ays_poll_fields_label_email'] != '') ? stripslashes(sanitize_text_field( $data['ays_poll_fields_label_email'] )) : 'E-mail' ;

            $poll_fields_label_phone = (isset($data['ays_poll_fields_label_phone']) && $data['ays_poll_fields_label_phone'] != '') ? stripslashes(sanitize_text_field( $data['ays_poll_fields_label_phone'] )) : 'Phone' ;

            $fields_placeholders = array(
                'poll_fields_placeholder_name'   => $poll_fields_placeholder_name,
                'poll_fields_placeholder_email'  => $poll_fields_placeholder_email,
                'poll_fields_placeholder_phone'  => $poll_fields_placeholder_phone,

                'poll_fields_label_name'   => $poll_fields_label_name,
                'poll_fields_label_email'  => $poll_fields_label_email,
                'poll_fields_label_phone'  => $poll_fields_label_phone,
            );

            // Animation Top
            $poll_animation_top = (isset($data['ays_poll_animation_top']) && $data['ays_poll_animation_top'] != '') ? absint(intval($data['ays_poll_animation_top'])) : 100;
            $poll_enable_animation_top = (isset( $data['ays_poll_enable_animation_top'] ) && $data['ays_poll_enable_animation_top'] == 'on') ? 'on' : 'off';
            
            // General CSS File
            $poll_exclude_general_css = (isset( $data['ays_poll_exclude_general_css'] ) && sanitize_text_field( $data['ays_poll_exclude_general_css'] ) == 'on') ? 'on' : 'off';

            // WP Editor height
            $poll_wp_editor_height = (isset($data['ays_poll_wp_editor_height']) && $data['ays_poll_wp_editor_height'] != '' && $data['ays_poll_wp_editor_height'] != 0) ? absint( sanitize_text_field($data['ays_poll_wp_editor_height']) ) : 100 ;

            // All results column
            $poll_all_results_columns = (isset($data['ays_poll_all_results_columns']) && !empty($data['ays_poll_all_results_columns'])) ? $data['ays_poll_all_results_columns'] : array();
            $poll_all_results_columns_order = (isset($data['ays_poll_all_results_columns_order']) && !empty($data['ays_poll_all_results_columns_order'])) ? $data['ays_poll_all_results_columns_order'] : array();

            // Show publicly ( All Results )
            $poll_all_results_show_publicly = (isset( $data['ays_poll_all_results_show_publicly'] ) && $data['ays_poll_all_results_show_publicly'] == 'on') ? 'on' : 'off';

            $options = array(
                "show_result_view"      => $show_result_view,
                "disable_ip_storing"    => $disable_ip_storing,
                "answers_sound"         => $answers_sound,
                "answer_default_count"  => $answer_default_count,
                "show_cat_title"        => $show_cat_title,
                "poll_title_length"     => $poll_title_length,
                "poll_category_title_length" => $poll_category_title_length,
                "poll_results_title_length"  => $poll_results_title_length,
                "enable_auto_approve"   => $enable_auto_approve,
                "all_shortcode_message" => $all_shortcode_message,

                "poll_animation_top"        => $poll_animation_top,
                "poll_enable_animation_top" => $poll_enable_animation_top,
                "poll_exclude_general_css"  => $poll_exclude_general_css,
                
                "enable_email_to_admins"  => $enable_email_to_admins,
                "email_to_admins_session" => $email_to_admins_session,
                "admins_emails"           => $admins_emails,
                "default_category"        => $ays_default_cat,
                "default_type"            => $ays_default_type,
                "poll_wp_editor_height"   => $poll_wp_editor_height,

                "ays_poll_user_page_columns"       => $ays_poll_user_page_columns,
                "ays_poll_user_page_columns_order" => $ays_poll_user_page_columns_order,

                "ays_poll_results_inherit" => $ays_poll_results_inherit,
                "ays_poll_request_cats" => $ays_poll_request_default_cat,

                "poll_all_results_columns"           => $poll_all_results_columns,
                "poll_all_results_columns_order"     => $poll_all_results_columns_order,
                "poll_all_results_show_publicly"     => $poll_all_results_show_publicly,
            );

            $del_stat = "";
            $month_count = isset($data['ays_delete_results_by']) ? intval($data['ays_delete_results_by']) : null;
            if($month_count !== null && $month_count > 0){
                $year = intval( date( 'Y', current_time('timestamp') ) );
                $dt = intval( date( 'n', current_time('timestamp') ) );
                $month = $dt - $month_count;
                if($month < 0){
                    $month = 12 - $month;
                    if($month > 12){
                        $mn = $month % 12;
                        $mnac = ($month - $mn) / 12;
                        $month = 12 - ($mn);
                        $year -= $mnac;
                    }
                }elseif($month == 0){
                    $month = 12;
                    $year--;
                }                
                $sql = "DELETE FROM " . $wpdb->prefix . "ayspoll_reports 
                        WHERE YEAR(vote_date) = '".$year."' 
                          AND MONTH(vote_date) <= '".$month."'";
                $res = $wpdb->query($sql);
                if($res >= 0){
                    $del_stat = "&del_stat=ok&mcount=".$data['ays_delete_results_by'];
                }
            }

            // Google sheets to DB
            $google_client = isset($data['ays_poll_google_client']) ? $data['ays_poll_google_client'] : '';
            $google_secret = isset($data['ays_poll_google_secret']) ? $data['ays_poll_google_secret'] : '';
            $google_token  = isset($data['ays_poll_get_token']) && $data['ays_poll_get_token'] != '' ? $data['ays_poll_get_token'] : '';
            $check_google_token = isset($google_token) && !empty($google_token) ? true : false;

            $google_refresh_token  = isset($data['ays_poll_get_refresh_token']) && $data['ays_poll_get_refresh_token'] != '' ? $data['ays_poll_get_refresh_token'] : '';
            $google_sheets = array(
                'client'         => $google_client,
                'secret'         => $google_secret,
                'token'          => $google_token,
                'refresh_token'  => $google_refresh_token
            );

            // Mad mimi
            $mad_mimi_user_name = isset($data['ays_poll_mad_mimi_user_name']) && $data['ays_poll_mad_mimi_user_name'] != "" ? sanitize_text_field($data['ays_poll_mad_mimi_user_name']) : '';
            $mad_mimi_api_key   = isset($data['ays_poll_mad_mimi_api_key']) && $data['ays_poll_mad_mimi_api_key'] != "" ? sanitize_text_field($data['ays_poll_mad_mimi_api_key']) : '';

            $mad_mimi_options   = array(
                "user_name" => $mad_mimi_user_name,
                "api_key"   => $mad_mimi_api_key
            );
            
            // Get Response
            $getResponse_api_key = isset($data['ays_poll_getresponse_api_key']) && $data['ays_poll_getresponse_api_key'] != "" ? sanitize_text_field($data['ays_poll_getresponse_api_key']) : '';
            $getResponse_options = array(
                "api_key" => $getResponse_api_key
            );
            //

            // ConvertKit
            $convertKit_account_id = isset($data['ays_poll_convert_kit']) && $data['ays_poll_convert_kit'] != "" ? sanitize_text_field($data['ays_poll_convert_kit']) : '';
            $convertKit_options = array(
                "api_key" => $convertKit_account_id,
            );

            


            $sendgrid_api_key = isset($data['ays_sendgrid_api_key']) ? $data['ays_sendgrid_api_key'] : '';
            $sendgrid = array(                
                'apiKey' => $sendgrid_api_key
            );

            $result = $this->ays_update_setting('user_roles', json_encode($roles));
            if($result){
                $success++;
            }
            $result = $this->ays_update_setting('mailchimp', json_encode($mailchimp));
            if($result){
                $success++;
            }
            $result = $this->ays_update_setting('monitor', json_encode($monitor));
            if ($result) {
                $success++;
            }
            $result = $this->ays_update_setting('slack', json_encode($slack));
            if ($result) {
                $success++;
            }
            $result = $this->ays_update_setting('active_camp', json_encode($active_camp));
            if ($result) {
                $success++;
            }
            $result = $this->ays_update_setting('zapier', json_encode($zapier));
            if ($result) {
                $success++;
            }
            $result = $this->ays_update_setting('leaderboard', json_encode($leaderboard));
            if ($result) {
                $success++;
            }
            $result = $this->ays_update_setting('options', json_encode($options));
            if ($result) {
                $success++;
            }
            if ($check_google_token) {
                $result = $this->ays_update_setting('google_sheet', json_encode($google_sheets));
                if ($result) {
                    $success++;
                }
            }
            $result = $this->ays_update_setting('sendgrid', json_encode($sendgrid));
            if ($result) {
                $success++;
            }
            $result = $this->ays_update_setting('mad_mimi', json_encode($mad_mimi_options));
            if ($result) {
                $success++;
            }
            $result = $this->ays_update_setting('get_response', json_encode($getResponse_options));
            if ($result) {
                $success++;
            }
            $result = $this->ays_update_setting('convertKit', json_encode($convertKit_options));
            if ($result) {
                $success++;
            }
            $result = $this->ays_update_setting('category_leaderboard', json_encode($category_leaderboard));
            if ($result) {
                $success++;
            }
            $result = $this->ays_update_setting('fields_placeholders', json_encode($fields_placeholders,  JSON_UNESCAPED_SLASHES));
            if ($result) {
                $success++;
            }

            $message = "saved";
            if($success > 0){
                $url = admin_url('admin.php') . "?page={$this->plugin_name}-settings" . '&status=' . $message;
                $tab = "";
                if(isset($data['ays_poll_tab'])){
                    $tab = "&ays_poll_tab=".$data['ays_poll_tab'];
                }
                $url = admin_url('admin.php') . "?page=poll-maker-ays-settings" . $tab . '&status=' . $message.$del_stat;
                wp_redirect( $url );
            }
        }
        
    }

    public function get_db_data(){
        global $wpdb;
        $settings_table = $wpdb->prefix . "ayspoll_settings";
        $sql = "SELECT * FROM ".$settings_table;
        $results = $wpdb->get_results($sql, ARRAY_A);
        if(count($results) > 0){
            return $results;
        }else{
            return array();
        }
    }
    
    public function check_setting_monitor() {
        global $wpdb;
        $settings_table = $wpdb->prefix . "ayspoll_settings";
        $sql            = "SELECT COUNT(*) FROM " . $settings_table . " WHERE meta_key = 'monitor'";
        $result         = $wpdb->get_var($sql);
        if (intval($result) == 0) {
            $this->ays_add_setting("monitor", "", "", "");
        }

        return false;
    }

    public function check_setting_slack() {
        global $wpdb;
        $settings_table = $wpdb->prefix . "ayspoll_settings";
        $sql            = "SELECT COUNT(*) FROM " . $settings_table . " WHERE meta_key = 'slack'";
        $result         = $wpdb->get_var($sql);
        if (intval($result) == 0) {
            $this->ays_add_setting("slack", "", "", "");
        }

        return false;
    }

    public function check_setting_active_camp() {
        global $wpdb;
        $settings_table = $wpdb->prefix . "ayspoll_settings";
        $sql            = "SELECT COUNT(*) FROM " . $settings_table . " WHERE meta_key = 'active_camp'";
        $result         = $wpdb->get_var($sql);
        if (intval($result) == 0) {
            $this->ays_add_setting("active_camp", "", "", "");
        }

        return false;
    }

    public function check_setting_zapier() {
        global $wpdb;
        $settings_table = $wpdb->prefix . "ayspoll_settings";
        $sql            = "SELECT COUNT(*) FROM " . $settings_table . " WHERE meta_key = 'zapier'";
        $result         = $wpdb->get_var($sql);
        if (intval($result) == 0) {
            $this->ays_add_setting("zapier", "", "", "");
        }

        return false;
    }


    public function check_setting_user_roles(){
        global $wpdb;
        $settings_table = $wpdb->prefix . "ayspoll_settings";
        $sql = "SELECT COUNT(*) FROM ".$settings_table." WHERE meta_key = 'user_roles'";
        $result = $wpdb->get_var($sql);
        if(intval($result) == 0){
            $roles = json_encode(array('administrator'));
            $this->ays_add_setting("user_roles", $roles, "", "");
        }
        return false;
    }
    public function check_setting_mailchimp(){
        global $wpdb;
        $settings_table = $wpdb->prefix . "ayspoll_settings";
        $sql = "SELECT COUNT(*) FROM ".$settings_table." WHERE meta_key = 'mailchimp'";
        $result = $wpdb->get_var($sql);
        if(intval($result) == 0){
            $this->ays_add_setting("mailchimp", "", "", "");
        }
        return false;
    }

    public function check_setting_sendgrid(){
        global $wpdb;
        $settings_table = $wpdb->prefix . "ayspoll_settings";
        $sql = "SELECT COUNT(*) FROM ".$settings_table." WHERE meta_key = 'sendgrid'";
        $result = $wpdb->get_var($sql);
        if(intval($result) == 0){
            $this->ays_add_setting("sendgrid", "", "", "");
        }
        return false;
    }
    
    public static function ays_get_setting($meta_key){
        global $wpdb;
        $settings_table = $wpdb->prefix . "ayspoll_settings";
        $sql = "SELECT meta_value FROM ".$settings_table." WHERE meta_key = '".$meta_key."'";
        $result = $wpdb->get_var($sql);
        if($result != ""){
            return $result;
        }
        return false;
    }
    
    public function ays_add_setting($meta_key, $meta_value, $note = "", $options = ""){
        global $wpdb;
        $settings_table = $wpdb->prefix . "ayspoll_settings";
        $result = $wpdb->insert(
            $settings_table,
            array(
                'meta_key'    => $meta_key,
                'meta_value'  => $meta_value,
                'note'        => $note,
                'options'     => $options
            ),
            array( '%s', '%s', '%s', '%s' )
        );
        if($result >= 0){
            return true;
        }
        return false;
    }
    
    public function ays_update_setting($meta_key, $meta_value, $note = null, $options = null){
        global $wpdb;
        $settings_table = $wpdb->prefix . "ayspoll_settings";
        $value = array(
            'meta_value'  => $meta_value,
        );
        $value_s = array( '%s' );
        if($note != null){
            $value['note'] = $note;
            $value_s[] = '%s';
        }
        if($options != null){
            $value['options'] = $options;
            $value_s[] = '%s';
        }
        $result = $wpdb->update(
            $settings_table,
            $value,
            array( 'meta_key' => $meta_key, ),
            $value_s,
            array( '%s' )
        );
        if($result >= 0){
            return true;
        }
        return false;
    }
    
    public function ays_delete_setting($meta_key){
        global $wpdb;
        $settings_table = $wpdb->prefix . "ayspoll_settings";
        $wpdb->delete(
            $settings_table,
            array( 'meta_key' => $meta_key ),
            array( '%s' )
        );
    }
    

    public function poll_settings_notices($status){

        if ( empty( $status ) )
            return;

        if ( 'saved' == $status )
            $updated_message = esc_html( __( 'Changes saved.', $this->plugin_name ) );
        elseif ( 'updated' == $status )
            $updated_message = esc_html( __( 'Poll attribute .', $this->plugin_name ) );
        elseif ( 'deleted' == $status )
            $updated_message = esc_html( __( 'Poll attribute deleted.', $this->plugin_name ) );

        if ( empty( $updated_message ) )
            return;

        ?>
        <div class="notice notice-success is-dismissible">
            <p> <?php echo $updated_message; ?> </p>
        </div>
        <?php
    }
    
}