<?php
global $ays_poll_db_version;
$ays_poll_db_version = '7.8.0';
/**
 * Fired during plugin activation
 *
 * @link       https://ays-pro.com/
 * @since      1.0.0
 *
 * @package    Poll_Maker_Ays
 * @subpackage Poll_Maker_Ays/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.0
 * @package    Poll_Maker_Ays
 * @subpackage Poll_Maker_Ays/includes
 * @author     Poll Maker Team <info@ays-pro.com>
 */
class Poll_Maker_Ays_Activator {

    /**
     * Short Description. (use period)
     *
     * Long Description.
     *
     * @since    1.0.0
     */
    public static function activate() {
        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        global $wpdb;
        $polls_table      = $wpdb->prefix . 'ayspoll_polls';
        $cats_table       = $wpdb->prefix . 'ayspoll_categories';
        $answers_table    = $wpdb->prefix . 'ayspoll_answers';
        $reports_table    = $wpdb->prefix . 'ayspoll_reports';
        $formfields_table = $wpdb->prefix . 'ayspoll_formfields';
        $settings_table   = $wpdb->prefix . 'ayspoll_settings';
        $requests_table   = $wpdb->prefix . 'ayspoll_requests';
        $popup_poll_table = $wpdb->prefix . 'ayspoll_popup_poll';
        $charset_collate  = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE `".$polls_table."` (
            id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
            author_id INT(16) UNSIGNED NOT NULL DEFAULT '0',
            post_id INT(16) UNSIGNED DEFAULT NULL,
            title VARCHAR(255) NOT NULL,
            description TEXT NOT NULL,
            question TEXT NOT NULL,
            type VARCHAR(64) NOT NULL,
            view_type VARCHAR(64) NOT NULL,
            categories VARCHAR(255) NOT NULL,
            image TEXT DEFAULT '',
            show_title INT(1) DEFAULT 1,
            styles TEXT DEFAULT '',
            custom_css TEXT DEFAULT '',
            theme_id INT(5) DEFAULT 1,
            answer_message TEXT DEFAULT '',
            PRIMARY KEY (id)
        )$charset_collate;";

        $sql_schema = "SELECT * FROM INFORMATION_SCHEMA.TABLES
                       WHERE table_schema = '".DB_NAME."' AND table_name = '".$polls_table."' ";
        $results = $wpdb->get_results($sql_schema);

        if(empty($results)){
            $wpdb->query( $sql );
        }else{
            dbDelta( $sql );
        }

        $sql = "CREATE TABLE `".$cats_table."` (
            id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
            title VARCHAR(255) NOT NULL,
            description TEXT NOT NULL,
            options TEXT DEFAULT '',
            PRIMARY KEY (id)
        )$charset_collate;";

        $sql_schema = "SELECT * FROM INFORMATION_SCHEMA.TABLES
                       WHERE table_schema = '".DB_NAME."' AND table_name = '".$cats_table."' ";
        $results = $wpdb->get_results($sql_schema);

        if(empty($results)){
            $wpdb->query( $sql );
        }else{
            dbDelta( $sql );
        }

        $sql = "CREATE TABLE `".$answers_table."` (
            id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
            poll_id INT(11) UNSIGNED NOT NULL,
            answer TEXT NOT NULL,
            votes INT(11) NOT NULL,
            answer_img TEXT DEFAULT '',
            ordering INT(11) NOT NULL DEFAULT 1,
            redirect TEXT DEFAULT '', 
            user_added INT(1) DEFAULT 0,
            show_user_added INT(1) DEFAULT 1,
            fake_votes INT(11) NOT NULL,
            PRIMARY KEY (id)
        )$charset_collate;";

        $sql_schema = "SELECT * FROM INFORMATION_SCHEMA.TABLES
                       WHERE table_schema = '".DB_NAME."' AND table_name = '".$answers_table."' ";
        $results = $wpdb->get_results($sql_schema);

        if(empty($results)){
            $wpdb->query( $sql );
        }else{
            dbDelta( $sql );
        }

        $sql = "CREATE TABLE `".$reports_table."` (
            id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
            answer_id INT(11) UNSIGNED NOT NULL,
            user_ip VARCHAR(255) NOT NULL,
            user_id INT(11) DEFAULT 0,
            vote_date DATETIME NOT NULL,
            user_email VARCHAR(255) NOT NULL,
            other_info TEXT DEFAULT '',
            unread  INT(1) DEFAULT 1,
            multi_answer_id  TEXT DEFAULT '',
            poll_id INT(11) UNSIGNED NOT NULL,
            country TEXT NOT NULL DEFAULT '',
            answer_value TEXT DEFAULT '',
            PRIMARY KEY (id)
        )$charset_collate;";

        $sql_schema = "SELECT * FROM INFORMATION_SCHEMA.TABLES
                       WHERE table_schema = '".DB_NAME."' AND table_name = '".$reports_table."' ";
        $results = $wpdb->get_results($sql_schema);

        if(empty($results)){
            $wpdb->query( $sql );
        }else{
            dbDelta( $sql );
        }

        $sql = "CREATE TABLE `".$formfields_table."` (
            id INT(16) UNSIGNED NOT NULL AUTO_INCREMENT,
            name VARCHAR(255) NOT NULL,
            type VARCHAR(255) NOT NULL,
            slug VARCHAR(255) NOT NULL,
            sendgrid TEXT DEFAULT '',
            published TINYINT UNSIGNED NOT NULL,
            options TEXT DEFAULT '',
            PRIMARY KEY (id)
        )$charset_collate;";

        $sql_schema = "SELECT * FROM INFORMATION_SCHEMA.TABLES
                       WHERE table_schema = '".DB_NAME."' AND table_name = '".$formfields_table."' ";
        $results = $wpdb->get_results($sql_schema);

        if(empty($results)){
            $wpdb->query( $sql );
        }else{
            dbDelta( $sql );
        }

        $sql = "CREATE TABLE `" . $settings_table . "` (
            `id` INT(11) NOT NULL AUTO_INCREMENT,
            `meta_key` TEXT NULL DEFAULT NULL,
            `meta_value` TEXT NULL DEFAULT NULL,
            `note` TEXT NULL DEFAULT NULL,
            `options` TEXT NULL DEFAULT NULL,
            PRIMARY KEY (`id`)
        )$charset_collate;";

        $sql_schema = "SELECT * FROM INFORMATION_SCHEMA.TABLES
                       WHERE table_schema = '".DB_NAME."' AND table_name = '".$settings_table."' ";
        $results = $wpdb->get_results($sql_schema);

        if(empty($results)){
            $wpdb->query( $sql );
        }else{
            dbDelta( $sql );
        }

        $sql = "CREATE TABLE `" . $requests_table . "` (
            `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
            `poll_id` INT(11) UNSIGNED DEFAULT NULL,
            `user_id` INT(11) DEFAULT 0,
            `user_ip` VARCHAR(256) NOT NULL,
            `title` VARCHAR(256) NOT NULL,
            `question` TEXT NOT NULL,
            `answers` TEXT NOT NULL,
            `category_type` VARCHAR(64) NOT NULL,
            `request_date` DATETIME NOT NULL,
            `unread`  INT(1) DEFAULT 1,
            `approved`  INT(1) DEFAULT 0,
            `category_id`  INT(1) DEFAULT 1,
            `options` TEXT NULL DEFAULT NULL,
            PRIMARY KEY (id)
        )$charset_collate;";

        $sql_schema = "SELECT * FROM INFORMATION_SCHEMA.TABLES
                       WHERE table_schema = '".DB_NAME."' AND table_name = '".$requests_table."' ";
        $results = $wpdb->get_results($sql_schema);

        if(empty($results)){
            $wpdb->query( $sql );
        }else{
            dbDelta( $sql );
        }

        $sql = "CREATE TABLE `" . $popup_poll_table . "` (
            `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
            `poll_id` INT(11) UNSIGNED NOT NULL DEFAULT '0',
            `title` TEXT NOT NULL,
            `show_all` VARCHAR(20) NOT NULL,
            `status` VARCHAR(256) NOT NULL DEFAULT 'published',
            `trash_status` VARCHAR(256) NOT NULL DEFAULT '',
            `author_id` INT(11) UNSIGNED NOT NULL DEFAULT '0',
            `date_created` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
            `date_modified` DATETIME NOT NULL DEFAULT '1000-01-01 00:00:00',
            `options` TEXT NOT NULL DEFAULT '',
            PRIMARY KEY (id)
        )$charset_collate;";

        $sql_schema = "SELECT * FROM INFORMATION_SCHEMA.TABLES
                       WHERE table_schema = '".DB_NAME."' AND table_name = '".$popup_poll_table."' ";
        $results = $wpdb->get_results($sql_schema);

        if(empty($results)){
            $wpdb->query( $sql );
        }else{
            dbDelta( $sql );
        }

        // AV added Poll id for report table
        $answers_table = $wpdb->prefix . 'ayspoll_answers';
        $report_table = $wpdb->prefix . 'ayspoll_reports';
        $polls_table = $wpdb->prefix . 'ayspoll_polls';

        $answ_id = $wpdb->get_results("SELECT DISTINCT answer_id FROM $report_table", 'ARRAY_A');
        if (isset($answ_id) && !empty($answ_id)) {
            $answer_ids = '';
            foreach ($answ_id as $key => $value) {
                if ($key == count($answ_id) - 1 ) {
                    $answer_ids .=  $value['answer_id'];
                }else{
                    $answer_ids .=  $value['answer_id'].',';
                }
            }
            $answ_poll_id = $wpdb->get_results("SELECT poll_id, id AS 'answ_id' FROM $answers_table WHERE id IN (".$answer_ids.")", 'ARRAY_A');

            if($answ_poll_id > 0){
                foreach ($answ_poll_id as $ap_key => $ap_value) {
                    $poll_result = $wpdb->update(
                        $report_table,
                        array(
                            'poll_id'     => $ap_value['poll_id']
                        ),
                        array('answer_id' => $ap_value['answ_id']),
                        array(
                            '%d'
                        ),
                        array('%d')
                    );
                }
            }
        }

        $polls_sql = "SELECT id, styles, author_id FROM ". $polls_table;
        $polls = $wpdb->get_results( $polls_sql, "ARRAY_A" );
        foreach( $polls as $poll){
            
            $poll_id = intval( $poll['id'] );
            $options = isset( $poll['styles'] ) ? json_decode( $poll['styles'], true ) : array();
            $author = isset( $options['author'] ) ? $options['author'] : array();
            $author_id = isset( $author['id'] ) ? intval( $author['id'] ) : 0;
            
            $wpdb->update(
                $polls_table,
                array(
                    'author_id'   => $author_id
                ),
                array('id' => $poll_id),
                array('%d'),
                array('%d')
            );
        }

    }

    private static function insert_default_values() {
        global $wpdb;
        $answers_table = $wpdb->prefix . 'ayspoll_answers';
        $polls_table   = $wpdb->prefix . 'ayspoll_polls';
        $cats_table    = $wpdb->prefix . 'ayspoll_categories';
        $settings_table = $wpdb->prefix . "ayspoll_settings";
        $cat_count     = $wpdb->get_var("SELECT COUNT(id) FROM $cats_table");

        if (0 == $cat_count) {
            $wpdb->insert($cats_table, array('title' => 'Uncategorized', 'description' => 'Default poll category'));
        }

        $polls_count = $wpdb->get_var("SELECT COUNT(id) FROM $polls_table");

        if (0 == $polls_count) {
            $wpdb->insert($polls_table, array(
                'title'       => 'Default choosing',
                'description' => 'Default choosing type ',
                'question'    => 'Did you like our plugin?',
                'type'        => 'choosing',
                'categories'  => ',1,',
                'styles'      => '{"main_color":"#0C6291","text_color":"#0C6291","icon_color":"#0C6291","icon_size":24,"width":0,"btn_text":"Vote","border_style":"ridge","bg_color":"#FBFEF9"}',
                'theme_id'    => 1,
            ));
            $last_insert = $wpdb->insert_id;
            $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => 'It was a mistake'));
            $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => 'There was nothing special'));
            $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => 'Everything\'s ok'));
            $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => 'I enjoyed it'));
            $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => 'It\'s amazing'));

            $wpdb->insert($polls_table, array(
                'title'       => 'Default rating',
                'description' => 'Default rating type ',
                'question'    => 'Did you like our plugin?',
                'type'        => 'rating',
                'view_type'   => 'star',
                'categories'  => ',1,',
                'styles'      => '{"main_color":"#0C6291","text_color":"#0C6291","icon_color":"#0C6291","icon_size":24,"width":0,"btn_text":"Vote","border_style":"ridge","bg_color":"#FBFEF9"}',
                'theme_id'    => 1,
            ));
            $last_insert = $wpdb->insert_id;
            $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => '1'));
            $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => '2'));
            $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => '3'));
            $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => '4'));
            $wpdb->insert($answers_table, array('poll_id' => $last_insert, 'answer' => '5'));
        }

        $metas = array(
            "user_roles",
            "mailchimp",
            "monitor",
            "slack",
            "active_camp",
            "zapier",
            "leaderboard",
            "google_sheet",
            "sendgrid",
            "poll_default_options",
            "options",
            "mad_mimi",
            "get_response",
            "convertKit",
            "category_leaderboard",
            "fields_placeholders"
        );
        
        foreach($metas as $meta_key){
            $meta_val = "";
            if($meta_key == "user_roles"){
                $meta_val = json_encode(array('administrator'));
            }
            $sql = "SELECT COUNT(*) FROM `".$settings_table."` WHERE `meta_key` = '".$meta_key."'";
            $result = $wpdb->get_var($sql);
            if(intval($result) == 0){
                $result = $wpdb->insert(
                    $settings_table,
                    array(
                        'meta_key'    => $meta_key,
                        'meta_value'  => $meta_val,
                        'note'        => "",
                        'options'     => ""
                    ),
                    array( '%s', '%s', '%s', '%s' )
                );
            }
        }
    }

    public static function ays_poll_update_db_check() {
        global $ays_poll_db_version;
        if (get_site_option('ays_poll_db_version') != $ays_poll_db_version) {
            self::activate();
            update_site_option('ays_poll_db_version', $ays_poll_db_version);
            self::insert_default_values();
        }
    }
}