<?php

class Poll_Maker_Data {
    public static function get_user_profile_data(){

        $user_first_name   = '';
        $user_last_name    = '';
        $user_nickname     = '';
        $user_display_name = '';
        $user_wordpress_roles_name = '';
        $user_email = '';
        
        $user_id = get_current_user_id();
        if($user_id != 0){
            $usermeta = get_user_meta( $user_id );
            if($usermeta !== null){
                $user_first_name = (isset($usermeta['first_name'][0]) && sanitize_text_field( $usermeta['first_name'][0] != '') ) ? sanitize_text_field( $usermeta['first_name'][0] ) : '';
                $user_last_name  = (isset($usermeta['last_name'][0]) && sanitize_text_field( $usermeta['last_name'][0] != '') ) ? sanitize_text_field( $usermeta['last_name'][0] ) : '';
                $user_nickname   = (isset($usermeta['nickname'][0]) && sanitize_text_field( $usermeta['nickname'][0] != '') ) ? sanitize_text_field( $usermeta['nickname'][0] ) : '';
            }

            $current_user_data = get_userdata( $user_id );
            if ( ! is_null( $current_user_data ) && $current_user_data ) {
                $user_display_name = ( isset( $current_user_data->data->display_name ) && $current_user_data->data->display_name != '' ) ? sanitize_text_field( $current_user_data->data->display_name ) : "";
                $user_email = ( isset( $current_user_data->data->user_email ) && $current_user_data->data->user_email != '' ) ? sanitize_text_field( $current_user_data->data->user_email ) : "";

                $user_wordpress_roles_name = ( isset( $current_user_data->roles ) && ! empty( $current_user_data->roles ) ) ? $current_user_data->roles : "";

				if ( !empty( $user_wordpress_roles_name ) && $user_wordpress_roles_name != "" ) {
					if ( is_array( $user_wordpress_roles_name ) ) {
						$user_wordpress_roles_name = implode(",", $user_wordpress_roles_name);
					}
				}
            }

        }

        $user_nickname        = '';
		$user_display_name    = '';
		$user_wordpress_email = '';
		$user_wordpress_roles = '';
		$user_id = get_current_user_id();
		if($user_id != 0){
			$usermeta = get_user_meta( $user_id );
			if($usermeta !== null){
				$user_nickname   = (isset($usermeta['nickname'][0]) && sanitize_text_field( $usermeta['nickname'][0] != '') ) ? sanitize_text_field( $usermeta['nickname'][0] ) : '';
			}

			$current_user_data = get_userdata( $user_id );
			if ( ! is_null( $current_user_data ) && $current_user_data ) {
				$user_display_name    = ( isset( $current_user_data->data->display_name ) && $current_user_data->data->display_name != '' ) ? sanitize_text_field( $current_user_data->data->display_name ) : "";
				$user_wordpress_email = ( isset( $current_user_data->data->user_email ) && $current_user_data->data->user_email != '' ) ? sanitize_text_field( $current_user_data->data->user_email ) : "";

				$user_wordpress_roles = ( isset( $current_user_data->roles ) && ! empty( $current_user_data->roles ) ) ? $current_user_data->roles : "";

				if ( !empty( $user_wordpress_roles ) && $user_wordpress_roles != "" ) {
					if ( is_array( $user_wordpress_roles ) ) {
						$user_wordpress_roles = implode(",", $user_wordpress_roles);
					}
				}
			}
		}

        $message_data = array(
            'user_first_name'             => $user_first_name,
            'user_last_name'              => $user_last_name,
            'user_nickname'               => $user_nickname,
            'user_display_name'           => $user_display_name,
            'user_email_name'             => $user_email,
            'user_wordpress_roles_name'   => $user_wordpress_roles_name,
        );
		
        return $message_data;
    }

    // Retrieves the attachment ID from the file URL
    public static function ays_poll_get_image_id_by_url( $image_url ) {
        global $wpdb;

        $image_alt_text = "";
        if ( !empty( $image_url ) ) {

            $re = '/-\d+[Xx]\d+\./';
            $subst = '.';

            $image_url = preg_replace($re, $subst, $image_url, 1);

            $attachment = $wpdb->get_col($wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE guid='%s';", $image_url ));
            if ( !is_null( $attachment ) && !empty( $attachment ) ) {

                $image_id = (isset( $attachment[0] ) && $attachment[0] != "") ? absint(  $attachment[0] ) : "";
                if ( $image_id != "" ) {
                    $image_alt_text = self::ays_poll_get_image_alt_text_by_id( $image_id );
                }
            }
        }

        return $image_alt_text; 
    }

    public static function ays_poll_get_image_alt_text_by_id( $image_id ) {

        $image_data = "";
        if ( $image_id != "" ) {

            $result = get_post_meta($image_id, '_wp_attachment_image_alt', TRUE);
            if ( $result && $result != "" ) {
                $image_data = esc_attr( $result );
            }
        }

        return $image_data; 
    }

    public static function ays_poll_autoembed( $content ) {
        global $wp_embed;
        $content = stripslashes( wpautop( $content ) );
        $content = $wp_embed->autoembed( $content );
        if ( strpos( $content, '[embed]' ) !== false ) {
            $content = $wp_embed->run_shortcode( $content );
        }
        $content = do_shortcode( $content );
        return $content;
    }

    public static function get_poll_pass_count($id) {
        global $wpdb;
        $poll_id = absint(sanitize_text_field($id));
        $args_id = esc_sql($poll_id);
        $answ_table = esc_sql($wpdb->prefix."ayspoll_answers");
        $sql = "SELECT SUM(votes) FROM ".$answ_table." WHERE poll_id=%d";
        $result = $wpdb->get_var(
			   	  	$wpdb->prepare( $sql, $args_id)
				  );

        return $result;
    }

    public static function get_current_poll_author( $id ){
        global $wpdb;

        $polls_table = $wpdb->prefix . 'ayspoll_polls';
        $sql = "SELECT `author_id` FROM `{$polls_table}` WHERE `id` = {$id}";
        $results = $wpdb->get_var($sql);
        
        if( is_null( $results ) || empty( $results ) ){
            $content_html = "";
            return $content_html;
        }

        $author_id = ( isset( $results ) && $results != '' ) ? absint($results) : 0;
        
        if( $author_id != 0){
            $author = get_userdata( $author_id );
        }
        
        if( $author !== null){
            $poll_author = $author->data->display_name;
        }else{
            $poll_author = "Unknown";
        }

        return $poll_author;
    }

    public static function get_user_passed_polls_count( $user_id ){
        global $wpdb;

        if (is_null($user_id) || $user_id == 0 ) {
            return null;
        }

        $user_id = absint( $user_id );

        $reports_table = esc_sql($wpdb->prefix."ayspoll_reports");
        $answ_table    = esc_sql($wpdb->prefix."ayspoll_answers");
        $polls_table   = esc_sql($wpdb->prefix."ayspoll_polls");

        $sql = "SELECT COUNT(*) FROM {$reports_table} AS r
                JOIN {$answ_table} AS a 
                ON a.id = r.answer_id 
                JOIN {$polls_table} AS p 
                ON a.poll_id = p.id
                WHERE r.user_id = ".$user_id;

        $results = $wpdb->get_var($sql);

        if ( ! empty( $results ) ) {
            $results = absint( $results );
        } else {
            $results = 0;
        }

        return $results;
    }

}
