<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://ays-pro.com/
 * @since      1.0.0
 *
 * @package    Poll_Maker_Ays
 * @subpackage Poll_Maker_Ays/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Poll_Maker_Ays
 * @subpackage Poll_Maker_Ays/includes
 * @author     Poll Maker Team <info@ays-pro.com>
 */
class Poll_Maker_Ays {

    /**
     * The loader that's responsible for maintaining and registering all hooks that power
     * the plugin.
     *
     * @since    1.0.0
     * @access   protected
     * @var      Poll_Maker_Ays_Loader    $loader    Maintains and registers all hooks for the plugin.
     */
    protected $loader;

    /**
     * The unique identifier of this plugin.
     *
     * @since    1.0.0
     * @access   protected
     * @var      string    $plugin_name    The string used to uniquely identify this plugin.
     */
    protected $plugin_name;

    /**
     * The current version of the plugin.
     *
     * @since    1.0.0
     * @access   protected
     * @var      string    $version    The current version of the plugin.
     */
    protected $version;

    /**
     * Define the core functionality of the plugin.
     *
     * Set the plugin name and the plugin version that can be used throughout the plugin.
     * Load the dependencies, define the locale, and set the hooks for the admin area and
     * the public-facing side of the site.
     *
     * @since    1.0.0
     */
    public function __construct() {
        if (defined('POLL_MAKER_AYS_VERSION')) {
            $this->version = POLL_MAKER_AYS_VERSION;
        } else {
            $this->version = '7.2.0';
        }
        $this->plugin_name = 'poll-maker-ays';

        $this->load_dependencies();
        $this->set_locale();
        $this->define_admin_hooks();
        $this->define_public_hooks();

    }

    /**
     * Load the required dependencies for this plugin.
     *
     * Include the following files that make up the plugin:
     *
     * - Poll_Maker_Ays_Loader. Orchestrates the hooks of the plugin.
     * - Poll_Maker_Ays_i18n. Defines internationalization functionality.
     * - Poll_Maker_Ays_Admin. Defines all hooks for the admin area.
     * - Poll_Maker_Ays_Public. Defines all hooks for the public side of the site.
     *
     * Create an instance of the loader which will be used to register the hooks
     * with WordPress.
     *
     * @since    1.0.0
     * @access   private
     */
    private function load_dependencies() {
        if (!class_exists('WP_List_Table')) {
            require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
        }

        /**
         * The class responsible for orchestrating the actions and filters of the
         * core plugin.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-poll-maker-ays-loader.php';

        /**
         * The class responsible for defining internationalization functionality
         * of the plugin.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/class-poll-maker-ays-i18n.php';

        /**
         * The class responsible for defining all actions that occur in the admin area.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/class-poll-maker-ays-admin.php';

        /*
         * The class is responsible for showing polls in wordpress default WP_LIST_TABLE style
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/lists/class-poll-maker-polls-list-table.php';

        /*
         * The class is responsible for showing polls categories in wordpress default WP_LIST_TABLE style
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/lists/class-poll-maker-categories-list-table.php';

        /*
         * The class is responsible for showing poll results in wordpress default WP_LIST_TABLE style
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/lists/class-poll-maker-results-list-table.php';

        /*
         * The class is responsible for showing poll results in wordpress default WP_LIST_TABLE style
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/lists/class-poll-maker-each-results-poll-list-table.php';

        /*
         * The class is responsible for showing poll form custom fields in wordpress default WP_LIST_TABLE style
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/lists/class-poll-maker-formfields-list-table.php';

        /*
         * The class is responsible for showing all polls results in wordpress default WP_LIST_TABLE style
         */
        require_once plugin_dir_path(dirname( __FILE__ ) ) . 'includes/lists/class-poll-maker-all-results-list-table.php';

        /*
         * The class is responsible for showing poll requests in wordpress default WP_LIST_TABLE style
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/lists/class-poll-maker-requests-list-table.php';

	    /*
		 * The class is responsible for showing poll settings
		 */
	    require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/settings/poll-maker-settings-actions.php';

        /*
         * The class is responsible for showing popup poll in wordpress default WP_LIST_TABLE style
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'includes/lists/class-poll-maker-popup-list-table.php';

        /**
         * The class responsible for defining all actions that occur in the public-facing
         * side of the site.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'public/class-poll-maker-ays-public.php';

        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/class-poll-maker-extra-shortcode.php';

        /**
		 * The class responsible for defining all functions for getting all poll data
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-poll-maker-ays-data.php';

        /**
         * The class responsible for widget.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'widgets/poll-maker-ays-widget.php';

        /**
         * The class responsible for frontend statistics shortcode
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'public/partials/class-poll-maker-frontend-statistics.php';

        /**
         * The class responsible for user activity per day
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'public/partials/class-poll-maker-user-activity-per-day.php';

        /**
         * The class responsible for user activity per day
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'public/partials/class-poll-maker-all-results.php';

         /**
         * The class responsible for showsing most popular shortcode in frontend
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'public/partials/class-poll-maker-most-popular-shortcode.php';

        /**
         * The class responsible for showsing activity of choosen poll
         */
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/class-poll-maker-poll-activity-per-day-shortcode.php';

	    /**
	     * The class responsible for SMTP mailing.
	     */
	    // if(!class_exists('PHPMailer\PHPMailer\PHPMailer', false)){
		   //  require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/PHPMailer/autoload.inc.php';
	    // }

        $this->loader = new Poll_Maker_Ays_Loader();

    }

    /**
     * Define the locale for this plugin for internationalization.
     *
     * Uses the Poll_Maker_Ays_i18n class in order to set the domain and to register the hook
     * with WordPress.
     *
     * @since    1.0.0
     * @access   private
     */
    private function set_locale() {

        $plugin_i18n = new Poll_Maker_Ays_i18n();

        $this->loader->add_action('plugins_loaded', $plugin_i18n, 'load_plugin_textdomain');
        $this->loader->add_action('init', $plugin_i18n, 'load_plugin_textdomain');

    }

    /**
     * Register all of the hooks related to the admin area functionality
     * of the plugin.
     *
     * @since    1.0.0
     * @access   private
     */
    private function define_admin_hooks() {

        $plugin_admin = new Poll_Maker_Ays_Admin($this->get_plugin_name(), $this->get_version());

	    $this->loader->add_action('admin_head', $plugin_admin, 'admin_menu_styles');
        $this->loader->add_action('admin_enqueue_scripts', $plugin_admin, 'enqueue_styles');
        $this->loader->add_action('admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts');
        $this->loader->add_action('widgets_init', $plugin_admin, 'register_poll_ays_widget');

        //Plugin deactivate
        $this->loader->add_action('wp_ajax_apm_deactivate_plugin_option_pmp', $plugin_admin, 'apm_deactivate_plugin_option');
        $this->loader->add_action('wp_ajax_nopriv_apm_deactivate_plugin_option_pmp', $plugin_admin, 'apm_deactivate_plugin_option');

        //Results modal
        $this->loader->add_action('wp_ajax_apm_show_results', $plugin_admin, 'apm_show_results');
        $this->loader->add_action('wp_ajax_nopriv_apm_show_results', $plugin_admin, 'apm_show_results');

        // EXPORT FILTERS
        $this->loader->add_action( 'wp_ajax_ays_poll_show_filters', $plugin_admin, 'ays_poll_show_filters' );
        $this->loader->add_action( 'wp_ajax_nopriv_ays_poll_show_filters', $plugin_admin, 'ays_poll_show_filters' );

        $this->loader->add_action( 'wp_ajax_ays_poll_results_export_file', $plugin_admin, 'ays_poll_results_export_file' );
        $this->loader->add_action( 'wp_ajax_nopriv_ays_poll_results_export_file', $plugin_admin, 'ays_poll_results_export_file' );

        $this->loader->add_action( 'wp_ajax_ays_poll_results_export_file_xlsx', $plugin_admin, 'ays_poll_results_export_file_xlsx' );
        $this->loader->add_action( 'wp_ajax_nopriv_ays_poll_results_export_file_xlsx', $plugin_admin, 'ays_poll_results_export_file_xlsx' );
        
        // Add Request
        $this->loader->add_action( 'wp_ajax_ays_poll_add_request', $plugin_admin, 'ays_poll_add_request' );
        $this->loader->add_action( 'wp_ajax_nopriv_ays_poll_add_request', $plugin_admin, 'ays_poll_add_request' );

        // Add menu item
        $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_admin_menu');

        $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_polls_submenu', 90 );
        $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_requests_submenu', 95 );
        $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_categories_submenu', 100 );
        $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_popup_poll_submenu', 105 );
        $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_results_submenu', 110 );
        $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_formfields_submenu', 115 );
        $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_general_settings_submenu', 120 );
        $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_how_to_use_submenu', 125 );
        $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_affiliate_submenu', 130 );
        $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_our_products_submenu', 135 );

        // Add Settings link to the plugin
        $plugin_basename = plugin_basename(plugin_dir_path(__DIR__) . $this->plugin_name . '.php');
        $this->loader->add_filter('plugin_action_links_' . $plugin_basename, $plugin_admin, 'add_action_links');
        $this->loader->add_action( 'elementor/widgets/widgets_registered', $plugin_admin, 'poll_maker_el_widgets_registered' );

        // CodeMirror
        $this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'codemirror_enqueue_scripts');

        //GamiPress
        $this->loader->add_filter( 'gamipress_activity_triggers', $plugin_admin, 'gamipress_ays_poll_maker_activity_triggers', 1, 2 );
        $this->loader->add_filter( 'gamipress_trigger_get_user_id', $plugin_admin, 'gamipress_ays_poll_maker_trigger_get_user_id', 10, 3 );
        $this->loader->add_action( 'ays_poll_before_save_entry', $plugin_admin, 'gamipress_ays_poll_maker_vote_poll' );

        //send mail to admin every x time
        $this->loader->add_filter( 'cron_schedules', $plugin_admin, 'cron_add_time');
        $this->loader->add_action( 'admin_head', $plugin_admin, 'send_mail_to_admins_per_time');
        $this->loader->add_action( 'ays_poll_send_mail_to_admins', $plugin_admin, 'send_mail_to_admins');
        
        // Import answers (choosing)
        $this->loader->add_action( 'wp_ajax_ays_import_answers', $plugin_admin, 'ays_import_answers' );
        $this->loader->add_action( 'wp_ajax_nopriv_ays_import_answers', $plugin_admin, 'ays_import_answers' );

        $this->loader->add_action( 'wp_ajax_ays_poll_admin_ajax', $plugin_admin, 'ays_poll_admin_ajax' );
        $this->loader->add_action( 'wp_ajax_nopriv_ays_poll_admin_ajax', $plugin_admin, 'ays_poll_admin_ajax' );

        // Add aditional links to the plugin
        $this->loader->add_filter( 'plugin_row_meta', $plugin_admin, 'add_poll_row_meta' , 10 , 2 );

        //Create quick poll
        $this->loader->add_action( 'wp_ajax_ays_poll_maker_quick_start', $plugin_admin, 'ays_poll_maker_quick_start' );
        $this->loader->add_action( 'wp_ajax_nopriv_ays_poll_maker_quick_start', $plugin_admin, 'ays_poll_maker_quick_start' );

    }

    /**
     * Register all of the hooks related to the public-facing functionality
     * of the plugin.
     *
     * @since    1.0.0
     * @access   private
     */
    private function define_public_hooks() {

        $plugin_public = new Poll_Maker_Ays_Public($this->get_plugin_name(), $this->get_version());
        $plugin_public_extra_shortcodes = new Ays_Poll_Maker_Extra_Shortcodes_Public( $this->get_plugin_name(), $this->get_version() );
        $plugin_public_statistics = new Poll_Maker_Frontent_Statistics( $this->get_plugin_name(), $this->get_version() );
        $plugin_public_user_activity_per_day = new Ays_Poll_Maker_User_Activity_Per_Day( $this->get_plugin_name(), $this->get_version() );
        $plugin_public_all_results = new Poll_Maker_All_Results( $this->get_plugin_name(), $this->get_version() );

        $plugin_most_popular_shortcode = new Ays_Poll_Maker_Most_Popular_Shortcodes_Public( $this->get_plugin_name(), $this->get_version() ); 
        $plugin_public_poll_activity_per_day    = new Poll_Maker_Poll_Activity_Per_Day_Shortcodes_Public( $this->get_plugin_name(), $this->get_version() );

        //$this->loader->add_action('init', $plugin_public, 'ays_poll_initialize_shortcode');

        $this->loader->add_action('wp_ajax_ays_finish_poll', $plugin_public, 'ays_finish_poll');
        $this->loader->add_action('wp_ajax_nopriv_ays_finish_poll', $plugin_public, 'ays_finish_poll');

        $this->loader->add_action('wp_ajax_ays_add_answer_poll', $plugin_public, 'ays_add_answer_poll');
        $this->loader->add_action('wp_ajax_nopriv_ays_add_answer_poll', $plugin_public, 'ays_add_answer_poll');

        //Poll Statistics Front
        $this->loader->add_action('wp_ajax_ays_poll_fs_draw_chart', $plugin_public_statistics, 'ays_poll_fs_draw_chart');
        $this->loader->add_action('wp_ajax_nopriv_ays_poll_fs_draw_chart', $plugin_public_statistics, 'ays_poll_fs_draw_chart');

        // $this->loader->add_action('wp_enqueue_scripts', $plugin_public, 'enqueue_styles');
        // $this->loader->add_action('wp_enqueue_scripts', $plugin_public, 'enqueue_scripts');
        $this->loader->add_action('wp_enqueue_scripts', $plugin_public, 'enqueue_styles_early');

        $this->loader->add_action( 'wp_footer', $plugin_public, 'ays_poll_shortcodes_show_all');

        $this->loader->add_action('wp_ajax_ays_poll_get_current_answer_users_pics', $plugin_public, 'ays_poll_get_current_answer_users_pics');
        $this->loader->add_action('wp_ajax_nopriv_ays_poll_get_current_answer_users_pics', $plugin_public, 'ays_poll_get_current_answer_users_pics');

        // Public AJAX action
        $this->loader->add_action( 'wp_ajax_ays_poll_ajax', $plugin_public, 'ays_poll_ajax' );
        $this->loader->add_action( 'wp_ajax_nopriv_ays_poll_ajax', $plugin_public, 'ays_poll_ajax' );
    }

    /**
     * Run the loader to execute all of the hooks with WordPress.
     *
     * @since    1.0.0
     */
    public function run() {
        $this->loader->run();
    }

    /**
     * The name of the plugin used to uniquely identify it within the context of
     * WordPress and to define internationalization functionality.
     *
     * @since     1.0.0
     * @return    string    The name of the plugin.
     */
    public function get_plugin_name() {
        return $this->plugin_name;
    }

    /**
     * The reference to the class that orchestrates the hooks with the plugin.
     *
     * @since     1.0.0
     * @return    Poll_Maker_Ays_Loader    Orchestrates the hooks of the plugin.
     */
    public function get_loader() {
        return $this->loader;
    }

    /**
     * Retrieve the version number of the plugin.
     *
     * @since     1.0.0
     * @return    string    The version number of the plugin.
     */
    public function get_version() {
        return $this->version;
    }

}