<?php
ob_start();
class Poll_All_Results_List_Table extends WP_List_Table{
    private $plugin_name;
    private $title_length;
    /** Class constructor */
    public function __construct($plugin_name) {
        $this->plugin_name = $plugin_name;
        $this->title_length = Poll_Maker_Ays_Admin::get_listtables_title_length('results');
        parent::__construct( array(
            'singular' => __( 'Result', $this->plugin_name ), //singular name of the listed records
            'plural'   => __( 'Results', $this->plugin_name ), //plural name of the listed records
            'ajax'     => false //does this table support ajax?
        ) );
        add_action( 'admin_notices', array( $this, 'results_notices' ) );
        add_filter( 'hidden_columns', array( $this, 'get_hidden_columns'), 10, 2 );

    }

    /**
     * Override of table nav to avoid breaking with bulk actions & according nonce field
     */
    public function display_tablenav( $which ) {
        ?>
        <div class="tablenav <?php echo esc_attr( $which ); ?>">

            <div class="alignleft actions">
                <?php $this->bulk_actions( $which ); ?>
            </div>

            <?php
            $this->extra_tablenav( $which );
            $this->pagination( $which );
            ?>
            <br class="clear" />
        </div>
        <?php
    }

    public function extra_tablenav( $which ){
        global $wpdb;
        $titles_sql = "SELECT {$wpdb->prefix}ayspoll_polls.title,
                              {$wpdb->prefix}ayspoll_polls.id
                       FROM {$wpdb->prefix}ayspoll_polls";
        $poll_titles = $wpdb->get_results($titles_sql);

        $users_sql = "SELECT {$wpdb->prefix}ayspoll_reports.user_id
                      FROM {$wpdb->prefix}ayspoll_reports
                      GROUP BY user_id";
        $users = $wpdb->get_results($users_sql);
        $poll_id = null;
        $user_id = null;
        if( isset( $_GET['filterby'] )){
            $poll_id = intval($_GET['filterby']);
        }
        if( isset( $_GET['wpuser'] )){
            $poll_id = intval($_GET['wpuser']);
        }
        ?>
        <div id="poll-filter-div" class="alignleft actions bulkactions">
            <select name="filterby" id="bulk-action-selector-top">
                <option value=""><?php echo __('Select Poll',$this->plugin_name)?></option>
                <?php
                    foreach($poll_titles as $key => $p_title){
                        $selected = "";
                        if($poll_id === intval($p_title->id)){
                            $selected = "selected";
                        }
                        echo "<option ".$selected." value='".$p_title->id."'>".$p_title->title."</option>";
                    }
                ?>
            </select>
            <input type="button" id="doaction" class="cat-filter-apply button" value="Filter">

            <select name="orderbyuser" id="bulk-action-selector-<?php echo $which; ?>-user" style="float: initial;">
                <option value="-1" ><?=__('Select User', $this->plugin_name);?></option>
                <?php
                    $selected = "";
                    $poll_users = $this->ays_poll_get_users();
                    foreach ($poll_users as $user_id => $user_name) {
                        $user_req_id = (isset($_REQUEST['orderbyuser']) && $_REQUEST['orderbyuser'] != "") ? $_REQUEST['orderbyuser'] : "-1";
                        $user_req_id = intval($user_req_id);
                        $users_id   = isset($user_id) && $user_id  != "" ? intval(esc_attr($user_id)) : "";
                        $users_name = isset($user_name) && $user_name != "" ? esc_attr($user_name) : "";
                        $selected = ($user_req_id == $users_id) ? 'selected' : '';
                    ?>                                
                    <option value="<?php echo $user_id ;?>" <?php echo $selected; ?>><?php echo $user_name;?></option>
                    <?php 
                    }
                ?>
            </select>
            <input type="button" id="doactionuser" class="cat-filter-apply-user-<?php echo $which;?> button" value="<?= __('Filter', $this->plugin_name); ?>" style="width: 3.7rem;">

        </div>
        <a style="display:inline-block;" href="?page=<?php echo $_REQUEST['page'] ?>" class="button"><?php echo __( "Clear filters", $this->plugin_name ); ?></a>
        <?php
    }

    protected function get_views() {
        $published_count   = $this->readed_records_count();
        $unpublished_count = $this->unread_records_count();
        $all_count         = $this->all_record_count();
        $selected_all = "";
        $selected_0   = "";
        $selected_1   = "";
        if(isset($_GET['fstatus'])){
            switch($_GET['fstatus']){
                case "0":
                    $selected_0 = " style='font-weight:bold;' ";
                    break;
                case "1":
                    $selected_1 = " style='font-weight:bold;' ";
                    break;
                default:
                    $selected_all = " style='font-weight:bold;' ";
                    break;
            }
        }else{
            $selected_all = " style='font-weight:bold;' ";
        }

        $status_links = array(
            "all"        => "<a ".$selected_all." href='?page=".esc_attr( $_REQUEST['page'] )."'>". __( 'All', $this->plugin_name )." (".$all_count.")</a>",
            "read"     => "<a ".$selected_1." href='?page=".esc_attr( $_REQUEST['page'] )."&fstatus=1'>". __( 'Read', $this->plugin_name )." (".$published_count.")</a>",
            "unread"   => "<a ".$selected_0." href='?page=".esc_attr( $_REQUEST['page'] )."&fstatus=0'>". __( 'Unread', $this->plugin_name )." (".$unpublished_count.")</a>"
        );
        return $status_links;
    }

    /**
     * Retrieve customers data from the database
     *
     * @param int $per_page
     * @param int $page_number
     *
     * @return mixed
     */
    public static function get_reports( $per_page = 50, $page_number = 1 ) {

        global $wpdb;

        $sql = "SELECT * FROM {$wpdb->prefix}ayspoll_reports";

        $sql .= self::get_where_condition();

        if ( ! empty( $_REQUEST['orderby'] ) ) {
            $sql .= ' ORDER BY ' . esc_sql( $_REQUEST['orderby'] );
            $sql .= ! empty( $_REQUEST['order'] ) ? ' ' . esc_sql( $_REQUEST['order'] ) : ' DESC';
        }
        else{
            $sql .= ' ORDER BY vote_date DESC';
        }

        $sql .= " LIMIT $per_page";
        $sql .= ' OFFSET ' . ( $page_number - 1 ) * $per_page;


        $result = $wpdb->get_results( $sql, 'ARRAY_A' );

        return $result;
    }

    public static function get_where_condition(){
        global $wpdb;
        $where = array();
        $sql = '';

        $search = ( isset( $_REQUEST['s'] ) ) ? $_REQUEST['s'] : false;
        if( $search ){
            $s = array();
            $s[] = ' `user_email` LIKE \'%'.$search.'%\' ';

            $args = 'search=';
            if($search !== null){
                $args .= $search;
                $args .= '*';
            }

            $users = get_users($args);
            $user_ids_arr = array();

            foreach ($users as $key => $value) {
                $user_ids_arr[] = $value->ID;
            }

            if (! empty($user_ids_arr)) {
                $user_ids = implode(',', $user_ids_arr);

                $s[] = ' `user_id` in ('. $user_ids .')';
            }

            $where[] = ' ( ' . implode(' OR ', $s) . ' ) ';
        }

        if(isset( $_REQUEST['fstatus'] )){
            $fstatus = intval($_REQUEST['fstatus']);
            switch($fstatus){
                case 0:
                    $where[] = ' `unread` = 1 ';
                    break;
                case 1:
                    $where[] = ' `unread` = 0 ';
                    break;
            }
        }

        if(! empty( $_REQUEST['filterby'] ) && $_REQUEST['filterby'] > 0){
            $cat_id = intval($_REQUEST['filterby']);
            $where[] = ' `poll_id` = '.$cat_id.' ';
        }
        
        if (isset($_REQUEST['orderbyuser']) && $_REQUEST['orderbyuser'] >= 0) {
			$user_id = absint(sanitize_text_field( $_REQUEST['orderbyuser'] ));
			$where[] = sprintf(" user_id IN('%d') ", esc_sql( $wpdb->esc_like( $user_id ) ) );
		}


        if( ! empty($where) ){
            $sql = " WHERE " . implode( " AND ", $where );
        }
        return $sql;
    }

    public function get_report_by_id( $id ) {
		global $wpdb;

		$sql = "SELECT * FROM {$wpdb->prefix}ayspoll_reports WHERE id=" . absint(intval($id));

		$result = $wpdb->get_row($sql, 'ARRAY_A');

		return $result;
	}


    /**
     * Delete a customer record.
     *
     * @param int $id customer ID
     */
    public static function delete_reports( $id ) {
		global $wpdb;
		$wpdb->delete(
			"{$wpdb->prefix}ayspoll_reports",
			array('id' => $id),
			array('%d')
		);
	}


    /**
     * Returns the count of records in the database.
     *
     * @return null|string
     */

    // public static function record_count() {
	// 	global $wpdb;

	// 	$sql = "SELECT
	// 	COUNT(r.id)
    //     FROM
    //     {$wpdb->prefix}ayspoll_reports as r
    //     INNER JOIN {$wpdb->prefix}ayspoll_answers as a
    //     ON r.answer_id = a.id
    //     WHERE a.poll_id = " . absint($_GET['poll']);

	// 	return $wpdb->get_var($sql);
	// }

    // public static function all_record_count() {
    //     global $wpdb;

    //     $sql = "SELECT COUNT(*) FROM {$wpdb->prefix}ayspoll_reports";

    //     return $wpdb->get_var( $sql );
    // }

    public static function record_count() {
        global $wpdb;

        $sql = "SELECT COUNT(*) FROM {$wpdb->prefix}ayspoll_reports";
        $sql .= self::get_where_condition();
        return $wpdb->get_var( $sql );
    }

    public static function all_record_count() {
        global $wpdb;

        $sql = "SELECT COUNT(*) FROM {$wpdb->prefix}ayspoll_reports";

        return $wpdb->get_var( $sql );
    }

    public static function unread_records_count() {
        global $wpdb;

        $sql = "SELECT COUNT(*) FROM {$wpdb->prefix}ayspoll_reports WHERE `unread` = 1;";

        return $wpdb->get_var( $sql );
    }

    public function readed_records_count() {
        global $wpdb;

        $sql = "SELECT COUNT(*) FROM {$wpdb->prefix}ayspoll_reports WHERE `unread` = 0;";

        return $wpdb->get_var( $sql );
    }
    

    /** Text displayed when no customer data is available */
    public function no_items() {
        echo __( 'There are no results yet.', $this->plugin_name );
    }


    /**
     * Render a column when no column specific method exist.
     *
     * @param array $item
     * @param string $column_name
     *
     * @return mixed
     */
    public function column_default( $item, $column_name ) {
        switch ( $column_name ) {
            case 'poll_id':
            case 'user_ip':
            case 'answer_id':
            case 'user_email':
            case 'vote_date':
            case 'vote_reason':
            case 'unread':
                return $item[$column_name];
                break;
            case 'user_id':
                $other_info = json_decode($item['other_info'], true);
                if (isset($other_info['not_show_user_id']) && $other_info['not_show_user_id'] == 1) {
                    return '';
                    break;
                }else{
                    return (!empty($item[$column_name]) && $item[$column_name] > 0) ? get_user_by('ID', $item[$column_name])->display_name : __("Guest", $this->plugin_name);
                    break;
                }
            case 'user_name':
                $other_info = json_decode($item['other_info'], true);
                return (isset($other_info['Name']) && !empty($other_info['Name'])) ? $other_info['Name'] : '';
                break;

            default:
                return print_r($item, true); //Show the whole array for troubleshooting purposes
                    break;
            }
    }

    /**
     * Render the bulk edit checkbox
     *
     * @param array $item
     *
     * @return string
     */
    function column_cb( $item ) {
        return sprintf(
            '<input type="checkbox" class="ays_result_delete" name="bulk-delete[]" value="%s" />', $item['id']
        );
    }


    /**
     * Method for name column
     *
     * @param array $item an array of DB data
     *
     * @return string
     */
    function column_poll_id( $item ) {
        global $wpdb;

        $delete_nonce = wp_create_nonce( $this->plugin_name . '-delete-result' );

        $result = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}ayspoll_polls WHERE id={$item['poll_id']}", "ARRAY_A");
        if($item['unread'] == 1){
            $result_read = "style='font-weight:bold;'";
        }else{
            $result_read = "";
        }
        $restitle = Poll_Maker_Ays_Admin::ays_restriction_string("word",stripcslashes($result['title']), $this->title_length);
        if($result == null){
            $title = __( 'Poll has been deleted', $this->plugin_name );
        }else{
            $title = sprintf( '<a href="javascript:void(0)" data-result="%d" class="%s" '.$result_read.' style="display: block;">%s</a><input type="hidden" value="%d" class="ays_result_read">', absint( $item['id'] ), 'ays-show-results', $restitle,  $item['unread']);
        }
        $poll_id =  isset($result['poll_id']) ? $result['poll_id'] : 0;
        $actions = array(
            'view-details' => sprintf( '<a href="javascript:void(0);" data-result="%d" class="%s">%s</a>', absint( $item['id'] ), 'ays-show-results', 'View details'),
            'delete' => sprintf( '<a class="ays_confirm_del" data-message="this report" href="?page=%s&action=%s&result=%s&_wpnonce=%s">Delete</a>', esc_attr( $_REQUEST['page'] ), 'delete', absint( $item['id'] ), $delete_nonce )
        );

        return $title . $this->row_actions( $actions );
    }

    // === Column user id old ===
    // function column_user_id( $item ) {
    //     $user_id = intval($item['user_id']);
    //     if($user_id == 0){
    //         $name = "Guest";
    //     }else{
    //         $name = '';
    //         $user = get_userdata($user_id);
    //         if ($user !== false) {
    //             $name = $user->data->display_name;
    //         }
    //     }
    //     return $name;
    // }

    // === Column user id new modified ===
    function column_user_id( $item ) {
        $other_info = json_decode($item['other_info'], true);
        $user_id = intval($item['user_id']);
        
        if (isset($other_info['not_show_user_id']) && $other_info['not_show_user_id'] == 1) {
            $name = '';
        } else if($user_id == 0){
            $name = __( "Guest", $this->plugin_name );
        } else{
            $name = '';
            $user = get_userdata($user_id);
            if ($user !== false) {
                $name = $user->data->display_name;
            }
        }
        return $name;
    }

    function column_poll_rate( $item ) {
        global $wpdb;

        $delete_nonce = wp_create_nonce( $this->plugin_name . '-delete-result' );

        $options = json_decode($item['options'], true);
        $rate_id = (isset($options['rate_id'])) ? $options['rate_id'] : null;
        if($rate_id !== null){
            $margin_of_icon = "style='margin-left: 5px;'";
            $result = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}ayspoll_rates WHERE id={$rate_id}", "ARRAY_A");
            if($this->isJSON($result['options'])){
                $review_json = json_decode($result['options'], true);
                $review = $review_json['reason'];
            }elseif($result['options'] != ''){
                $review = $result['options'];
            }else{
                $review = $result['review'];
            }
            $reason = htmlentities(stripslashes(wpautop($review)));
            if($reason == ''){
                $reason = __("No review provided", $this->plugin_name);
            }
            $score = $result['score'];
            $title = "<span data-result='".absint( $item['id'] )."' class='ays-show-rate-avg'>
                        $score
                        <a class='ays_help' $margin_of_icon data-template='<div class=\"rate_tooltip tooltip\" role=\"tooltip\"><div class=\"arrow\"></div><div class=\"rate-tooltip-inner tooltip-inner\"></div></div>' data-toggle='tooltip' data-html='true' title='$reason'><i class='ays_fa ays_fa_info_circle'></i></a>
                </span>";
        }else{
            $margin_of_icon = '';
            $reason = __("No rate provided", $this->plugin_name);
            $score = '';
            $title = "";
        }
        return $title;
    }

    function column_vote_date( $item ) {
		return date('H:i:s d.m.Y', strtotime($item['vote_date']));
	}

    function column_vote_reason( $item ) {
		$info = json_decode($item['other_info'], true);

		return isset($info['voteReason']) ? $info['voteReason'] : '';
	}

    // function column_duration( $item ) {
    //     global $wpdb;

    //     $delete_nonce = wp_create_nonce( $this->plugin_name . '-delete-result' );

    //     $options = json_decode($item['options'], true);
    //     $passed_time = (isset($options['passed_time'])) ? $options['passed_time'] : null;
    //     if($passed_time !== null){
    //         $title = $passed_time;
    //     }else{
    //         $title = __('No data', $this->plugin_name);
    //     }
    //     return $title;
    // }

    function isJSON($string){
       return is_string($string) && is_array(json_decode($string, true)) && (json_last_error() == JSON_ERROR_NONE) ? true : false;
    }


    function ays_get_average_of_rates($id){
        global $wpdb;
        $sql = "SELECT AVG(`score`) AS avg_score FROM {$wpdb->prefix}ayspoll_rates WHERE poll_id= $id";
        $result = $wpdb->get_var($sql);
        return $result;
    }

    function column_unread( $item ) {
		$unread = $item['unread'] == 1 ? "unread-result" : "";

		return "<div class='unread-result-badge $unread'></div>";
    }
    
    public static function mark_as_read_reports( $id ) {
		global $wpdb;
		$wpdb->update(
			"{$wpdb->prefix}ayspoll_reports",
			array(
				"unread" => 0
			),
			array(
				"id" => absint($id)
			)
		);
	}

    /**
     *  Associative array of columns
     *
     * @return array
     */
    function get_columns() {
        $columns = array(
			'cb'          => '<input type="checkbox" />',
			'poll_id'     => __('Polls', $this->plugin_name),
			'answer_id'   => __('Answer', $this->plugin_name),
			'user_ip'     => __('User IP', $this->plugin_name),
			'user_id'     => __('WP User', $this->plugin_name),
			'user_email'  => __('User Email', $this->plugin_name),
			'user_name'   => __('User Name', $this->plugin_name),
			'vote_date'   => __('Vote Datetime', $this->plugin_name),
			'vote_reason' => __('Vote Reason', $this->plugin_name),
			'unread'      => __('Read Status', $this->plugin_name)
		);

		return $columns;
    }


    /**
     * Columns to make sortable.
     *
     * @return array
     */
    public function get_sortable_columns() {
        $sortable_columns = array(
			'id'        	=> array('id', true),
			'poll_id'    	=> array('poll_id', true),
			'answer_id' 	=> array('answer_id', true),
			'user_ip' 		=> array('user_ip', true),
			'user_id' 		=> array('user_id', true),
			'user_email'	=> array('user_email', true),
			'user_name'	    => array('user_name', true),
			'vote_date' 	=> array('vote_date', true),
			'vote_reason'	=> array('vote_reason', true),
			'unread'		=> array('unread', true),
		);


		return $sortable_columns;
    }

    /**
     * Columns to make sortable.
     *
     * @return array
     */
    public function get_hidden_columns() {
        $sortable_columns = array(
            'id'
        );

        return $sortable_columns;
    }

    /**
     * Returns an associative array containing the bulk action
     *
     * @return array
     */
    public function get_bulk_actions() {
		$actions = array(
			'bulk-delete' => __('Delete', $this->plugin_name),
			'bulk-read'   => __('Mark as read', $this->plugin_name),
		);

		return $actions;
	}


    /**
     * Handles data query and filter, sorting, and pagination.
     */
    public function prepare_items() {

        $this->_column_headers = $this->get_column_info();

        /** Process bulk action */
        $this->process_bulk_action();

        $per_page     = $this->get_items_per_page( 'poll_all_results_per_page', 50 );

        $current_page = $this->get_pagenum();
        $total_items  = self::record_count();

        $this->set_pagination_args( array(
            'total_items' => $total_items, //WE have to calculate the total number of items
            'per_page'    => $per_page //WE have to determine how many items to show on a page
        ) );

        $this->items = self::get_reports( $per_page, $current_page );
    }

    public function process_bulk_action() {
        //Detect when a bulk action is being triggered...
        $message = 'deleted';
        if ( 'delete' === $this->current_action() ) {

            // In our file that handles the request, verify the nonce.
            $nonce = esc_attr( $_REQUEST['_wpnonce'] );

            if ( ! wp_verify_nonce( $nonce, $this->plugin_name . '-delete-result' ) ) {
                die( 'Go get a life script kiddies' );
            }
            else {
                self::delete_reports( absint( $_GET['result'] ) );

                // $read_ids = esc_sql($_POST['bulk-action']);
                // foreach ( $read_ids as $id ) {
                //     echo $id . "<br>";
                //     self::mark_as_read_reports($id);
                // }

                // esc_url_raw() is used to prevent converting ampersand in url to "#038;"
                // add_query_arg() return the current url

                $url = esc_url_raw( remove_query_arg(array('action', 'result', '_wpnonce')  ) ) . '&status=' . $message;
                wp_redirect( $url );
            }

        }

        // If the delete bulk action is triggered
        if ( ( isset( $_POST['action'] ) && $_POST['action'] == 'bulk-delete' )
            || ( isset( $_POST['action2'] ) && $_POST['action2'] == 'bulk-delete' )
        )  {

            $delete_ids = esc_sql( $_POST['bulk-delete'] );

            // loop over the array of record IDs and delete them
            foreach ( $delete_ids as $id ) {
                self::delete_reports( $id );

            }

            // esc_url_raw() is used to prevent converting ampersand in url to "#038;"
            // add_query_arg() return the current url
            $message = 'deleted';
            $url = esc_url_raw( remove_query_arg(array('action', 'result', '_wpnonce')  ) ) . '&status=' . $message;
            wp_redirect( $url );
        } elseif ((isset($_POST['action']) && $_POST['action'] == 'bulk-read')
              || (isset($_POST['action2']) && $_POST['action2'] == 'bulk-read')
        ) {

            $read_ids = esc_sql( $_POST['bulk-delete'] );

            // loop over the array of record IDs and mark as read them
            foreach ( $read_ids as $id ) {
                // echo $id . "<br>";
                self::mark_as_read_reports($id);
            }

            // esc_url_raw() is used to prevent converting ampersand in url to "#038;"
            // add_query_arg() return the current url

            $message = 'read';
            $url     = esc_url_raw(remove_query_arg(['action', 'result', '_wpnonce'])) . '&status=' . $message;
            wp_redirect($url);
        }
    }

    public function results_notices(){
        $status = (isset($_REQUEST['status'])) ? sanitize_text_field( $_REQUEST['status'] ) : '';

        if ( empty( $status ) )
            return;

        if ( 'created' == $status )
            $updated_message = esc_html( __( 'Poll created.', $this->plugin_name ) );
        elseif ( 'updated' == $status )
            $updated_message = esc_html( __( 'Poll saved.', $this->plugin_name ) );
        elseif ( 'deleted' == $status )
            $updated_message = esc_html( __( 'Result(s) deleted.', $this->plugin_name ) );
        elseif ( 'read' == $status )
            $updated_message = esc_html( __( 'Result(s) marked as read.', $this->plugin_name) );

        if ( empty( $updated_message ) )
            return;

        ?>
        <div class="notice notice-success is-dismissible">
            <p> <?php echo $updated_message; ?> </p>
        </div>
        <?php
    }

    public function ays_poll_get_users(){
		global $wpdb;
		$users_sql = "SELECT user_id
		FROM {$wpdb->prefix}ayspoll_reports";
		$users_res = $wpdb->get_results($users_sql, 'ARRAY_A');
		$users = array();
		foreach($users_res as $key => $user){
			if(intval($user['user_id']) == 0){
				$name = __( 'Guests', $this->plugin_name );
			}else{
				$wpuser = get_userdata( intval($user['user_id']) );
				if($wpuser !== false){
					$name = $wpuser->data->display_name;
				}else{
					continue;
				}
			}
			$users[$user['user_id']] = $name;
		}
		return $users;
	}

}
