<?php
ob_start();

class Polls_List_Table extends WP_List_Table {
	public $themes;
	private $plugin_name;
	private $title_length;

	/** Class constructor */
	public function __construct( $plugin_name ) {
		$this->plugin_name = $plugin_name;
		$this->title_length = Poll_Maker_Ays_Admin::get_listtables_title_length('polls');
		parent::__construct(array(
			'singular' => __('Poll', $this->plugin_name), //singular name of the listed records
			'plural'   => __('Polls', $this->plugin_name), //plural name of the listed records
			'ajax'     => false, //does this table support ajax?
		));
		add_action('admin_notices', array($this, 'poll_notices'));
        add_filter( 'hidden_columns', array( $this, 'get_hidden_columns'), 10, 2 );
	}

	public function get_categories() {
		global $wpdb;
		$sql = "SELECT * FROM {$wpdb->prefix}ayspoll_categories";

		return $wpdb->get_results($sql, 'ARRAY_A');
	}

	public function display_tablenav( $which ) {
        ?>
        <div class="tablenav <?php echo esc_attr( $which ); ?>">
            
            <div class="alignleft actions">
                <?php  $this->bulk_actions( $which ); ?>
            </div>
            <?php
            $this->extra_tablenav( $which );
            $this->pagination( $which );
            ?>
            <br class="clear" />
        </div>
        <?php
	}
	
	public function extra_tablenav($which) {
		global $wpdb;
		$category_table = $wpdb->prefix . 'ayspoll_categories';
        $titles_sql = "SELECT ".$category_table.".title,".$category_table.".id FROM ".$category_table;
        $cat_titles = $wpdb->get_results($titles_sql);
        $cat_id = null;
        if( isset( $_GET['filterby'] )){
            $cat_id = intval($_GET['filterby']);
        }
        $categories_select = array();
        foreach($cat_titles as $key => $cat_title){
            $selected = "";
            if($cat_id === intval($cat_title->id)){
                $selected = "selected";
            }
            $categories_select[$cat_title->id]['title'] = $cat_title->title;
            $categories_select[$cat_title->id]['selected'] = $selected;
            $categories_select[$cat_title->id]['id'] = $cat_title->id;
        }
        sort($categories_select);
        ?>
        <div id="category-filter-div-polllist" class="alignleft actions bulkactions">
            <select name="filterby-<?php echo $which?>" id="bulk-action-selector-cat-<?php echo $which?>">
                <option value=""><?php echo __('Select Category',$this->plugin_name)?></option>
                <?php
                    foreach($categories_select as $key => $cat_title){
                        echo "<option ".$cat_title['selected']." value='".$cat_title['id']."'>".$cat_title['title']."</option>";
                    }
                ?>
            </select>
            <input type="button" id="doaction-<?php echo $which?>" class="cat-filter-apply-<?php echo $which;?> button" value="Filter">
        </div>
        
        <a style="margin: 0px 8px 0 0;" href="?page=<?php echo $_REQUEST['page'] ?>" class="button"><?php echo __( "Clear filters", $this->plugin_name ); ?></a>
        <?php
    }

	public function add_or_edit_polls( $data, $id = null, $ays_change_type = "" ) {
		global $allowedtags;
		$old_allowedtags = $allowedtags;
		$default_attribs = array(
			'id'    => array(),
			'class' => array(),
			'title' => array(),
			'style' => array(),
		);
		$allowedtags     = array(
			'div'        => $default_attribs,
			'span'       => $default_attribs,
			'p'          => $default_attribs,
			'a'          => array_merge($default_attribs, array(
				'href'   => array(),
				'target' => array('_blank', '_top'),
			)),
			'input'      => array_merge($default_attribs, array(
				'type'  => array(),
				'name'  => array(),
				'value' => array(),
			)),
			'textarea'   => array_merge($default_attribs, array(
				'type' => array(),
				'name' => array(),
			)),
			'u'          => $default_attribs,
			'i'          => $default_attribs,
			'q'          => $default_attribs,
			'b'          => $default_attribs,
			'ul'         => $default_attribs,
			'dl'         => $default_attribs,
			'ol'         => $default_attribs,
			'li'         => $default_attribs,
			'br'         => $default_attribs,
			'hr'         => $default_attribs,
			'strong'     => $default_attribs,
			'blockquote' => $default_attribs,
			'del'        => $default_attribs,
			'strike'     => $default_attribs,
			'em'         => $default_attribs,
			'code'       => $default_attribs,
		);
		global $wpdb;
		$poll_table   = $wpdb->prefix . 'ayspoll_polls';
		$answer_table = $wpdb->prefix . 'ayspoll_answers';
		if (isset($data["poll_action"]) && wp_verify_nonce($data["poll_action"], 'poll_action')) {
			$title                     = sanitize_text_field($data['ays-poll-title']);
			$show_title                = isset($data['ays_poll_show_title']) && 'show' == $data['ays_poll_show_title'] ? 1 : 0;
			$hide_results              = isset($data['ays-poll-hide-results']) && 'hide' == $data['ays-poll-hide-results'] ? 1 : 0;
			$hide_result_message       = isset($data['ays_poll_result_message']) && 'hide' == $data['ays_poll_result_message'] ? 1 : 0;
			$limit_users               = isset($data['apm_limit_users']) && $data['apm_limit_users'] == 'on' ? 1 : 0;
			$limit_users_method        = isset($data['ays_limit_method']) ? sanitize_text_field($data['ays_limit_method']) : 'ip';
			$limit_users_msg           = isset($data['ays_limitation_message']) ? wpautop($data['ays_limitation_message']) : "";
			$limit_users_url           = isset($data['ays_redirect_url']) ? wp_http_validate_url($data['ays_redirect_url']) : "";
			$limit_users_delay         = isset($data['ays_redirection_delay']) ? absint($data['ays_redirection_delay']) : 0;
			$limit_users_role_enable   = isset($data['ays_enable_restriction_pass']) && $data['ays_enable_restriction_pass'] == 'on' ? 1 : 0;
			$limit_users_role          = isset($data['ays_users_roles']) ? sanitize_text_field(implode(',', $data['ays_users_roles'])) : "";
			$limit_users_role_msg      = isset($data['restriction_pass_message']) ? wpautop($data['restriction_pass_message']) : "";
			$limit_users_logged_enable = (isset($data['ays_enable_logged_users']) && $data['ays_enable_logged_users'] == 'on') || $limit_users_role_enable ? 1 : 0;
			$limit_users_logged_msg    = isset($data['ays_enable_logged_users_message']) ? wpautop($data['ays_enable_logged_users_message']) : "";
			$hide_results_text         = wpautop($data['ays-poll-hide-results-text']);
			$ays_result_message        = stripcslashes($data['ays_result_message']);
			$allow_not_vote            = isset($data['ays-poll-allow-not-vote']) && 'allow' == $data['ays-poll-allow-not-vote'] ? 1 : 0;
			$show_social               = isset($data['ays-poll-show-social']) && 'show' == $data['ays-poll-show-social'] ? 1 : 0;
			$poll_social_buttons_heading = ( isset( $data[ 'ays_poll_social_buttons_heading' ] ) && $data[ 'ays_poll_social_buttons_heading' ] != '' ) ? wp_kses_post($data[ 'ays_poll_social_buttons_heading' ]) : '';
			$poll_show_social_ln       = isset($data['ays_poll_enable_linkedin_share_button']) && $data['ays_poll_enable_linkedin_share_button'] == "on" ? "on" : "off";
			$poll_show_social_fb	   = isset($data['ays_poll_enable_facebook_share_button']) && $data['ays_poll_enable_facebook_share_button'] == "on" ? "on" : "off";
			$poll_show_social_tr	   = isset($data['ays_poll_enable_twitter_share_button'])  && $data['ays_poll_enable_twitter_share_button']  == "on" ? "on" : "off";
			$poll_show_social_vk	   = isset($data['ays_poll_enable_vkontakte_share_button']) && $data['ays_poll_enable_vkontakte_share_button'] == "on" ? "on" : "off";
			$info_form                 = isset($data['ays_poll_info_form']) && $data['ays_poll_info_form'] == 'on' && !empty($data['ays-poll-form-fields']) ? 1 : 0;
			$form_fields               = isset($data['ays-poll-form-fields']) && is_array($data['ays-poll-form-fields']) ? implode(',', $data['ays-poll-form-fields']) : "";
			$form_required_fields      = isset($data['ays-poll-form-required-fields']) && is_array($data['ays-poll-form-required-fields']) ? implode(',', $data['ays-poll-form-required-fields']) : "";
			$info_form_title           = isset($data['ays-poll-info-form-text']) ? wpautop($data['ays-poll-info-form-text']) : "";
			$categories                = isset($data['ays-poll-categories']) ? ',' . implode(',', $data['ays-poll-categories']) . ',' : ',1,';
			$description               = sanitize_textarea_field($data['ays-poll-description']);
			$type                      = sanitize_text_field($data['ays-poll-type']);
			$question                  = wpautop($data['ays_poll_question']);
			$image                     = wp_http_validate_url($data['ays_poll_image']);
			$theme_id                  = isset($data['ays_poll_theme']) && $data['ays_poll_theme'] != '' ? absint($data['ays_poll_theme']) : 1;
			$main_color                = sanitize_text_field($data['ays_poll_main_color']);
			$text_color                = sanitize_text_field($data['ays_poll_text_color']);
			$icon_color                = sanitize_text_field($data['ays_poll_icon_color']);
			$bg_color                  = sanitize_text_field($data['ays_poll_bg_color']);
			$answer_bg_color           = sanitize_text_field($data['ays_poll_answer_bg_color']);
			$answer_border_side        = isset($data['ays_poll_border_side']) ? sanitize_text_field($data['ays_poll_border_side']) : 'all_sides';
			$title_bg_color            = sanitize_text_field($data['ays_poll_title_bg_color']);
			// $poll_create_date          = !isset($data['ays_poll_ctrate_date']) ? '0000-00-00 00:00:00' : $data['ays_poll_ctrate_date'];
			$changed_creation_date     = (isset($data['ays_poll_change_creation_date']) && $data['ays_poll_change_creation_date'] != '') ? $data['ays_poll_change_creation_date'] : current_time( 'mysql' ) ;
			// $author = isset($data['ays_poll_author'])?stripslashes($data['ays_poll_author']) : '';
            // $author = json_decode($author, true);
			$author = isset($data['ays_poll_author']) ? $data['ays_poll_author'] : 0;

            // Change the author of the current poll
            $poll_create_author = ( isset($data['ays_poll_create_author']) && $data['ays_poll_create_author'] != "" ) ? absint( sanitize_text_field( $data['ays_poll_create_author'] ) ) : "";

            if ( $poll_create_author != "" && $poll_create_author > 0 ) {
                $user = get_userdata($poll_create_author);
                if ( ! is_null( $user ) && $user ) {
                    $poll_author = array(
                        'id' => $user->ID."",
                        'name' => $user->data->display_name
                    );

                    $author = $poll_author['id'];
                } else {
                    $poll_create_author = (isset( $author ) && $author != "") ? absint( sanitize_text_field( $author ) ) : get_current_user_id();
                }
            }

			$bg_image                  = wp_http_validate_url($data['ays_poll_bg_image']);
			$randomize_answers         = !isset($data['randomize_answers']) ? "off" : $data['randomize_answers'];
			$enable_asnwers_sound      = !isset($data['ays_poll_enable_asnwers_sound']) ? "off" : $data['ays_poll_enable_asnwers_sound'];
			$icon_size                 = absint($data['ays_poll_icon_size']) >= 10 ? absint($data['ays_poll_icon_size']) : 24;
			$width                     = absint($data['ays_poll_width']);
			$width_for_mobile        = ( isset( $data['ays_poll_width_for_mobile'] ) && $data['ays_poll_width_for_mobile'] != '' ) ? absint($data['ays_poll_width_for_mobile']) : 0;
			$btn_text                  = sanitize_text_field($data['ays_poll_btn_text']);
			$see_res_btn_text          = sanitize_text_field($data['ays_poll_res_btn_text']);
			$border_style              = sanitize_text_field($data['ays_poll_border_style']);
			$border_radius             = sanitize_text_field($data['ays_poll_border_radius']);
			$border_width              = sanitize_text_field($data['ays_poll_border_width']);
			$box_shadow_color          = sanitize_text_field($data['ays_poll_box_shadow_color']);
			//Gradient Aro
			$enable_background_gradient    = !isset($data['ays_enable_background_gradient']) ? "off" : $data['ays_enable_background_gradient'];
			$background_gradient_color_1   = sanitize_text_field($data['ays_background_gradient_color_1']);
			$background_gradient_color_2   = sanitize_text_field($data['ays_background_gradient_color_2']);
			$poll_gradient_direction       = sanitize_text_field($data['ays_poll_gradient_direction']);

			// Poll background size Xcho
			$background_size       		   = sanitize_text_field($data['ays_poll_background_size']);

			// Redirect after submit
            $redirect_after_submit = ( isset( $data['ays_redirect_after_submit'] ) && $data['ays_redirect_after_submit'] == 'on' ) ? 1 : 0;
            $submit_redirect_url = !isset($data['ays_submit_redirect_url']) ? '' : $data['ays_submit_redirect_url'];

			$enable_box_shadow         = !isset($data['ays_poll_enable_box_shadow']) ? "off" : $data['ays_poll_enable_box_shadow'];
			$enable_answer_style       = isset($data['ays_poll_enable_answer_style']) && $data['ays_poll_enable_answer_style'] == "on" ? sanitize_text_field($data['ays_poll_enable_answer_style']) : "";
			$load_effect               = sanitize_text_field($data['ays-poll-load-effect']);
			$load_gif                  = isset($data['ays-poll-load-gif']) && !empty($data['ays-poll-load-gif']) ? sanitize_text_field($data['ays-poll-load-gif']) : 'plg_pro1';
			$custom_load               = isset($data['ays_poll_custom_load']) ? wp_http_validate_url($data['ays_poll_custom_load']) : "";
			$notify_on                 = isset($data['ays_notify_by_email_on']) && $data['ays_notify_by_email_on'] == 'on' ? 1 : 0;
			// $notify_email              = isset($data['ays_notify_email']) && !empty($data['ays_notify_email']) ? sanitize_email($data['ays_notify_email']) : get_option('admin_email');
			$published                 = absint(intval($data['ays_publish']));
			$enable_pass_count         = !isset($data['ays_enable_pass_count']) ? null : $data['ays_enable_pass_count'];
			$result_sort_type          = sanitize_text_field($data['ays-poll-result-sort-type']);
			$redirect_users            = isset($data['ays_redirect_after_vote']) && $data['ays_redirect_after_vote'] == 'on' ? 1 : 0;
			$redirect_after_vote_url   = isset($data['redirection_url']) ? wp_http_validate_url($data['redirection_url']) : "";
			$redirect_after_vote_delay = isset($data['redirection_delay']) ? absint($data['redirection_delay']) : 0;
			$activeInterval_full       = isset($data['ays-active']) ? $data['ays-active'] : "";
			$activeInterval_fullArr    = explode(" ",$activeInterval_full);
			$activeInterval            = isset($activeInterval_fullArr[0]) ? $activeInterval_fullArr[0] : "";
			$activeIntervalSec         = isset($activeInterval_fullArr[1]) ? $activeInterval_fullArr[1] : "";

			$deactiveInterval_full       = isset($data['ays-deactive']) ? $data['ays-deactive'] : "";
			$deactiveInterval_fullArr    = explode(" ",$deactiveInterval_full);
			$deactiveInterval            = isset($deactiveInterval_fullArr[0]) ? $deactiveInterval_fullArr[0] : "";
			$deactiveIntervalSec         = isset($deactiveInterval_fullArr[1]) ? $deactiveInterval_fullArr[1] : "";
			$active_date_message       = wpautop($data['active_date_message']);
			$active_date_message_soon  = wpautop($data['active_date_message_soon']);
			$vote_reason               = isset($data['ays-poll-reason']) ? 1 : 0;
			$show_result_view          = isset($data['ays_poll_show_result_view']) ? $data['ays_poll_show_result_view'] : 'standart';
			$css                       = stripcslashes($data['ays_custom_css']);
			$active_date_check         = isset($data['active_date_check']) && !empty($data['active_date_check']) ? $data['active_date_check'] : '';
			$enable_restart_button     = isset($data['ays_enable_restart_button']) && 'on' == $data['ays_enable_restart_button'] ? 1 : 0;
			$enable_vote_btn           = isset($data['ays_enable_vote_button']) && 1 == $data['ays_enable_vote_button'] ? 1 : 0;
			$show_votes_count          = isset($data['show_votes_count']) && 1 == $data['show_votes_count'] ? 1 : 0;
            $ays_attempts_count = (isset($data['ays_attempts_count']) && $data['ays_attempts_count'] != '') ? $data['ays_attempts_count'] : 1;
			$ays_allow_anonymity       = isset($data['ays_allow_anonymity']) && 1 == $data['ays_allow_anonymity'] ? 1 : 0;
			$show_create_date          = isset($data['show_poll_creation_date']) && 1 == $data['show_poll_creation_date'] ? 1 : 0;
			$show_author          	   = ( isset($data['show_poll_author']) && $data['show_poll_author'] == '1' ) ? 1 : 0;
			$show_res_percent          = isset($data['show_res_percent']) && 1 == $data['show_res_percent'] ? 1 : 0;
			$show_result_btn_schedule  = isset($data['show_result_btn_schedule']) && 1 == $data['show_result_btn_schedule'] ? 1 : 0;
			$ays_poll_show_timer  	   = isset($data['ays_poll_show_timer']) && 1 == $data['ays_poll_show_timer'] ? 1 : 0;
			$ays_show_timer_type  	   = isset($data['ays_show_timer_type']) && !empty($data['ays_show_timer_type']) ? $data['ays_show_timer_type'] : 'countdown';		
			$user_add_answer           = (isset($data['apm_allow_add_answers']) && $data['apm_allow_add_answers'] == 'allow') ? 1 : 0;
			$add_answers_not_show_up   = (isset($data['add_answers_not_show_up']) && $data['add_answers_not_show_up'] == 'allow') ? 1 : 0;
			$versus_icon_type          = isset($data['versus-icon-type']) && $data['versus-icon-type'] ? sanitize_text_field($data['versus-icon-type']) : "default";
			$versus_icon_position      = isset($data['versus-icon-position']) && $data['versus-icon-position'] ? sanitize_text_field($data['versus-icon-position']) : "center";
			$versus_answers_label      = (isset($data['versus-show-label']) && $data['versus-show-label'] == 'show') ? 1 : 0;
			$result_in_rgba            = isset($data['ays-poll-res-rgba']) && $data['ays-poll-res-rgba'] == 'on' ? 1 : 0;
			$allow_multivote           = isset($data['ays_poll_allow_multivote']) && $data['ays_poll_allow_multivote'] == 'on' ? "on" : "off";
			$multivote_answer_min_count    = (isset($data['ays_poll_multivote_min_count']) && $data['ays_poll_multivote_min_count'] != '') ? sanitize_text_field($data['ays_poll_multivote_min_count']) : '';
			$multivote_answer_max_count    = (isset($_POST['ays_poll_multivote_max_count']) && $_POST['ays_poll_multivote_max_count'] != '') ? sanitize_text_field($_POST['ays_poll_multivote_max_count']) : '';
			$poll_direction            = isset($data['ays_poll_direction']) && $data['ays_poll_direction'] != '' ? sanitize_text_field($data['ays_poll_direction']) : 'ltr';

			///////////////////////////////////////////////////////////////
			//-------------------- Developer Package --------------------//
			//////////////////////////// Start ////////////////////////////

			// Enable copy protection
			$poll_enable_copy_protection = (isset($data['ays_poll_enable_copy_protection']) && $data['ays_poll_enable_copy_protection'] == 'on') ? 'on' : 'off';

			///////////////////////////////////////////////////////////////
			//-------------------- Developer Package --------------------//
			////////////////////////////  End  ////////////////////////////

            // MailChimp
            $enable_mailchimp          = isset($data['ays_enable_mailchimp']) && $data['ays_enable_mailchimp'] == 'on' ? "on": "off";
            $mailchimp_list             = !isset($data['ays_mailchimp_list'])?"":$data['ays_mailchimp_list'];

            // Campaign Monitor
            $monitor_list   = !isset($data['ays_monitor_list']) ? "" : $data['ays_monitor_list'];
            $enable_monitor = isset($data['ays_enable_monitor']) && $data['ays_enable_monitor'] == "on" ? "on" : "off";

            // Slack
            $slack_conversation = !isset($data['ays_slack_conversation']) ? "" : $data['ays_slack_conversation'];
            $enable_slack       = isset($data['ays_enable_slack']) && $data['ays_enable_slack'] == "on" ? "on" : "off";

            // ActiveCampaign
            $active_camp_list       = !isset($data['ays_active_camp_list']) ? "" : $data['ays_active_camp_list'];
            $active_camp_automation = !isset($data['ays_active_camp_automation']) ? "" : $data['ays_active_camp_automation'];
            $enable_active_camp     = isset($data['ays_enable_active_camp']) && $data['ays_enable_active_camp'] == "on" ? "on" : "off";

            //Zapier
            $enable_zapier = isset($data['ays_enable_zapier']) && $data['ays_enable_zapier'] == "on" ? "on" : "off";

            // Google Sheets
            $get_sheets = $this->get_poll_by_id($id);
            $sheet_id = isset($get_sheets['styles']) ? $get_sheets['styles'] : array();

			// Mad mimi
			$enable_mad_mimi = isset($data['ays_poll_enable_mad_mimi']) && $data['ays_poll_enable_mad_mimi'] == "on" ? "on" : "off";
			$mad_mimi_list   = isset($data['ays_poll_mad_mimi_list']) && $data['ays_poll_mad_mimi_list'] != "" ? sanitize_text_field($data['ays_poll_mad_mimi_list']) : "";

			// GetResponse
			$enable_getResponse = isset($data['ays_poll_enable_getResponse']) && $data['ays_poll_enable_getResponse'] == "on" ? "on" : "off";
			$getResponse_list   = isset($data['ays_poll_getResponse_list']) && $data['ays_poll_getResponse_list'] ? sanitize_text_field($data['ays_poll_getResponse_list']) : "";
			
			// ConvertKit
			$poll_enable_convertKit  = (isset($data['ays_poll_enable_convertkit']) && $data['ays_poll_enable_convertkit'] == "on") ? "on" : 'off';
			$poll_convertKit_form_id = (isset($data['ays_poll_convertKit_list']) && $data['ays_poll_convertKit_list'] != "") ? sanitize_text_field($data['ays_poll_convertKit_list']) : '';
			
            
            $old_sheet_id         = isset($sheet_id['spreadsheet_id']) && $sheet_id['spreadsheet_id'] != '' ? $sheet_id['spreadsheet_id'] : '';
            $check_sheet_id       = isset($sheet_id['spreadsheet_id']) && $sheet_id['spreadsheet_id'] != '' ? true : false;

            $enable_google_sheets = isset($data['ays_poll_enable_google']) && $data['ays_poll_enable_google'] == "on" ? "on" : "off";
            $check_sheet_on_off = isset($data['ays_poll_enable_google']) && $data['ays_poll_enable_google'] == "on" ? true : false;
            $google_res           = (Poll_Maker_Settings_Actions::ays_get_setting('google_sheet') === false) ? json_encode(array()) : Poll_Maker_Settings_Actions::ays_get_setting('google_sheet');
            $google               = json_decode($google_res, true);
            $google_client        = isset($google['client']) ? $google['client'] : '';
            $google_secret        = isset($google['secret']) ? $google['secret'] : '';
            $google_token         = isset($google['token']) ? $google['token'] : '';
            $google_refresh_token = isset($google['refresh_token']) ? $google['refresh_token'] : '';
            $this_poll_title      = isset($get_sheets['title']) && $get_sheets['title'] != '' ? $get_sheets['title'] : $title;
            $spreadsheet_id = '';
            $google_data = array(
            	'refresh_token' => $google_refresh_token,
            	'google_client' => $google_client,
            	'google_secret' => $google_secret,
            	'poll_title'    => $this_poll_title,
            	'id'            => $id
            );
            if(!$check_sheet_id && $check_sheet_on_off){
                $spreadsheet_id  = Poll_Maker_Ays_Admin::ays_poll_get_google_sheet_id($google_data);
            }else{
                if($old_sheet_id != ''){
                    $spreadsheet_id = $old_sheet_id;
                }
            }

            // Show login form for not logged in users
            $show_login_form = (isset($data['ays_show_login_form']) && $data['ays_show_login_form'] == "on" && $limit_users_logged_enable == 1) ? 'on' : 'off';

            // Disable answer hover 
            $disable_answer_hover = (isset($data['ays_disable_answer_hover']) && $data['ays_disable_answer_hover'] == 'on') ? 1 : 0;

            // Show answers caption
            $show_answers_caption = (isset($data['ays_poll_show_answers_caption']) && $data['ays_poll_show_answers_caption'] == 'on') ? 'on' :'off';

            // Show answers icon
            $show_answers_icon = (isset($data['ays_poll_show_answers_icon']) && $data['ays_poll_show_answers_icon'] == 'on') ? 'on' :'off';
            $answers_icon = isset($data['ays_poll_answer_icon']) ? $data['ays_poll_answer_icon'] :'radio';

             // Xcho Password for Poll
            $enable_password = isset($data['ays_enable_password']) && $data['ays_enable_password'] == 'on' ? 'on' : 'off';
			$password_poll = (isset($data['ays_password_poll']) && $data['ays_password_poll'] != '') ? $data['ays_password_poll'] : '';
			$poll_password_message = ( isset($data['ays_poll_password_message']) && $data['ays_poll_password_message'] != "" ) ? wp_kses_post($data['ays_poll_password_message']) : "Please enter password";
			// Enable toggle password visibility
			$poll_enable_password_visibility = (isset($data['ays_poll_enable_password_visibility']) && $data['ays_poll_enable_password_visibility'] == 'on') ? 'on' : 'off';


			// Add post for poll
			 $ays_add_post_for_poll = isset($data['ays_add_post_for_poll']) && $data['ays_add_post_for_poll'] == 'on' ? 'on' : 'off';
			 
			 // Add answer table
			 $answers_message = isset($data['ays_answer_message']) && !empty($data['ays_answer_message']) ? $data['ays_answer_message'] : array();
			 $answers_id = !empty($data['ays_answer_id']) ?  implode(',' , $data['ays_answer_id']) : "";
			 $answer_image = !empty($data['interval_image']) ? implode(',' , $data['interval_image']) : "";
			 $ays_answer_message_check = isset($data['ays_show_answer_message']) && $data['ays_show_answer_message'] == "on" ? "on" : "off";

			// Limitation tackers of poll
            $enable_tackers_count = (isset($data['ays_enable_tackers_count']) && $data['ays_enable_tackers_count'] == 'on') ? 'on' : 'off';
            $tackers_count = (isset($data['ays_tackers_count']) && $data['ays_tackers_count'] != '') ? $data['ays_tackers_count'] : '';

			// Vote Limitation
            $enable_vote_limitation      = (isset($data['ays_enable_vote_limitation']) && $data['ays_enable_vote_limitation'] == 'on') ? 'on' : 'off';
			$vote_limitation             = (isset($data['ays_vote_limitation']) && $data['ays_vote_limitation'] != '') ? absint(intval(sanitize_text_field($data['ays_vote_limitation']))) : '';
			// $vote_limit_message          = isset($data['vote_limit_message']) ? wpautop($data['vote_limit_message']) : "";			
			$vote_limitation_time_period = (isset($data['ays_vote_limitation_time_period']) && $data['ays_vote_limitation_time_period'] != '') ? sanitize_text_field($data['ays_vote_limitation_time_period']) : '';

			//Email msg after vote
			$enable_email_msg_after_vote  = (isset($data['ays_enable_mail_user']) && $data['ays_enable_mail_user'] == 'on') ? 'on' : 'off';
			$vote_msg_email= isset($data['vote_notification_email_msg']) ? wpautop($data['vote_notification_email_msg']) : "";

			//Custom_class
			$custom_class = (isset($data['ays_poll_custom_class']) && $data['ays_poll_custom_class'] != '') ? $data['ays_poll_custom_class'] : '';

			// Bg image positioning
            $poll_bg_image_position = (isset($data['ays_poll_bg_image_position']) && $data['ays_poll_bg_image_position'] != "") ? $data['ays_poll_bg_image_position'] : 'center center';
            $poll_bg_img_in_finish_page = (isset($data['ays_poll_bg_img_in_finish_page']) && $data['ays_poll_bg_img_in_finish_page'] != "") ? $data['ays_poll_bg_img_in_finish_page'] : 'off';

			// Ani =========== Buttons Styles Start ===========

            // Buttons size
            $buttons_size = (isset($data['ays_buttons_size']) && $data['ays_buttons_size'] != "") ? $data['ays_buttons_size'] : 'medium';

            // Buttons font size
            $buttons_font_size = (isset($data['ays_buttons_font_size']) && $data['ays_buttons_font_size'] != "") ? $data['ays_buttons_font_size'] : '17';

			// Buttons mobile font size
			$poll_buttons_mobile_font_size = (isset($data['ays_poll_buttons_mobile_font_size']) && $data['ays_poll_buttons_mobile_font_size'] != "") ? sanitize_text_field($data['ays_poll_buttons_mobile_font_size']) : '17';

            // Buttons Left / Right padding
            $buttons_left_right_padding = (isset($data['ays_buttons_left_right_padding']) && $data['ays_buttons_left_right_padding'] != "") ? $data['ays_buttons_left_right_padding'] : '20';

            // Buttons Top / Bottom padding
            $buttons_top_bottom_padding = (isset($data['ays_buttons_top_bottom_padding']) && $data['ays_buttons_top_bottom_padding'] != "") ? $data['ays_buttons_top_bottom_padding'] : '10';

            // Buttons padding
            $buttons_border_radius = (isset($data['ays_buttons_border_radius']) && $data['ays_buttons_border_radius'] != "") ? $data['ays_buttons_border_radius'] : '3';

			// =========== Buttons Styles End ===========
			
			//dropdown type
            $redirect_after_submit_drpdwn = ( isset( $data['ays_redirect_after_submit_dropdown'] ) && $data['ays_redirect_after_submit_dropdown'] == 'on' ) ? 1 : 0;
			$dropdown_submit_redirect_url = !isset($data['ays_dropdown_submit_redirect_url']) ? '' : $data['ays_dropdown_submit_redirect_url'];
			$user_add_answer_dropdown = (isset($data['apm_allow_add_answers_dropdown']) && $data['apm_allow_add_answers_dropdown'] == 'allow') ? 1 : 0;

			// Enable View more button
            $enable_view_more_button = (isset($data['ays_enable_view_more_button']) && $data['ays_enable_view_more_button'] == 'on' ) ? 'on' : 'off';
            $poll_view_more_button_count = (isset($data['ays_poll_view_more_button_count']) && $data['ays_poll_view_more_button_count'] != '' ) ? absint(intval($data['ays_poll_view_more_button_count'])) : 0;

            // Poll Min Height
            $poll_min_height = (isset($data['ays_poll_min_height']) && $data['ays_poll_min_height'] != '') ? absint(intval($data['ays_poll_min_height'])) : '';

            // Poll answer ordering
			$poll_answer_ordering = (isset($data['ays_answers_sort_select']) && $data['ays_answers_sort_select'] != '') ? sanitize_text_field($data['ays_answers_sort_select']) : '';

			// Answers font size
			$poll_answer_font_size = (isset($data['ays_answer_font_size']) && $data['ays_answer_font_size'] != '') ? sanitize_text_field($data['ays_answer_font_size']) : '16';

			// Poll answers font size on mobile
			$poll_answer_font_size_mobile  = (isset($data['ays_poll_answer_font_size_mobile']) && $data['ays_poll_answer_font_size_mobile'] != '') ? sanitize_text_field($data['ays_poll_answer_font_size_mobile']) : '16';
			
			// Poll show passed users in result page
			$poll_show_passed_users = (isset($data['ays_poll_show_users']) && $data['ays_poll_show_users'] == 'on') ? 'on' : 'off';
			$poll_show_passed_users = sanitize_text_field($poll_show_passed_users);

			// // Poll Logo image
			$poll_logo_image = (isset($data['ays_poll_logo_image']) && $data['ays_poll_logo_image'] != '') ? sanitize_url($data['ays_poll_logo_image']) : '';

			//Open Logo Url in new tab
			$poll_logo_url_new_tab = (isset( $data[ 'ays_poll_logo_enable_image_url_new_tab' ] ) && $data[ 'ays_poll_logo_enable_image_url_new_tab' ] == 'on') ? "on" : 'off';

			// Allow collect user information
			$poll_allow_collect_info = (isset($data['ays_allow_collecting_logged_in_users_data']) && $data['ays_allow_collecting_logged_in_users_data'] == 'on') ? 'on' : 'off';

			// Send mail type Custom / SendGrid
			$poll_send_mail_type = (isset($data['ays_poll_send_mail_type']) && $data['ays_poll_send_mail_type'] != '') ? sanitize_text_field( $data['ays_poll_send_mail_type'] ) : 'custom';

			// SendGrid mail Name
			$poll_sendgrid_email_name = (isset($data['ays_poll_sendgrid_email_name']) && $data['ays_poll_sendgrid_email_name'] != '') ? sanitize_text_field( $data['ays_poll_sendgrid_email_name'] ) : '';
			
			// SendGrid mail From
			$poll_sendgrid_email_from = (isset($data['ays_poll_sendgrid_email_from']) && $data['ays_poll_sendgrid_email_from'] != '') ? sanitize_email( $data['ays_poll_sendgrid_email_from'] ) : '';

			// SendGrid template id
			$poll_sendgrid_template_id = (isset($data['ays_poll_sendgrid_template_id']) && $data['ays_poll_sendgrid_template_id'] != '') ? $data['ays_poll_sendgrid_template_id'] : '';

			//limit user by country
			$enable_limit_by_country = (isset($data['ays_enable_limit_by_country']) && $data['ays_enable_limit_by_country'] == 'on' ) ? 'on' : "off";
			$limit_country = (isset($data['ays_poll_limit_country']) && $data['ays_poll_limit_country'] != "") ? stripslashes ( sanitize_text_field( $data['ays_poll_limit_country']) ) : '';

			// Add fake votes 
			$ays_fake_votes = (isset($data['ays_add_f_votes']) && $data['ays_add_f_votes'] == "on") ? 'on' : 'off';
			$fake_votes_values   = (isset($data['ays_f_votes_count']) && !empty($data['ays_f_votes_count'])) ? $data['ays_f_votes_count'] : array();

			// =========== Answer Styles start == / Ani / =========
			
			// Answers padding option
			$answers_padding = (isset($data['ays_answers_padding']) && $data['ays_answers_padding'] != '') ? absint( intval( $data['ays_answers_padding'] ) ) : '10';

			// Answers margin option
			$answers_margin = (isset($data['ays_answers_margin']) && $data['ays_answers_margin'] != '') ? absint( intval( $data['ays_answers_margin'] ) ) : '10';

			// Answers border options
			$answers_border = (isset($data['ays_answers_border']) && $data['ays_answers_border'] == 'on') ? 'on' : 'off';
			$answers_border_width = (isset($data['ays_answers_border_width']) && $data['ays_answers_border_width'] != '') ? absint( intval( $data['ays_answers_border_width'] ) ) : '1';
			$answers_border_style = (isset($data['ays_answers_border_style']) && $data['ays_answers_border_style'] != '') ? sanitize_text_field( $data['ays_answers_border_style'] ) : 'solid';
			$answers_border_color = (isset($data['ays_answers_border_color']) && $data['ays_answers_border_color'] != '') ? sanitize_text_field( $data['ays_answers_border_color'] ) : '';

			$answers_box_shadow = (isset($data['ays_answers_box_shadow']) && $data['ays_answers_box_shadow'] == 'on') ? 'on' : 'off';
			$answers_box_shadow_color = (isset($data['ays_answers_box_shadow_color']) && $data['ays_answers_box_shadow_color'] != '') ? sanitize_text_field( $data['ays_answers_box_shadow_color'] ) : '#000';
			$poll_answer_box_shadow_x_offset  = (isset($data['ays_poll_answer_box_shadow_x_offset']) && $data['ays_poll_answer_box_shadow_x_offset'] != "") ? intval($data['ays_poll_answer_box_shadow_x_offset']) : 0;

			$poll_answer_box_shadow_y_offset  = (isset($data['ays_poll_answer_box_shadow_y_offset']) && $data['ays_poll_answer_box_shadow_y_offset'] != "") ? intval($data['ays_poll_answer_box_shadow_y_offset']) : 0;

			$poll_answer_box_shadow_z_offset  = (isset($data['ays_poll_answer_box_shadow_z_offset']) && $data['ays_poll_answer_box_shadow_z_offset'] != "") ? intval($data['ays_poll_answer_box_shadow_z_offset']) : 10;

			// Answers image options
			$ans_img_height = (isset($data['ays_ans_img_height']) && $data['ays_ans_img_height'] != '') ? absint(intval( $data['ays_ans_img_height'] ) ) : '150';
			// Poll answer image height for mobile
			$poll_answer_image_height_for_mobile = (isset($data['ays_poll_answer_image_height_for_mobile']) && $data['ays_poll_answer_image_height_for_mobile'] != "") ? sanitize_text_field($data['ays_poll_answer_image_height_for_mobile']) : "150";
			if($poll_answer_image_height_for_mobile == '0'){
				$poll_answer_image_height_for_mobile = "150";
			}			
			$ans_img_caption_style = (isset($data['ays_ans_img_caption_style']) && $data['ays_ans_img_caption_style'] != '') ? sanitize_text_field( $data['ays_ans_img_caption_style'] ) : 'outside';
			$ans_img_caption_position = (isset($data['ays_ans_img_caption_position']) && $data['ays_ans_img_caption_position'] != '') ? sanitize_text_field( $data['ays_ans_img_caption_position'] ) : 'bottom';

			// Question Font Size
			$question_font_size = (isset($data['ays_poll_answers_font_size_pc']) && $data['ays_poll_answers_font_size_pc'] != '') ? absint( intval( $data['ays_poll_answers_font_size_pc']) ) : '16';

			// Question Font Size mobile
			$question_font_size_mobile = (isset($data['ays_poll_answers_font_size_mobile']) && $data['ays_poll_answers_font_size_mobile'] != '') ? absint( intval( $data['ays_poll_answers_font_size_mobile']) ) : '16';
			
			// Poll question image height
			$poll_question_image_height = isset($data['ays_poll_question_image_height']) && $data['ays_poll_question_image_height'] != "" ? abs(sanitize_text_field($data['ays_poll_question_image_height'])) : "";
			
			//Answers font size
			$answers_font_size = (isset($data['ays_answers_font_size']) && $data['ays_answers_font_size'] != '') ? absint( intval( $data['ays_answers_font_size'] ) ) : '15';

			// Object fit for answer images
			$answers_object_fit = (isset($data['ays_answers_object_fit']) && $data['ays_answers_object_fit'] != '') ? sanitize_text_field( $data['ays_answers_object_fit'] ) : 'cover';
			
			//answers grid column
			$answers_grid_column = (isset($data['ays_answers_grid_column']) && $data['ays_answers_grid_column'] != '') ? absint( intval( $data['ays_answers_grid_column'] ) ) : '2';
			
			//answers border radius
			$answers_border_radius = (isset($data['ays_answers_border_radius']) && $data['ays_answers_border_radius'] != '') ? absint( intval( $data['ays_answers_border_radius'] ) ) : '0';

			// =========== Answer Styles End == / Ani / =========

			// Show votes count per answers before voting
			$show_votes_before_voting = (isset($data['ays_show_votes_before_voting']) && $data['ays_show_votes_before_voting'] == 'on') ? 'on' : 'off';
			$show_votes_before_voting_by = (isset($data['ays_show_votes_before_voting_by']) && $data['ays_show_votes_before_voting_by'] != '') ? $data['ays_show_votes_before_voting_by'] : 'by_count';

			// ==== ADDED NEW ====
			// Poll schedule container on/off
			$poll_show_container = (isset($data['ays_show_poll_container']) && $data['ays_show_poll_container'] == 'on') ? 'on' : 'off';

			// Poll see results button in limitations
			$poll_see_result_button = (isset($data['ays_see_result_show']) && $data['ays_see_result_show'] == 'on') ? 'on' : 'off';
			$poll_see_result_radio  = (isset($data['ays_poll_see_result_show']) && $data['ays_poll_see_result_show'] != '') ? sanitize_text_field($data['ays_poll_see_result_show']) : '';

			// loader font size 
			$poll_loader_font_size = (isset($data['ays_loader_font_size']) && $data['ays_loader_font_size'] != '') ? sanitize_text_field($data['ays_loader_font_size']) : '';
			if(intval($poll_loader_font_size) <= 0){
				$poll_loader_font_size = '';
			}

			// Show answers numbering
			$show_answers_numbering = (isset($_POST['ays_poll_show_answers_numbering']) && sanitize_text_field( $_POST['ays_poll_show_answers_numbering']) != '') ? sanitize_text_field( $_POST['ays_poll_show_answers_numbering'] ) : 'none';

			// Poll load effect message
			$poll_effect_message = (isset($data['ays_poll_load_effect_message']) && $data['ays_poll_load_effect_message'] != '') ? sanitize_text_field($data['ays_poll_load_effect_message']) : '';

			// Poll show avatars count
			$poll_show_passed_users_count = (isset($data['ays_poll_show_users_count']) && $data['ays_poll_show_users_count'] != '') ? intval(sanitize_text_field($data['ays_poll_show_users_count'])) : 3;

			// Show Answers image after voting
			if(empty(array_filter($data['apm-answers-images']))){
				$data['ays_poll_enable_answer_image_after_voting'] = 'off';
			}			

			$poll_enable_answer_image_after_voting = isset($data['ays_poll_enable_answer_image_after_voting']) && $data['ays_poll_enable_answer_image_after_voting'] == "on" ? "on" : "off"; 
			

			// Additional emails | Notify email
			$notify_email = "";
			if( isset( $data['ays_notify_email'] ) ) {
				if(!empty( $data['ays_notify_email'] )) {
					$additional_emails_arr = explode(",", $data['ays_notify_email'] );
					foreach($additional_emails_arr as $email) {
						$email = stripslashes(trim($email));
						if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
							$notify_email .= $email.", ";
						}
					}
					$notify_email = substr($notify_email, 0, -2);
				}
			}

			// Send mail to super Admin
			$poll_send_mail_to_site_admin = ( isset( $data['ays_poll_send_mail_to_site_admin'] ) && $data['ays_poll_send_mail_to_site_admin'] == 'on' ) ? 'on' : 'off';

			//Email Message
			$poll_mail_message_admin = (isset($data['ays_poll_mail_message_admin']) && $data['ays_poll_mail_message_admin'] != '') ? $data['ays_poll_mail_message_admin'] : '';
			// Subject
			$poll_admin_email_subject = (isset( $_POST[ 'ays_poll_admin_email_subject' ] ) && $_POST[ 'ays_poll_admin_email_subject' ] != '') ? stripslashes ( sanitize_text_field( $_POST[ 'ays_poll_admin_email_subject' ] ) ) : '';

			//---- Email configuration Start  ---- //

			// From email
			$poll_email_configuration_from_email = (isset( $_POST[ 'ays_poll_email_configuration_from_email' ] ) && $_POST[ 'ays_poll_email_configuration_from_email' ] != '') ? stripslashes ( sanitize_email( $_POST[ 'ays_poll_email_configuration_from_email' ] ) ) : '';
			// From name
			$poll_email_configuration_from_name = (isset( $_POST[ 'ays_poll_email_configuration_from_name' ] ) && $_POST[ 'ays_poll_email_configuration_from_name' ] != '') ? stripslashes ( sanitize_text_field( $_POST[ 'ays_poll_email_configuration_from_name' ] ) ) : '';
			// Subject
			$poll_email_configuration_from_subject = (isset( $_POST[ 'ays_poll_email_configuration_from_subject' ] ) && $_POST[ 'ays_poll_email_configuration_from_subject' ] != '') ? stripslashes ( sanitize_text_field( $_POST[ 'ays_poll_email_configuration_from_subject' ] ) ) : '';
			// Reply to email
			$poll_email_configuration_replyto_email = (isset( $_POST[ 'ays_poll_email_configuration_replyto_email' ] ) && $_POST[ 'ays_poll_email_configuration_replyto_email' ] != '') ? stripslashes ( sanitize_email( $_POST[ 'ays_poll_email_configuration_replyto_email' ] ) ) : '';
			// Reply to name
			$poll_email_configuration_replyto_name = (isset( $_POST[ 'ays_poll_email_configuration_replyto_name' ] ) && $_POST[ 'ays_poll_email_configuration_replyto_name' ] != '') ? stripslashes ( sanitize_text_field( $_POST[ 'ays_poll_email_configuration_replyto_name' ] ) ) : '';

			//---- Email configuration End ---- //

			// Poll logo image url
			$poll_logo_image_url       = isset($data['ays_poll_logo_image_url']) && $data['ays_poll_logo_image_url'] != "" ? sanitize_text_field($data['ays_poll_logo_image_url']) : ""; 
			$poll_logo_image_url_check = isset($data['ays_poll_logo_enable_image_url']) && $data['ays_poll_logo_enable_image_url'] == "on" ? "on" : "off";

			// ==== ====

			// Poll container max-width for mobile
			$poll_mobile_max_width = (isset($data['ays_poll_mobile_max_width']) && $data['ays_poll_mobile_max_width'] != "") ? abs(sanitize_text_field($data['ays_poll_mobile_max_width'])) : '';
			
			// Poll title font size 
			$poll_title_font_size    = (isset($data['ays_poll_title_font_size']) && $data['ays_poll_title_font_size'] != "" && $data['ays_poll_title_font_size'] > 0) ? sanitize_text_field($data['ays_poll_title_font_size']) : "18";
			
			// Poll title font size for mobile
			$poll_title_font_size_mobile    = (isset($data['ays_poll_title_font_size_mobile']) && $data['ays_poll_title_font_size_mobile'] != "" && $data['ays_poll_title_font_size_mobile'] > 0) ? sanitize_text_field($data['ays_poll_title_font_size_mobile']) : "20";


			// Poll title alignment
			$poll_title_alignment    = ( isset($data['ays_poll_title_alignment']) && $data['ays_poll_title_alignment'] != "" ) ? sanitize_text_field($data['ays_poll_title_alignment']) : "center";

			// Poll text type options
			$poll_text_type_length_enable = ( isset($data['ays_poll_enable_question_length']) && $data['ays_poll_enable_question_length'] != "" ) ? sanitize_text_field($data['ays_poll_enable_question_length']) : "off";
			$poll_text_type_limit_type    = ( isset($data['ays_poll_question_limit_text_type']) && $data['ays_poll_question_limit_text_type'] != "" ) ? sanitize_text_field($data['ays_poll_question_limit_text_type']) : "characters";
			$poll_text_type_limit_length  = ( isset($data['ays_poll_question_text_max_length']) && $data['ays_poll_question_text_max_length'] != "" ) ? sanitize_text_field($data['ays_poll_question_text_max_length']) : "";
			$poll_text_type_limit_message = ( isset($data['ays_poll_question_enable_text_message']) && $data['ays_poll_question_enable_text_message'] != "" ) ? sanitize_text_field($data['ays_poll_question_enable_text_message']) : "off";
			$poll_text_type_placeholder   = ( isset($data['ays_poll_text_type_placeholder']) && $data['ays_poll_text_type_placeholder'] != "" ) ? sanitize_text_field($data['ays_poll_text_type_placeholder']) : "";
			$poll_text_type_width         = ( isset($data['ays_poll_text_type_width']) && $data['ays_poll_text_type_width'] != "" ) ? absint(intval(sanitize_text_field($data['ays_poll_text_type_width']))) : "";			
			$poll_text_type_width_type    = ( isset($data['ays_poll_text_type_width_type']) && $data['ays_poll_text_type_width_type'] != "" ) ? sanitize_text_field($data['ays_poll_text_type_width_type']) : "percent";			

			//Title Text Shadow
			$enable_poll_title_text_shadow = ( isset( $data['ays_poll_enable_title_text_shadow'] ) && $data['ays_poll_enable_title_text_shadow'] != '' ) ? 'on' : 'off';

			$poll_title_text_shadow = ( isset($data['ays_poll_title_text_shadow_color'] ) && $data['ays_poll_title_text_shadow_color'] != '' ) ? sanitize_text_field( $data['ays_poll_title_text_shadow_color'] ) : 'rgba(255,255,255,0)';
			
			$poll_title_text_shadow_x_offset = (isset($data['ays_poll_title_text_shadow_x_offset']) && $data['ays_poll_title_text_shadow_x_offset'] != '') ? intval( $data['ays_poll_title_text_shadow_x_offset'] )  : 2;

			$poll_title_text_shadow_y_offset = (isset($data['ays_poll_title_text_shadow_y_offset']) && $data['ays_poll_title_text_shadow_y_offset'] != '') ? intval( $data['ays_poll_title_text_shadow_y_offset'] ) : 2;
	
			$poll_title_text_shadow_z_offset = (isset($data['ays_poll_title_text_shadow_z_offset']) && $data['ays_poll_title_text_shadow_z_offset'] != '') ? intval( $data['ays_poll_title_text_shadow_z_offset'] ) : 0;

			//Display form fields labels
            $display_fields_labels = ( isset($data['ays_poll_display_fields_labels']) && sanitize_text_field( $data['ays_poll_display_fields_labels'] ) == 'on' ) ? 'on' : 'off';

			// Social Media links
            $enable_social_links = (isset($data['ays_poll_enable_social_links']) && sanitize_text_field( $data['ays_poll_enable_social_links'] ) == "on") ? 'on' : 'off';
            $poll_social_links_heading = ( isset( $data[ 'ays_poll_social_links_heading' ] ) && $data[ 'ays_poll_social_links_heading' ] != '' ) ? stripslashes(wp_kses_post($data[ 'ays_poll_social_links_heading' ])) : '';
            $ays_social_links = (isset($data['ays_poll_social_links'])) ? array_map( 'sanitize_text_field', $data['ays_poll_social_links'] ) : array(
                'linkedin_link' => '',
                'facebook_link' => '',
                'twitter_link' => '',
                'vkontakte_link' => '',
                'youtube_link' => '',
            );
            
            $linkedin_link = isset($ays_social_links['ays_linkedin_link']) && sanitize_text_field( $ays_social_links['ays_linkedin_link'] ) != '' ? sanitize_text_field( $ays_social_links['ays_linkedin_link'] ) : '';
            $facebook_link = isset($ays_social_links['ays_facebook_link']) && sanitize_text_field( $ays_social_links['ays_facebook_link'] ) != '' ? sanitize_text_field( $ays_social_links['ays_facebook_link'] ) : '';
            $twitter_link = isset($ays_social_links['ays_twitter_link']) && sanitize_text_field( $ays_social_links['ays_twitter_link'] ) != '' ? sanitize_text_field( $ays_social_links['ays_twitter_link'] ) : '';
            $vkontakte_link = isset($ays_social_links['ays_vkontakte_link']) && sanitize_text_field( $ays_social_links['ays_vkontakte_link'] ) != '' ? sanitize_text_field( $ays_social_links['ays_vkontakte_link'] ) : '';
            $youtube_link = isset($ays_social_links['ays_youtube_link']) && sanitize_text_field( $ays_social_links['ays_youtube_link'] ) != '' ? sanitize_text_field( $ays_social_links['ays_youtube_link'] ) : '';
            
            $social_links = array(
                'linkedin_link'     => $linkedin_link,
                'facebook_link'     => $facebook_link,
                'twitter_link'      => $twitter_link,
                'vkontakte_link'    => $vkontakte_link,
                'youtube_link'    	=> $youtube_link,
            );

			$styles     = json_encode(array(
				'poll_version'                => POLL_MAKER_AYS_VERSION,
				// Developer Package options
				'poll_enable_copy_protection' => $poll_enable_copy_protection,

				'main_color'                  => $main_color,
				'text_color'                  => $text_color,
				'icon_color'                  => $icon_color,
				'bg_color'                    => $bg_color,
				'answer_bg_color'             => $answer_bg_color,
				'answer_border_side'          => $answer_border_side,
				'title_bg_color'              => $title_bg_color,
				'icon_size'                   => $icon_size,
				'width'                       => $width,
				'width_for_mobile'            => $width_for_mobile,
				'btn_text'                    => $btn_text,
				'see_res_btn_text'            => $see_res_btn_text,
				'border_style'                => $border_style,
				'border_radius'               => $border_radius,
				'border_width'                => $border_width,
				'box_shadow_color'            => $box_shadow_color,
				'enable_box_shadow'           => $enable_box_shadow,
				'enable_answer_style'         => $enable_answer_style,
				'bg_image'                    => $bg_image,
				'info_form'                   => $info_form,
				'fields'                      => sanitize_text_field($form_fields),
				'required_fields'             => sanitize_text_field($form_required_fields),
				'info_form_title'             => $info_form_title,
				'hide_results'                => $hide_results,
				'hide_result_message'         => $hide_result_message,
				'hide_results_text'           => $hide_results_text,
				'result_message'          	  => $ays_result_message,
				'allow_not_vote'              => $allow_not_vote,
				'show_social'                 => $show_social,
				'poll_social_buttons_heading' => $poll_social_buttons_heading,
				'poll_show_social_ln'         => $poll_show_social_ln,
				'poll_show_social_fb'		  => $poll_show_social_fb,
				'poll_show_social_tr'	      => $poll_show_social_tr,
				'poll_show_social_vk'		  => $poll_show_social_vk,
				'enable_social_links'         => $enable_social_links,
				'poll_social_links_heading'	  => $poll_social_links_heading,
                'social_links'                => $social_links,
				'load_effect'                 => $load_effect,
				'load_gif'                    => $load_gif,
				'custom_load'                 => $custom_load,
				'limit_users'                 => $limit_users,
				'limit_users_method'          => $limit_users_method,
				'limitation_message'          => $limit_users_msg,
				'redirect_url'                => $limit_users_url,
				'redirection_delay'           => $limit_users_delay,
				'user_role'                   => $limit_users_role,
				'enable_restriction_pass'     => $limit_users_role_enable,
				'restriction_pass_message'    => $limit_users_role_msg,
				'enable_logged_users'         => $limit_users_logged_enable,
				'enable_logged_users_message' => $limit_users_logged_msg,
				'notify_email_on'             => $notify_on,
				'notify_email'                => $notify_email,
				'published'                   => $published,
				'enable_pass_count'           => $enable_pass_count,
				'result_sort_type'            => $result_sort_type,
				'create_date'                 => $changed_creation_date,
				// 'author'                      => $author,
				'redirect_users'              => $redirect_users,
				'redirect_after_vote_url'     => $redirect_after_vote_url,
				'redirect_after_vote_delay'   => $redirect_after_vote_delay,
				'activeInterval'              => $activeInterval,
				'deactiveInterval'            => $deactiveInterval,
				'activeIntervalSec'           => $activeIntervalSec,
				'deactiveIntervalSec'         => $deactiveIntervalSec,
				'active_date_message'         => $active_date_message,
				'active_date_message_soon'    => $active_date_message_soon,
				'vote_reason'                 => $vote_reason,
				'show_result_view'            => $show_result_view,
				'active_date_check'           => $active_date_check,
				'enable_restart_button'       => $enable_restart_button,
				'enable_vote_btn'             => $enable_vote_btn,
				'show_votes_count'            => $show_votes_count,
				'attempts_count'              => $ays_attempts_count,
				'allow_anonymity'             => $ays_allow_anonymity,
				'show_create_date'            => $show_create_date,
				'show_author'            	  => $show_author,
				'show_res_percent'            => $show_res_percent,
				'show_result_btn_schedule'	  => $show_result_btn_schedule,
				'ays_poll_show_timer'    	  => $ays_poll_show_timer,
				'ays_show_timer_type'    	  => $ays_show_timer_type,
				'show_login_form'             => $show_login_form,				
				'user_add_answer'             => $user_add_answer,
				'add_answer_show_up'          => $add_answers_not_show_up,
				'versus_icon_type'            => $versus_icon_type,
				'versus_icon_position'        => $versus_icon_position,
				'versus_answers_label'        => $versus_answers_label,
				'result_in_rgba'              => $result_in_rgba,
				'enable_mailchimp'            => $enable_mailchimp,
				'enable_background_gradient'  => $enable_background_gradient,
                'background_gradient_color_1' => $background_gradient_color_1,
                'background_gradient_color_2' => $background_gradient_color_2,
                'poll_gradient_direction'     => $poll_gradient_direction,
                'redirect_after_submit'       => $redirect_after_submit,
				'mailchimp_list'              => $mailchimp_list,
                'poll_direction'              => $poll_direction,
                'poll_allow_multivote'        => $allow_multivote,
                'multivote_answer_min_count'  => $multivote_answer_min_count,
                'poll_allow_multivote_count'  => $multivote_answer_max_count,
                'monitor_list'                => $monitor_list,
                'enable_monitor'              => $enable_monitor,
                'slack_conversation'          => $slack_conversation,
                'enable_slack'                => $enable_slack,
                'active_camp_list'            => $active_camp_list,
                'active_camp_automation'      => $active_camp_automation,
                'enable_active_camp'          => $enable_active_camp,
                'enable_zapier'               => $enable_zapier,
				'randomize_answers'           => $randomize_answers,
				'enable_asnwers_sound'        => $enable_asnwers_sound,
				'enable_password'             => $enable_password,
				'password_poll'               => $password_poll,
				'poll_password_message'       => $poll_password_message,
				'poll_enable_password_visibility'   => $poll_enable_password_visibility,
				'background_size'             => $background_size,
				"disable_answer_hover"        => $disable_answer_hover,
				"custom_class"        		  => $custom_class,
				"enable_poll_title_text_shadow" => $enable_poll_title_text_shadow,
                "poll_title_text_shadow"        => $poll_title_text_shadow,
				"poll_title_text_shadow_x_offset" => $poll_title_text_shadow_x_offset,
                "poll_title_text_shadow_y_offset" => $poll_title_text_shadow_y_offset,
                "poll_title_text_shadow_z_offset" => $poll_title_text_shadow_z_offset,

				"poll_bg_image_position"	  => $poll_bg_image_position,
                "poll_bg_img_in_finish_page"  => $poll_bg_img_in_finish_page,
				'ays_add_post_for_poll'       => $ays_add_post_for_poll,
				'show_answer_message'         => $ays_answer_message_check,
				"show_answers_caption"        => $show_answers_caption,
				'enable_vote_limitation'  	  => $enable_vote_limitation,
				'vote_limitation'       	  => $vote_limitation,
				'limitation_time_period'      => $vote_limitation_time_period,
				// 'vote_limit_message'		  => $vote_limit_message,
				'enable_tackers_count'        => $enable_tackers_count,
                'tackers_count'               => $tackers_count,
                'ays_enable_mail_user'        => $enable_email_msg_after_vote,
    			'vote_notification_email_msg' => $vote_msg_email,
    			'show_answers_icon' 		  => $show_answers_icon,
    			'answers_icon' 		  		  => $answers_icon,
    			'buttons_size'                => $buttons_size,
                'buttons_font_size'           => $buttons_font_size,
				'poll_buttons_mobile_font_size' => $poll_buttons_mobile_font_size,
                'buttons_left_right_padding'  => $buttons_left_right_padding,
                'buttons_top_bottom_padding'  => $buttons_top_bottom_padding,
				'buttons_border_radius'       => $buttons_border_radius,
				'redirect_after_submit_drpdwn'=> $redirect_after_submit_drpdwn,
				'user_add_answer_dropdown'    => $user_add_answer_dropdown,
				'enable_google_sheets'        => $enable_google_sheets,
				'spreadsheet_id'              => $spreadsheet_id,
				"enable_view_more_button"	  => $enable_view_more_button,
                "poll_view_more_button_count" => $poll_view_more_button_count,
                "poll_min_height"			  => $poll_min_height,
                "answer_sort_type"			  => $poll_answer_ordering,
                "answer_font_size"			  => $poll_answer_font_size,
                "poll_answer_font_size_mobile" => $poll_answer_font_size_mobile,
                "show_passed_users"			  => $poll_show_passed_users,
                "logo_image"       			  => $poll_logo_image,
                "allow_collect_user_info"     => $poll_allow_collect_info,
                "poll_send_mail_type"     	  => $poll_send_mail_type,
                "poll_sendgrid_email_from"    => $poll_sendgrid_email_from,
                "poll_sendgrid_email_name"    => $poll_sendgrid_email_name,
                "poll_sendgrid_template_id"   => $poll_sendgrid_template_id,
                "enable_limit_by_country"	  => $enable_limit_by_country,
				"limit_country"			      => $limit_country,
				"show_votes_before_voting"	  => $show_votes_before_voting,
				"show_votes_before_voting_by" => $show_votes_before_voting_by,
				"fake_votes"			      => $ays_fake_votes,
				"dont_show_poll_cont"     	  => $poll_show_container,
				"see_result_button"     	  => $poll_see_result_button,
                "see_result_radio"     	      => $poll_see_result_radio,
				"loader_font_size"     	      => $poll_loader_font_size,
				"show_answers_numbering"      => $show_answers_numbering,
				"effect_message"              => $poll_effect_message,
				"enable_mad_mimi"             => $enable_mad_mimi,
                "mad_mimi_list"               => $mad_mimi_list,
				'poll_show_passed_users_count' => $poll_show_passed_users_count,
				'question_font_size'		   => $question_font_size,
				'question_font_size_mobile'    => $question_font_size_mobile,
				'poll_question_image_height'   => $poll_question_image_height,
				'poll_mobile_max_width'        => $poll_mobile_max_width,

				'poll_title_font_size'         => $poll_title_font_size,
				'poll_title_font_size_mobile'  => $poll_title_font_size_mobile,
				'poll_title_alignment'         => $poll_title_alignment,
				'poll_enable_answer_image_after_voting' => $poll_enable_answer_image_after_voting,
				// Text type options
				'poll_text_type_length_enable'      => $poll_text_type_length_enable,
				'poll_text_type_limit_type'         => $poll_text_type_limit_type,
				'poll_text_type_limit_length'       => $poll_text_type_limit_length,
				'poll_text_type_limit_message'      => $poll_text_type_limit_message,
				'poll_text_type_placeholder'        => $poll_text_type_placeholder,
				'poll_text_type_width'              => $poll_text_type_width,
				'poll_text_type_width_type'         => $poll_text_type_width_type,
                //Answer style
				'answers_padding'        	  => $answers_padding,
                'answers_margin'              => $answers_margin,
                'answers_border'              => $answers_border,
    			'answers_border_width' 		  => $answers_border_width,
    			'answers_border_style' 		  => $answers_border_style,
    			'answers_border_color' 		  => $answers_border_color,
    			'answers_box_shadow'          => $answers_box_shadow,
                'answers_box_shadow_color'    => $answers_box_shadow_color,
				'poll_answer_box_shadow_x_offset'	=> $poll_answer_box_shadow_x_offset,
				'poll_answer_box_shadow_y_offset'	=> $poll_answer_box_shadow_y_offset,
				'poll_answer_box_shadow_z_offset'	=> $poll_answer_box_shadow_z_offset,

                'ans_img_height'  			  => $ans_img_height,
				'poll_answer_image_height_for_mobile' => $poll_answer_image_height_for_mobile,
                'ans_img_caption_style'       => $ans_img_caption_style,
				'ans_img_caption_position'    => $ans_img_caption_position,
				'answers_font_size'    		  => $answers_font_size,
				'answers_object_fit'          => $answers_object_fit,
				'answers_grid_column'         => $answers_grid_column,
				'answers_border_radius'       => $answers_border_radius,
				'enable_getResponse'          => $enable_getResponse,
				'getResponse_list'            => $getResponse_list,
				'enable_convertKit'           => $poll_enable_convertKit,
				'poll_convertKit_form_id'     => $poll_convertKit_form_id,
				'poll_logo_url' 			  => $poll_logo_image_url,
    			'poll_enable_logo_url'		  => $poll_logo_image_url_check,
    			'poll_logo_url_new_tab'		  => $poll_logo_url_new_tab,
				

				'poll_send_mail_to_site_admin'   		  => $poll_send_mail_to_site_admin,
				'poll_mail_message_admin'                 => $poll_mail_message_admin,
				'poll_admin_email_subject'                => $poll_admin_email_subject,
				// Email configurations
				'poll_email_configuration_from_email'     => $poll_email_configuration_from_email,
				'poll_email_configuration_from_name'      => $poll_email_configuration_from_name,
				'poll_email_configuration_from_subject'   => $poll_email_configuration_from_subject,
				'poll_email_configuration_replyto_email'  => $poll_email_configuration_replyto_email,
				'poll_email_configuration_replyto_name'   => $poll_email_configuration_replyto_name,

				'display_fields_labels'  => $display_fields_labels,
				'poll_create_author'     => $poll_create_author,
			));

			$messages = array();
			$answer_all_ids = explode("," , $answers_id);
			$answer_all_images = explode("," , $answer_image);
			foreach($answers_message as $key => $value){
				$messages[$answer_all_ids[$key]]['answer'] = stripslashes($answers_message[$key]);
				$messages[$answer_all_ids[$key]]['answer_image'] = $answer_all_images[$key];
			}
			$poll_answer_message = json_encode($messages , JSON_UNESCAPED_SLASHES);

			$answers_bg = array();
			$range_answer = array();
			$fake_votes_count = array();
			switch ( $type ) {
				case 'versus':
					$view_type   = isset($data['versus-type']) ? sanitize_text_field($data['versus-type']) : 'horizontal';
					$answers_bg  = $data['vs-answers-images'];
					$answers     = $data['vs-poll-answers'];
					$answers_ids = $data['vs-poll-answers-ids'];
					$answers_show_added = array(1,1);
					break;
				case 'choosing':
					$view_type = isset($data['ays_poll_choose_answer_type']) ? sanitize_text_field($data['ays_poll_choose_answer_type']) : 'list';
					$answers_bg = $data['apm-answers-images'];
					$answers     = $data['ays-poll-answers'];
					$answers_ids = $data['ays-poll-answers-ids'];
					$fake_votes_count = $fake_votes_values;
					$answers_url = $submit_redirect_url;
					$answers_show_added = isset($data['ays_poll_show_user_added']) && !empty( $data['ays_poll_show_user_added']) ? $data['ays_poll_show_user_added'] : array(1,1);
					break;
				case 'voting':
					$view_type = $data['ays-poll-vote-type'] ? sanitize_text_field($data['ays-poll-vote-type']) : 'hand';
					$answers   = array(1, -1);
					$answers_show_added = array(1,1);
					break;
				case 'rating':
					$view_type  = $data['ays-poll-rate-type'] ? sanitize_text_field($data['ays-poll-rate-type']) : 'star';
					$rate_value = $data['ays-poll-rate-value'];
					$answers    = range(1, $rate_value);
					for ($l = 0; $l < intval($rate_value); $l++) { 
						$answers_show_added[$l] = 1;
					}
					break;
				case 'dropdown':
					$view_type   = "";
					$answers     = $data['ays-poll-answers-dropdown'];
					$answers_ids = $data['ays-poll-answers-dropdown-ids'];
					$answers_url = $dropdown_submit_redirect_url;
					$answers_show_added = isset($data['ays_poll_show_user_added_dropdown']) && !empty( $data['ays_poll_show_user_added_dropdown']) ? $data['ays_poll_show_user_added_dropdown'] : array(1,1);
					break;
				case 'range':
					$view_type  = "";
					$range_answer = array(
						'answer_range' => '0-100',
					);
					$answers  = $range_answer;
					$answer = $range_answer;
					break;
				case 'text':
					$view_type  = isset($data['ays_poll_text_type']) ? sanitize_text_field($data['ays_poll_text_type']) : "";
					$answers = array();
					break;
				default:
					$fake_votes_count = array();
					break;
			}

			if (isset($data['ays_default_option']) && $data['ays_default_option'] == 'ays_default_option') {

                $poll_default_options = json_decode($styles , true);
				unset($poll_default_options['active_date_check']);
                unset($poll_default_options['activeInterval']);
                unset($poll_default_options['activeIntervalSec']);
				unset($poll_default_options['deactiveInterval']);
				unset($poll_default_options['deactiveIntervalSec']);
				$poll_default_options['theme_id'] = $theme_id;
				$poll_default_options = json_encode($poll_default_options);
				

                Poll_Maker_Settings_Actions::ays_update_setting( 'poll_default_options',  $poll_default_options );
            }

			if ($id == 0) {
				$poll_result = $wpdb->insert(
					$poll_table,
					array(
						'author_id'			=> $poll_create_author,
						'title'       		=> $title,
						'description' 		=> $description,
						'type'        		=> $type,
						'question'    		=> $question,
						'view_type'   		=> $view_type,
						'categories'  		=> $categories,
						'image'       		=> $image,
						'show_title'  		=> $show_title,
						'styles'      		=> $styles,
						'custom_css'  		=> $css,
						'theme_id'    		=> $theme_id,
						'answer_message'    => $poll_answer_message,
					),
					array(
						'%d', // author_id
						'%s', // title
						'%s', // description
						'%s', // type
						'%s', // question
						'%s', // view_type
						'%s', // categories
						'%s', // image
						'%d', // show_title
						'%s', // styles
						'%s', // custom_css
						'%d', // theme_id
						'%s', // answer_message
					)
				);
				$last_id     = $wpdb->insert_id;
				foreach ( $answers as $key => $answer ) {
					if (empty($answer)) {
						continue;
					}
					if($type == 'range'){
						$answer = json_encode($answers);
					}
					$fakes_votes = 0;
					if(!empty($fake_votes_count)){
						$fakes_votes = isset($fake_votes_count[$key]) && $fake_votes_count[$key] != '' ? $fake_votes_count[$key] : 0; 
					}

					$answer_result = $wpdb->insert(
						$answer_table,
						array(
							'poll_id'    		=> $last_id,
							'answer'     		=> wp_filter_kses($answer),
							'answer_img' 		=> ($type == 'choosing' || $type == 'versus') ? wp_http_validate_url($answers_bg[$key]) : "",
							'show_user_added' 	=> isset($answers_show_added[$key]) ? $answers_show_added[$key] : 1,
							'ordering'  		=> (intval($key) + 1),
							'fake_votes'  		=> $fakes_votes,
						),
						array(
							'%d', // poll_id
							'%s', // answer
							'%s', // answer_img
							'%d', // show_user_added
							'%d', // ordering
							'%d', // fake votes
						)
					);
				}
				$message = 'created';
			} else {

				$poll        = $this->get_poll_by_id($id);
				$poll_result = $wpdb->update(
					$poll_table,
					array(
						'author_id'			=> $poll_create_author,
						'title'       		=> $title,
						'description' 		=> $description,
						'type'        		=> $type,
						'question'    		=> $question,
						'view_type'   		=> $view_type,
						'categories'  		=> $categories,
						'image'       		=> $image,
						'show_title'  		=> $show_title,
						'styles'      		=> $styles,
						'custom_css'  		=> $css,
						'theme_id'    		=> $theme_id,
						'answer_message'    => $poll_answer_message,
					),
					array('id' => $id),
					array(
						'%d', // author_id
						'%s', // title
						'%s', // description
						'%s', // type
						'%s', // question
						'%s', // view_type
						'%s', // categories
						'%s', // image
						'%d', // show_title
						'%s', // styles
						'%s', // custom_css
						'%d', // theme_id
						'%s', // answer_message
					),
					array('%d')
				);
				if ($type != $poll['type']) {
					$sql = "DELETE r FROM {$wpdb->prefix}ayspoll_reports as r
                            JOIN $answer_table ON $answer_table.id = r.answer_id
                            JOIN $poll_table ON $poll_table.id = $answer_table.poll_id
                            WHERE $poll_table.id = $id";
					$wpdb->query($sql);

					$wpdb->delete(
						$answer_table,
						array('poll_id' => $id),
						array('%d')
					);

					foreach ( $answers as $key => $answer ) {
						if (empty($answer)) {
							continue;
						}
						$fakes_votes = 0;
						if(!empty($fake_votes_count)){
							$fakes_votes = isset($fake_votes_count[$key]) && $fake_votes_count[$key] != '' ? $fake_votes_count[$key] : 0; 
						}

						$wpdb->insert(
							$answer_table,
							array(
								'poll_id'    		=> $id,
								'answer'     		=> wp_filter_kses($answer),
								'answer_img' 		=> ($type == 'choosing' || $type == 'versus') ? wp_http_validate_url($answers_bg[$key]) : "",
								'show_user_added' 	=> isset($answers_show_added[$key]) ? $answers_show_added[$key] : 1,
								'ordering'  		=> (intval($key) + 1),
								'fake_votes'  		=> $fakes_votes,
							),
							array(
								'%d', // poll_id
								'%s', // answer
								'%s', // answer_img
								'%d', // show_user_added
								'%d', // ordering
								'%d', // fake votes
							)
						);
					}
				}
				if (($type == 'choosing' || $type == 'versus' || $type == 'dropdown') && $type == $poll['type']) {
					foreach ( $poll['answers'] as $answer ) {
						$old_id = $answer['id'];
						$index  = array_search($old_id, $answers_ids);
						$fake_votes_all = isset($fake_votes_count[$index]) && $fake_votes_count[$index] != '' ? intval($fake_votes_count[$index]) : 0;
						if ($index !== false) {
							$new_answer = $answers[$index];
							$new_url = isset($answers_url[$index]) ? $answers_url[$index] : "";
							if (empty($new_answer)) {
								continue;
							}
							if (empty($new_url)) {
								$new_url = null;
							}

							$ans_res = $wpdb->update(
								$answer_table,
								array(
									'answer'     		=> wp_filter_kses($new_answer),
									'answer_img' 		=> ($type == 'choosing' || $type == 'versus') ? wp_http_validate_url($answers_bg[$index]) : "",
									'redirect'   		=> $new_url,
									'show_user_added' 	=> isset($answers_show_added[$index]) ? $answers_show_added[$index] : 1,
									'ordering'  		=> ($index + 1),
									'fake_votes' 		=> $fake_votes_all,
								),
								array('id' => $old_id),
								array(
									'%s', // answer
									'%s', // answer_img
									'%s', // redirect
									'%d', // show_user_added
									'%d', // ordering
									'%d', // fake votes
								),
								array('%d')
							);
						} else {
							$wpdb->delete(
								"{$wpdb->prefix}ayspoll_reports",
								array('answer_id' => $old_id),
								array('%d')
							);
							$wpdb->delete(
								$answer_table,
								array('id' => $old_id),
								array('%d')
							);
						}
					}
					foreach ( $answers_ids as $index => $value ) {
						if ($value == 0 && !empty($answers[$index])) {
							$fake_votes_all = isset($fake_votes_count[$index]) && $fake_votes_count[$index] != '' ? intval($fake_votes_count[$index]) : 0;
							$wpdb->insert(
								$answer_table,
								array(
									'poll_id'    		=> $id,
									'answer'     		=> wp_filter_kses($answers[$index]),
									'answer_img' 		=> ($type == 'choosing' || $type == 'versus') ? wp_http_validate_url($answers_bg[$index]) : "",
									'redirect'  		=> isset($answers_url[$index]) ? $answers_url[$index] : "",
									'show_user_added' 	=> isset($answers_show_added[$index]) ? $answers_show_added[$index] : 1,
									'ordering'  		=> ($index + 1),
									'fake_votes' 		=> $fake_votes_all,

								),
								array(
									'%d', // poll_id
									'%s', // answer
									'%s', // answer_img
									'%s', // redirect
									'%d', // show_user_added
									'%d', // ordering
									'%d', // fake votes
								)
							);
						}
					}
				}
				if ($type == 'rating' && $poll['type'] == 'rating' && count($poll['answers']) != $rate_value) {
					if (count($poll['answers']) > $rate_value) {
						for ( $i = $rate_value; $i < count($poll['answers']); $i++ ) {

							$wpdb->delete(
								"{$wpdb->prefix}ayspoll_reports",
								array('answer_id' => $poll['answers'][$i]['id']),
								array('%d')
							);
							$wpdb->delete(
								$answer_table,
								array('id' => $poll['answers'][$i]['id']),
								array('%d')
							);
						}
					} else {
						for ( $i = count($poll['answers']); $i < $rate_value; $i++ ) {
							$wpdb->insert(
								$answer_table,
								array(
									'poll_id' => $id,
									'answer'  => wp_filter_kses($answers[$i]),
								),
								array('%d', '%s')
							);
						}
					}
				}
				$message = 'updated';
			}

			$add_post_for_poll = (isset($data['ays_add_post_for_poll']) && $data['ays_add_post_for_poll'] == 'on') ? 'on' : 'off';
			$add_postcat_for_poll =  isset($data['ays_add_postcat_for_poll']) ? $data['ays_add_postcat_for_poll'] : array();
			$poll_post_id =  ($id == 0) ? $last_id : $id;
				
            if($add_post_for_poll == "on"){
                global $user_ID;
                $post_content = '[ays_poll id="'.$poll_post_id.'"]';
                
                if ( Poll_Maker_Ays_Admin::is_active_gutenberg() ) {
					$post_content = '<!-- wp:poll-maker/poll {"metaFieldValue":'.$poll_post_id.',"shortcode":"[ays_poll id='.$poll_post_id.']"} -->[ays_poll id="'.$poll_post_id.'"]<!-- /wp:poll-maker/poll -->';
                }
                
                $new_post = array(
                    'post_title' => $title,
                    'post_content' => $post_content,
                    'post_status' => 'publish',
                    'post_date' => current_time( 'mysql' ),
                    'post_author' => $user_ID,
                    'post_type' => 'post',
                    'post_category' => $add_postcat_for_poll
				);
                $post_id = wp_insert_post($new_post);
                if(! empty($image)){
                    $sql = "SELECT ID FROM ".$wpdb->prefix."posts WHERE post_type = 'attachment' AND guid = '".$image."'";
                    $attachment_id = intval($wpdb->get_var($sql));
                    if($attachment_id !== 0){
						$featured_image = set_post_thumbnail($post_id, $attachment_id);
                    }
                }
                $poll_post_result = $wpdb->update(
                    $poll_table,
                    array( 'post_id' => $post_id ),
                    array( 'id' => $poll_post_id ),
                    array( '%d' ),
                    array( '%d' )
                );
                
            }

			$active_tab = !empty($data['ays_poll_active_tab']) ? sanitize_text_field($data['ays_poll_active_tab']) : "tab1";
			if ($poll_result >= 0) {
				if ($ays_change_type != '') {
					if($id == null){
                        $url = esc_url_raw( add_query_arg( array(
                            "action"      => "edit",
                            "poll"        => $last_id,
                            "active-tab"  => $active_tab,
                            "status"      => $message
                        ) ) );
                    }else{
						$url = esc_url_raw(remove_query_arg(false)) . "&active-tab=$active_tab" . '&status=' . $message . ($message == 'created' ? "&poll=$last_id" : "");
					}
					wp_redirect($url);
				} else {
					$url = esc_url_raw(remove_query_arg(['action'])) . "&active-tab=$active_tab" . '&status=' . $message;
					wp_redirect($url);
				}
			}
		}
		$allowedtags = $old_allowedtags;
	}

	public function duplicate_poll( $id ) {
		global $wpdb;
		$poll_table    = "{$wpdb->prefix}ayspoll_polls";
		$answers_table = "{$wpdb->prefix}ayspoll_answers";

		$duplicate = $this->get_poll_by_id($id, false);
		if (empty($duplicate)) {
			$url = esc_url_raw(remove_query_arg(array('action', 'poll'))) . '&status=failed';
			wp_redirect($url);
		}

		$user_id = get_current_user_id();
        $user = get_userdata($user_id);
        $author = array(
            'id' => $user->ID,
            'name' => $user->data->display_name
        );
		$options = json_decode($duplicate['styles'], true);
        
        $options['create_date'] = current_time( 'mysql' );
        $options['ays_add_post_for_poll'] = 'off';
		$answers = $duplicate['answers'];

		$result = $wpdb->insert(
			$poll_table,
			array(
				'author_id'			=> absint(intval( $author['id'] )),
				'title'       		=> "Copy - " . $duplicate['title'],
				'description' 		=> $duplicate['description'],
				'type'        		=> $duplicate['type'],
				'question'    		=> $duplicate['question'],
				'view_type'   		=> $duplicate['view_type'],
				'categories'  		=> $duplicate['categories'],
				'image'       		=> $duplicate['image'],
				'show_title'  		=> absint(intval( $duplicate['show_title'] )),
				'styles'      		=> json_encode($options),
				'custom_css'  		=> $duplicate['custom_css'],
				'theme_id'    		=> absint(intval( $duplicate['theme_id'] )),
				'answer_message'    => json_encode( $duplicate['answer_message'] ),
			),
			array(
				'%d', // author_id
				'%s', // title
				'%s', // description
				'%s', // type
				'%s', // question
				'%s', // view_type
				'%s', // categories
				'%s', // image
				'%d', // show_title
				'%s', // styles
				'%s', // custom_css
				'%d', // theme_id
				'%s', // answer_message
			)
		);

		$poll_id         = $wpdb->insert_id;
		$answers_results = array();
		$flag            = true;

		foreach ( $answers as $key => $answer ) {
			$answers_results[] = $wpdb->insert(
				$answers_table,
				array(
					'poll_id'    		=> $poll_id,
					'answer'     		=> wp_filter_kses($answer['answer']),
					'answer_img' 		=> wp_http_validate_url($answer['answer_img']),
					'redirect' 			=> $answer['redirect'],
					'user_added' 		=> absint(intval( $answer['user_added'] )),
					'show_user_added' 	=> absint(intval( $answer['show_user_added'] )),
				),
				array(
					'%d', // poll_id
					'%s', // answer
					'%s', // answer_img
					'%s', // redirect
					'%d', // user_added
					'%d', // show_user_added
				)
			);
		}

		foreach ( $answers_results as $answers_result ) {
			if ($answers_result >= 0) {
				$flag = true;
			} else {
				$flag = false;
				break;
			}
		}
		$message = 'duplicated';
		if ($result >= 0 && $flag == true) {
			$url = esc_url_raw(remove_query_arg(array('action', 'poll'))) . '&status=' . $message;
			wp_redirect($url);
		}

	}

	public function get_poll_pass_count($id) {
        global $wpdb;
        $poll_id = intval($id);
		$sql = "SELECT COUNT(*) AS res_count
                FROM {$wpdb->prefix}ayspoll_reports
                INNER JOIN {$wpdb->prefix}ayspoll_answers 
                ON {$wpdb->prefix}ayspoll_answers.id={$wpdb->prefix}ayspoll_reports.answer_id
                WHERE {$wpdb->prefix}ayspoll_answers.poll_id = " . $poll_id;
		$poll = $wpdb->get_var($sql);
		return $poll;
    }

	public function get_poll_by_id( $id, $decode = true ) {
		global $wpdb;

		$sql  = "SELECT * FROM {$wpdb->prefix}ayspoll_polls WHERE id=" . absint(intval($id));
		$poll = $wpdb->get_row($sql, 'ARRAY_A');
		if (empty($poll)) {
			return array();
		}
		$sql             = "SELECT * FROM {$wpdb->prefix}ayspoll_answers WHERE poll_id=" . absint(intval($id)) . " ORDER BY ordering ASC, id ASC";
		$poll['answers'] = $wpdb->get_results($sql, 'ARRAY_A');

		if ($decode) {
			$json               = $poll['styles'];
			$poll['styles']     = json_decode($json, true);
			$poll['categories'] = trim($poll['categories'], ',');
			$cats               = explode(',', $poll['categories']);
			$poll['categories'] = !empty($cats) ? $cats : [];
			$all_fields         = $this->get_all_formfields();
			if (isset($poll['styles']['fields'])) {
				$poll['fields'] = array();
				$fields         = explode(',', $poll['styles']['fields']);
				foreach ( $fields as $field ) {
					$index = array_search($field, array_column($all_fields, 'slug'));
					if ($index !== false) {
						$poll['fields'][] = $all_fields[$index];
					}
				}
			}
			if (isset($poll['styles']['required_fields'])) {
				$poll['required_fields'] = array();
				$fields                  = explode(',', $poll['styles']['required_fields']);
				foreach ( $fields as $field ) {
					$index = array_search($field, array_column($all_fields, 'slug'));
					if ($index !== false) {
						$poll['required_fields'][] = $all_fields[$index];
					}
				}
			}
		}

		return $poll;
	}

	public function get_all_formfields() {
		global $wpdb;
		$all = array(
			array(
				"id"        => 0,
				"name"      => "Name",
				"type"      => "text",
				"slug"      => "apm-name",
				"published" => 1,
			),
			array(
				"id"        => 0,
				"name"      => "E-mail",
				"type"      => "email",
				"slug"      => "apm-email",
				"published" => 1,
			),
			array(
				"id"        => 0,
				"name"      => "Phone",
				"type"      => "tel",
				"slug"      => "apm_phone",
				"published" => 1,
			),
		);
		$sql = "SELECT * FROM {$wpdb->prefix}ayspoll_formfields WHERE published='1'";
		$res = $wpdb->get_results($sql, 'ARRAY_A');

		return array_merge($all, $res);
	}

	/** Text displayed when no customer data is available */
	public function no_items() {
		_e('There are no polls yet.', $this->plugin_name);
	}

	/**
	 * Render a column when no column specific method exist.
	 *
	 * @param array $item
	 * @param string $column_name
	 *
	 * @return mixed
	 */
	public function column_default( $item, $column_name ) {
		switch ( $column_name ) {
			case 'title':
			case 'poll_image':
			case 'categories':
			case 'type':
			case 'shortcode':
			case 'code_include':
			case 'create_date':
			case 'author_id':
			case 'completed_count':
			case 'published':
			case 'id':
				return $item[$column_name];
				break;
			default:
				return print_r($item, true); //Show the whole array for troubleshooting purposes
		}
	}

	/**
	 * Render the bulk edit checkbox
	 *
	 * @param array $item
	 *
	 * @return string
	 */
	function column_cb( $item ) {
		return sprintf(
			'<input type="checkbox" name="bulk-action[]" value="%s" />', $item['id']
		);
	}

	/**
	 * Method for name column
	 *
	 * @param array $item an array of DB data
	 *
	 * @return string
	 */
	function column_title( $item ) {
		$delete_nonce = wp_create_nonce($this->plugin_name . '-delete-poll');

		$current_user = get_current_user_id();
        $author_id = intval( $item['author_id'] );
        $owner = false;
        if( $current_user == $author_id ){
            $owner = true;
        }

        if( current_user_can( 'manage_options' ) ){
            $owner = true;
        }

		$poll_title = stripcslashes($item['title']);
		$p = esc_attr($poll_title);
        $polls_title_length = intval( $this->title_length );

        $restitle = Poll_Maker_Ays_Admin::ays_restriction_string("word", $poll_title, $polls_title_length);

		$title   = sprintf('<a href="?page=%s&action=%s&poll=%d" title="%s">%s</a>', esc_attr($_REQUEST['page']), 'edit', absint($item['id']), $p, $restitle);

		$actions = array();
        
        if( $owner ){
            $actions['edit'] = sprintf( '<a href="?page=%s&action=%s&poll=%d">'. __('Edit', $this->plugin_name) .'</a>', esc_attr( $_REQUEST['page'] ), 'edit', absint( $item['id'] ) );
        }else{
            $actions['edit'] = sprintf( '<a href="?page=%s&action=%s&poll=%d">'. __('View', $this->plugin_name) .'</a>', esc_attr( $_REQUEST['page'] ), 'edit', absint( $item['id'] ) );
        }
        // page=poll-maker-ays-results-each&poll=3&title=Demographic+poll
        $actions['results'] = sprintf( '<a href="?page=%s&poll=%d&title=%s">'. __('View Results', $this->plugin_name) .'</a>', esc_attr( $_REQUEST['page'] ) . '-results-each', absint( $item['id'] ) , $poll_title );

        $actions['duplicate'] = sprintf( '<a href="?page=%s&action=%s&poll=%d">'. __('Duplicate', $this->plugin_name) .'</a>', esc_attr( $_REQUEST['page'] ), 'duplicate', absint( $item['id'] ) );
        
        if( $owner ){
            $actions['delete'] = sprintf( '<a href="?page=%s&action=%s&poll=%s&_wpnonce=%s">'. __('Delete', $this->plugin_name) .'</a>', esc_attr( $_REQUEST['page'] ), 'delete', absint( $item['id'] ), $delete_nonce );
        }

		/*$actions = [
			'edit'      => sprintf('<a href="?page=%s&action=%s&poll=%d">' . __('Edit', $this->plugin_name) . '</a>', esc_attr($_REQUEST['page']), 'edit', absint($item['id'])),
			'duplicate' => sprintf('<a href="?page=%s&action=%s&poll=%d">' . __('Duplicate', $this->plugin_name) . '</a>', esc_attr($_REQUEST['page']), 'duplicate', absint($item['id'])),
			'delete'    => sprintf('<a href="?page=%s&action=%s&poll=%d&_wpnonce=%s">' . __('Delete', $this->plugin_name) . '</a>', esc_attr($_REQUEST['page']), 'delete', absint($item['id']), $delete_nonce),
		];*/

		return $title . $this->row_actions($actions);
	}

	function column_poll_image( $item ) {
        global $wpdb;
        $poll_image = (isset( $item['image'] ) && $item['image'] != '') ? esc_url( $item['image'] ) : '';

        $image_html     = array();
        $edit_page_url  = '';

        if($poll_image != ''){

            if ( isset( $item['id'] ) && absint( $item['id'] ) > 0 ) {
                $edit_page_url = sprintf( 'href="?page=%s&action=%s&poll=%d"', esc_attr( $_REQUEST['page'] ), 'edit', absint( $item['id'] ) );
            }

            $poll_image_url = $poll_image;
            $this_site_path = trim( get_site_url(), "https:" );
            if( strpos( trim( $poll_image_url, "https:" ), $this_site_path ) !== false ){
                $query = "SELECT * FROM `" . $wpdb->prefix . "posts` WHERE `post_type` = 'attachment' AND `guid` = '" . $poll_image_url . "'";
                $result_img =  $wpdb->get_results( $query, "ARRAY_A" );

                if( ! empty( $result_img ) ){
                    $url_img = wp_get_attachment_image_src( $result_img[0]['ID'], 'thumbnail' );
                    if( $url_img !== false ){
                        $poll_image_url = $url_img[0];
                    }
                }
            }

            $image_html[] = '<div class="ays-poll-image-list-table-column">';
                $image_html[] = '<a '. $edit_page_url .' class="ays-poll-image-list-table-link-column">';
                    $image_html[] = '<img src="'. $poll_image_url .'" class="ays-poll-image-list-table-img-column">';
                $image_html[] = '</a>';
            $image_html[] = '</div>';
        }

        $image_html = implode('', $image_html);

        return $image_html;
    }

	function column_shortcode( $item ) {
		return sprintf('<input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="[ays_poll id=%s]" />', $item["id"]);
	}

	function column_code_include( $item ) {
		return sprintf('<input type="text" onClick="this.setSelectionRange(0, this.value.length)" readonly value="<?php echo do_shortcode(\'[ays_poll id=%s]\'); ?>" />', $item["id"]);
	}

	function column_categories( $item ) {
		if ($item['categories'] == '') {
			return '';
		}
		global $wpdb;
		$cats_ids     = explode(',', $item['categories']);
		$cats_content = "<ul id='cats-in-table'>";
		$category_location = "#";
		foreach ( $cats_ids as $id ) {
			if (empty($id)) {
				continue;
			}
			$args_id = absint( esc_sql($id) );
			$result = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}ayspoll_categories WHERE id='$id'", "ARRAY_A");
			if (empty($result)) {
				continue;
			}
			// $cats_content .= "<li>{$result['title']}</li>";
			if ( isset($result) && $result > 0 ) {
				$category_location = sprintf( '<a href="?page=%s&action=%s&poll_category=%d" target="_blank">%s</a>', 'poll-maker-ays-cats', 'edit', $args_id, $result['title']);
			}

			$cats_content .= "<li>".$category_location."</li>";

		}
		$cats_content .= "</ul>";

		return $cats_content;
	}

	function column_create_date( $item ) {
        $options = json_decode($item['styles'], true);
        $date = isset($options['create_date']) && $options['create_date'] != '' ? $options['create_date'] : "0000-00-00 00:00:00";

        $date_format = get_option( 'date_format' );
        $time_format = get_option( 'time_format' );

        $format = $date_format . " " . $time_format;

        $text = "";
        if(Poll_Maker_Ays_Admin::validateDate($date)){
            $text .= date_i18n( $format, strtotime( $date ) );
        }

        return $text;
    }

    function column_author_id( $item ) {
    	$author_id = isset($item['author_id']) && intval( $item['author_id'] ) != 0 ? intval( $item['author_id'] ) : 0;
        $author = null;
        if( $author_id != 0){
            $author = get_userdata( $author_id );
        }
        
        $text = "";
        if( $author !== null ){
            $text .= $author->data->display_name;
        }

    	// $options = json_decode($item['styles'], true);	

        // if(isset($options['author'])){
        //     if(is_array($options['author'])){
        //         $author = $options['author'];
        //     }else{
        //         $author = json_decode($options['author'], true);
        //     }
        // }else{
        //     $author = array("name"=>"Unknown");
        // }

        // $text = "";
        // if($author['name'] !== "Unknown"){
        //     $text .= $author['name'];
        // }        

        return $text;
    }

	function column_completed_count( $item ) {
        $id = $item['id'];
        $passed_count = $this->get_poll_pass_count($id);
        $text = "<p style='text-align:center;font-size:14px;'>".$passed_count."</p>";
        return $text;
    }

	function column_publish( $item ) {
		global $wpdb;
		$res     = $wpdb->get_row("SELECT * FROM {$wpdb->prefix}ayspoll_polls WHERE id='{$item['id']}'", 'ARRAY_A');
		$options = json_decode($res['styles'], true);
		$status  = isset($options['published']) ? $options['published'] : 1;

		return $status ? "<i class=\"ays_poll_far ays_poll_fa-check-square\"></i> " . __("Published", $this->plugin_name) : "<i class=\"ays_poll_far ays_poll_fa-square\"></i> " . __("Unpublished", $this->plugin_name);
	}

	/**
	 *  Associative array of columns
	 *
	 * @return array
	 */
	function get_columns() {
		$columns = array(
			'cb'           		=> '<input type="checkbox" />',
			'title'        		=> __('Title', $this->plugin_name),
			'poll_image'        => __('Question image', $this->plugin_name),
			'type'         		=> __('Type', $this->plugin_name),
			'shortcode'    		=> __('Shortcode', $this->plugin_name),
			'code_include' 		=> __('Code Include', $this->plugin_name),
			'categories'   		=> __('Categories', $this->plugin_name),
			'completed_count'   => __('Completed count', $this->plugin_name),
			'create_date'   	=> __('Created', $this->plugin_name ),
			'author_id'         => __('Author', $this->plugin_name ),
			'publish'      		=> __('Status', $this->plugin_name),
			'id'           		=> __('ID', $this->plugin_name)
		);

		return $columns;
	}

	/**
	 * Columns to make sortable.
	 *
	 * @return array
	 */
	public function get_sortable_columns() {
		$sortable_columns = array(
			'title' 	=> array('title', true),
			'author_id' => array( 'author_id', true ),
			'type'  	=> array('type', true),
			'id'    	=> array('id', true),
		);

		return $sortable_columns;
	}

    /**
     * Columns to make sortable.
     *
     * @return array
     */
    public function get_hidden_columns() {
        $sortable_columns = array(
            'code_include',
        );

        return $sortable_columns;
    }

	/**
	 * Returns an associative array containing the bulk action
	 *
	 * @return array
	 */
	public function get_bulk_actions() {
		$actions = array(
			'bulk-delete' => __('Delete', $this->plugin_name),
		);

		return $actions;
	}

	/**
	 * Handles data query and filter, sorting, and pagination.
	 */
	public function prepare_items() {

		$this->_column_headers = $this->get_column_info();

		/** Process bulk action */
		$this->process_bulk_action();

		$per_page     = $this->get_items_per_page('polls_per_page', 20);
		$current_page = $this->get_pagenum();
		$total_items  = self::record_count();

		$this->set_pagination_args(array(
			'total_items' => $total_items, //WE have to calculate the total number of items
			'per_page'    => $per_page, //WE have to determine how many items to show on a page
		));

		$search = ( isset( $_REQUEST['s'] ) ) ? $_REQUEST['s'] : false;

        $do_search = ( $search ) ? " title LIKE '%%".$search."%%' " : '';

		$this->items = self::get_polls($per_page, $current_page, $do_search);
	}

	public function process_bulk_action() {
		//Detect when a bulk action is being triggered...
		$message = 'deleted';
		if ('delete' === $this->current_action()) {

			// In our file that handles the request, verify the nonce.
			$nonce = esc_attr($_REQUEST['_wpnonce']);

			if (!wp_verify_nonce($nonce, $this->plugin_name . '-delete-poll')) {
				die('Go get a life script kiddies');
			} else {
				self::delete_polls(absint($_GET['poll']));

				// esc_url_raw() is used to prevent converting ampersand in url to "#038;"
				// add_query_arg() return the current url

				$url = esc_url_raw(remove_query_arg(['action', 'poll', '_wpnonce'])) . '&status=' . $message;
				wp_redirect($url);
			}

		}

		// If the delete bulk action is triggered
		if ((isset($_POST['action']) && 'bulk-delete' == $_POST['action'])
		    || (isset($_POST['action2']) && 'bulk-delete' == $_POST['action2'])
		) {

			$delete_ids = esc_sql($_POST['bulk-action']);

			// loop over the array of record IDs and delete them
			foreach ( $delete_ids as $id ) {
				self::delete_polls($id);

			}

			// esc_url_raw() is used to prevent converting ampersand in url to "#038;"
			// add_query_arg() return the current url

			$url = esc_url_raw(remove_query_arg(['action', 'poll', '_wpnonce'])) . '&status=' . $message;
			wp_redirect($url);
		}
	}

	/**
	 * Delete a customer record.
	 *
	 * @param int $id customer ID
	 */
	public static function delete_polls( $id ) {
		global $wpdb;
		$wpdb->delete(
			"{$wpdb->prefix}ayspoll_polls",
			array('id' => $id),
			array('%d')
		);
		$wpdb->delete(
			"{$wpdb->prefix}ayspoll_answers",
			array('poll_id' => $id),
			array('%d')
		);
		$sql = "DELETE FROM {$wpdb->prefix}ayspoll_reports
        WHERE answer_id NOT IN (SELECT id FROM {$wpdb->prefix}ayspoll_answers)";
		$wpdb->query($sql);
	}

	/**
	 * Returns the count of records in the database.
	 *
	 * @return null|string
	 */
	public static function record_count() {
		global $wpdb;
		$where = array();
		$sql = '';

		$sql = "SELECT COUNT(*) FROM {$wpdb->prefix}ayspoll_polls";
        $search = ( isset( $_REQUEST['s'] ) ) ? $_REQUEST['s'] : false;

		if( ! current_user_can( 'manage_options' ) ){
            $current_user = get_current_user_id();
            $where[] = " author_id = ".$current_user." ";
        }

        if(isset( $_REQUEST['filterby'] ) && $_REQUEST['filterby'] > 0 ){
			$cat_id = $_REQUEST['filterby'];
            $where[] = 'categories LIKE("%,'.$cat_id.',%")';
        }

        if( $search ){
			$where[] = " title LIKE '%%".$search."%%' " ;
		}

        if( !empty($where)){
			$sql .= " WHERE " . implode( " AND ", (($where)) );
		}

		return $wpdb->get_var($sql);
	}

	public static function get_where_condition(){
        $where = array();
        $sql = '';

        $search = ( isset( $_REQUEST['s'] ) ) ? $_REQUEST['s'] : false;
        if( $search ){
			$where[] = " title LIKE '%%".$search."%%' " ;
		}
			
		if( !empty($where)){
			$sql = " WHERE " . implode( " AND ", (($where)) );
		}
		return $sql;
    }

	/**
	 * Retrieve customers data from the database
	 *
	 * @param int $per_page
	 * @param int $page_number
	 *
	 * @return mixed
	 */
	public static function get_polls( $per_page = 20, $page_number = 1, $search = '' ) {

		global $wpdb;
		$sql = "SELECT * FROM {$wpdb->prefix}ayspoll_polls";

		$where = array();

        if( $search != '' ){
            $where[] = $search;
        }

	 	if( ! current_user_can( 'manage_options' ) ){
            $current_user = get_current_user_id();
            $where[] = " author_id = ".$current_user." ";
        }

        if(isset( $_REQUEST['filterby'] ) && $_REQUEST['filterby'] > 0 ){
			$cat_id = $_REQUEST['filterby'];
            $where[] = 'categories LIKE("%,'.$cat_id.',%")';
        }

        if( ! empty($where) ){
            $sql .= " WHERE " . implode( " AND ", $where );
        }

		if (!empty($_REQUEST['orderby'])) {
			$sql .= ' ORDER BY ' . esc_sql($_REQUEST['orderby']);
			$sql .= !empty($_REQUEST['order']) ? ' ' . esc_sql($_REQUEST['order']) : ' DESC';
		} else {
			$sql .= ' ORDER BY id DESC';
		}
		$sql .= " LIMIT $per_page";
		$sql .= ' OFFSET ' . ($page_number - 1) * $per_page;

		$result = $wpdb->get_results($sql, 'ARRAY_A');

		return $result;
	}

	public function poll_notices() {
		$status = (isset($_REQUEST['status'])) ? sanitize_text_field($_REQUEST['status']) : '';

		if (empty($status)) {
			return;
		}

		if ('created' == $status) {
			$updated_message = esc_html(__('Poll created.', $this->plugin_name));
		} elseif ('updated' == $status) {
			$updated_message = esc_html(__('Poll saved.', $this->plugin_name));
		} elseif ('deleted' == $status) {
			$updated_message = esc_html(__('Poll(s) deleted.', $this->plugin_name));
		}

		if (empty($updated_message)) {
			return;
		}

		?>
        <div class="notice notice-success is-dismissible" style='margin-top:20px'>
            <p>
				<?php echo $updated_message; ?>
            </p>
        </div>
		<?php
	}

	public function apm_import_polls( $files ) {
		global $wpdb;
		$category_table = $wpdb->prefix."ayspoll_categories";
		$name = $files['import_csv']['name'];
		$arr  = explode('.', $name);
		$ext  = $arr[count($arr) - 1];
		if ($ext !== 'csv' && $ext !== 'CSV') {
			$message = array(
				__('You selected wrong file. Select *.csv file, please.', $this->plugin_name),
				'error'
			);
		} else {
			if (!file_exists('import')) {
				mkdir(plugin_dir_path(__FILE__) . '/import');
			}
			$upload_dir = plugin_dir_path(__FILE__) . "/import/" . uniqid('apm-import-poll-') . $name;
			move_uploaded_file($_FILES['import_csv']['tmp_name'], $upload_dir);
			$csv_data = array();
			if (($csv_file = fopen($upload_dir, 'r')) !== false) {
				while ( ($row = fgetcsv($csv_file)) !== false ) {
					$csv_data[] = $row;
				}
				fclose($csv_file);
				unlink($upload_dir);
				rmdir(plugin_dir_path(__FILE__) . '/import');

				$polls_count = 0;
				
				
				$answer_slice = 10;
				$for_new_files = false;
				if(isset($csv_data[0]) && count($csv_data[0]) > 11){
					$answer_slice = 12;
					$for_new_files = true;
				}
				$categories = $this->get_categories();
				$categories_added = array();
				if(!empty($categories)){
					foreach($categories as $c_key => $c_value){
						$current_cat_id    = isset($c_value['id']) && $c_value['id'] != '' ? $c_value['id'] : '';
						$current_cat_title = isset($c_value['title']) && $c_value['title'] != '' ? $c_value['title'] : '';
						$categories_added[$current_cat_id] = strtolower($current_cat_title);
					}
				}
				foreach ( $csv_data as $key => $impoll ) {
					if ($key == 0) {
						continue;
					}
					$answers = array_slice($impoll, $answer_slice);
					if (empty($answers)) {
						continue;
					}
					$polls_count++;
					$cat_names = isset($impoll[10]) && $impoll[10] != "" ? explode("," , $impoll[10]) : array();
					if(!empty($cat_names)){
						$cat_new_ids = array();
						foreach($cat_names as $cat_key => $cat_value){							
							if(isset($cat_value) && $cat_value != ""){
								$cat_new_id = 1;
								$category_name = 'Uncategorized';
								$category_name = strval($cat_value);								
								if($this->string_starts_with_number($category_name)){
									$cat_new_id = 1;
									$cat_new_ids = array("1");
								}elseif(in_array(strtolower($category_name), $categories_added)){
									$category_id = array_search(strtolower($category_name), $categories_added);
									if($category_id !== false && $category_id > 1){
										$cat_new_id = intval($category_id);
										$cat_new_ids[] = intval($category_id);
									}else{
										$cat_new_id = 1;
										$cat_new_ids = array("1");
									}
								}
								else{
									$wpdb->insert(
										$category_table,
										array( 'title'  =>  $category_name),
										array( '%s' )
									);
									$cat_new_id = $wpdb->insert_id;
									$cat_new_ids[] = $wpdb->insert_id;
									$categories_added[$cat_new_id] = strtolower($category_name);
								}
							}
						}
					}
					$all_cats = ",".implode("," , $cat_new_ids).",";
					$current_user = wp_get_current_user();
					$current_user_id = $current_user->data->ID;
					$options = isset($impoll[7]) && !empty($impoll[7]) ? json_decode($impoll[7] , "ARRAY_A") : '{"main_color":"#0C6291","text_color":"#0C6291","icon_color":"#0C6291","icon_size":24,"width":0,"btn_text":"Vote","border_style":"ridge","bg_color":"#FBFEF9","bg_image":false,"info_form":0,"fields":"apm-name,apm-email,apm-phone,apm-date_of_birth","required_fields":"apm-email","hide_results":0,"hide_results_text":"Thanks for your answer!","allow_not_vote":0}';					
					if(isset($options['create_date'])){
						$options['create_date'] = current_time('mysql');
					}
					if(is_array($options)){
						$options = json_encode($options);
					}
						$poll_result = $wpdb->insert(
							$wpdb->prefix . "ayspoll_polls",
							array(
								'author_id'   => $current_user_id,
								'title'       => $impoll[0],
								'description' => 'imported poll',
								'type'        => $impoll[2],
								'question'    => $impoll[1],
								'view_type'   => empty($impoll[3]) ? 'emoji' : $impoll[3],
								'categories'  => $all_cats,
								'image'       => $impoll[4],
								'show_title'  => empty($impoll[6]) ? 1 : $impoll[6],
								'styles'      => $options,
								'custom_css'  => $impoll[8],
								'theme_id'    => empty($impoll[9]) ? 1 : $impoll[9],
							),
							array(
								'%d',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%s',
								'%d',
								'%s',
								'%s',
								'%d',
							)
						);
						$last_id     = $wpdb->insert_id;
						foreach ( $answers as $k => $answer ) {
							if (empty($answer)) {
								continue;
							}
							$poll_opened_answers = json_decode($answer);
							$poll_new_answer = isset($poll_opened_answers[0]) && $poll_opened_answers[0] != "" ? $poll_opened_answers[0] : ""; 
							$poll_new_answer_img = isset($poll_opened_answers[1]) && $poll_opened_answers[1] != "" ? $poll_opened_answers[1] : ""; 
							$wpdb->insert(
								$wpdb->prefix . "ayspoll_answers",
								array(
									'poll_id' => $last_id,
									'answer'  => $poll_new_answer,
									'answer_img'  => $poll_new_answer_img
								),
								array(
									'%d',
									'%s',
									'%s',
								)
							);
						}
					
				}

				$message = array(
					__("$polls_count poll(s) were imported from " . (count($csv_data) - 1), $this->plugin_name),
					'success'
				);
			} else {
				$message = array(
					__("Selected file is invalid. Select correct *.csv file, please.", $this->plugin_name),
					'error'
				);
			}			
		}
		echo "<div class='notice notice-{$message[1]} is-dismissible' style='margin-top:20px'>
                <p>" . esc_html($message[0]) . "</p>
             </div>";
	}

	//export all polls
	public function apm_export_polls( $path ) {
		global $wpdb;
		error_reporting(0);
		$file_path   = $path . 'exported_polls/exported_polls.csv';
		$export_file = fopen($file_path, 'wa');
		$sql = "";
		if(current_user_can("manage_options")){
			$sql = "SELECT * FROM {$wpdb->prefix}ayspoll_polls ORDER BY id ASC";
		}
		else{
			$current_user = get_current_user_id();
			if($current_user > 0){
				$sql = "SELECT * FROM {$wpdb->prefix}ayspoll_polls WHERE author_id=".$current_user." ORDER BY id ASC";
			}
		}
		$polls = $wpdb->get_results($sql, 'ARRAY_A');
		if (empty($polls)) {
			return array('status' => 'error', 'message' => __("Nothing for export.", $this->plugin_name));
		}

		$fields = array(
			'poll title',
			'poll question',
			'poll type',
			'poll view_type',
			'poll image',
			'poll categories',
			'poll show_title',
			'poll styles',
			'poll custom_css',
			'poll theme_id',
			'poll category titles',
			'poll author',
			'poll answers',
		);
		fputcsv($export_file, $fields);
		foreach ( $polls as $poll ) {
			$poll_cat_ids = isset($poll['categories']) && $poll['categories'] != "" ? trim($poll['categories'] , ',') : '';
			$categories   = array();
			$cat_titles = '';
			if($poll_cat_ids != ''){
				$categories = $this->get_categories_by_ids($poll_cat_ids);
			}
			if(!empty($categories)){
				foreach($categories as $c_key => $c_value){
					$this_title = isset($c_value['title']) && $c_value['title'] != '' ? sanitize_text_field($c_value['title']) : '';
					$cat_titles .= $this_title;
					if(count($categories) > 1){
						$cat_titles .= ",";
					}
				}
			}
			$sql         = "SELECT * FROM {$wpdb->prefix}ayspoll_answers WHERE poll_id='{$poll['id']}' ORDER BY id ASC";
			$res         = $wpdb->get_results($sql, 'ARRAY_A');
			$answers     = array_column($res, 'answer');
			$gagas = array();
			foreach($res as $k => $t){
				$gagas[] = array(
					$t['answer'],
					$t['answer_img']
				); 
			}
			$poll_data   = array(
				$poll['title'],
				$poll['question'],
				$poll['type'],
				$poll['view_type'],
				$poll['image'],
				$poll['categories'],
				$poll['show_title'],
				$poll['styles'],
				$poll['custom_css'],
				$poll['theme_id'],
				$cat_titles,
				$poll['author_id'],
			);
			// $added_cat = array(
			// 	"categories" => $cat_titles,
			// 	"author_id"  => $poll['author_id'],
			// );
			foreach($gagas as $z => $r){
				$poll_data[] = json_encode($r);

			}
			// $export_data = array_merge($poll_data, $gagas);
			// $export_data = array_merge($export_data, $added_cat);
			fputcsv($export_file, $poll_data);
		}

		if (!$export_file) {
			return array(
				'status'  => 'warning',
				'message' => __("Something wents wrong. May be your *.csv file is open, please close it", $this->plugin_name)
			);
		}
		fclose($export_file);

		return array(
			'file'    => $file_path,
			'status'  => 'success',
			'message' => __(count($polls) . " poll(s) were exported.", $this->plugin_name)
		);
	}

	public function get_categories_by_ids($ids){
		global $wpdb;
		$category_table = $wpdb->prefix."ayspoll_categories";
		$sql = "SELECT id,title FROM ".$category_table." WHERE id IN(".$ids.")";
		$results = $wpdb->get_results($sql, 'ARRAY_A');
		return $results;
	}

	public static function string_starts_with_number($string){
        $match = preg_match('/^\d/', $string);
        if($match === 1){
            return true;
        }else{
            return false;
        }
    }

	public function hex2rgba( $color, $opacity = false ) {

		$default = 'rgba(80, 24, 1, 0.5)';
		/**
		 * Return default if no color provided
		 */
		if (empty($color)) {
			return $default;
		}
		/**
		 * Sanitize $color if "#" is provided
		 */
		if ($color[0] == '#') {
			$color = substr($color, 1);
		}

		/**
		 * Check if color has 6 or 3 characters and get values
		 */
		if (strlen($color) == 6) {
			$hex = array($color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5]);
		} elseif (strlen($color) == 3) {
			$hex = array($color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2]);
		} else {
			return $default;
		}

		/**
		 * [$rgb description]
		 * @var array
		 */
		$rgb = array_map('hexdec', $hex);
		/**
		 * Check if opacity is set(rgba or rgb)
		 */
		if ($opacity) {
			if (abs($opacity) > 1) {
				$opacity = 1;
			}
			$output = 'rgba( ' . implode(",", $rgb) . ',' . $opacity . ' )';
		} else {
			$output = 'rgb( ' . implode(",", $rgb) . ' )';
		}

		/**
		 * Return rgb(a) color string
		 */
		return $output;
	}
}