<?php
    class Poll_Maker_All_Results{
        /**
         * The ID of this plugin.
         *
         * @since    1.0.0
         * @access   private
         * @var      string $plugin_name The ID of this plugin.
         */
        protected $plugin_name;

        /**
         * The version of this plugin.
         *
         * @since    1.0.0
         * @access   private
         * @var      string $version The current version of this plugin.
         */
        private $version;

        /**
         * Initialize the class and set its properties.
         *
         * @since    1.0.0
         * @param      string $plugin_name The name of the plugin.
         * @param      string $version The version of this plugin.
         */
        public function __construct($plugin_name, $version){

            $this->plugin_name = $plugin_name;
            $this->version = $version;

            add_shortcode('ays_poll_all_results', array($this, 'ays_generate_poll_all_results'));
            
            $this->settings = new Poll_Maker_Settings_Actions($this->plugin_name);
        }

            /**
         * Register the stylesheets for the public-facing side of the site.
         *
         * @since    1.0.0
         */
	    public function enqueue_styles() {

            /**
             * This function is provided for demonstration purposes only.
             *
             * An instance of this class should be passed to the run() function
             * defined in Poll_Maker_Ays_Loader as all of the hooks are defined
             * in that particular class.
             *
             * The Poll_Maker_Ays_Loader will then create the relationship
             * between the defined hooks and the functions defined in this
             * class.
             */
            wp_enqueue_style($this->plugin_name . '-dataTable-min', POLL_MAKER_AYS_PUBLIC_URL . '/css/poll-maker-dataTables.min.css', array(), $this->version, 'all');
	    }

        /**
         * Register the JavaScript for the public-facing side of the site.
         *
         * @since    1.0.0
         */
	    public function enqueue_scripts() {

            /**
             * This function is provided for demonstration purposes only.
             *
             * An instance of this class should be passed to the run() function
             * defined in Poll_Maker_Ays_Loader as all of the hooks are defined
             * in that particular class.
             *
             * The Poll_Maker_Ays_Loader will then create the relationship
             * between the defined hooks and the functions defined in this
             * class.
             */
            wp_enqueue_script( $this->plugin_name . '-datatable-min', POLL_MAKER_AYS_PUBLIC_URL . '/js/poll-maker-datatable.min.js', array('jquery'), $this->version, true);
            wp_enqueue_script( $this->plugin_name , plugin_dir_url(__FILE__) . 'js/poll-maker-ays-public.js', array('jquery'), $this->version, false);
            wp_localize_script( $this->plugin_name . '-ajax-public', 'pollLangDataTableObj', array(
                "sEmptyTable"           => __( "No data available in table", $this->plugin_name ),
                "sInfo"                 => __( "Showing _START_ to _END_ of _TOTAL_ entries", $this->plugin_name ),
                "sInfoEmpty"            => __( "Showing 0 to 0 of 0 entries", $this->plugin_name ),
                "sInfoFiltered"         => __( "(filtered from _MAX_ total entries)", $this->plugin_name ),
                // "sInfoPostFix":          => __( "", $this->plugin_name ),
                // "sInfoThousands":        => __( ",", $this->plugin_name ),
                "sLengthMenu"           => __( "Show _MENU_ entries", $this->plugin_name ),
                "sLoadingRecords"       => __( "Loading...", $this->plugin_name ),
                "sProcessing"           => __( "Processing...", $this->plugin_name ),
                "sSearch"               => __( "Search:", $this->plugin_name ),
                // "sUrl":                  => __( "", $this->plugin_name ),
                "sZeroRecords"          => __( "No matching records found", $this->plugin_name ),
                "sFirst"                => __( "First", $this->plugin_name ),
                "sLast"                 => __( "Last", $this->plugin_name ),
                "sNext"                 => __( "Next", $this->plugin_name ),
                "sPrevious"             => __( "Previous", $this->plugin_name ),
                "sSortAscending"        => __( ": activate to sort column ascending", $this->plugin_name ),
                "sSortDescending"       => __( ": activate to sort column descending", $this->plugin_name ),
            ) );
            
	    }

        public function get_user_reports_info( $show_publicly ){
            global $wpdb;

            $current_user = wp_get_current_user();
            $id = $current_user->ID;

            if (! $show_publicly) {
                if($id == 0){
                    return null;
                }
            }

            $reports_table = $wpdb->prefix . "ayspoll_reports";
            $quizes_table  = $wpdb->prefix . "ayspoll_polls";
            $answers_table = $wpdb->prefix . "ayspoll_answers";

            $sql = "SELECT r.poll_id, q.title, r.vote_date, r.id, r.user_id, a.answer
                    FROM $reports_table AS r
                    LEFT JOIN $quizes_table AS q
                    ON r.poll_id = q.id
                    LEFT JOIN {$answers_table} AS a
                    ON r.answer_id = a.id
                    ORDER BY r.id DESC";
            $results = $wpdb->get_results($sql, "ARRAY_A");

            return $results;

        }

        public function ays_poll_all_results_html(){
            $poll_settings = $this->settings;
            $poll_settings_options = ($poll_settings->ays_get_setting('options') === false) ? json_encode(array()) : $poll_settings->ays_get_setting('options');
            $poll_set_option = json_decode(stripcslashes($poll_settings_options), true);
            
            // Show publicly
            $poll_set_option['poll_all_results_show_publicly'] = isset($poll_set_option['poll_all_results_show_publicly']) ? $poll_set_option['poll_all_results_show_publicly'] : 'off';
            $all_results_show_publicly = (isset($poll_set_option['poll_all_results_show_publicly']) && $poll_set_option['poll_all_results_show_publicly'] == "on") ? true : false;

            $results = $this->get_user_reports_info( $all_results_show_publicly );

            $default_all_results_columns = array(
                'user_name'     => 'user_name',
                'poll_name'     => 'poll_name',
                'vote_date'     => 'vote_date',
                'vote_answer'   => 'vote_answer',
            );
            
            $all_results_columns = (isset( $poll_set_option['poll_all_results_columns'] ) && !empty($poll_set_option['poll_all_results_columns']) ) ? $poll_set_option['poll_all_results_columns'] : $default_all_results_columns;
            $all_results_columns_order = (isset( $poll_set_option['poll_all_results_columns_order'] ) && !empty($poll_set_option['poll_all_results_columns_order']) ) ? $poll_set_option['poll_all_results_columns_order'] : $default_all_results_columns;

            $all_results_columns_order_arr = $all_results_columns_order;

            foreach( $default_all_results_columns as $key => $value ){
                if( !isset( $all_results_columns[$key] ) ){
                    $all_results_columns[$key] = '';
                }

                if( !isset( $all_results_columns_order[$key] ) ){
                    $all_results_columns_order[$key] = $key;
                }

                if ( ! in_array( $key , $all_results_columns_order_arr) ) {
                    $all_results_columns_order_arr[] = $key;
                }
            }

            foreach( $all_results_columns_order as $key => $value ){
                if( !isset( $all_results_columns[$key] ) ){
                    if( isset( $all_results_columns[$value] ) ){
                        $all_results_columns_order[$value] = $value;
                    }
                    unset( $all_results_columns_order[$key] );
                }
            }

            foreach ($all_results_columns_order_arr  as $key => $value) {
                if( isset( $all_results_columns_order[$value] ) ){
                    $all_results_columns_order_arr[$value] = $value;
                }

                if ( is_int( $key ) ) {
                    unset( $all_results_columns_order_arr[$key] );
                }
            }

            $all_results_columns_order = $all_results_columns_order_arr;

            $default_all_results_column_names = array(
                "user_name"     => __( 'User name', $this->plugin_name ),
                "poll_name"     => __( 'Poll name', $this->plugin_name ),
                "vote_date"     => __( 'Vote date', $this->plugin_name ),
                "vote_answer"   => __( 'Vote answer', $this->plugin_name ),
            );

            if( !empty($user_results_custom_fields) ){
                foreach ($user_results_custom_fields as $custom_field_key => $custom_field_value) {
                    $default_all_results_column_names[$custom_field_key] = $custom_field_value;
                }
            }

            $ays_default_header_value = array(
                "user_name"     => "<th style='width:20%;'>" . __( "User Name", $this->plugin_name ) . "</th>",
                "poll_name"     => "<th style='width:20%;'>" . __( "Poll Name", $this->plugin_name ) . "</th>",
                "vote_date"     => "<th style='width:15%;'>" . __( "Vote Date", $this->plugin_name ) . "</th>",
                "vote_answer"     => "<th style='width:15%;'>" . __( "Vote Answer", $this->plugin_name ) . "</th>",
            );

            if($results === null){
                $all_results_html = "<p style='text-align: center;font-style:italic;'>" . __( "You must log in to see your results.", $this->plugin_name ) . "</p>";
                return $all_results_html;
            }
            
            if( empty( $results ) ){
                $all_results_html = "<p style='text-align: center;font-style:italic;'>" . __( "There are no results yet.", $this->plugin_name ) . "</p>";
                return $all_results_html;
            }

            $all_results_html = "<div class='ays-poll-all-results-container'>
            <table id='ays-poll-all-result-score-page' class='display'>
            <thead>
            <tr>";
            
            foreach ($all_results_columns_order as $key => $value) {
                if ( isset($all_results_columns[$value]) && $all_results_columns[$value] != '' && isset( $ays_default_header_value[$value] )) {
                    $all_results_html .= $ays_default_header_value[$value];
                }
            }
            
            $all_results_html .= "</tr></thead>";

            foreach($results as $key => $result){
                $id         = isset($result['id']) ? $result['id'] : null;
                $poll_id    = isset($result['poll_id']) ? absint($result['poll_id']) : null;
                $user_id    = isset($result['user_id']) ? intval($result['user_id']) : 0;
                $title      = isset($result['title']) ? $result['title'] : "";
                $vote_answer = (isset($result['answer']) && $result['answer'] != '') ? stripslashes(sanitize_text_field($result['answer'])) : "";
                $vote_date  = date_create($result['vote_date']);
                $vote_date  = date_format($vote_date, 'H:i:s M d, Y');

                $vote_date_for_ordering = strtotime($result['vote_date']);


                if ($user_id == 0) {
                    $user_name = (isset($result['user_name']) && $result['user_name'] != '') ? $result['user_name'] : __('Guest', $this->plugin_name);
                }else{
                    $user_name = (isset($result['user_name']) && $result['user_name'] != '') ? $result['user_name'] : '';
                    if($user_name == ''){
                        $user = get_userdata( $user_id );
                        if($user !== false){
                            $user_name = $user->data->display_name ? $user->data->display_name : $user->user_login;
                        }else{
                            continue;
                        }
                    }
                }

                $ays_default_html_order = array(
                    "user_name"     => "<td>$user_name</td>",
                    "poll_name"     => "<td>$title</td>",
                    "vote_date"     => "<td data-order='". $vote_date_for_ordering ."'>$vote_date</td>",
                    "vote_answer"      => "<td>$vote_answer</td>",
                );

                $all_results_html .= "<tr>";
                foreach ($all_results_columns_order as $key => $value) {
                    if ( isset($all_results_columns[$value]) && $all_results_columns[$value] != '' && isset( $ays_default_html_order[$value] ) ) {
                        $all_results_html .= $ays_default_html_order[$value];
                    }
                }
                $all_results_html .= "</tr>";
            }

            $all_results_html .= "</table>
                </div>";
            
            return $all_results_html;
        }

        public function ays_generate_poll_all_results() {

            $this->enqueue_styles();
            $this->enqueue_scripts();
            $poll_all_results_html = $this->ays_poll_all_results_html();

            return str_replace(array("\r\n", "\n", "\r"), '', $poll_all_results_html);
        }
    }

?>