var paoc_meta_notify_timer;

(function($) {

	"use strict";

	paoc_pro_tooltip();

	/* Initialize Select 2 */
	if( $('.paoc-select2').length > 0 ) {
		$('.paoc-select2').select2({
			allowClear		: true,
			closeOnSelect	: false,
			language		: {
								inputTooShort : function() {
									return PaocProAdmin.select2_input_too_short;
								},
								removeAllItems : function() {
									return PaocProAdmin.select2_remove_all_items;
								},
								removeItem : function() {
									return PaocProAdmin.select2_remove_item;
								},
								searching : function() {
									return PaocProAdmin.select2_searching;
								}
							}
		});
	}

	/* Color Picker */
	if( $('.paoc-colorpicker').length > 0 ) {
		$('.paoc-colorpicker').wpColorPicker({
			width : 260,
		}).closest('td').addClass('paoc-colorpicker-wrap');
	}

	/* Initialize DatePicker */
	if( $('.paoc-date').length > 0 ) {
		$('.paoc-date').datepicker({
			dateFormat	: 'yy-mm-dd',
			changeMonth	: true,
			changeYear	: true,
		});
	}

	/* Initialize Datetimepicker */
	if( $('.paoc-datetime').length > 0 ) {
		$('.paoc-datetime').datetimepicker({
			dateFormat	: 'yy-mm-dd',
			timeFormat	: 'HH:mm:ss',
			minDate		: 0,
			changeMonth	: true,
			changeYear	: true,
		});
	}

	/* Initialize Timepicker */
	if( $('.paoc-time').length > 0 ) {

		$('.paoc-time').timepicker({
			timeFormat : 'HH:mm:ss',
		});
	}

	/* Click to Copy the Text */
	$(document).on('click', '.paoc-copy-clipboard', function() {
		var copyText = $(this);
		copyText.select();
		document.execCommand("copy");
	});

	/* Vertical Tab */
	$( document ).on( "click", ".paoc-vtab-nav a", function() {

		$(".paoc-vtab-nav").removeClass('paoc-active-vtab');
		$(this).parent('.paoc-vtab-nav').addClass("paoc-active-vtab");

		var selected_tab = $(this).attr("href");
		$('.paoc-vtab-cnt').hide();

		/* Show the selected tab content */
		$(selected_tab).show();

		/* Pass selected tab */
		$('.paoc-selected-tab').val(selected_tab);
		return false;
	});

	/* Remain selected tab for user */
	if( $('.paoc-selected-tab').length > 0 ) {

		var sel_tab = $('.paoc-selected-tab').val();

		if( typeof(sel_tab) !== 'undefined' && sel_tab != '' && $(sel_tab).length > 0 ) {
			$('.paoc-vtab-nav [href="'+sel_tab+'"]').click();
		} else {
			$('.paoc-vtab-nav:first-child a').click();
		}
	}

	/***** Start - Add More for Social Profile & Integration Tab *****/
	$( document ).on('click', '.paoc-add-clone-btn', function() {

		var highest;

		var cls_ele 		= $(this).closest('.paoc-clone-ele-wrap');
		var clone_ele		= $(this).closest('.paoc-clone-row').clone();
		var clone_type		= $(this).attr('data-clone-type');
		var update_name		= $(this).attr('data-update-name');
			update_name		= update_name ? update_name : 1;

		/* Retrieve the highest current key */
		var key = highest = -1;
		cls_ele.find( '.paoc-clone-row' ).each(function() {
			var current = $(this).data( 'key' );
			if( parseInt( current ) > highest ) {
				highest = current;
			}
		});
		key = highest += 1;

		clone_ele.attr( 'data-key', key );
		clone_ele.find( 'input, textarea' ).val( '' );
		clone_ele.find( 'select').prop('selectedIndex', 0);
		clone_ele.find( 'input[type=checkbox]').prop("checked", false);
		clone_ele.find('.paoc-clone-list-no').text( key );
		clone_ele.removeClass('paoc-accordion-active');

		clone_ele.find( 'input, select, textarea' ).each(function() {
			var name = $( this ).attr( 'name' );
			var id   = $( this ).attr( 'id' );

			if( update_name == 1 && name ) {
				name = name.replace( /\[(\d+)\]/, '[' + parseInt( key ) + ']');
				$( this ).attr( 'name', name );
				$( this ).attr( 'data-key', key );
			}

			if( typeof id != 'undefined' ) {
				id = id.replace( /(\d+)/, parseInt( key ) );
				$( this ).attr( 'id', id );
			}
		});

		clone_ele.find( 'label' ).each(function() {
			var label = $( this ).attr( 'for' );

			if( typeof label != 'undefined' ) {
				label = label.replace( /(\d+)/, parseInt( key ) );
				$( this ).attr( 'for', label );
			}
		});

		clone_ele.appendTo( cls_ele ); /* Clone and insert */

		/* If `Integration` is there */
		if( clone_type == 'integration' ) {

			/* Remove other fields dropdown */
			clone_ele.find('.paoc-clone-row').not(':first').remove();
			clone_ele.find('.paoc-empty-select option:not(:first)').remove();

			/* Change mailchimp list name on row */
			clone_ele.find('.paoc-intgs-list-name').text('');
		}

		clone_ele.find('.paoc-tooltip').removeClass('tooltipstered');
		paoc_pro_tooltip();
	});

	$(document).on('click', '.paoc-del-clone-btn', function() {
			
		var cls_ele	= $(this).closest('.paoc-clone-ele-wrap');

		/* Add nested class so it will not mis calculate */
		cls_ele.find('.paoc-clone-ele-wrap .paoc-clone-row').addClass('paoc-nested-clone-ele');
		
		var num_of_row = cls_ele.find('.paoc-clone-row').not('.paoc-nested-clone-ele').length;

		if( num_of_row == 1 ) {
			
			alert( PaocProAdmin.one_field_msg );
			return false;

		} else {

			$(this).closest('tr.paoc-clone-row, div.paoc-clone-row').remove();
		}

		cls_ele.find('.paoc-clone-row').removeClass('paoc-nested-clone-ele');
	});
	/***** End - Add More *****/

	/***** Start - Form Fields *****/
	/* Add Row for Form Fields */
	$( document ).on('click', '.paoc-add-form-field-row', function() {

		var highest, clone_ele;

		var cls_ele 	= $(this).closest('.paoc-form-field-row-wrp');
		var template	= wp.template('paoc-form-field-tmpl');

		/* Retrieve the highest current key */
		var key = highest = -1;
		cls_ele.find( '.paoc-form-field-row' ).each(function() {
			var current = $(this).data( 'key' );
			if( parseInt( current ) > highest ) {
				highest = current;
			}
		});
		key = highest += 1;

		var tmpl_data = {
			field_key : key
		};
		template	= template( tmpl_data );
		clone_ele	= $( template );

		clone_ele.attr( 'data-key', key );
		clone_ele.find( 'input[type="text"], textarea' ).val( '' );

		clone_ele.find( 'input, select, textarea' ).each(function() {
				var name = $( this ).attr( 'name' );
				var id   = $( this ).attr( 'id' );

				if( name ) {
					name = name.replace( /\[(\d+)\]/, '[' + parseInt( key ) + ']');
					$( this ).attr( 'name', name );
				}

				if( typeof id != 'undefined' ) {
					id = id.replace( /(\d+)/, parseInt( key ) );
					$( this ).attr( 'id', id );
				}
			});

		clone_ele.find( 'label' ).each(function() {
			var label = $( this ).attr( 'for' );

			if( typeof label != 'undefined' ) {
				label = label.replace( /(\d+)/, parseInt( key ) );
				$( this ).attr( 'for', label );
			}
		});

		$(this).closest('.paoc-form-field-row').after( clone_ele );

		paoc_pro_tooltip();
	});

	/* Delete Form Field Row */
	$(document).on('click', '.paoc-del-form-field-row', function() {

		var num_of_row = $('.paoc-form-field-row-wrp .paoc-form-field-row').length;

		if( num_of_row > 1 ) {
			var ans = confirm( PaocProAdmin.cofirm_msg );
			if( ans ) {
				$(this).closest('.paoc-form-field-row').remove();
			}
		} else {
			alert( PaocProAdmin.one_field_msg );
		}
		return false;
	});
	/***** End - Form Fields *****/

	/* Show change notice */
	$(document).on('click', '.paoc-behav-box-wrp', function() {

		/* Display info notice */
		paoc_pro_popup_meta_notice( $('.paoc-meta-notify') );
	});

	/* Drag and Drop Social Services */
	if( $( '.paoc-form-field-row-wrp' ).length > 0 ) {
		$( '.paoc-form-field-row-wrp' ).sortable({
			items 				: '.paoc-form-field-row',
			handle 				: ".paoc-drag-form-field-row",
			cursor 				: 'move',
			axis 				: 'y',
			scrollSensitivity   : 40,
			placeholder         : "paoc-form-field-row-highlight",
			helper				: function( event, ui ) {
									return ui;
								},
			start				: function( event, ui ) {
									ui.placeholder.html("<tr><td colspan='3'></td><tr>")
									if ( ! ui.item.hasClass( 'alternate' ) ) {
										ui.item.css( 'background-color', '#ffffff' );
									}
								},
			stop				: function( event, ui ) {
								},
			update				: function( event, ui ) {
									if ( ! ui.item.hasClass( 'alternate' ) ) {
										ui.item.css( 'background-color', '' );
									}
								}
		});
	}

	/* Show / Hide form fields on change Field Type */
	$( document ).on('change', '.paoc-field-type', function() {
		var cls_ele		= $(this).closest('.paoc-form-field-row');
		var type_val	= $(this).val();

		cls_ele.find('.paoc-field-show').show();
		cls_ele.find('.paoc-field-hide').hide();

		cls_ele.find('.paoc-field-show-'+type_val).show();
		cls_ele.find('.paoc-field-hide-'+type_val).hide();
	});

	/* Flush Popup Stats */
	$(document).on('click', '.paoc-flush-stats-btn', function() {

		var remove = paoc_pro_confirm();

		if( ! remove ) {
			return false;
		}

		var cls_ele = $(this).closest('.paoc-popup-report-sett');
		cls_ele.find('.paoc-spinner').css('visibility', 'visible');

		var data = {
			action		: 'paoc_pro_flush_popup_stats',
			popup_id	: PaocProAdmin.popup_id,
			nonce		: $(this).attr('data-nonce')
		};

		jQuery.post(ajaxurl, data, function(response) {

			if( response.success == 1 ) {
				location.reload( true );
			} else {
				alert( PaocProAdmin.sorry_msg );
				cls_ele.find('.paoc-spinner').css('visibility', 'hidden');
			}
		});
		return false;
	});

	/* Initialize Select 2 with Ajax */
	if( $('.paoc-post-title-sugg').length > 0 ) {

		/* Ajax suggest post title based on post type */
		$('.paoc-post-title-sugg').each(function() {

			var cls_ele			= $(this).closest('.paoc-report-form-wrp');
			var meta_data		= $(this).attr('data-meta');
			var nonce			= $(this).attr('data-nonce');
			var post_type_attr	= $(this).attr('data-post-type');
			var post_status		= $(this).attr('data-post-status');
			var predefined		= $(this).attr('data-predefined');

			$(this).select2({
				ajax: {
					url				: ajaxurl,
					dataType		: 'json',
					delay			: 500,
					data			: function ( params ) {
										var search_term = params.term.trim();
										var post_type	= post_type_attr ? post_type_attr : cls_ele.find('.paoc-post-type-sugg').val();

										delay: 0;

										return {
											action		: 'paoc_pro_post_title_sugg',
											form_data	: $('.paoc-post-title-sugg-form').serialize(),
											search		: search_term,
											post_type	: post_type,
											meta_data	: meta_data,
											post_status	: post_status,
											nonce		: nonce,
										};
									},
					processResults	: function( data ) {
										var options = [];

										if( predefined ) {
											options = JSON.parse( predefined );
											options = $.makeArray(options);
										}

										if ( data ) {
											$.each( data, function( index, text ) {
												options.push( { id: text[0], text: text[1]  } );
											});
										}
										return {
											results: options
										};
									},
					cache			: true
				},
				minimumInputLength	: 1,
				allowClear			: true,
				closeOnSelect		: false,
				language			: {
										inputTooShort : function() {
											return PaocProAdmin.select2_input_too_short;
										},
										removeAllItems : function() {
											return PaocProAdmin.select2_remove_all_items;
										},
										removeItem : function() {
											return PaocProAdmin.select2_remove_item;
										},
										searching : function() {
											return PaocProAdmin.select2_searching;
										}
									}

			});
		});
	}

	/* Media Uploader */
	$( document ).on( 'click', '.paoc-image-upload', function() {

		var imgfield, showfield, file_frame, parent_td, attachment_id;

		imgfield	= jQuery(this).prev('input').attr('id');
		parent_td	= jQuery(this).parents('td');
		showfield	= jQuery(this).parents('td').find('.paoc-img-view');

		/* If the media frame already exists, reopen it. */
		if ( file_frame ) {
			file_frame.open();
			return;
		}

		/* Create the media frame. */
		file_frame = wp.media.frames.file_frame = wp.media({
			frame		: 'post',
			state		: 'insert',
			title		: jQuery(this).data( 'uploader-title' ),
			button		: {
							text : jQuery(this).data( 'uploader-button-text' ),
						},
			multiple	: false  /* Set to true to allow multiple files to be selected */
		});

		file_frame.on( 'menu:render:default', function(view) {
			/* Store our views in an object. */
			var views = {};

			/* Unset default menu items */
			view.unset('library-separator');
			view.unset('gallery');
			view.unset('featured-image');
			view.unset('embed');
			view.unset('playlist');
			view.unset('video-playlist');

			/* Initialize the views in our view object. */
			view.set(views);
		});

		/* When an image is selected, run a callback. */
		file_frame.on( 'insert', function() {

			/* Get selected size from media uploader */
			var selected_size = $('.attachment-display-settings .size').val();

			var selection = file_frame.state().get('selection');
			selection.each( function( attachment, index ) {
				attachment		= attachment.toJSON();
				attachment_id	= attachment.id;

				if ( typeof(attachment.sizes) != 'undefined' ) {

					/* Selected attachment url from media uploader */
					var attachment_url = attachment.sizes[selected_size].url;

					parent_td.find('.popup-image-id').val( attachment_id );

					$('#'+imgfield).val(attachment_url);
					showfield.html('<img src="'+attachment_url+'" alt="" />');
				}
			});
		});

		/* Finally, open the modal */
		file_frame.open();
	});

	/* Clear Media */
	$( document ).on( 'click', '.paoc-image-clear', function() {

		$(this).parent().find('.paoc-img-upload-input').val('');
		$(this).parent().find('.paoc-img-view').html('');
		$(this).parent().find('.popup-image-id').val('');
	});

	/* Quick Overview Popup Data Click to Tab Trigger */
	$( document ).on( "click", ".paoc-navigate-sett", function() {

		/* Hide Quick Overview Popup */
		paoc_pro_hide_popup_modal();

		var sel_tab = $(this).attr('data-href');

		if( typeof(sel_tab) !== 'undefined' && sel_tab != '' && $(sel_tab).length > 0 ) {
			$('.paoc-vtab-nav [href="'+sel_tab+'"]').click();
		}
	});

	/* Show Preview Popup Modal - Start */
	$(document).on('click', '.paoc-show-popup-modal', function() {

		var curr_ele	= $(this);
		var preview		= $(this).attr('data-preview');
		var popup_id	= $(this).data('popup-id');
		var main_ele	= $('.paoc-popup-modal');

		main_ele.find('.paoc-popup-modal-loader').show();

		$('.paoc-popup-modal-preview').show();
		$('.paoc-popup-modal-overlay').show();
		$('body').addClass('paoc-no-overflow');

		if( preview == 1 ) {

			if( typeof(tinyMCE) != 'undefined' ) {
				tinyMCE.triggerSave();
			}

			var form_data = $('form#post').serialize();

			if( main_ele.find('.paoc-popup-modal-preview-toggle').hasClass('paoc-popup-modal-act-btn-active') ) {
				var preview_frame_data_src	= main_ele.find('.paoc-preview-frame').attr('data-default-preview-src');
			} else {
				var preview_frame_data_src	= main_ele.find('.paoc-preview-frame').attr('data-src');
			}

			$('body').append('<form action="'+preview_frame_data_src+'" method="post" class="paoc-preview-form" id="paoc-preview-form" target="paoc_preview_frame"></form>');
			$('#paoc-preview-form').append('<input type="hidden" name="paoc_preview_form_data" value="'+form_data+'" /> <input type="hidden" name="paoc_preview_popup_id" value="'+popup_id+'" />');
			$('#paoc-preview-form').trigger('submit');
			$('#paoc-preview-form').remove();

		} else {
			main_ele.find('.paoc-popup-modal-loader').fadeOut();
		}

		return false;
	});

	/* Popup Preview Toggle */
	$(document).on('click', '.paoc-popup-modal-preview-toggle', function() {
		$(this).toggleClass('paoc-popup-modal-act-btn-active');
		$('.paoc-show-popup-modal').trigger('click');
	});

	/* Tweak - To display preview link in admin bar menu */
	if( $('.paoc-popup-preview-btn').length > 0 ) {

		var curr_ele	= $('.paoc-popup-preview-btn');
		var preview		= curr_ele.attr('data-preview');
		var popup_id	= curr_ele.attr('data-popup-id');
		var btn_text	= curr_ele.text();

		if( preview == 1 ) {
			$('#wpadminbar #wp-admin-bar-top-secondary').append('<li id="wp-admin-bar-paoc-preview-menu" class="paoc-show-popup-modal" data-preview="1" data-popup-id="'+popup_id+'"><div class="ab-item ab-empty-item">'+btn_text+'</div></li>');
		}
	}

	/* Content Popup Open JS */
	$(document).on('click', '.paoc-open-popup', function() {
		paoc_pro_show_popup_modal( $(this) );
	});

	/* Close Popup Preview */
	$(document).on('click', '.paoc-popup-close', function() {
		paoc_pro_hide_popup_modal();
	});

	/* On load iframe */
	$('.paoc-popup-modal').find('.paoc-preview-frame').on('load', function() {
		$('.paoc-popup-modal').find('.paoc-popup-modal-loader').fadeOut();
	});

	/* Show Popup Quick Overview Popup */
	$(document).on('click', '.paoc-open-ajax-popup', function() {

		var curr_ele		= $(this);
		var paoc_res_data 	= curr_ele.data('paoc-res-data');
		var popup_id		= curr_ele.attr('data-popup-id');
		var identifier		= curr_ele.attr('data-id');
		var navigate		= curr_ele.attr('data-navigate');
		var cache			= curr_ele.attr('data-cache');
			cache			= cache == 0 ? 0 : 1;
		var popup_ele		= $('.paoc-modal-popup-'+identifier);
		var notice_ele		= $('.paoc-js-notice-notify');
		var form_data		= $('form#post').serialize();

		notice_ele.hide();
		notice_ele.removeClass('paoc-success paoc-error');

		popup_ele.find('.paoc-popup-modal-cnt-inr').html(''); /* Remove Quick Overview HTML */

		if( ! paoc_res_data ) {

			curr_ele.find('.paoc-btn-txt-icon').hide();
			curr_ele.find('.paoc-inline-loader').show();

			var data = {
				action					: 'paoc_pro_popup_quick_overview',
				popup_id				: popup_id,
				navigate				: navigate,
				paoc_preview_form_data	: form_data,
				nonce					: $(this).attr('data-nonce')
			};

			jQuery.post(ajaxurl, data, function( response ) {

				if( response.success == 1 ) {

					popup_ele.find('.paoc-popup-modal-cnt-inr').html( response.data );

					paoc_pro_show_popup_modal( curr_ele );

					if( cache == 1 ) {
						curr_ele.data('paoc-res-data', response.data);
					}

				} else {
					notice_ele.addClass('paoc-error');

					/* Display success notice */
					notice_ele.html( response.msg );
					paoc_pro_popup_meta_notice( notice_ele );
				}

				curr_ele.find('.paoc-btn-txt-icon').show();
				curr_ele.find('.paoc-inline-loader').hide();
			});

		} else {

			popup_ele.find('.paoc-popup-modal-cnt-inr').html( paoc_res_data );
			paoc_pro_show_popup_modal( curr_ele );
		}
	});
	/* Show Preview Popup Modal - End */

	/* Show/Hide JS */
	$( document ).on( 'change', '.paoc-show-hide', function() {

		var prefix		= $(this).attr('data-prefix');
		var inp_type	= $(this).attr('type');
		var showlabel	= $(this).attr('data-label');

		if(typeof(showlabel) == 'undefined' || showlabel == '' ) {
			showlabel = $(this).val();
		}

		if( prefix ) {
			showlabel = prefix +'-'+ showlabel;
			$('.paoc-show-hide-row-'+prefix).hide();
			$('.paoc-show-for-all-'+prefix).show();
		} else {
			$('.paoc-show-hide-row').hide();
			$('.paoc-show-for-all').show();
		}

		$('.paoc-show-if-'+showlabel).hide();
		$('.paoc-hide-if-'+showlabel).hide();

		if( inp_type == 'checkbox' || inp_type == 'radio' ) {
			if( $(this).is(":checked") ) {
				$('.paoc-show-if-'+showlabel).show();
			} else {
				$('.paoc-hide-if-'+showlabel).show();
			}
		} else {
			$('.paoc-show-if-'+showlabel).show();
		}
	});

	/* Report Setting Custom Date Range JS */
	$(document).on('change', '.paoc-date-range-filter', function() {
		var selected_date = $(this).val();

		$('.paoc-date-range-field').hide();
		$('.paoc-report-form .paoc-date-field').val('');

		if( selected_date == 'other' ) {
			$('.paoc-date-range-field').show();
		}
	});

	/* WP Code Editor */
	if( PaocProAdmin.code_editor == 1 && PaocProAdmin.syntax_highlighting == 1 ) {
		jQuery('.paoc-code-editor').each( function() {

			var cur_ele		= jQuery(this);
			var data_mode	= cur_ele.attr('data-mode');
			data_mode		= data_mode ? data_mode : 'css';

			if( cur_ele.hasClass('paoc-code-editor-initialized') ) {
				return;
			}

			var editorSettings = wp.codeEditor.defaultSettings ? _.clone( wp.codeEditor.defaultSettings ) : {};
			editorSettings.codemirror = _.extend(
				{},
				editorSettings.codemirror,
				{
					indentUnit	: 2,
					tabSize		: 2,
					mode		: data_mode,
				}
			);
			var editor = wp.codeEditor.initialize( cur_ele, editorSettings );
			cur_ele.addClass('paoc-code-editor-initialized');

			editor.codemirror.on( 'change', function( codemirror ) {
				cur_ele.val( codemirror.getValue() ).trigger( 'change' );
			});

			/* When post metabox is toggle */
			$(document).on('postbox-toggled', function( event, ele ) {
				if( $(ele).hasClass('closed') ) {
					return;
				}

				if( $(ele).find('.paoc-code-editor').length > 0 ) {
					editor.codemirror.refresh();
				}
			});

			/* When setting tab is opened */
			$(document).on('click', '.paoc-vtab-nav a', function() {

				var selected_tab = $(this).attr("href");

				if( $(selected_tab).find('.paoc-code-editor').length > 0 ) {
					editor.codemirror.refresh();
				}
			});
		});
	}

	/* Process Entries Export */
	$(document).on('submit', '.paoc-tools-form', function(e) {

		e.preventDefault();

		var obj_ele			= $(this);
		var submitbutton	= obj_ele.find( 'input[type="submit"]' );

		if ( ! submitbutton.hasClass( 'button-disabled' ) ) {

			submitbutton.addClass( 'button-disabled' );

			obj_ele.find('.notice-wrap').remove();
			obj_ele.append( '<div class="notice-wrap"><span class="spinner is-active"></span><div class="paoc-progress"><div></div></div></div>' );

			obj_ele.find('.paoc-progress-wrap').show();
			obj_ele.find('.paoc-progress-wrap .paoc-progress-strip').css('width', 0);

			paoc_pro_export_entries( null, obj_ele );
		}
		return false;
	});

	/* MailChimp List Show / Hide */
	$(document).on('click', '.paoc-accordion-toggle', function(e) {

		e.preventDefault();
		var cls_ele	= $(this).closest('.paoc-accordion-row');

		cls_ele.find('.paoc-accordion-data-wrap').slideToggle('fast', function() {

			$('.paoc-accordion-row').removeClass('paoc-accordion-active');
			cls_ele.addClass('paoc-accordion-active');
		});
	});

	/* Comman cofirm alert box */
	$(document).on('click', '.paoc-confirm', function(e) {
		var confirm = paoc_pro_confirm();

		return confirm;
	});

	/* Save Data on Ctrl + S - Start */
	if( adminpage == 'post-php' ) {
		var paoc_save_btn = $('#publish');
	} else {
		var paoc_save_btn = $('.paoc-sett-submit');
	}

	if( paoc_save_btn.length > 0 ) {
		$(window).on('keydown', function(event) {
			if ( (event.ctrlKey || event.metaKey) && (String.fromCharCode(event.which).toLowerCase() == 's') ) {

				event.preventDefault();
				paoc_save_btn.trigger('click');
				return;
			}
		});
	}
	/* Save Data on Ctrl + S - End */

	/* Synchronize mailchimp list fields */
	$(document).on('click', '.paoc-mc-field-syn', function() {

		var curr_ele		= $(this);
		var cls_ele			= $(this).closest('.paoc-accordion-data-wrap');
		var notice_ele		= $('.paoc-js-notice-notify');
		var mc_list_id		= cls_ele.find('.paoc-mailchimp-list').val();
		var mc_list_data	= {
								action		: 'paoc_pro_get_mc_fields',
								mc_list_id	: mc_list_id,
								popup_id	: PaocProAdmin.popup_id,
								form_data	: $('form#post').serialize(),
								nonce		: $(this).attr('data-nonce'),
							};

		curr_ele.prop('disabled', 'disabled');
		cls_ele.find('.paoc-spinner').css('visibility', 'visible');
		notice_ele.hide();
		notice_ele.removeClass('paoc-success paoc-error');

		$.post(ajaxurl, mc_list_data, function( response ) {
			
			if( response.success == 1 ) {

				cls_ele.find('.paoc-intgs-hidden-fields').attr( 'value', response.mc_fields );

				/* Form Fields Loop */
				cls_ele.find(".paoc-form-fields").each( function() {

					var form_field_val = $(this).val();

					$(this).html( response.form_field_opts );

					if( form_field_val != '' ) {
						$(this).find("option[value="+form_field_val+"]").attr("selected", "selected");
					}
				});

				/* MailChimp Loop */
				cls_ele.find(".paoc-mc-fields").each( function() {

					var mc_field_val = $(this).val();

					$(this).html( response.mc_field_opts );

					if( mc_field_val != '' ) {
						$(this).find("option[value="+mc_field_val+"]").attr("selected", "selected");
					}
				});

				notice_ele.addClass('paoc-success');

			} else {

				notice_ele.addClass('paoc-error');
			}

			/* Display success notice */
			notice_ele.html( response.msg );
			paoc_pro_popup_meta_notice( notice_ele );

			curr_ele.prop('disabled', null);
			cls_ele.find('.paoc-spinner').css('visibility', 'hidden');
		});
	});

	/* On Change MailChimp Mailchimp List */
	$(document).on('change', '.paoc-mailchimp-list', function() {

		var cls_ele		= $(this).closest('.paoc-accordion-row');
		var list_val	= $(this).val();

		cls_ele.find('.paoc-fields-wrap select').val('');

		/* Change mailchimp list name on row */
		if( list_val != '' ) {
			var list_name = $(this).find("option:selected").text();
			cls_ele.find('.paoc-intgs-list-name').text( ' - '+list_name );
		}

		/* Fire trigger to get fields */
		cls_ele.find('.paoc-mc-field-syn').trigger('click');
	});

})(jQuery);

/* Function to generate CSV for form entries */
function paoc_pro_export_entries( data, obj_ele ) {

	if( ! data ) {
		var form_data	= obj_ele.serialize();
		var data		= {
			action		: 'paoc_pro_do_export_action',
			form_data	: form_data,
			page		: 1,
			is_ajax		: 1,
		};
	}

	jQuery.post(ajaxurl, data, function(result) {

		var notice_wrap = obj_ele.find('.notice-wrap');

		if( result.status == 0 ) {

			notice_wrap.html('<div class="updated error"><p>' + result.message + '</p></div>');
			obj_ele.find('.button-disabled').removeClass('button-disabled');

		} else {

			jQuery('.paoc-progress div').animate({
				width: result.percentage + '%',
			}, 50, function() {

			});

			/* If data is there then process again */
			if( result.data_process != 0 && ( result.data_process < result.total_count ) ) {
				data['page']            = result.page;
				data['total_count']     = result.total_count;
				data['data_process']    = result.data_process;
				paoc_pro_export_entries( data, obj_ele );
			}

			/* If process is done */
			if( result.data_process >= result.total_count ) {

				notice_wrap.html('<div id="paoc-batch-success" class="updated notice"><p>' + result.message + '</p></div>');
				obj_ele.find('.button-disabled').removeClass('button-disabled');

				if( result.url ) {
					window.location = result.url;
				}
			}
		}
	});
}

/* Common alert message function */
function paoc_pro_confirm( msg ) {

	var msg	= jQuery(this).attr('data-msg');
	msg		= msg ? msg : PaocProAdmin.cofirm_msg;

	var ans = confirm(msg);

	if(ans) {
		return true;
	} else {
		return false;
	}
}

/* Tooltip */
function paoc_pro_tooltip() {
	if( jQuery('.paoc-tooltip').length > 0 ) {
		jQuery('.paoc-tooltip').each( function( attachment, index ) {

			if( jQuery(this).hasClass('tooltipstered') ) {
				return;
			}

			var tooltip_text		= jQuery(this).attr('data-tooltip-text');
			var tooltip_cnt			= jQuery(this).attr('data-tooltip-content');
			var tooltip_theme		= jQuery(this).attr('data-tooltip-theme');
			var tooltip_side		= jQuery(this).attr('data-tooltip-side');
			var tooltip_min_width	= jQuery(this).attr('data-tooltip-min-width');

			tooltip_theme		= tooltip_theme		? tooltip_theme		: 'paoc-tooltipster tooltipster-punk';
			tooltip_side		= tooltip_side		? tooltip_side		: 'top';
			tooltip_min_width	= tooltip_min_width	? tooltip_min_width	: false;

			if ( typeof(tooltip_text) !== 'undefined' ) {
				tooltip_cnt = tooltip_text;
			} else {
				tooltip_cnt	= ( jQuery(tooltip_cnt).length > 0 ) ? jQuery(tooltip_cnt) : null;
			}

			jQuery(this).tooltipster({
				maxWidth			: 500,
				contentCloning		: true,
				contentAsHTML		: true,
				interactive			: true,
				repositionOnScroll	: true,
				animation			: 'grow',
				content				: tooltip_cnt,
				theme				: tooltip_theme,
				minWidth			: tooltip_min_width,
				side				: tooltip_side,
				trigger				: ( PaocProAdmin.is_mobile == 1 ) ? 'click' : 'hover',
			});
		});
	}
}

/* Function to display notice */
function paoc_pro_popup_meta_notice( notice_cls ) {

	var anim_bottom = '50px';
	if( PaocProAdmin.is_mobile == 1 ) {
		anim_bottom = 0;
	}

	notice_cls.show().animate({bottom: anim_bottom}, 500);

	clearTimeout(paoc_meta_notify_timer);
	paoc_meta_notify_timer = setTimeout(function() {
									notice_cls.fadeOut( "slow", function() {
										jQuery(this).css({bottom:''});
									});
								}, 5000);
}

/* Function to show popup content */
function paoc_pro_show_popup_modal( curr_ele ) {

	var popup_title	= curr_ele.attr('title');
	var identifier	= curr_ele.attr('data-id');
	var popup_ele	= jQuery('#paoc-modal-popup-'+identifier);

	if( popup_title != '' ) {
		popup_ele.find('.paoc-popup-modal-title').html( popup_title );
	}

	popup_ele.show();

	jQuery('.paoc-popup-modal-overlay-'+identifier).show();
	jQuery('body').addClass('paoc-no-overflow');
}

/* Function to hide preview popup modal */
function paoc_pro_hide_popup_modal() {
	jQuery('.paoc-popup-modal').hide();
	jQuery('.paoc-popup-modal-overlay').hide();
	jQuery('body').removeClass('paoc-no-overflow');
}