/* Inview JS - http://github.com/zuk/jquery.inview/ */
!function(e){"function"==typeof define&&define.amd?define(["jquery"],e):"object"==typeof exports?module.exports=e(require("jquery")):e(jQuery)}(function(c){var d,h,i,p=[],s=document,u=window,g=s.documentElement;function t(){if(p.length){var e,t,n=0,i=c.map(p,function(e){var t=e.data.selector,e=e.$element;return t?e.find(t):e});for(d=d||((t={height:u.innerHeight,width:u.innerWidth}).height||!(e=s.compatMode)&&c.support.boxModel||(t={height:(e="CSS1Compat"===e?g:s.body).clientHeight,width:e.clientWidth}),t),h=h||{top:u.pageYOffset||g.scrollTop||s.body.scrollTop,left:u.pageXOffset||g.scrollLeft||s.body.scrollLeft};n<p.length;n++)if(c.contains(g,i[n][0])){var o=c(i[n]),l=o[0].offsetHeight,a=o[0].offsetWidth,r=o.offset(),f=o.data("paoc_inview");if(!h||!d)return;r.top+l>h.top&&r.top<h.top+d.height&&r.left+a>h.left&&r.left<h.left+d.width?f||o.data("paoc_inview",!0).trigger("paoc_inview",[!0]):f&&o.data("paoc_inview",!1).trigger("paoc_inview",[!1])}}}c.event.special.paoc_inview={add:function(e){p.push({data:e,$element:c(this),element:this}),!i&&p.length&&(i=setInterval(t,250))},remove:function(e){for(var t=0;t<p.length;t++){var n=p[t];if(n.element===this&&n.data.guid===e.guid){p.splice(t,1);break}}p.length||(clearInterval(i),i=null)}},c(u).on("scroll resize scrollstop",function(){d=h=null}),!g.addEventListener&&g.attachEvent&&g.attachEvent("onfocusin",function(){h=null})});

(function($) {

	"use strict";

	paoc_pro_tooltip();

	/* Taking some variable */
	var paoc_ideal_timer	= 0;
	var current_time		= new Date();
	var paoc_pro_mobile		= paoc_pro_is_mobile();
	var server_local_time	= window.wp.date.dateI18n('Y-m-d H:i:s');
	var server_current_time	= new Date( server_local_time );

	/* Get Geolocation storage from browser local storage */
	var geolocation	= paoc_pro_get_local_storage( 'paoc_popup_common_data' );

	/* If `Geolocation` is enabled */
	if( PaocProPublic.geo_enable == 1 ) {

		/* If local storage is not there
		 * If local storage is there but storage time is expired
		*/
		if( geolocation == null || ( geolocation != null && new Date( geolocation.geo.date ) < current_time ) ) {

			var geolocation_data = {
				'action'		: 'paoc_pro_process_popup_data',
				'geo_location'	: 1,
			};

			$.post(PaocProPublic.paoc_ajaxurl, geolocation_data, function(response) {

				if( response.success == 1 && response.data.geo != '' ) {

					paoc_pro_set_local_storage( 'paoc_popup_common_data', response.data, 'obj' );

					geolocation	= paoc_pro_get_local_storage( 'paoc_popup_common_data' );

					$(document.body).trigger('paoc_pro_popup_trigger', 'geo_location');
				}
			});
		}
	}

	/* Make Embeded Video Responsive */
	$('.paoc-popup iframe[src*="vimeo.com"]').wrap('<div class="paoc-iframe-wrap" />');
	$('.paoc-popup iframe[src*="dailymotion.com"]').wrap('<div class="paoc-iframe-wrap" />');
	$('.paoc-popup iframe[src*="youtube.com"]').wrap('<div class="paoc-iframe-wrap" />');
	$('.paoc-popup iframe[src*="m.youtube.com"]').wrap('<div class="paoc-iframe-wrap" />');
	$('.paoc-popup iframe[src*="youtu.be"]').wrap('<div class="paoc-iframe-wrap" />');
	$('.paoc-popup iframe[src*="screencast-o-matic.com"]').wrap('<div class="paoc-iframe-wrap" />');
	$('.paoc-popup iframe[src*="videopress.com"]').wrap('<div class="paoc-iframe-wrap" />');
	$('.paoc-popup iframe[src*="video.wordpress.com"]').wrap('<div class="paoc-iframe-wrap" />');
	$('.paoc-popup iframe[src*="docs.google.com/presentation"]').wrap('<div class="paoc-iframe-wrap" />');
	$('.paoc-popup iframe[src*="fast.wistia.net"]').wrap('<div class="paoc-iframe-wrap" />');
	$('.paoc-popup .paoc-iframe-responsive').wrap('<div class="paoc-iframe-wrap" />');

	/* Taking some global variable */
	var paoc_pro_camp_temp	= '';
	var paoc_pro_utm_params	= paoc_pro_get_utm_params();

	/* Store Click and view for Inline Popup */
	$('.paoc-inline-popup').each(function() {

		var target		= $(this).attr('id');
		var data_opts	= $(this).data('conf');

		$(this).one('paoc_inview', function(event, visible) {

			if ( visible == true ) {

				/* Store Popup Views */
				paoc_pro_popup_views( data_opts );

				/* Google Analytics Event */
				paoc_pro_google_anlytics_setup( target );
			}
		});
	});

	/* Delete the OLD local storage if browser is newly opened */
	if( paoc_pro_get_cookie_value( 'paoc_popup_sess_cookie' ) != 1 ) {
		localStorage.removeItem( 'paoc_utm_data' );
		localStorage.removeItem( 'paoc_referrer_domains' );
		paoc_pro_create_cookie( 'paoc_popup_sess_cookie', 1, '', '', 'Lax' );
	}

	/* Set UTM data to local storage - Start */
	paoc_pro_set_local_storage( 'paoc_utm_data', paoc_pro_utm_params, 'obj' );
	/* Set UTM data to local storage - End */

	/* Referer Popup - Start */
	var paoc_referrer_domain	= document.referrer;
		paoc_referrer_domain	= paoc_referrer_domain.replace('http://','').replace('https://','').toLowerCase();
		paoc_referrer_domain	= paoc_referrer_domain.split(/[?#]/)[0].replace(/^\/|\/$/g, '');		/* First remove part after ? and # then remove last slash */

	var paoc_domain_data		= paoc_referrer_domain.split(/[/?#]/);

	if( paoc_referrer_domain != '' ) {

		paoc_pro_set_local_storage( 'paoc_referrer_domains', paoc_domain_data[0], '' );
		paoc_pro_set_local_storage( 'paoc_referrer_domains', paoc_referrer_domain, '' );

		if( typeof( paoc_domain_data[1] ) !== 'undefined' ) {
			var paoc_subdomain_name = ( paoc_domain_data[0] +'/'+ paoc_domain_data[1] );
			paoc_pro_set_local_storage( 'paoc_referrer_domains', paoc_subdomain_name, '' );
		}
	}
	/* Referer Popup - End */

	var paoc_pro_second		= 0;
	var paoc_pro_interval	= setInterval(function() {
								++paoc_pro_second;
							}, 1000);

	/* Zero the idle timer on mouse movement */
	$(document).on('mousemove keypress scroll click touchstart touchmove', function() {
		paoc_ideal_timer = 0;
	});

	/* Campaign Popup */
	$('.paoc-campaign-popup').each(function() {

		var target = $(this).attr('id');

		if( $('#'+target).length > 0 ) {

			var paoc_camp_popup_id	= '';
			var campaign_data		= '';
			var campaign_arr		= {};
			var storage_data		= {};
			var data_opts			= $('#'+target).data('conf');
			var camp_popups			= data_opts.campaign_popup;
			var campaign_id			= data_opts.campaign_id;

			/**
			 * Loop of campaign popups and we detect one popup ID to render
			 * Assign popup campaign ID to temp variable and continue loop for rest of the campaign popups
			 */
			if ( campaign_id == paoc_pro_camp_temp ) {
				return;
			}

			paoc_pro_camp_temp	= campaign_id;
			var get_cookie_val	= paoc_pro_get_cookie_value( PaocProPublic.cookie_prefix+'_campaign_popup' );

			if( typeof(get_cookie_val) != 'undefined' && get_cookie_val != null ) {

				campaign_arr		= JSON.parse( get_cookie_val );
				paoc_camp_popup_id	= campaign_arr[campaign_id];
			}

			if( campaign_arr[campaign_id] == 'undefined' || jQuery.inArray( paoc_camp_popup_id, camp_popups ) < 0 ) {
				paoc_camp_popup_id	= paoc_pro_shuffle( camp_popups );
				paoc_camp_popup_id	= paoc_camp_popup_id[0];
			}

			storage_data[campaign_id]	= paoc_camp_popup_id;
			var new_campaign_obj		= jQuery.extend( campaign_arr, storage_data );
			campaign_data				= JSON.stringify( new_campaign_obj );

			/* Create Campaign Cookie */
			paoc_pro_create_cookie( PaocProPublic.cookie_prefix+'_campaign_popup', campaign_data, 365, 'day', 'Lax' );

			/* Check campaign popup id greater then 0 AND popup class not there to remove popup */
			$('.paoc-campaign-'+campaign_id).not('.paoc-popup-'+paoc_camp_popup_id).remove();
			$('.paoc-campaign-panel-'+campaign_id).not('.paoc-popup-panel-'+paoc_camp_popup_id).remove();
		}
	});

	/* Page Load Popups */
	paoc_pro_page_load_popup();

	/* Display Action Based Inline Popup, Link, Button and etc for Adblocker, Geo Location and etc */
	paoc_pro_action_popup();

	$(document.body).on('paoc_pro_popup_trigger', function( e, trigger_type ) {
		
		if( PaocProPublic.paoc_preview == 1 ) {
			return false;
		}

		paoc_pro_page_load_popup();

		/* If `Trigger Type` geolocation is there */
		if( trigger_type == 'geo_location' ) {
			paoc_pro_action_popup();
		}
	});

	/* X Sec Inactivity Popup Bar & Modal */
	$('.paoc-popup-inactivity.paoc-popup-js').each(function() {

		var target = $(this).attr('id');

		if( typeof( target ) !== 'undefined' ) {

			var options				= $('#'+target).data('popup-conf');
			var data_opts			= $('#'+target).data('conf');
			var paoc_active_flag	= paoc_pro_popup_active_flag( target, data_opts );

			if( paoc_active_flag == 1 ) {

				var IdleInterval = setInterval(function() {

					paoc_ideal_timer = paoc_ideal_timer + 1;

					if( paoc_ideal_timer >= data_opts.open_inactivity ) {

						/* Open popup & fire events */
						paoc_pro_open_popup( target, options, data_opts );

						clearInterval( IdleInterval );
					}
				}, 1000);
			}

			return false;
		}
	});

	/* X Sec Inactivity Popup for Push Notification / Slide In */
	$('.paoc-popup-inactivity.paoc-nfs-popup').each(function() {

		var target = $(this).attr('id');

		if( typeof( target ) !== 'undefined' ) {

			var data_opts			= $('#'+target).data('conf');
			var paoc_active_flag	= paoc_pro_popup_active_flag( target, data_opts );

			if( paoc_active_flag == 1 ) {

				var IdleInterval = setInterval(function() {

					paoc_ideal_timer = paoc_ideal_timer + 1;

					if( paoc_ideal_timer >= data_opts.open_inactivity ) {

						$('#paoc-popup-panel-'+ data_opts.id).show();
						clearInterval( IdleInterval );
					}
				}, 1000);
			}
		}
	});

	/* When Page Scroll */
	var paoc_scrolld_popup_open	= false;
	var paoc_scrollu_popup_open	= false;
	var paoc_exitu_popup_open	= false;
	var paoc_scroll_end_pos		= $(window).scrollTop();
	var scroll_position			= paoc_scroll_end_pos;
	var window_height			= ( $(document).height() - $(window).height() );

	var scrollTimer = null;
	$(window).on('scroll', function () {
		if ( scrollTimer ) {
			clearTimeout( scrollTimer );
		}
		scrollTimer = setTimeout(paoc_pro_handle_scroll, 200);
	});

	/* Scroll Function */
	function paoc_pro_handle_scroll() {

		var direction				= 'up';
		var paoc_scroll_start_pos	= $(this).scrollTop();
		var height					= parseInt( (paoc_scroll_start_pos / window_height) * 100 );
		var up_scroll_percent		= ( 100 - height );

		/* Set Direction */
		if ( paoc_scroll_start_pos > paoc_scroll_end_pos ) {
			var direction = 'down';
		}
		paoc_scroll_end_pos = paoc_scroll_start_pos;

		/***** When Page Scroll Down - Start *****/
		if ( paoc_scrolld_popup_open == false && direction == 'down' ) {

			/* Bar & Modal Popup */
			$('.paoc-popup-scroll.paoc-popup-js').each(function() {

				var target = $(this).attr('id');

				if( typeof( target ) !== 'undefined' ) {

					var options		= $('#'+target).data('popup-conf');
					var data_opts	= $('#'+target).data('conf');

					if ( height >= data_opts.open_scroll ) {

						var paoc_active_flag = paoc_pro_popup_active_flag( target, data_opts );

						if( paoc_active_flag == 1 ) {

							/* Open popup & fire events */
							paoc_pro_open_popup( target, options, data_opts );

							paoc_scrolld_popup_open = true;
						}

						return false;
					}
				}
			});

			/* Push Notification / Slide In Popup */
			$('.paoc-popup-scroll.paoc-nfs-popup').each(function() {

				var target = $(this).attr('id');

				if( typeof( target ) !== 'undefined' ) {

					var data_opts = $('#'+target).data('conf');

					if ( height >= data_opts.open_scroll ) {

						var paoc_active_flag = paoc_pro_popup_active_flag( target, data_opts );

						if( paoc_active_flag == 1 ) {

							$('#paoc-popup-panel-'+ data_opts.id).show();

							paoc_scrolld_popup_open = true;
						}
					}
				}
			});
		}
		/***** When Page Scroll Down - End *****/


		/***** When Page Scroll UP - Start *****/
		if ( paoc_scrollu_popup_open == false && direction == 'up' ) {

			/* Bar & Modal Popup */
			$('.paoc-popup-scroll-up.paoc-popup-js').each(function() {

				var target = $(this).attr('id');

				if( typeof( target ) !== 'undefined' ) {

					var options		= $('#'+target).data('popup-conf');
					var data_opts	= $('#'+target).data('conf');

					if ( up_scroll_percent >= data_opts.open_scroll ) {

						var paoc_active_flag = paoc_pro_popup_active_flag( target, data_opts );

						if( paoc_active_flag == 1 ) {

							/* Open popup & fire events */
							paoc_pro_open_popup( target, options, data_opts );

							paoc_scrollu_popup_open = true;
						}

						return false;
					}
				}
			});

			/* Push Notification / Slide In Popup */
			$('.paoc-popup-scroll-up.paoc-nfs-popup').each(function() {

				var target = $(this).attr('id');

				if( typeof( target ) !== 'undefined' ) {

					var data_opts = $('#'+target).data('conf');

					if ( up_scroll_percent >= data_opts.open_scroll ) {

						var paoc_active_flag = paoc_pro_popup_active_flag( target, data_opts );

						if( paoc_active_flag == 1 ) {

							$('#paoc-popup-panel-'+ data_opts.id).show();

							paoc_scrollu_popup_open = true;
						}
					}
				}
			});
		}

		/***** Exit Intent For Mobile (Tweak With Scroll UP) - Start *****/
		if ( paoc_pro_mobile == true && direction == 'up' && paoc_exitu_popup_open == false ) {
			paoc_pro_exit_intent_popup();
		}
		/***** When Page Scroll UP - End *****/
	}

	/* Exit Intent Popup */
	var paoc_exit_popup_open = false;
	$(document).on( 'mouseleave', function (e) {
		if ( paoc_exit_popup_open == false && e.clientY <= 0 ) {
			paoc_pro_exit_intent_popup();
		}
	});

	/* On Click Popup Link, Button, Image OR Custom HTML */
	$(document).on('click', '[class*="paoc-pro-popup-cust-"], [class*="paoc-pro-campaign-cust-"]', function() {

		var html_classes = $(this).attr("class").split(' ');

		$.each(html_classes, function( class_key, class_val ) {

			if ( class_val == '' ) {
				return;
			}

			var target = null;
			var normal_cls_pos		= class_val.indexOf('paoc-pro-popup-cust-');
			var campaign_cls_pos	= class_val.indexOf('paoc-pro-campaign-cust-');

			if( campaign_cls_pos >= 0 ) {

				target = class_val.replace('paoc-pro-campaign-cust-', 'paoc-campaign-');

			} else if( normal_cls_pos >= 0 ) {

				target = class_val.replace("paoc-pro-popup-cust-", "paoc-popup-");
			}

			if ( typeof(target) === 'undefined' || target == null ) {
				return;
			}

			target			= target.trim();
			var popup_ele	= $('.'+target).not('.paoc-inline-popup').attr('id');
			var options		= $('#'+ popup_ele).data('popup-conf');
			var data_opts	= $('#'+ popup_ele).data('conf');

			if( typeof( popup_ele ) !== 'undefined' ) {

				var paoc_active_flag = paoc_pro_popup_active_flag( popup_ele, data_opts );

				if( paoc_active_flag == 1 ) {

					/* Open popup & fire events */
					setTimeout(function() {

						if( data_opts.display_type == 'push-notification' || data_opts.display_type == 'slide-in' ) {

							/* If notification icon is visible to fisrt hide then visible second one */
							if( $('#paoc-popup-panel-'+ data_opts.id).is(":visible") ) {
								$('#paoc-popup-panel-'+ data_opts.id).hide();
							}

							$('#paoc-popup-panel-'+ data_opts.id).fadeIn();

						} else {

							paoc_pro_open_popup( popup_ele, options, data_opts );
						}
					}, data_opts.open_delay);

					return false;
				}
			}
		});
	});

	/* Push Notification / Slide In Click */
	$(document).on('click', '[class*="paoc-popup-panel-"]', function() {

		var panel_classes = $(this).attr("class").split(' ');

		$.each(panel_classes, function( class_key, class_val ) {
			var target_pos = class_val.indexOf("paoc-popup-panel-");

			if( target_pos !== -1 ) {
				var target		= class_val.replace("paoc-popup-panel-", "paoc-popup-");
					target		= target.trim();
				var popup_ele	= $('.'+target).not('.paoc-inline-popup').attr('id');

				if( typeof( target ) !== 'undefined' ) {

					var options		= $('#'+popup_ele).data('popup-conf');
					var data_opts	= $('#'+popup_ele).data('conf');

					if( $(this).hasClass('paoc-popup-panel-open') ) {

						Custombox.modal.close();

					} else {

						/* Open popup & fire events */
						paoc_pro_open_popup( popup_ele, options, data_opts );

						/* Add Popup open class at popup open time */
						$('#paoc-popup-panel-'+data_opts.id).addClass('paoc-popup-panel-open');
					}
				}
			}
		});
		return false;
	});

	/* Process Form Field Submission */
	$(document).on('submit', '.paoc-fields-form', function(e) {

		e.preventDefault();

		if( PaocProPublic.paoc_preview == 1 ) {
			return false;
		}

		var this_ele		= $(this);
		var options			= $(this).closest('.paoc-popup-email-lists').data('conf');
		var cls_form 		= $(this).closest('form');
		var cls_succ_ele	= $(this).closest('.paoc-popup-form-process');

		cls_form.find('.paoc-form-field-row').removeClass('paoc-form-inp-err');
		cls_form.find('.paoc-form-submit').attr('disabled', 'disabled');
		cls_form.find('.paoc-error').remove();
		this_ele.find('.paoc-loader').removeClass('paoc-hide');

		var popup_data	= {
			'action'		: 'paoc_pro_popup_form_submit',
			'form_data'		: cls_form.serialize(),
			'popup_id'		: options.id,
			'campaign_id'	: options.campaign_id,
			'popup_type'	: options.popup_type,
			'store_no_data'	: options.store_no_data,
			'store_no_views': options.store_no_views,
			'ref_page_url'	: PaocProPublic.paoc_url,
		};

		$.post(PaocProPublic.paoc_ajaxurl, popup_data, function(response) {

			if( response.success == 0 ) {
				$.each(response.errors, function( key, err_data ) {
					cls_form.find('.'+key).closest('.paoc-form-field-row').addClass('paoc-form-inp-err');
				});
			} else {
				cls_succ_ele.html( response.thanks_msg );
			}

			this_ele.find('.paoc-loader').addClass('paoc-hide');
			cls_form.append( '<div class="paoc-col-12 paoc-column paoc-error">' + response.msg + '</div>' );
			cls_form.find('.paoc-form-submit').removeAttr('disabled', 'disabled');

			$(document.body).trigger('paoc_pro_popup_form_submit', [response, options, this_ele]);
		});

		return false;
	});

	/* Popup close event */
	$(document).on('click', '.paoc-popup-close', function() {

		/* Remove Class from Popup */
		$('.custombox-content').removeClass( 'paoc-cb-popup-complete' );
		$('html').removeClass( 'custombox-lock' );

		Custombox.modal.close();
	});

	/* Popup click store for Popup Goal: Target URL, Phone Calls */
	$( document ).on('click', '.paoc-btn-click', function() {

		var cls_ele		= $(this).closest('.paoc-popup');
		var data_opts	= cls_ele.data('conf');

		/* Popup click store */
		if( data_opts.store_no_views == 0 ) {
			paoc_pro_popup_clicks( data_opts );
		}
	});

	/* Function to Fire Page Load Popups */
	function paoc_pro_page_load_popup() {

		/* Welcome Popup for Bar & Modal (Page Load Popup) */
		$('.paoc-popup-page-load.paoc-popup-js').each(function() {

			var target = $(this).attr('id');

			if( typeof( target ) !== 'undefined' ) {

				if( $('#'+target).is(":visible") ) {
					return;
				}

				var options				= $('#'+target).data('popup-conf');
				var data_opts			= $('#'+target).data('conf');
				var paoc_active_flag	= paoc_pro_popup_active_flag( target, data_opts );

				if( paoc_active_flag == 1 ) {

					setTimeout(function() {

						/* Open popup & fire events */
						paoc_pro_open_popup( target, options, data_opts );

					}, data_opts.open_delay);
				}

				return false;
			}
		});

		/* Welcome Popup for Push Notification / Slide In (Page Load Popup) */
		$('.paoc-popup-page-load.paoc-nfs-popup').each(function() {

			var target = $(this).attr('id');

			if( typeof( target ) !== 'undefined' ) {

				var data_opts			= $('#'+target).data('conf');
				var paoc_active_flag	= paoc_pro_popup_active_flag( target, data_opts );

				if( paoc_active_flag == 1 ) {

					/* Open Delay */
					setTimeout(function() {
						$('#paoc-popup-panel-'+ data_opts.id).show();
					}, data_opts.open_delay);
				}
			}
		});
	}

	/* Function to fire Exit Intent Popup */
	function paoc_pro_exit_intent_popup() {

		/* Bar & Modal Popup */
		$('.paoc-popup-exit.paoc-popup-js').each(function() {

			var target = jQuery(this).attr('id');

			if( typeof( target ) !== 'undefined' ) {

				var options				= $('#'+target).data('popup-conf');
				var data_opts			= $('#'+target).data('conf');
				var paoc_active_flag	= paoc_pro_popup_active_flag( target, data_opts );

				if( paoc_active_flag == 1 ) {
					if( data_opts.open_delay && (data_opts.open_delay <= (paoc_pro_second * 1000)) ) {

						/* Open popup & fire events */
						paoc_pro_open_popup( target, options, data_opts );
						clearInterval( paoc_pro_interval );

						paoc_exit_popup_open = true;

					} else if( data_opts.open_delay == 0 ) {

						/* Open popup & fire events */
						paoc_pro_open_popup( target, options, data_opts );
						paoc_exit_popup_open = true;
					}
				}

				return false;
			}
		});

		/* Push Notification / Slide In Popup */
		$('.paoc-popup-exit.paoc-nfs-popup').each(function() {

			var target = $(this).attr('id');

			if( typeof( target ) !== 'undefined' ) {

				var data_opts			= $('#'+target).data('conf');
				var paoc_active_flag	= paoc_pro_popup_active_flag( target, data_opts );

				if( paoc_active_flag == 1 ) {
					if( data_opts.open_delay && (data_opts.open_delay <= (paoc_pro_second * 1000)) ) {

						$('#paoc-popup-panel-'+ data_opts.id).show();
						clearInterval( paoc_pro_interval );

						paoc_exit_popup_open = true;

					} else if( data_opts.open_delay == 0 ) {

						$('#paoc-popup-panel-'+ data_opts.id).show();
						paoc_exit_popup_open = true;
					}
				}
			}
		});
	}

	/*========================= Start - Functions ============================*/
	/* Function to get popup & fire the events */
	function paoc_pro_open_popup( target, options, data_opts ) {

		var paoc_popup_open	= 1;

		if (typeof paoc_pro_popup_befoer_open === "function") {
			paoc_popup_open = paoc_pro_popup_befoer_open( paoc_popup_open, target, options, data_opts );
		}

		if( paoc_popup_open != 1 ) {
			return;
		}

		/* Popup Events */
		paoc_pro_set_popup_events( target, options, data_opts );

		/* Google Analytics Event */
		paoc_pro_google_anlytics_setup( target );

		/* Popup Open */
		new Custombox.modal(options).open();
	}

	/* Function to set Popup Events */
	function paoc_pro_set_popup_events( target, options, data_opts ) {

		/* Tweak for Content onOpen Event */
		options.content.onOpen = function() {

									/* Add Class for hide body scroll */
									jQuery('html').addClass('custombox-lock');

									jQuery('.custombox-overlay, .custombox-content').removeClass('paoc-popup-active');

									/* Add Classes for overlay */
									jQuery('.custombox-overlay').not('.paoc-popup-overlay').addClass('paoc-popup-active paoc-popup-overlay paoc-popup-overlay-'+ data_opts.id);

									/* Add Classes from Popup Content */
									jQuery('.custombox-content').not('.paoc-cb-popup').addClass( 'paoc-popup-active paoc-cb-popup paoc-cb-popup-'+data_opts.id+' paoc-popup-'+options.content.positionX+'-'+options.content.positionY );

									if( options.overlay.active == false && options.content.fullscreen == false ) {
										jQuery('.custombox-content.paoc-popup-active').addClass( 'paoc-hide-overlay' );
									}

									if( data_opts.display_type == 'bar' ) {
										jQuery('.custombox-content').addClass( 'paoc-cb-bar-popup' );
									}

									/* Ovarlay Background Hide */
									if( options.overlay.active == false ) {
										jQuery('html').css({'overflow':'auto', 'margin-right':'0'});
									}

									/* Tweak : Bar Popup - Top Push */
									if( data_opts.display_type == 'bar' ) {

										var calc_popup_height = jQuery('#'+target).height();

										/* If show credit is there */
										if( jQuery('.paoc-credit-wrp').length > 0 ) {

											var calc_credit_height	= jQuery('.paoc-credit-wrp').height();
											var calc_popup_height = calc_popup_height + calc_credit_height;
										}

										/* Top Push popup position */
										if( data_opts.popup_position == 'top-push' ) {

											jQuery('html').css({'padding-top': calc_popup_height+'px'});

										} else if( data_opts.popup_position == 'bottom-push' ) {

											jQuery('html').css({'padding-bottom': calc_popup_height+'px'});
										}
									}

									/* Slick Slider Tweak */
									var slick_slider_id = jQuery('.slick-slider').attr('id');
									if( typeof(slick_slider_id) !== 'undefined' && slick_slider_id != '' ) {
										jQuery('#'+slick_slider_id).slick( 'setPosition' );
									}

									/* Tweak for Social Profile `WhatsApp` */
									if( paoc_pro_mobile == true ) {
										var social_link = jQuery('#'+target+' .paoc-whatsapp-icon').attr('data-mobile');
									} else {
										var social_link = jQuery('#'+target+' .paoc-whatsapp-icon').attr('data-desktop');
									}
									jQuery('#'+target+' .paoc-whatsapp-icon').attr( 'href', social_link );

									/* Trigger fires right before begins to open */
									jQuery(document.body).trigger('paoc_popup_open', [target, options]);
								};

		/* Tweak for Content onComplete Event */
		options.content.onComplete = function() {

									/* Add Classes for Popup Content */
									jQuery('.custombox-content').addClass( 'paoc-cb-popup-complete' );

									/* Popup impression store */
									if( data_opts.store_no_views == 0 ) {
										paoc_pro_popup_views( data_opts );
									}

									/* Popup Disapper */
									if( data_opts.disappear != 0 ) {

										if( data_opts.disappear_mode == 'normal' ) {

											var IdleInterval = setInterval(function() {

												paoc_ideal_timer = paoc_ideal_timer + 1;

												if( paoc_ideal_timer >= data_opts.disappear ) {

													Custombox.modal.close();

													clearInterval( IdleInterval );
												}
											}, 1000);

										} else if( data_opts.disappear_mode == 'force' ) {

											setTimeout(function() {

												Custombox.modal.close();

											}, ( data_opts.disappear * 1000 ) );
										}
									}

									/* Tweak for Window Resize */
									jQuery(window).trigger('resize');

									/* Trigger fires right after loaded content is displayed */
									jQuery(document.body).trigger('paoc_popup_complete', [target, options]);
								};

		/* Tweak for Content onClose Event */
		options.content.onClose = function() {

			/* Add Overflow Class in HTML Tag */
			jQuery('html').removeClass('custombox-lock');

			/* Remove Class from Notification Popup icon */
			jQuery('.paoc-popup-nfs-js').removeClass('paoc-popup-panel-open');

			/* Tweak : Bar Popup */
			if( data_opts.display_type == 'bar' ) {

				if( data_opts.popup_position == 'top-push' ) {

					jQuery('html').css({'padding-top': ''});

				} else if( data_opts.popup_position == 'bottom-push' ) {

					jQuery('html').css({'padding-bottom': ''});
				}
			}

			/* Set Cookie */
			var cookie_name = PaocProPublic.cookie_prefix +'_'+ data_opts.id;

			if( data_opts.cookie_expire !== '' ) {
				paoc_pro_create_cookie( cookie_name, 1, data_opts.cookie_expire, data_opts.cookie_unit, 'Lax' );
			}

			/* Trigger fires once is closed */
			jQuery(document.body).trigger('paoc_popup_close', [target, options]);
		};
	}

	/* Function for the Google Analytics Event */
	function paoc_pro_google_anlytics_setup(target) {

		var analytic_lbl 			= jQuery('#'+target).attr('data-label');
		var analytic_event_action	= jQuery('#'+target).attr('data-event-action');
		var analytic_event_category	= jQuery('#'+target).attr('data-event');

		if( typeof(analytic_lbl) !== 'undefined' &&  typeof(analytic_event_action) !== 'undefined' && typeof(analytic_event_category) !== 'undefined' ) {

			if( typeof(gtag) !== 'undefined' ) {
				gtag('event', analytic_event_action, {'event_category': analytic_event_category, 'event_label': analytic_lbl});
			} else if( typeof(ga) !== 'undefined' ) {
				ga( 'send', 'event', analytic_event_category, analytic_event_action, analytic_lbl );
			} else {
				console.log( PaocProPublic.paoc_err_msg );
			}
		}
	}

	/* Function to check Popup active flag */
	function paoc_pro_popup_active_flag( $this, data_opts ) {

		var paoc_check_active = false;

		/* Return 0 if cookie expire is there & cookie value is also there */
		if( typeof( data_opts.cookie_expire ) !== 'undefined' && data_opts.cookie_expire !== '' && paoc_pro_get_cookie_value( PaocProPublic.cookie_prefix +'_'+ data_opts.id ) != null ) {
			return 0;
		}

		/*
		 * If `Referrer Popup`, `UTM Popup` OR `Cookie Popup` is there
		 * Schedule Popup will be checked in AND condition
		 */
		if( jQuery('#'+$this).hasClass('paoc-popup-has-referrer') || jQuery('#'+$this).hasClass('paoc-popup-has-utm') || jQuery('#'+$this).hasClass('paoc-popup-has-cookie') || jQuery('#'+$this).hasClass('paoc-popup-has-schedule') ) {

			/* If `Referrer Popup` is there */
			if( ! paoc_check_active && jQuery('#'+$this).hasClass('paoc-popup-has-referrer') ) {

				/* Taking some variale */
				var domain_host		= data_opts.referrer_url;
				var stored_domain	= paoc_pro_get_local_storage( 'paoc_referrer_domains' );

				/* If `Referer Mode` is `Track Referer` */
				if( data_opts.referrer_mode == 1 ) {

					jQuery.each( stored_domain, function( stored_key, stored_val ) {

						if( jQuery.inArray( stored_val, domain_host ) != -1 ) {
							paoc_check_active = 1;
							return false;
						}
					});

				} else if( (jQuery.inArray( paoc_domain_data[0], domain_host ) != -1) || (jQuery.inArray( paoc_referrer_domain, domain_host ) != -1) || (jQuery.inArray( paoc_subdomain_name, domain_host ) != -1) ) {
					paoc_check_active = 1;
				}
			}

			/* If check `UTM Popup` is there */
			if( ! paoc_check_active && jQuery('#'+$this).hasClass('paoc-popup-has-utm') ) {

				var utm_params = data_opts.utm_params;

				/* If `UTM Mode` is `Track UTM` */
				if( data_opts.utm_mode == 1 ) {
					var utm_params_data = paoc_pro_get_local_storage( 'paoc_utm_data' );
				} else if( paoc_pro_utm_params != '' ) {
					var utm_params_data = paoc_pro_utm_params;
				}

				if( typeof( utm_params_data ) !== 'undefined' && utm_params_data != null ) {
					jQuery.each( utm_params_data, function( utm_param_key, utm_param_val ) {

						utm_param_val = paoc_pro_escape_html( utm_param_val );

						if( utm_param_key in utm_params ) {
							if( jQuery.inArray( utm_param_val, utm_params[utm_param_key] ) != -1 ) {
								
								paoc_check_active = 1;
								return false;

							} else if( jQuery.inArray( '', utm_params[utm_param_key] ) != -1 ) { /* Check if UTM key is present when user has not entered value */
								
								paoc_check_active = 1;
								return false;
							}
						}
					});
				}
			}

			/* If check `Cookie Popup` is there */
			if( ! paoc_check_active && jQuery('#'+$this).hasClass('paoc-popup-has-cookie') ) {

				var paoc_cookie_arr = document.cookie ? document.cookie.split('; ') : [];

				jQuery.each( paoc_cookie_arr, function( cookie_key, cookie_val ) {

					var cookie_params		= data_opts.cookie_params;
					var cookie_split		= cookie_val.split(/=(.*)/);
					var cookie_split_key	= cookie_split[0].trim();
					var cookie_split_val	= cookie_split[1].trim();

					if( cookie_split_key !== 'undefined' || cookie_split_key != null ) {

						if( cookie_split_key in cookie_params ) {
							if( jQuery.inArray( cookie_split_val, cookie_params[cookie_split_key] ) != -1 ) {
								
								paoc_check_active = 1;
								return false;

							} else if( jQuery.inArray( '', cookie_params[cookie_split_key] ) != -1 ) { /* Check if cookie key is present when user has not entered value */
								
								paoc_check_active = 1;
								return false;
							}
						}
					}					
				});
			}

			/* Check Schedule is there */
			if( jQuery('#'+$this).hasClass('paoc-popup-has-schedule') ) {

				var popup_start_date	= new Date( data_opts.popup_start_date );
				var popup_end_date		= new Date( data_opts.popup_end_date );

				if( data_opts.schedule_mode == 'recurring' ) {
					
					var popup_start_date	= new Date( data_opts.recurring_data.start_time );
					var popup_end_date		= new Date( data_opts.recurring_data.end_time );
				}

				/* Check if end date is passed */
				if( popup_end_date && ( server_current_time > popup_end_date ) ) {
					paoc_check_active = 0;
				} else if( popup_start_date && ( server_current_time < popup_start_date ) ) {
					paoc_check_active = 0;
				} else {
					paoc_check_active = 1;
				}
			}

		} else {

			paoc_check_active = 1;
		}

		if( paoc_check_active == 1 ) {

			/* If display on `Desktop` & `Mobile` device */
			if( data_opts.display_on == 'desktop_only' && paoc_pro_mobile == true ) { /* Display on `Desktop Only` */
				paoc_check_active = 0;
			} else if( data_opts.display_on == 'mobile_only' && paoc_pro_mobile == false ) { /* Display on `Mobile Only` */
				paoc_check_active = 0;
			}

			/* Adblocker detect */
			if( data_opts.adblocker >= 1 ) {

				var ad_blocker = paoc_pro_is_adblocker();

				if( ad_blocker == 1 ) {
					paoc_check_active = 1;
				} else {
					paoc_check_active = 0;
				}
			}

			/* Check Geolocation if geolocation is enabled, geolocation storage is there */
			if( paoc_check_active == 1 && PaocProPublic.geo_enable == 1 && jQuery('#'+$this).hasClass('paoc-popup-has-geolocation') ) {

				var countries		= data_opts.geo_countries;
				var stored_country	= geolocation ? geolocation.geo.country : '';

				if( jQuery.inArray( stored_country, countries ) < 0 ) {
					paoc_check_active = 0;
				}
			}
		}

		return paoc_check_active;
	}

	/* Function to store popup impression */
	function paoc_pro_popup_views( data_opts ) {

		/* Popup Preview is there to not store popup views */
		if( PaocProPublic.paoc_preview == 1 ) {
			return false;
		}

		var popup_data = {
			'action'		: 'paoc_pro_store_popup_click_view',
			'popup_id'		: data_opts.id,
			'campaign_id'	: data_opts.campaign_id,
			'popup_type'	: data_opts.popup_type,
			'type'			: 1,
		};

		jQuery.post(PaocProPublic.paoc_ajaxurl, popup_data, function(response) {
			jQuery(document.body).trigger('paoc_pro_popup_views', [response, data_opts]);
		});
	}

	/* Function to store popup clicks */
	function paoc_pro_popup_clicks( data_opts ) {

		/* Popup Preview is there to not store popup clicks */
		if( PaocProPublic.paoc_preview == 1 ) {
			return false;
		}

		var popup_data = {
			'action'		: 'paoc_pro_store_popup_click_view',
			'popup_id'		: data_opts.id,
			'campaign_id'	: data_opts.campaign_id,
			'popup_type'	: data_opts.popup_type,
			'type'			: 2,
		};

		jQuery.post(PaocProPublic.paoc_ajaxurl, popup_data, function(response) {
			jQuery(document.body).trigger('paoc_pro_popup_clicks', [response, data_opts]);
		});
	}

	/* Set Browser Local Storage */
	function paoc_pro_set_local_storage( key, storage_data, storage_type ) {

		var result = '';

		/* Check browser support */
		if (typeof(Storage) !== "undefined") {

			var stored_data		= '';
			var stored_obj		= {};
			var get_stored_data	= localStorage.getItem( key );

			if( typeof(get_stored_data) != 'undefined' && get_stored_data != null ) {
				stored_obj = JSON.parse( get_stored_data );
			}

			if( storage_type == 'obj' ) {
				var new_stored_obj	= jQuery.extend({}, stored_obj, storage_data);
				stored_data			= JSON.stringify( new_stored_obj );

			} else {

				stored_obj[storage_data]	= storage_data;
				stored_data					= JSON.stringify( stored_obj );
			}

			localStorage.setItem( key, stored_data );
		}

		return result;
	}

	/* Get Browser Local Storage */
	function paoc_pro_get_local_storage( key ) {

		var result	= '';

		/* Check browser support */
		if (typeof(Storage) !== "undefined") {
			result = JSON.parse( localStorage.getItem( key ) );
		}

		return result;
	}

	/* Get UTM query string data */
	function paoc_pro_get_utm_params( query_string ) {

		var paoc_vars		= {}, paoc_hash;
		var query_string	= query_string ? query_string : window.location.search;
			query_string	= decodeURI( query_string );

		if( query_string != '' ) {
			var paoc_params	= query_string.slice(query_string.indexOf('?') + 1).split('&');

			for(var i = 0; i < paoc_params.length; i++) {

				paoc_hash = paoc_params[i].split(/=(.*)/);

				if( paoc_hash[0] !== 'undefined' || paoc_hash[0] != null ) {
					paoc_vars[paoc_hash[0]] = paoc_hash[1];
				}
			}
		}

		return paoc_vars;
	}

	/* Function to check mobile device */
	function paoc_pro_is_mobile() {

		var is_mobile	= false;
		var user_agent	= navigator.userAgent.toLowerCase();

		if ( user_agent == '' ) {
			is_mobile = false;
		} else if ( user_agent.indexOf( 'mobile' ) >= 0 /* Many mobile devices (all iPhone, iPad, etc.) */
			|| user_agent.indexOf( 'android' ) >= 0
			|| user_agent.indexOf( 'silk/' ) >= 0
			|| user_agent.indexOf( 'kindle' ) >= 0
			|| user_agent.indexOf( 'blackberry' ) >= 0
			|| user_agent.indexOf( 'opera mini' ) >= 0
			|| user_agent.indexOf( 'opera mobi' ) >= 0 ) {
			is_mobile = true;
		} else {
			is_mobile = false;
		}

		return is_mobile;
	}

	/* Function to check adblocker */
	function paoc_pro_is_adblocker() {

		var result = 0;

		if( window.paoc_adblocker === undefined ) {
			result = 1;
		}

		if( ! result && jQuery('body').hasClass('paoc-pro-adblock') ) {
			result = 1;
		}

		return result;
	}

	/* Function to shuffle array */
	function paoc_pro_shuffle( popup_ids ) {
		for(var j, x, i = popup_ids.length; i; j = parseInt(Math.random() * i), x = popup_ids[--i], popup_ids[i] = popup_ids[j], popup_ids[j] = x);
		return popup_ids;
	}

	/* Fcuntion to render Inline, Link, Button and Image Popup with action based like geolocation, Adblocker and etc */
	function paoc_pro_action_popup() {

		/* Geolocation Popup */
		$('.paoc-action-popup').each(function() {

			var data_opts		= '';
			var target_ele		= '';
			var this_ele		= $(this);
			var stored_country	= geolocation ? geolocation.geo.country : '';

			/* If check popup `paoc-popup-action-show` & `paoc-popup-action-hide` class is there */
			if( ! this_ele.hasClass('paoc-popup-action-show') && ! this_ele.hasClass('paoc-popup-action-hide') ) {

				/* If `Inline` popup is there */
				if( this_ele.hasClass('paoc-inline-popup') ) {

					target_ele	= this_ele.attr('id');
					data_opts	= this_ele.data('conf');

				} else { /* Simple Link, Button Click, Image Click & HTML Element popup is there */

					var html_classes = this_ele.attr("class").split(' ');

					$.each(html_classes, function( class_key, class_val ) {

						if ( class_val == '' ) {
							return;
						}

						var target = null;
						var normal_cls_pos = class_val.indexOf('paoc-pro-popup-cust-');

						if( normal_cls_pos >= 0 ) {
							target = class_val.replace("paoc-pro-popup-cust-", "paoc-popup-");
						}

						if ( typeof(target) === 'undefined' || target == null ) {
							return;
						}

						target		= target.trim();
						target_ele	= $('.'+target).not('.paoc-inline-popup').attr('id');
						data_opts	= $('#'+ target_ele).data('conf');

						return false;
					});
				}

				var paoc_check_active = paoc_pro_popup_active_flag( target_ele, data_opts );

				if( paoc_check_active == 1 ) {
					$('.paoc-pro-popup-cust-'+data_opts.id).addClass('paoc-popup-action-show');
					$('.paoc-inline-popup-'+data_opts.id).addClass('paoc-popup-action-show');
				} else {
					$('.paoc-pro-popup-cust-'+data_opts.id).addClass('paoc-popup-action-hide');
					$('.paoc-inline-popup-'+data_opts.id).addClass('paoc-popup-action-hide');
				}
			}

			/* If popup `paoc-popup-action-show` class is there */
			if( this_ele.hasClass('paoc-popup-action-show') ) {	
				/* Show */
			} else if( this_ele.hasClass('paoc-popup-action-hide') ) { /* Else If popup `paoc-popup-action-hide` class is there */
				this_ele.remove();
			}
		});
	}

	/* Function to escapping HTML entity */
	function paoc_pro_escape_html( string ) {

		var paoc_pro_entity_Map	= {'"': '&quot;', "'": '&#039;'};

		return String(string).replace(/[&<>"'`=\/]/g, function (s) {
			return paoc_pro_entity_Map[s];
		});
	}

	/* Tooltip */
	function paoc_pro_tooltip() {
		if( jQuery('.paoc-tooltip').length > 0 ) {
			jQuery('.paoc-tooltip').each( function( attachment, index ) {

				if( jQuery(this).hasClass('tooltipstered') ) {
					return;
				}

				var tooltip_text		= jQuery(this).attr('data-tooltip-text');
				var tooltip_cnt			= jQuery(this).attr('data-tooltip-content');
				var tooltip_theme		= jQuery(this).attr('data-tooltip-theme');
				var tooltip_side		= jQuery(this).attr('data-tooltip-side');
				var tooltip_min_width	= jQuery(this).attr('data-tooltip-min-width');

				tooltip_theme		= tooltip_theme		? tooltip_theme		: 'paoc-tooltipster tooltipster-punk';
				tooltip_side		= tooltip_side		? tooltip_side		: 'top';
				tooltip_min_width	= tooltip_min_width	? tooltip_min_width	: false;

				if ( typeof(tooltip_text) !== 'undefined' ) {
					tooltip_cnt = tooltip_text;
				} else {
					tooltip_cnt	= ( jQuery(tooltip_cnt).length > 0 ) ? jQuery(tooltip_cnt) : null;
				}

				jQuery(this).tooltipster({
					maxWidth			: 500,
					contentCloning		: true,
					contentAsHTML		: true,
					interactive			: true,
					repositionOnScroll	: true,
					animation			: 'grow',
					content				: tooltip_cnt,
					theme				: tooltip_theme,
					minWidth			: tooltip_min_width,
					side				: tooltip_side,
					trigger				: ( PaocProPublic.paoc_mobile == 1 ) ? 'click' : 'hover',
				});
			});
		}
	}
})(jQuery);

/* Function to Create Cookie */
function paoc_pro_create_cookie(name, value, time_val, type, samesite) {

	var date, expires, expire_time, samesite;

	time_val	= time_val	? time_val	: false;
	type		= type		? type		: 'day';
	samesite	= samesite	? ";SameSite="+samesite : '';

	if( type == 'hour' ) {
		expire_time = (time_val * 60 * 60 * 1000);

	} else if( type == 'minutes' ) {
		expire_time = (time_val * 60 * 1000);

	} else {
		expire_time = (time_val * 24 * 60 * 60 * 1000);
	}

	if ( time_val ) {
		date = new Date();
		date.setTime( date.getTime() + expire_time );
		expires = "; expires="+date.toGMTString();
	} else {
		expires = "";
	}
	document.cookie = encodeURIComponent(name) + "=" + value + expires + "; path=/"+samesite;
}

/* Function to get cookie value */
function paoc_pro_get_cookie_value( cookie_name ) {

	var result		= null;
	var nameEQ		= cookie_name + "=";
	var get_cookie	= document.cookie.split(';');

	for (var i = 0; i < get_cookie.length; i++) {

		var c = get_cookie[i];

		while (c.charAt(0)==' ') {
			c = c.substring( 1, c.length );
		}

		if (c.indexOf(nameEQ) == 0) {
			result = c.substring(nameEQ.length,c.length);
		}
	}

	return result;
}

/* Function to check adblocker img success */
function paoc_pro_adblock_img_suc() {
	jQuery('.paoc-pro-adblock-img').remove();
}

/* Function to check adblocker img error */
function paoc_pro_adblock_img_err() {
	jQuery('body').addClass('paoc-pro-adblock');
	jQuery('.paoc-pro-adblock-img').remove();

	if( window.paoc_adblocker === true ) {
		jQuery(document.body).trigger('paoc_pro_popup_trigger', 'adblocker');
	}
}