<?php
/**
 * Campaign Functions
 *
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Get Campaign Data
 * 
 * @since 2.0
 */
function paoc_pro_get_campaigns( $args = array() ) {

	global $wpdb;

	$results			= array();
	$args['limit']		= ! empty( $args['limit'] )		? $args['limit']			: 15;
	$args['orderby']	= ! empty( $args['orderby'] )	? $args['orderby']			: 'created_date';
	$args['order']		= ! empty( $args['order'] )		? $args['order']			: 'DESC';
	$args['search']		= isset( $args['search'] )		? trim( $args['search'] )	: '';

	if( ! empty( $args['page'] ) ) {
		$page = $args['page'];
	} else if ( ! empty( $_GET['paged'] ) ) {
		$page = $_GET['paged'];
	} else {
		$page = 1;
	}

	// Query Offset
	$page_offset = ( ( $page * $args['limit'] ) - $args['limit'] );

	// Get campaign table data
	$sql = "SELECT SQL_CALC_FOUND_ROWS * FROM ".PAOC_PRO_CAMPAIGN_TBL." WHERE 1=1";

	// Search
	if( $args['search'] ) {
		$sql .= " AND `title` LIKE '%{$args['search']}%' ";
	}

	// Order By
	if( $args['orderby'] ) {
		$sql .= " ORDER BY `{$args['orderby']}` {$args['order']} ";
	}

	// Limit
	if( $args['limit'] ) {
		$sql .= " LIMIT {$page_offset},{$args['limit']} ";
	}

	// Get Entries
	$entries = $wpdb->get_results( $sql );

	// Total Entry Count
	$total_entries	= (int) $wpdb->get_var( 'SELECT FOUND_ROWS()' );

	$results['data']	= $entries;
	$results['count']	= ! empty( $total_entries ) ? $total_entries : 0;

	return $results;
}

/**
 * Function to get enabled campaign `publish` popup IDs.
 * 
 * @since 2.0
 */
function paoc_pro_campaign_popups( $popup_id ) {

	global $wpdb, $paoc_campaign_popup_data;

	// Taking some variables
	$results	= array();
	$prefix		= PAOC_PRO_META_PREFIX;

	// Check `Campaign ID` is not there in popup post
	if( empty( $popup_id ) ) {
		return $results;
	}

	// Get Popup Campaign ID
	$campaign_id = get_post_meta( $popup_id, $prefix.'campaign_id', true );

	// Check `Campaign ID` is not there in popup post
	if( empty( $campaign_id ) ) {
		return $results;
	}

	// If data is already in global variable
	if( ! empty( $paoc_campaign_popup_data[ $campaign_id ] ) ) {
		return $paoc_campaign_popup_data[ $campaign_id ];
	}

	// Get campaign data
	$select_query	= "SELECT popup_ids, popup_appear FROM ".PAOC_PRO_CAMPAIGN_TBL." WHERE `id` = {$campaign_id} AND `enable` = 1";
	$campaign_data	= $wpdb->get_row( $select_query );

	if( ! empty( $campaign_data ) ) {

		$popup_ids	= isset( $campaign_data->popup_ids ) ? $campaign_data->popup_ids : array();
		$popup_ids	= explode( ',', $popup_ids );

		foreach( $popup_ids as $popup_key => $popup_id ) {

			$post_status = paoc_pro_get_post_status( $popup_id );

			$results['id']				= $campaign_id;
			$results['popup_appear']	= $campaign_data->popup_appear;
			$results['popup_ids'][]		= $popup_id;

			if( $post_status != 'publish' ) {
				continue;
			}

			// Get popup appear
			$popup_appear = get_post_meta( $popup_id, $prefix.'popup_appear', true );

			if( $campaign_data->popup_appear == $popup_appear ) {
				$results['display_popup'][] = $popup_id;
			}
		}

		// empty `display_popup` if popups are less than 1
		if ( ! empty( $results['display_popup'] ) && count( $results['display_popup'] ) <= 1 ) {
			$results['display_popup'] = array();
		}

		// Assign to global variables
		$paoc_campaign_popup_data[ $campaign_id ] = $results;
	}

	return $results;
}