<?php
/**
 * Admin Class
 * Handles the Admin side functionality of A/B testing
 *
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Paoc_Pro_Campaign_Admin {

	function __construct() {

		// Action to add admin menu
		add_action( 'admin_menu', array($this, 'paoc_pro_register_ab_testing_menu'), 9 );

		// Process A/B Testing Data
		add_action( 'admin_init', array($this, 'paoc_pro_process_campaign_data') );
	}

	/**
	 * Function to add menu
	 * 
	 * @package Popup Anything on Click Pro
	 * @since 2.0
	 */
	function paoc_pro_register_ab_testing_menu() {

		// Register A/B Testing page
		add_submenu_page( 'edit.php?post_type='.PAOC_PRO_POST_TYPE, __('A/B Testing Campaign - Popup Anything Pro', 'popup-anything-on-click'), __('A/B Testing', 'popup-anything-on-click'), 'manage_options', 'paoc-campaign', array($this, 'paoc_pro_ab_testing_page') );
	}

	/**
	 * Function to handle the A/B Testing page html
	 *
	 * @package Popup Anything on Click Pro
	 * @since 2.0
	 */
	function paoc_pro_ab_testing_page() {

		if( ! empty( $_GET['action'] ) && ( $_GET['action'] == 'add' || $_GET['action'] == 'edit' ) ) {

			include_once( PAOC_PRO_DIR . '/includes/ab-testing/form/campaign-form.php' );

		} else {

			include_once( PAOC_PRO_DIR . '/includes/ab-testing/campaign-lists.php' );
		}
	}

	/**
	 * Function to process A/B Testing data (Save, Update, Delete)
	 *
	 * @package Popup Anything on Click Pro
	 * @since 2.0
	 */
	function paoc_pro_process_campaign_data() {

		global $wpdb, $paoc_campaign_err;

		$prefix = PAOC_PRO_META_PREFIX; // Meta Prefix

		// Add OR Update Campaign Data in DB
		if( ! empty( $_POST['paoc_campaign_save'] ) && check_admin_referer( 'paoc_campaign_save', 'paoc_campaign_save_nonce' ) ) {

			// Taking some variable
			$paoc_campaign_err		= array();
			$mode					= ( isset( $_GET['action'] ) && $_GET['action'] == 'edit' ) ? 'edit' : 'add';
			$campaign_id			= ! empty( $_GET['campaign_id'] )	? $_GET['campaign_id'] : 0;
			$campaign_enable		= ! empty( $_POST['enable'] )		? 1 : 0;
			$campaign_title			= ! empty( $_POST['title'] )		? paoc_pro_clean( $_POST['title'] )			: __('Campaign', 'popup-anything-on-click');
			$campaign_popup_appear	= ! empty( $_POST['popup_appear'] )	? paoc_pro_clean( $_POST['popup_appear'] )	: 'page_load';
			$campaign_popups		= ! empty( $_POST['popup_ids'] )	? paoc_pro_clean( $_POST['popup_ids'] )		: array();
			$popup_ids				= implode(',', $campaign_popups );

			// Check if selected popups less then or equal to 1
			if( count( $campaign_popups ) <= 1 ) {
				
				$paoc_campaign_err['campaign_popups'] = __('Please select two or more popups for campaign.', 'popup-anything-on-click');

			} else {

				// Get Campaign Data
				$campaign_query	= 'SELECT `id`, `title` FROM `'.PAOC_PRO_CAMPAIGN_TBL.'` WHERE 1=1 AND CONCAT(",", `popup_ids`, ",") REGEXP ",('.implode('|', $campaign_popups ).'),"';

				if( $mode == 'edit' ) {
					$campaign_query	.= " AND `id` != {$campaign_id}";
				}
				$campaign_query .= " Limit 1";

				$get_campaign_data = $wpdb->get_row( $campaign_query );

				if( ! empty( $get_campaign_data ) ) {

					$campaign_url = add_query_arg( array('post_type' => PAOC_PRO_POST_TYPE, 'page' => 'paoc-campaign', 'action' => 'edit', 'campaign_id' => $get_campaign_data->id ), admin_url('edit.php') );
					$paoc_campaign_err['campaign_popups'] = sprintf( __('One or more popup is already set in another campaign %s. Please select different popups.', 'popup-anything-on-click'), '<a target="_blank" href="'.esc_url( $campaign_url ).'">'.$get_campaign_data->title.'</a>' );
				}
			}

			// If no error is there
			if( empty( $paoc_campaign_err ) ) {

				if( $mode == 'add' ) {

					// Insert Query
					$wpdb->insert( PAOC_PRO_CAMPAIGN_TBL,
									array(
										'enable'		=> $campaign_enable,
										'title'			=> $campaign_title,
										'popup_ids'		=> $popup_ids,
										'popup_appear'	=> $campaign_popup_appear,
										'created_date'	=> current_time('mysql'),
										'modified_date'	=> current_time('mysql'),
									));

					// Last Inserted Campaign ID
					$campaign_id = $wpdb->insert_id;

				} else {

					// Get campaign data before update to remove campaign id from popup meta
					$old_campaign_query	= "SELECT popup_ids FROM `".PAOC_PRO_CAMPAIGN_TBL."` WHERE id={$campaign_id}";
					$old_campaign_data	= $wpdb->get_results( $old_campaign_query );

					// Remove campaign id from popup meta
					foreach ($old_campaign_data as $old_popup_key => $old_popup_data) {

						$old_popup_ids = explode( ',', $old_popup_data->popup_ids );

						foreach( $old_popup_ids as $old_popup_id_key => $old_popup_id ) {
							update_post_meta( $old_popup_id, $prefix.'campaign_id', '' );
						}
					}

					// Update Query
					$wpdb->update( PAOC_PRO_CAMPAIGN_TBL,
									array(
										'enable'		=> $campaign_enable,
										'title'			=> $campaign_title,
										'popup_ids'		=> $popup_ids,
										'popup_appear'	=> $campaign_popup_appear,
										'modified_date'	=> current_time('mysql'),
									),
									array(
										'id' => $campaign_id,
									));
				}

				// If Campaign ID is there
				if( $campaign_id ) {

					// Update campaign id in Popup Meta
					foreach ($campaign_popups as $popup_key => $popup_id) {
						update_post_meta( $popup_id, $prefix.'campaign_id', $campaign_id );
					}

					// After to save to redirect to edit campaign page
					$redirect_url = add_query_arg( array('post_type' => PAOC_PRO_POST_TYPE, 'page' => 'paoc-campaign', 'action' => 'edit', 'campaign_id' => $campaign_id, 'message' => 'paoc_campaign_save' ), admin_url('edit.php') );
					wp_redirect( $redirect_url );
					exit;
				}
			}
		}


		/***** Delete Campaign Data *****/
		if( ( isset( $_GET['page'] ) && $_GET['page'] == 'paoc-campaign' )
			&& ( (isset( $_GET['action'] ) && $_GET['action'] == 'delete') || (isset( $_GET['action2'] ) && $_GET['action2'] == 'delete') )
			&& ! empty( $_GET['paoc_pro_campaign'] ) && isset( $_GET['_wpnonce'] ) && wp_verify_nonce( $_GET['_wpnonce'], 'bulk-paoc_pro_campaign' )
		) {

			// Taking some variable
			$paoc_pro_campaign = implode( ',', $_GET['paoc_pro_campaign'] );

			// Get Campaign data
			$campaign_query	= "SELECT `popup_ids` FROM `".PAOC_PRO_CAMPAIGN_TBL."` WHERE `id` in( $paoc_pro_campaign )";
			$campaign_data		= $wpdb->get_results( $campaign_query );

			// Delete Campaign ID From Popup Meta
			if( ! empty( $campaign_data ) ) {
				foreach ($campaign_data as $data_key => $data_val) {

					$popup_ids = explode( ',', $data_val->popup_ids );

					foreach ($popup_ids as $popup_key => $popup_id) {
						update_post_meta( $popup_id, $prefix.'campaign_id', '' );
					}
				}
			}

			// Delete Campaign Data
			$delete_query = "DELETE FROM `".PAOC_PRO_CAMPAIGN_TBL."` WHERE `id` in( $paoc_pro_campaign )";
			$wpdb->query( $delete_query );

			// Redirect to Campaign List Page
			$redirect_url = add_query_arg( array('post_type' => PAOC_PRO_POST_TYPE, 'page' => 'paoc-campaign', 'message' => 'delete' ), admin_url('edit.php') );
			wp_redirect( $redirect_url );
			exit;
		}
	}
}

$paoc_pro_campaign_admin = new Paoc_Pro_Campaign_Admin();