<?php
/**
 * A/B Testing Campaign HTML
 *
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $wpdb, $paoc_campaign_err;

// Taking some data
$paoc_highest		= 0;
$count				= 0;
$popup_data			= array();
$popup_ids_arr		= array();
$prefix				= PAOC_PRO_META_PREFIX;
$popup_appear_data	= paoc_pro_when_appear_options();
$campaign_id		= isset( $_GET['campaign_id'] ) ? $_GET['campaign_id'] : 0;
$mode				= ( isset( $_GET['action'] ) && $_GET['action'] == 'edit' ) ? 'edit' : 'add';

// Return if no campaign ID is set
if( empty( $campaign_id ) && $mode == 'edit' ) {
	paoc_pro_display_message( 'error', null );
	return;
}

if( $mode == 'edit' ) {

	$page_title = __( 'Edit A/B Testing Campaign', 'popup-anything-on-click' );
	$update_msg	= __('Campaign updated successfully.', 'popup-anything-on-click');
	$btn_text	= __('Update Campaign', 'popup-anything-on-click');

	// Get Campaign Data
	$sql			= "SELECT * FROM ".PAOC_PRO_CAMPAIGN_TBL." WHERE 1=1 AND `id` = '{$campaign_id}'";
	$campaign_data	= $wpdb->get_row( $sql, 'ARRAY_A' );
	$campaign_data	= ! empty( $_POST['paoc_campaign_save'] ) ? $_POST : $campaign_data;

	$campaign_enable	= ! empty( $campaign_data['enable'] )		? 1 : 0;
	$campaign_title		= isset( $campaign_data['title'] )			? $campaign_data['title']			: '';
	$camp_popup_appear	= isset( $campaign_data['popup_appear'] )	? $campaign_data['popup_appear']	: '';
	$popup_ids			= isset( $campaign_data['popup_ids'] )		? $campaign_data['popup_ids']		: '';
	$popup_ids			= ! is_array( $popup_ids )					? explode( ',', $popup_ids )		: $popup_ids;

} else {

	$page_title			= __( 'Add A/B Testing Campaign', 'popup-anything-on-click' );
	$update_msg			= __('Campaign created successfully.', 'popup-anything-on-click');
	$btn_text			= __('Add Campaign', 'popup-anything-on-click');

	$campaign_enable	= ! empty( $_POST['enable'] )		? 1 : 0;
	$campaign_title		= isset( $_POST['title'] )			? $_POST['title']			: '';
	$camp_popup_appear	= isset( $_POST['popup_appear'] )	? $_POST['popup_appear']	: '';
	$popup_ids			= ! empty( $_POST['popup_ids'] )	? $_POST['popup_ids']		: '';
}

// Validate the popup if it is deleted or status changed later
if( ! empty( $popup_ids ) ) {
	foreach ( $popup_ids as $popup_key => $popup_id ) {

		if ( empty( $popup_id ) ) {
			continue;
		}

		$popup_post = get_post( $popup_id );

		if( empty( $popup_post ) || ( isset( $popup_post->post_type ) && $popup_post->post_type != PAOC_PRO_POST_TYPE ) ) {
			continue;
		}

		$popup_data[]		= $popup_post;
		$popup_ids_arr[]	= $popup_id;
	}
}

$popup_ids = $popup_ids_arr;
?>

<div class="wrap paoc-cnt-wrap paoc-campaign-wrap">
	<h2>
		<?php echo esc_html( $page_title );

		if( $mode == 'edit' ) { ?>
		<a href="<?php echo esc_url( PAOC_PRO_ADD_CAMPAIGN_LINK ); ?>" class="page-title-action"><?php esc_html_e('Add New', 'popup-anything-on-click'); ?></a>
		<?php } ?>
	</h2>

	<?php
		// Campaign Published Message
		if( ! empty($_GET['message']) && $_GET['message'] == 'paoc_campaign_save' ) {
			paoc_pro_display_message( 'update', $update_msg );
		}

		// Validation error
		if( ! empty( $paoc_campaign_err ) ) {
			paoc_pro_display_message( 'error', __('One more field have an error. Please check and try again.', 'popup-anything-on-click') );
		}
	?>

	<form id="paoc-campaign-form" class="paoc-campaign-form paoc-post-title-sugg-form" method="POST">
		<div class="metabox-holder">
			<div class="post-box-container">
				<div class="meta-box-sortables">

					<!-- Campaign Settings Box -->
					<div class="postbox">
						<div class="postbox-header">
							<h3 class="hndle">
								<span><?php esc_html_e( 'Campaign Settings', 'popup-anything-on-click' ); ?></span>
							</h3>
						</div>

						<div class="inside">
							<table class="form-table paoc-tbl">
								<tr>
									<th>
										<label for="paoc-campaign-enable"><?php esc_html_e('Enable', 'popup-anything-on-click'); ?></label>
									</th>
									<td>
										<input type="checkbox" name="enable" <?php checked( $campaign_enable, 1 ); ?> value="1" id="paoc-campaign-enable" class="paoc-checkbox paoc-campaign-enable" /><br/>
										<span class="description"><?php esc_html_e('Check this box to enable A/B testing campaign.', 'popup-anything-on-click'); ?></span>
									</td>
								</tr>
								<tr>
									<th>
										<label for="paoc-campaign-title"><?php esc_html_e('Title', 'popup-anything-on-click'); ?></label>
									</th>
									<td>
										<input type="text" name="title" value="<?php echo esc_attr( $campaign_title ); ?>" id="paoc-campaign-title" class="large-text paoc-text paoc-campaign-title" /><br/>
										<span class="description"><?php esc_html_e('Enter campaign title. This is just for admin purpose only.', 'popup-anything-on-click'); ?></span>
									</td>
								</tr>

								<tr>
									<th>
										<label for="paoc-popup-appear"><?php esc_html_e('Popup Appearance', 'popup-anything-on-click'); ?></label>
									</th>
									<td>
										<select name="popup_appear" class="paoc-select paoc-popup-appear" id="paoc-popup-appear">
											<?php if ( ! empty( $popup_appear_data ) ) {
												foreach ( $popup_appear_data as $popup_appear_key => $popup_appear_val ) { ?>
													<option value="<?php echo esc_attr( $popup_appear_key ); ?>" <?php selected( $camp_popup_appear, $popup_appear_key ); ?>><?php echo esc_html( $popup_appear_val ); ?></option>
											<?php } } ?>
										</select><br/>
										<span class="description"><?php esc_html_e('Choose popup appearance.', 'popup-anything-on-click'); ?></span>
									</td>
								</tr>

								<tr>
									<th>
										<label for="paoc-campaign-popups"><?php esc_html_e('Select Popups', 'popup-anything-on-click'); ?></label>
									</th>
									<td>
										<select name="popup_ids[]" id="paoc-campaign-popups" class="paoc-select2-mul paoc-post-title-sugg paoc-campaign-popups" data-placeholder="<?php esc_html_e('Select Popups for Campaign', 'popup-anything-on-click'); ?>" data-nonce="<?php echo wp_create_nonce('paoc-post-title-sugg'); ?>" data-post-type="<?php echo esc_attr( PAOC_PRO_POST_TYPE ); ?>" multiple="multiple">
											<option></option>
											<?php if( ! empty( $popup_data ) ) {
												foreach ( $popup_data as $popup_key => $popup_val ) {

													$popup_appear		= get_post_meta( $popup_val->ID, $prefix.'popup_appear', true );
													$popup_appear_name	= isset( $popup_appear_data[ $popup_appear ] ) ? $popup_appear_data[ $popup_appear ] : $popup_appear;

													$option_name = $popup_val->post_title ." - (#{$popup_val->ID})";
													$option_name .= ( $popup_val->post_status != 'publish' ) ? " &mdash; (".ucfirst($popup_val->post_status).") " : '';
													$option_name .= ( $popup_appear != $camp_popup_appear ) ? " &mdash; (".$popup_appear_name.") " : '';
											?>
													<option value="<?php echo esc_attr( $popup_val->ID ); ?>" <?php selected( in_array( $popup_val->ID, $popup_ids ), true ); ?>><?php echo esc_html( $option_name ); ?></option>
												<?php }
											} ?>
										</select><br/>
										<span class="description"><?php esc_html_e('Select popups for campaign.', 'popup-anything-on-click'); ?></span>
										<?php if( isset( $paoc_campaign_err['campaign_popups'] ) ) { ?><div class="paoc-form-err"><?php echo wp_kses_post( $paoc_campaign_err['campaign_popups'] ); ?></div><?php } ?>
									</td>
								</tr>
								<tr>
									<td colspan="2">
										<?php wp_nonce_field( 'paoc_campaign_save', 'paoc_campaign_save_nonce' ); ?>
										<input type="submit" name="paoc_campaign_save" class="button button-primary right paoc-btn paoc-campaign-save paoc-sett-submit" value="<?php echo esc_attr( $btn_text ); ?>" />
									</td>
								</tr>
							</table>
						</div>
					</div><!-- .postbox -->


					<!-- Campaign Popup Details -->
					<?php if( $mode == 'edit' && ! empty( $popup_ids ) ) { ?>
					<div class="postbox">

						<div class="postbox-header">
							<h3 class="hndle">
								<span><?php esc_html_e( 'Campaign Popup Details', 'popup-anything-on-click' ); ?></span>
							</h3>
						</div>

						<div class="inside">
							<div class="paoc-row paoc-popup-details-wrap paoc-clearfix">
								<?php foreach ( $popup_data as $popup_key => $popup_val ) {

									// Taking Popup Appear data
									$count++;
									$highest_css		= '';
									$popup_id			= $popup_val->ID;
									$popup_goals		= paoc_pro_popup_goals();
									$popup_types		= paoc_pro_popup_types();
									$time_options		= paoc_pro_time_options();
									$show_for_data		= paoc_pro_show_for_options();
									$display_on_data	= paoc_pro_display_on_options();
									$popup_goal			= get_post_meta( $popup_id, $prefix.'popup_goal', true );
									$display_type		= get_post_meta( $popup_id, $prefix.'display_type', true );
									$popup_appear		= get_post_meta( $popup_id, $prefix.'popup_appear', true );
									$advance			= get_post_meta( $popup_id, $prefix.'advance', true );

									// Get popup total views
									$total_views	= $wpdb->get_var( "SELECT SUM( click_view ) FROM `".PAOC_PRO_REPORT_TBL."` WHERE 1=1 AND `popup_id` = {$popup_id} AND `campaign_id` = {$campaign_id} AND `type` = '1'" );
									$popup_views	= ! empty( $total_views ) ? ( $total_views ) : 0;

									// Get popup total clicks
									$total_clicks	= $wpdb->get_var( "SELECT SUM( click_view ) FROM `".PAOC_PRO_REPORT_TBL."` WHERE 1=1 AND `popup_id` = {$popup_id} AND `campaign_id` = {$campaign_id} AND `type` = '2'" );
									$popup_clicks	= ! empty( $total_clicks ) ? ( $total_clicks ) : 0;

									$popup_appear_name	= isset( $popup_appear_data[ $popup_appear ] ) ? $popup_appear_data[ $popup_appear ] : $popup_appear;

									// Taking Advance Data
									$display_on			= isset( $advance['display_on'] )			? $advance['display_on']		: '';
									$cookie_expire		= isset( $advance['cookie_expire'] )		? $advance['cookie_expire']		: '';
									$cookie_unit		= isset( $advance['cookie_unit'] )			? $advance['cookie_unit']		: '';
									$start_time			= isset( $advance['start_time'] )			? $advance['start_time']		: '';
									$end_time			= isset( $advance['end_time'] )				? $advance['end_time']		: '';
									$cookie_unit		= isset( $time_options[ $cookie_unit ] )	? $time_options[ $cookie_unit ]	: $cookie_unit;
									$schedule_tooltip	= __('Start Time', 'popup-anything-on-click')." : ".$start_time."\n".__('End Time', 'popup-anything-on-click')." : ".$end_time."\n\n".__('Note : Time is displayed in 24 Hrs format.', 'popup-anything-on-click');

									// Calculate Average
									if( $popup_views || $popup_clicks ) {
										$average = ( $popup_clicks / $popup_views ) * 100;
										$average = round( $average, 2 );
									} else {
										$average = 0;
									}

									// Highlight highest
									if( $average > $paoc_highest ) {
										$highest_css = "<style type='text/css'>.paoc-camp-popup-{$popup_id} .paoc-highest{background-color: #dff0d8; border-top: 1px solid #d6e9c6;}</style>";
									}
									$paoc_highest = $average;
								?>
									<div class="paoc-medium-4 paoc-camp-popup-<?php echo esc_attr( $popup_id ); ?> paoc-columns <?php if( $count % 3 == 1 ) { echo 'paoc-clear'; } ?> <?php if( $popup_appear != $camp_popup_appear ) { echo 'paoc-extra-popup'; } ?>">
										<div class="paoc-detail-box">
											<div class="paoc-popup-title">
												<?php echo esc_html( $popup_val->post_title . " &mdash; (#{$popup_id})" );

												if( $popup_appear != $camp_popup_appear ) { ?>
													<span class="paoc-extra-info" title="<?php esc_attr_e('This popup will not be display because popup appearance is different then campaign popups appearance.', 'popup-anything-on-click'); ?>">
														<i class="dashicons dashicons-info"></i>
													</span>
												<?php } ?>

												<a href="<?php echo esc_url( get_edit_post_link( $popup_id ) ); ?>" target="_blank" title="<?php esc_attr_e('Edit', 'popup-anything-on-click'); ?>" class="paoc-popup-edit-link">
													<i class="dashicons dashicons-edit"></i>
												</a>
											</div>

											<div class="paoc-popup-detail">
												<table class="wp-list-table widefat fixed paoc-tbl">
													<tbody>
														<tr>
															<th><?php esc_html_e('Popup Goal', 'popup-anything-on-click'); ?></th>
															<td><?php echo esc_html( $popup_goals[ $popup_goal ]['name'] ); ?></td>
														</tr>
														<tr>
															<th><?php esc_html_e('Popup Type', 'popup-anything-on-click'); ?></th>
															<td><?php echo esc_html( $popup_types[ $display_type ]['name'] ); ?></td>
														</tr>
														<tr>
															<th><?php esc_html_e('Popup Appear', 'popup-anything-on-click'); ?></th>
															<td><?php echo esc_html( $popup_appear_name ); ?></td>
														</tr>

														<tr>
															<th><?php esc_html_e('Display On', 'popup-anything-on-click'); ?></th>
															<td><?php echo isset( $display_on_data[ $display_on ] ) ? esc_html( $display_on_data[ $display_on ] ) : esc_html__('Every Device', 'popup-anything-on-click'); ?></td>
														</tr>

														<tr>
															<th><?php esc_html_e('Show For', 'popup-anything-on-click'); ?></th>
															<td><?php echo isset( $show_for_data[ $advance['show_for'] ] ) ? esc_html( $show_for_data[ $advance['show_for'] ] ) : esc_html__('Every One', 'popup-anything-on-click'); ?></td>
														</tr>

														<tr>
															<th><?php esc_html_e('Adblocker', 'popup-anything-on-click'); ?></th>
															<td><?php echo ! empty( $advance['adblocker'] ) ? esc_html__('Yes', 'popup-anything-on-click') : esc_html__('No', 'popup-anything-on-click'); ?></td>
														</tr>

														<tr>
															<th><?php esc_html_e('Referrer Popup', 'popup-anything-on-click'); ?></th>
															<td><?php echo ! empty( $advance['referrer_enable'] ) ? esc_html__('Yes', 'popup-anything-on-click') : esc_html__('No', 'popup-anything-on-click'); ?></td>
														</tr>

														<tr>
															<th><?php esc_html_e('UTM Popup', 'popup-anything-on-click'); ?></th>
															<td><?php echo ! empty( $advance['utm_enable'] ) ? esc_html__('Yes', 'popup-anything-on-click') : esc_html__('No', 'popup-anything-on-click'); ?></td>
														</tr>

														<tr>
															<th><?php esc_html_e('Cookie Popup', 'popup-anything-on-click'); ?></th>
															<td><?php echo ! empty( $advance['cookie_enable'] ) ? esc_html__('Yes', 'popup-anything-on-click') : esc_html__('No', 'popup-anything-on-click'); ?></td>
														</tr>

														<tr>
															<th><?php esc_html_e('Geolocation', 'popup-anything-on-click'); ?></th>
															<td><?php echo ! empty( $advance['geo_countries'] ) ? implode( ', ', $advance['geo_countries'] ) : '&mdash;' ?></td>
														</tr>

														<tr>
															<th><?php esc_html_e('Schedule', 'popup-anything-on-click'); ?></th>
															<td>
																<?php if( ! empty( $start_time ) || ! empty( $end_time ) ) {
																	esc_html_e('Yes', 'popup-anything-on-click'); ?>
																	<i class="dashicons dashicons-info paoc-dashicons-icon" title="<?php echo esc_attr( $schedule_tooltip ); ?>"></i>
																<?php } else {
																	esc_html_e('No', 'popup-anything-on-click');
																} ?>
															</td>
														</tr>

														<tr>
															<th><?php esc_html_e('Cookie', 'popup-anything-on-click'); ?></th>
															<td>
																<?php if( $cookie_expire ) {
																	echo esc_html( $cookie_expire ).' '.esc_html( $cookie_unit );
																} else {
																	esc_html_e('No', 'popup-anything-on-click');
																} ?>
															</td>
														</tr>

														<tr>
															<td colspan="2"><hr/></td>
														</tr>

														<tr>
															<th><?php esc_html_e('Views', 'popup-anything-on-click'); ?></th>
															<td><?php echo number_format( $popup_views ); ?></td>
														</tr>

														<tr>
															<th><?php esc_html_e('Clicks', 'popup-anything-on-click'); ?></th>
															<td><?php echo number_format( $popup_clicks ); ?></td>
														</tr>

														<tr class="paoc-highest">
															<th><?php esc_html_e('Average', 'popup-anything-on-click'); ?></th>
															<td><?php echo esc_html( $average.'%' ); ?></td>
														</tr>
													</tbody>
												</table>
											</div>
										</div>
									</div>
								<?php }
								
								// Print style
								echo $highest_css; // phpcs:ignore WordPress.XSS.EscapeOutput.OutputNotEscaped
								?>
							</div>
						</div>
					</div><!-- .postbox -->
					<?php } ?>

				</div><!-- end .meta-box-sortables -->
			</div><!-- end .post-box-container -->
		</div><!-- end .metabox-holder -->
	</form>
</div>