<?php
/**
 * Add some content to the help tab
 *
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class PAOC_Admin_Help {

	function __construct() {

		// Action to add help tab
		add_action( 'current_screen', array( $this, 'paoc_pro_add_help_tabs' ), 50 );
	}

	/**
	 * Add Contextual help tabs.
	 * @since 1.1
	 */
	public function paoc_pro_add_help_tabs() {

		global $current_screen;

		$screen = isset( $current_screen->id ) ? $current_screen->id : '';

		// If not form entries main screen then return
		if( $screen != PAOC_PRO_POST_TYPE.'_page_paoc-form-entries' ) {
			return;
		}

		$current_screen->add_help_tab(
			array(
				'id'		=> 'paoc_pro_form_entries_tab_overview',
				'title'		=> __( 'Overview', 'popup-anything-on-click' ),
				'content'	=>	'<p>'. __( 'Welcome to popup form entries page! You can find your popup entries here. Just choose your popup and press the filter button.', 'popup-anything-on-click' ) .'</p>'.
								'<ul>' .
									'<li>' . __( 'At listing page, you can see only top three form fields.', 'popup-anything-on-click' ) .'</li>'.
									'<li>' . __( 'To see all form fields, you go to entry detailed page.', 'popup-anything-on-click' ) .'</li>'.
								'</ul>',
			));

		$current_screen->add_help_tab(
			array(
				'id'		=> 'paoc_pro_form_entries_tab_search',
				'title'		=> __( 'Search Entries', 'popup-anything-on-click' ),
				'content'	=> '<p>'. __( 'Search any form entries by any form field via search bar.', 'popup-anything-on-click' ) .'</p>',
			));

		$current_screen->add_help_tab(
			array(
				'id'		=> 'paoc_pro_form_entries_tab_export',
				'title'		=> __( 'Export Entries', 'popup-anything-on-click' ),
				'content'	=>	'<p>'. __( 'To export form entries, kindly navigate to Tools menu of plugin.', 'popup-anything-on-click' ) .'</p>',
			));
	}
}

$paoc_admin_help = new PAOC_Admin_Help();