<?php
/**
 * Form Submission Functions
 *
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Process the bulk actions of Form Entries
 *
 * @since 2.0
 * @return void
 */
function paoc_pro_process_entries_actions() {

	global $wpdb;

	// Form Submission Page
	if( ( isset( $_GET['page'] ) && $_GET['page'] == 'paoc-form-entries' )
		&& ( (isset( $_GET['action'] ) && $_GET['action'] == 'delete') || (isset( $_GET['action2'] ) && $_GET['action2'] == 'delete') )
		&& ! empty( $_GET['paoc_pro_entry'] ) && isset( $_GET['_wpnonce'] ) && wp_verify_nonce( $_GET['_wpnonce'], 'bulk-paoc_pro_entry' )
	) {

		$paoc_pro_entry = $_GET['paoc_pro_entry'];
		$paoc_pro_entry = implode( ',', $_GET['paoc_pro_entry'] );

		$sql = "DELETE FROM `".PAOC_PRO_ENTRY_TBL."` WHERE `id` in( $paoc_pro_entry )";
		$wpdb->query( $sql );

		$redirect_url = add_query_arg( array('message' => 1, 'action' => false, '_wpnonce' => false, 'paoc_pro_entry' => false ) );
		wp_redirect( $redirect_url );
		exit;
	}
}

// Action to process form entries action
add_action( 'admin_init', 'paoc_pro_process_entries_actions' );

/**
 * Get Popup Form Entries
 * 
 * @since 2.0
 */
function paoc_pro_get_entries( $args = array() ) {

	global $wpdb;

	$entries			= array();
	$results			= array();
	$entry_ids			= array();
	$args['limit']		= ! empty( $args['limit'] )		? $args['limit']			: 1;
	$args['orderby']	= ! empty( $args['orderby'] )	? $args['orderby']			: 'created_date';
	$args['order']		= ! empty( $args['order'] )		? $args['order']			: 'ASC';
	$args['search']		= ( $args['search'] != '' )		? trim( $args['search'] )	: '';
	$args['popup_id']	= ! empty( $args['popup_id'] )	? trim( $args['popup_id'] )	: '';

	if( ! empty( $args['page'] ) ) {
		$page = $args['page'];
	} else if ( ! empty( $_GET['paged'] ) ) {
		$page = $_GET['paged'];
	} else {
		$page = 1;
	}

	// Query Offset
	$page_offset = ( ( $page * $args['limit'] ) - $args['limit'] );

	// Get entry table data
	$sql = "SELECT SQL_CALC_FOUND_ROWS entry_tbl.* FROM `".PAOC_PRO_ENTRY_TBL."` AS entry_tbl
			INNER JOIN `".PAOC_PRO_ENTRY_META_TBL."` as entry_meta_tbl ON entry_tbl.`id` = entry_meta_tbl.`entry_id` WHERE 1=1";

	// Popup ID
	if( $args['popup_id'] ) {
		$sql .= " AND entry_tbl.`popup_id`='{$args['popup_id']}' ";
	}

	// Search
	if( $args['search'] ) {
		$sql .= " AND entry_meta_tbl.`meta_value` LIKE '%{$args['search']}%' ";
	}

	// Group By
	$sql .= " GROUP BY entry_tbl.`id` ";

	// Order By
	if( $args['orderby'] ) {
		$sql .= " ORDER BY `{$args['orderby']}` {$args['order']} ";
	}

	// Limit
	if( $args['limit'] ) {
		$sql .= " LIMIT {$page_offset},{$args['limit']} ";
	}

	$form_entries = $wpdb->get_results( $sql, ARRAY_A );

	/***** Get Entry Meta *****/
	if( ! empty( $form_entries ) ) {

		// Total Entry Count
		$total_entries	= (int) $wpdb->get_var( 'SELECT FOUND_ROWS()' );

		// Loop of form entries
		foreach( $form_entries as $entry_key => $entry_data ) {
			
			// Store entry with indexed id
			$entries[ $entry_data['id'] ] = $entry_data;

			// Entry ID array
			$entry_ids[] = $entry_data['id'];
		}

		// Get Form Entries Meta
		$sql_entry_meta			= "SELECT * FROM ".PAOC_PRO_ENTRY_META_TBL." WHERE 1=1 AND entry_id IN(".implode( ',', $entry_ids ).")";
		$sql_entry_meta_result	= $wpdb->get_results( $sql_entry_meta, ARRAY_A );

		// Loop of form entries meta
		foreach( $sql_entry_meta_result as $entry_key => $entry_data ) {

			if( isset( $entries[ $entry_data['entry_id'] ] ) ) {
				$entries[ $entry_data['entry_id'] ][ 'meta_key_'.$entry_data['meta_key'] ]		= $entry_data['meta_value'];
				$entries[ $entry_data['entry_id'] ][ 'meta_key_type_'.$entry_data['meta_key'] ] = $entry_data['meta_key_type'];
			}
		}
	}

	$results['data']	= $entries;
	$results['count']	= ! empty( $total_entries ) ? $total_entries : 0;

	return $results;
}