<?php
/**
 * View Form Submission Entry
 *
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $wpdb, $post;

// Taking some variable
$prefix				= PAOC_PRO_META_PREFIX;
$entry_id			= isset( $_GET['entry_id'] ) ? $_GET['entry_id'] : 0;
$entries_page_url	= add_query_arg( array('entry_id' => false, 'action' => false) );

// Get entry & entry meta table data
$sql			= "SELECT entry_tbl.*, entry_meta_tbl.* FROM `".PAOC_PRO_ENTRY_TBL."` AS entry_tbl
					INNER JOIN `".PAOC_PRO_ENTRY_META_TBL."` as entry_meta_tbl ON entry_tbl.`id` = entry_meta_tbl.`entry_id` WHERE 1=1 AND entry_tbl.`id` = {$entry_id}";
$form_entries	= $wpdb->get_results( $sql, ARRAY_A );

// Print Error if no valid entry is found
if( empty( $form_entries ) ) {
	echo '<div class="error notice notice-error">
			<p><strong>'.__('Sorry, Something happened wrong.', 'popup-anything-on-click').'</strong></p>
		</div>';
	exit;
}

// Taking some variable
$popup_types	= paoc_pro_when_appear_options();
$popup_id		= isset( $form_entries[0]['popup_id'] )			? $form_entries[0]['popup_id']		: 0;
$referral_link	= isset( $form_entries[0]['referral_link'] )	? $form_entries[0]['referral_link']	: '';
$ip_address		= isset( $form_entries[0]['ip_address'] )		? $form_entries[0]['ip_address']	: '';
$created_date	= isset( $form_entries[0]['created_date'] )		? $form_entries[0]['created_date']	: '';
$popup_type		= isset( $form_entries[0]['popup_type'] )		? $form_entries[0]['popup_type']	: '';
$popup_type		= isset( $popup_types[ $popup_type ] )			? $popup_types[ $popup_type ]		: ucfirst( $popup_type );

// Get content tab data
$content		= get_post_meta( $popup_id, $prefix.'content', true );
$form_fields	= ! empty( $content['form_fields'] ) ? $content['form_fields'] : array();
?>

<div class="wrap paoc-entry-view-wrap">

	<h2>
		<?php echo esc_html__( 'Form Entry', 'popup-anything-on-click' ) . " #{$entry_id}"; ?>
		<a href="<?php echo esc_url( $entries_page_url ); ?>" class="paoc-right button button-primary"><?php esc_html_e('Back Form Entries', 'popup-anything-on-click'); ?></a>
	</h2>
	<br/>

	<table class="wp-list-table widefat fixed striped paoc-tbl">
		<thead>
			<tr>
				<th><strong><?php esc_html_e('Field', 'popup-anything-on-click'); ?></strong></th>
				<th><strong><?php esc_html_e('Value', 'popup-anything-on-click'); ?></strong></th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<th>
					<label><?php esc_html_e('Entry ID', 'popup-anything-on-click'); ?></label>
				</th>
				<td><?php echo esc_attr( $entry_id ); ?></td>
			</tr>

			<tr>
				<th>
					<label><?php esc_html_e('Popup', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<?php
					$popup_name = ( $popup_id )		? get_the_title( $popup_id ) : '';
					$popup_name = ( $popup_name )	? $popup_name : esc_html__('Popup') . " - {$popup_id}";
					?>
					<a href="<?php echo esc_url( get_edit_post_link( $popup_id ) ); ?>"><?php echo esc_html( $popup_name ); ?></a>
				</td>
			</tr>

			<!-- Start - Display Other Form Fields -->
			<?php foreach($form_entries as $entry_key => $entry_data) {

				// Taking some variable
				$field_label	= ! empty( $form_fields[ $entry_data['meta_key'] ]['label'] )	? $form_fields[ $entry_data['meta_key'] ]['label']	: sprintf( __("Field %s", 'popup-anything-on-click'), $entry_data['meta_key'].'<label style="vertical-align:top;" title="'.esc_attr__("Why i am seeing this?\n\n1) May be this field has no label text.\n2) May be this field is removed.", 'popup-anything-on-click').'"> [?]</label>' );
				$field_type		= ! empty( $form_fields[ $entry_data['meta_key'] ]['type'] )	? $form_fields[ $entry_data['meta_key'] ]['type']	: "text";
				$field_value	= ! empty( $entry_data['meta_value'] )							? $entry_data['meta_value']							: '-';

				// If `Math Captcha` field is there then skip it
				if( $field_type == 'math_captcha' ) {
					continue;
				}

				// If `Field Type` checkbox is there
				if( $field_type == 'checkbox' ) {

					$field_value = ( $field_value == 1 ) ? esc_html__('Yes', 'popup-anything-on-click') : esc_html__('No', 'popup-anything-on-click');

				} elseif ( $field_type == 'textarea' ) { // Esle If `Field Type` textarea is there

					$field_value = nl2br( $field_value );
				}
			?>
				<tr>
					<th><?php echo wp_kses_post( $field_label ); ?></th>
					<td><?php echo wp_kses_post( $field_value ); ?></td>
				</tr>
			<?php } ?>
			<!-- End - Display Other Form Fields -->

			<tr>
				<th>
					<label><?php esc_html_e('Ref Page URL', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<?php if( $referral_link ) { ?>
						<a href="<?php echo esc_url( $referral_link ); ?>" target="_blank"><?php echo esc_attr( $referral_link ); ?></a>
					<?php } else {
						echo "&mdash;";
					} ?>
				</td>
			</tr>

			<tr>
				<th>
					<label><?php esc_html_e('IP Address', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<?php if( $ip_address ) { ?>
						<a href="https://ipinfo.io/<?php echo esc_attr( $ip_address ); ?>" target="_blank" rel="noopener noreferrer"><?php echo esc_attr( $ip_address ); ?></a>
					<?php } else {
						echo "&mdash;";
					} ?>
				</td>
			</tr>

			<tr>
				<th>
					<label><?php esc_html_e('Popup Type', 'popup-anything-on-click'); ?></label>
				</th>
				<td><?php echo esc_html( $popup_type ); ?></td>
			</tr>

			<tr>
				<th>
					<label><?php esc_html_e('Submitted Date', 'popup-anything-on-click'); ?></label>
				</th>
				<td><?php echo esc_html( $created_date ); ?></td>
			</tr>
		</tbody>
	</table>
</div><!-- end .paoc-entry-view-wrap -->