<?php
/**
 * Handles Advance Setting metabox HTML
 * 
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// Global variable
global $wp_roles;

// Taking some variable
$user_roles			= $wp_roles->roles;
$role				= isset( $advance['role'] )				? $advance['role']			: array();
$show_for			= isset( $advance['show_for'] )			? $advance['show_for']		: '';
$display_on			= isset( $advance['display_on'] )		? $advance['display_on']	: '';
$cookie_expire		= isset( $advance['cookie_expire'] )	? $advance['cookie_expire']	: '';
$cookie_unit		= ! empty( $advance['cookie_unit'] )	? $advance['cookie_unit']	: 'days';
$adblocker			= ! empty( $advance['adblocker'] )		? $advance['adblocker']		: 0;
$show_credit		= ! empty( $advance['show_credit'] )	? 1 : 0;
$show_credit		= ! isset( $advance['show_credit'] )	? 1	: $show_credit;
$store_no_views		= ! empty( $advance['store_no_views'] )	? 1	: 0;
$store_no_data		= ! empty( $advance['store_no_data'] )	? 1	: 0;
$store_no_views		= ( $campaign_enable && $campaign_id )	? 0 : $store_no_views;

// Schedule Data
$days_arr			= paoc_pro_week_days();
$start_time			= isset( $advance['start_time'] )			? $advance['start_time']		: '';
$end_time			= isset( $advance['end_time'] )				? $advance['end_time']			: '';
$recur_days			= isset( $advance['recur_days'] )			? $advance['recur_days']		: array();
$recur_start_time	= isset( $advance['recur_start_time'] )		? $advance['recur_start_time']	: '';
$recur_end_time		= isset( $advance['recur_end_time'] )		? $advance['recur_end_time']	: '';
$schedule_mode		= ! empty( $advance['schedule_mode'] )		? $advance['schedule_mode']		: 'default';
$recurring_type		= ! empty( $advance['recurring_type'] )		? $advance['recurring_type']	: 'daily';
$recur_week_start	= ! empty( $advance['recur_week_start'] )	? $advance['recur_week_start']	: '1';
$recur_week_end		= ! empty( $advance['recur_week_end'] )		? $advance['recur_week_end']	: '0';
?>

<div id="paoc_advance_sett" class="paoc-vtab-cnt paoc-advance-sett paoc-clearfix">

	<div class="paoc-tab-info-wrap">
		<div class="paoc-tab-title"><?php esc_html_e('Advance Settings', 'popup-anything-on-click'); ?></div>
		<span class="paoc-tab-desc"><?php esc_html_e('Choose Popup advance settings.', 'popup-anything-on-click'); ?></span>
	</div>

	<table class="form-table paoc-tbl">
		<tbody>
			<tr>
				<th>
					<label for="paoc-show-for"><?php esc_html_e('Show For', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<select name="<?php echo esc_attr( $prefix ); ?>advance[show_for]" class="paoc-select paoc-show-hide paoc-show-for" id="paoc-show-for" data-prefix="showfor" />
						<?php if( ! empty( $show_for_data ) ) {
							foreach ( $show_for_data as $show_for_key => $show_for_val ) { ?>
								<option value="<?php echo esc_attr( $show_for_key ); ?>" <?php selected( $show_for, $show_for_key ); ?>><?php echo esc_html( $show_for_val ); ?></option>
							<?php }
						} ?>
					</select><br/>
					<span class="description"><?php esc_html_e('Choose popup visibility for users.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr class="paoc-show-hide-row-showfor paoc-show-if-showfor-member" style="<?php if( $show_for != 'member' ) { echo 'display: none;'; } ?>">
				<th>
					<label for="paoc-user-role"><?php esc_html_e('User Role', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<select name="<?php echo esc_attr( $prefix ); ?>advance[role][]" class="paoc-medium-text paoc-select-mul" multiple="multiple" />
						<?php if( ! empty( $user_roles ) ) {
							foreach ( $user_roles as $user_role_key => $user_role_val ) { ?>
								<option value="<?php echo esc_attr( $user_role_key ); ?>" <?php selected( in_array( $user_role_key, $role ), true ); ?>><?php echo esc_html( $user_role_val['name'] ); ?></option>
							<?php }
						} ?>
					</select><br/>
					<span class="description"><?php esc_html_e('Choose popup visibility for user roles. You can choose multiple user role by pressing CTRL button.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-display-on"><?php esc_html_e('Display On', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<select name="<?php echo esc_attr( $prefix ); ?>advance[display_on]" id="paoc-display-on" class="paoc-select paoc-display-on">
						<?php if( ! empty( $display_on_data ) ) {
							foreach ( $display_on_data as $display_on_key => $display_on_val ) { ?>
								<option value="<?php echo esc_attr( $display_on_key ); ?>" <?php selected( $display_on_key, $display_on ); ?>><?php echo esc_html( $display_on_val ); ?></option>
							<?php }
						} ?>
					</select><br/>
					<span class="description"><?php esc_html_e('Select device on which popup will be display.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-adblocker"><?php esc_html_e('Adblocker Popup', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<select name="<?php echo esc_attr( $prefix ); ?>advance[adblocker]" id="paoc-adblocker" class="paoc-select paoc-adblocker">
						<option value=""><?php esc_html_e('No Detection', 'popup-anything-on-click'); ?></option>
						<option value="1" <?php selected( $adblocker, 1 ); ?>><?php esc_html_e('Normal Detection', 'popup-anything-on-click'); ?></option>
						<option value="2" <?php selected( $adblocker, 2 ); ?>><?php esc_html_e('Advance Detection', 'popup-anything-on-click'); ?></option>
					</select><br/>
					<span class="description"><?php esc_html_e('Enable adblocker popup. Popup will be displaye when browser is blocking ads.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-store-no-views"><?php esc_html_e('Do not Store Impression or Clicks Data', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="checkbox" name="<?php echo esc_attr( $prefix ); ?>advance[store_no_views]" value="1" <?php checked( $store_no_views, 1 ); ?> class="paoc-checkbox paoc-store-no-views" id="paoc-store-no-views" <?php if( $campaign_enable && $campaign_id ) { echo 'disabled="disabled"'; } ?> /><br/>
					<span class="description">
						<?php esc_html_e('Check this box if you do not want to store popup impressions or clicks data in database.', 'popup-anything-on-click'); ?>
						<?php if( $campaign_enable && $campaign_id ) { ?>
							<label style="vertical-align:top;" class="paoc-tooltip" title="<?php esc_attr_e('This feature is unavailable because this popup is set in campaign.', 'popup-anything-on-click'); ?>">[?]</label>
						<?php } ?>
					</span>
				</td>
			</tr>
			<tr class="paoc-show-hide-row-goal paoc-show-if-goal-email-lists" style="<?php if( $popup_goal != 'email-lists' ) { echo 'display: none;'; } ?>">
				<th>
					<label for="paoc-store-no-data"><?php esc_html_e('Do not Store Form Submission Data', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="checkbox" name="<?php echo esc_attr( $prefix ); ?>advance[store_no_data]" value="1" <?php checked( $store_no_data, 1 ); ?> class="paoc-checkbox paoc-store-no-data" id="paoc-store-no-data" /><br/>
					<span class="description"><?php esc_html_e('Check this box if you do not want to store `Collect Lead` popup form submission data in database.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-show-credit"><?php esc_html_e('Show Credit', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="checkbox" name="<?php echo esc_attr( $prefix ); ?>advance[show_credit]" value="1" <?php checked( $show_credit, 1 ); ?> class="paoc-checkbox paoc-show-credit" id="paoc-show-credit" /><br/>
					<span class="description"><?php esc_html_e('Check this box to show credit of our work A huge thanks in advance :)', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-cookie-expire"><?php esc_html_e('Cookie Expiry Time', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>advance[cookie_expire]" value="<?php echo esc_attr( $cookie_expire ); ?>" class="paoc-medium-text paoc-text paoc-cookie-expire" id="paoc-cookie-expire" />
					<select name="<?php echo esc_attr( $prefix ); ?>advance[cookie_unit]" class="paoc-select" style="vertical-align: top;">
						<?php if( ! empty( $popup_time_data ) ) {
							foreach ( $popup_time_data as $popup_time_key => $popup_time_val ) { ?>
								<option value="<?php echo esc_attr( $popup_time_key ); ?>" <?php selected( $cookie_unit, $popup_time_key ); ?>><?php echo esc_html( $popup_time_val ); ?></option>
							<?php }
						} ?>
					</select><br />
					<span class="description"><?php esc_html_e('Enter cookie expiry time after how many days user can see popup again. Some values are.', 'popup-anything-on-click'); ?></span>
					<div class="paoc-code-tag-wrap">
						<code><?php esc_html_e('Each Page Load', 'popup-anything-on-click') ?></code> - <span class="description"><?php esc_html_e('Leave it blank to display popup on each page load.', 'popup-anything-on-click') ?></span><br/>
						<code><?php esc_html_e('Once Per Session', 'popup-anything-on-click') ?></code> - <span class="description"><?php esc_html_e('Enter 0 to display popup once per browser session.', 'popup-anything-on-click') ?></span><br/>
						<code><?php esc_html_e('After X times', 'popup-anything-on-click') ?></code> - <span class="description"><?php esc_html_e('Enter cookie expiry time after how many times user can see popup again.', 'popup-anything-on-click') ?></span>
					</div>
				</td>
			</tr>

			<tr>
				<th colspan="3">
					<div class="paoc-sub-sett-title"><i class="dashicons dashicons-admin-generic"></i> <?php esc_html_e('Popup Schedule Settings', 'popup-anything-on-click'); ?></div>
				</th>
			</tr>

			<tr>
				<th>
					<label for="paoc-schedule-start"><?php esc_html_e('Popup Start Date & Time', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>advance[start_time]" value="<?php echo esc_attr( $start_time ); ?>" class="paoc-medium-text paoc-datetime paoc-schedule-start" id="paoc-schedule-start" /><br/>
					<span class="description"><?php esc_html_e('Set popup start time.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-schedule-end"><?php esc_html_e('Popup End Date & Time', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>advance[end_time]" value="<?php echo esc_attr( $end_time ); ?>" class="paoc-medium-text paoc-datetime paoc-schedule-end" id="paoc-schedule-end" /><br/>
					<span class="description"><?php esc_html_e('Set popup end time.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-schedule-mode"><?php esc_html_e('Schedule Mode', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<select name="<?php echo esc_attr( $prefix ); ?>advance[schedule_mode]" class="paoc-select paoc-show-hide paoc-schedule-mode" id="paoc-schedule-mode" data-prefix="schedule">
						<option value="default" <?php selected( $schedule_mode, 'default' ); ?>><?php esc_html_e('Default', 'popup-anything-on-click'); ?></option>
						<option value="recurring" <?php selected( $schedule_mode, 'recurring' ); ?>><?php esc_html_e('Recurring Popup', 'popup-anything-on-click'); ?></option>
					</select><br/>
					<span class="description"><?php esc_html_e('Select schedule mode.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<!-- Start - Recurring Popup Schedule Settings -->
			<tr class="paoc-show-hide-row-schedule paoc-show-if-schedule-recurring" style="<?php if( $schedule_mode != 'recurring' ) { echo 'display: none;'; } ?>">
				<td colspan="2" class="paoc-no-padding">
					<table class="form-table paoc-tbl">
						<tr>
							<th>
								<label for="paoc-recurring-type"><?php esc_html_e('Recurring Type', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<select name="<?php echo esc_attr( $prefix ); ?>advance[recurring_type]" id="paoc-recurring-type" class="paoc-select paoc-recurring-type paoc-show-hide" data-prefix="rtype">
									<option value="daily" <?php selected( $recurring_type, 'daily' ); ?>><?php esc_html_e('Daily', 'popup-anything-on-click'); ?></option>
									<option value="weekly" <?php selected( $recurring_type, 'weekly' ); ?>><?php esc_html_e('Weekly', 'popup-anything-on-click'); ?></option>
									<option value="custom" <?php selected( $recurring_type, 'custom' ); ?>><?php esc_html_e('Custom', 'popup-anything-on-click'); ?></option>
								</select><br/>
								<span class="description"><?php esc_html_e('Select recurring type for popup.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr class="paoc-show-hide-row-rtype paoc-show-if-rtype-weekly" style="<?php if( $recurring_type != 'weekly' ) { echo 'display: none;'; } ?>">
							<th>
								<label for="paoc-week-start"><?php esc_html_e('Week Start On', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<select name="<?php echo esc_attr( $prefix ); ?>advance[recur_week_start]" id="paoc-week-start" class="paoc-select paoc-week-start">
									<?php foreach ($days_arr as $day_key => $day_val) { ?>
										<option value="<?php echo esc_attr( $day_key ); ?>" <?php selected( $recur_week_start, $day_key ); ?>><?php echo esc_html( $day_val ); ?></option>
									<?php } ?>
								</select><br/>
								<span class="description"><?php esc_html_e('Select week start day for popup.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr class="paoc-show-hide-row-rtype paoc-show-if-rtype-weekly" style="<?php if( $recurring_type != 'weekly' ) { echo 'display: none;'; } ?>">
							<th>
								<label for="paoc-week-end"><?php esc_html_e('Week End On', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<select name="<?php echo esc_attr( $prefix ); ?>advance[recur_week_end]" id="paoc-week-end" class="paoc-select paoc-week-end">
									<?php foreach ($days_arr as $day_key => $day_val) { ?>
										<option value="<?php echo esc_attr( $day_key ); ?>" <?php selected( $recur_week_end, $day_key ); ?>><?php echo esc_html( $day_val ); ?></option>
									<?php } ?>
								</select><br/>
								<span class="description"><?php esc_html_e('Select week end day for popup.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr class="paoc-show-hide-row-rtype paoc-show-if-rtype-custom paoc-hide" style="<?php if( $recurring_type == 'custom' ) { echo 'display: table-row;'; } ?>">
							<th>
								<label for="paoc-recurring-on"><?php esc_html_e('Recurring Days', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<select name="<?php echo esc_attr( $prefix ); ?>advance[recur_days][]" id="paoc-recurring-on" class="paoc-select paoc-recurring-on" multiple="multiple">
									<?php foreach ($days_arr as $day_key => $day_val) { ?>
										<option value="<?php echo esc_attr( $day_key ); ?>" <?php echo in_array($day_key, $recur_days) ? 'selected' : ''; ?>><?php echo esc_html( $day_val ); ?></option>
									<?php } ?>
								</select><br/>
								<span class="description"><?php esc_html_e('Select recurring days. Hold Ctrl key to select multiple days at a time.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr>
							<th>
								<label for="paoc-recur-start-time"><?php esc_html_e('Start Time', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>advance[recur_start_time]" value="<?php echo esc_attr( $recur_start_time ); ?>" id="paoc-recur-start-time" class="paoc-text paoc-time paoc-recur-start-time" /><br/>
								<span class="description"><?php esc_html_e('Choose recurring popup start time.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr>
							<th>
								<label for="paoc-recur-end-time"><?php esc_html_e('End Time', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>advance[recur_end_time]" value="<?php echo esc_attr( $recur_end_time ); ?>" id="paoc-recur-end-time" class="paoc-text paoc-time paoc-recur-end-time" /><br/>
								<span class="description"><?php esc_html_e('Choose recurring popup end time.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<!-- End - Recurring Popup Schedule Settings -->
		</tbody>
	</table>
</div><!-- end .paoc-advance-sett -->