<?php
/**
 * Handles Google Analytic Setting metabox HTML
 * 
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// Taking some variable
$enable		= ! empty( $analytics['enable'] )	? 1							: 0;
$action		= ! empty( $analytics['action'] )	? $analytics['action']		: 'Popup-Click';
$category	= ! empty( $analytics['category'] )	? $analytics['category']	: 'Popup-Open';
$label		= ! empty( $analytics['label'] )	? $analytics['label']		: 'Popup';
?>
<div id="paoc_analytics_sett" class="paoc-vtab-cnt paoc-analytics-sett paoc-clearfix">

	<div class="paoc-tab-info-wrap">
		<div class="paoc-tab-title"><?php esc_html_e('Google Analytics Settings', 'popup-anything-on-click'); ?></div>
		<span class="paoc-tab-desc"><?php esc_html_e('Choose Popup google analytics settings.', 'popup-anything-on-click'); ?></span>
	</div>

	<table class="form-table paoc-tbl">
		<tbody>
			<tr>
				<th>
					<label for="paoc-analytics-enable"><?php esc_html_e('Enable', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="checkbox" name="<?php echo esc_attr( $prefix ); ?>analytics[enable]" value="1" <?php checked( $enable, 1 ); ?> class="paoc-checkbox paoc-analytics-enable" id="paoc-analytics-enable" /><br />
					<span class="description"><?php esc_html_e('Check this box to enable google analytic event for popup.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<tr>
				<th>
					<label for="paoc-analytics-action"><?php esc_html_e('Action', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>analytics[action]" value="<?php echo esc_attr( $action ); ?>" id="paoc-analytics-action" class="paoc-text large-text paoc-analytics-action" /><br/>
					<span class="description"><?php esc_html_e('Enter google analytic event action.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<tr>
				<th>
					<label for="paoc-analytics-category"><?php esc_html_e('Category', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>analytics[category]" value="<?php echo esc_attr( $category ); ?>" id="paoc-analytics-category" class="paoc-text large-text paoc-analytics-category" /><br/>
					<span class="description"><?php esc_html_e('Enter google analytic event category.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<tr>
				<th>
					<label for="paoc-analytics-label"><?php esc_html_e('Label', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>analytics[label]" value="<?php echo esc_attr( $label ); ?>" id="paoc-analytics-label" class="paoc-text large-text paoc-analytics-label" /><br/>
					<span class="description"><?php esc_html_e('Enter google analytic event label.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
		</tbody>
	</table>
</div><!-- end .paoc-analytics-sett -->