<?php
/**
 * Handles Campaign Setting metabox HTML
 * 
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// Taking some variable
$campaign_url	= add_query_arg( array( 'post_type' => PAOC_PRO_POST_TYPE, 'page' => 'paoc-campaign', 'action' => 'edit', 'campaign_id' => $campaign_id ), admin_url('edit.php') );
$campaign_list	= add_query_arg( array( 'post_type' => PAOC_PRO_POST_TYPE, 'page' => 'paoc-campaign' ), admin_url('edit.php') );
$campaign_title	= ! empty( $campaign_data->title ) ? $campaign_data->title : '';
?>

<div id="paoc_campaign_sett" class="paoc-vtab-cnt paoc-campaign-sett paoc-clearfix">

	<div class="paoc-tab-info-wrap">
		<div class="paoc-tab-title"><?php esc_html_e('A/B Testing Settings', 'popup-anything-on-click'); ?></div>
		<span class="paoc-tab-desc"><?php esc_html_e('Check popup A/B testing campaign settings.', 'popup-anything-on-click'); ?></span>
	</div>

	<table class="form-table paoc-tbl">
		<tbody>
			<tr>
				<td colspan="2" class="paoc-no-lr-padding">
					<?php if( $campaign_id ) { ?>

						<div class="paoc-info">
							<?php if ( current_user_can( 'manage_options' ) ) { ?>
								<a href="<?php echo esc_url( $campaign_url ); ?>" target="_blank"><?php echo esc_html( $campaign_title ); ?></a> 
							<?php } else {
								echo esc_html( $campaign_title ) . "&nbsp;";
							}

							esc_html_e('A/B testing is set for this popup.', 'popup-anything-on-click');

							if( ! $campaign_enable ) { ?>
								<span style="color:#F00000;"><?php esc_html_e('Campaign is not enabled yet.', 'popup-anything-on-click'); ?></span>
							<?php } ?>
						</div>

					<?php } else { ?>
						<div class="paoc-notice">
							<?php esc_html_e('Campaign is not set for this popup.', 'popup-anything-on-click'); ?>
							
							<?php if ( current_user_can( 'manage_options' ) ) { ?>
							<?php esc_html_e('Please configure it from', 'popup-anything-on-click'); ?> <a href="<?php echo esc_url( $campaign_list ); ?>" target="_blank"><?php esc_html_e('here', 'popup-anything-on-click'); ?></a>.
							<?php } ?>
						</div>
					<?php } ?>
				</td>
			</tr>
		</tbody>
	</table>
</div>