<?php
/**
 * Handles Content Setting metabox HTML
 * 
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// Taking some variables
$content			= paoc_pro_get_meta( $post->ID, $prefix.'content' );
$popup_content		= ( $post->post_content != '' )				? $post->post_content				: $default_meta['content'];
$main_heading		= isset( $content['main_heading'] )			? $content['main_heading']			: '';
$sub_heading		= isset( $content['sub_heading'] )			? $content['sub_heading']			: '';
$secondary_content	= isset( $content['secondary_content'] )	? $content['secondary_content']		: '';
$cust_close_txt		= isset( $content['cust_close_txt'] )		? $content['cust_close_txt']		: '';
$security_note		= isset( $content['security_note'] )		? $content['security_note']			: '';
$thanks_msg			= isset( $content['thanks_msg'] )			? $content['thanks_msg']			: '';
$slide_in_text		= ! empty( $content['slide_in_text'] )		? $content['slide_in_text']			: esc_html__('Click Here', 'popup-anything-on-click');
$submit_btn_txt		= ! empty( $content['submit_btn_txt'] )		? $content['submit_btn_txt']		: esc_html__('Submit', 'popup-anything-on-click');

// Target URL settings data
$btn1_text		= isset( $content['target_url']['btn1_text'] )		? $content['target_url']['btn1_text']	: '';
$btn1_link		= isset( $content['target_url']['btn1_link'] )		? $content['target_url']['btn1_link']	: '';
$btn1_target	= isset( $content['target_url']['btn1_target'] )	? $content['target_url']['btn1_target']	: '';
$btn2_text		= isset( $content['target_url']['btn2_text'] )		? $content['target_url']['btn2_text']	: '';
$btn2_link		= isset( $content['target_url']['btn2_link'] )		? $content['target_url']['btn2_link']	: '';
$btn2_target	= isset( $content['target_url']['btn2_target'] )	? $content['target_url']['btn2_target']	: '';

// Phone Calls settings data
$btn_txt	= isset( $content['phone_calls']['btn_txt'] )	? $content['phone_calls']['btn_txt']	: '';
$phone_num	= isset( $content['phone_calls']['phone_num'] )	? $content['phone_calls']['phone_num']	: '';
?>

<div id="paoc_content_sett" class="paoc-vtab-cnt paoc-content-sett paoc-clearfix">

	<div class="paoc-tab-info-wrap">
		<div class="paoc-tab-title"><?php esc_html_e('Content Settings', 'popup-anything-on-click'); ?></div>
		<span class="paoc-tab-desc"><?php esc_html_e('Choose Popup content settings.', 'popup-anything-on-click'); ?></span>
	</div>

	<table class="form-table paoc-tbl">
		<tbody>
			<tr>
				<th>
					<label for="paoc-main-heading"><?php esc_html_e('Main Heading', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>content[main_heading]" value="<?php echo esc_attr( $main_heading ); ?>" class="large-text paoc-text paoc-main-heading" id="paoc-main-heading" />
					<span class="description"><?php esc_html_e('Enter popup main heading text.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<tr>
				<th>
					<label for="paoc-sub-heading"><?php esc_html_e('Sub Heading', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>content[sub_heading]" value="<?php echo esc_attr( $sub_heading ); ?>" class="large-text paoc-text paoc-sub-heading" id="paoc-sub-heading" />
					<span class="description"><?php esc_html_e('Enter popup sub heading text.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<tr>
				<th>
					<label for="paoc-popup-content"><?php esc_html_e('Primary Content', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<?php wp_editor( $popup_content, 'paoc-popup-content', array('textarea_name' => 'content', 'editor_height' => 300, 'media_buttons' => true) ); ?>
					<span class="description"><?php echo sprintf( esc_html__('Enter popup content which will display after respective `Call to Action` like email form etc. Available template tags are %s.', 'popup-anything-on-click'), '<a href="javascript:void(0)" class="paoc-open-popup" title="'.esc_attr__('Popup Tags', 'popup-anything-on-click').'" data-id="general_tags">'.esc_html__('here', 'popup-anything-on-click').'</a>' ); ?></span>
				</td>
			</tr>

			<tr>
				<th>
					<label for="paoc-secondary-con"><?php esc_html_e('Secondary Content', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<?php wp_editor( $secondary_content, 'paoc-secondary-con', array('textarea_name' => $prefix.'content[secondary_content]', 'editor_height' => 300, 'media_buttons' => true) ); ?>
					<span class="description"><?php echo sprintf( esc_html__('Enter popup secondary content which will display after respective `Call to Action` like email form etc. Available template tags are %s.', 'popup-anything-on-click'), '<a href="javascript:void(0)" class="paoc-open-popup" title="'.esc_attr__('Popup Tags', 'popup-anything-on-click').'" data-id="general_tags">'.esc_html__('here', 'popup-anything-on-click').'</a>' ); ?></span>
				</td>
			</tr>

			<tr>
				<th>
					<label for="paoc-cus-close-txt"><?php esc_html_e('Custom Close Text', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>content[cust_close_txt]" value="<?php echo esc_attr( $cust_close_txt ); ?>" class="large-text paoc-text paoc-cus-close-txt" id="paoc-cus-close-txt" />
					<span class="description"><?php esc_html_e('Enter custom close text. e.g No, thank you. I do not want.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<tr>
				<th>
					<label for="paoc-secur-note"><?php esc_html_e('Security Note', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>content[security_note]" value="<?php echo esc_attr( $security_note ); ?>" class="large-text paoc-text paoc-secur-note" id="paoc-secur-note" />
					<span class="description"><?php esc_html_e('Enter security note text.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<!-- Start - Slide In Popup Settings -->
			<tr class="paoc-show-hide-row-type paoc-show-if-type-slide-in" style="<?php if( $display_type != 'slide-in' ) { echo 'display: none;'; } ?>">
				<td colspan="2" class="paoc-no-padding">
					<table class="form-table">
						<tbody>
							<tr>
								<th colspan="2">
									<div class="paoc-sub-sett-title"><i class="dashicons dashicons-admin-generic"></i> <?php esc_html_e('Slide In Settings', 'popup-anything-on-click'); ?></div>
								</th>
							</tr>

							<tr>
								<th>
									<label for="paoc-slide-in-text"><?php esc_html_e('Slide In Text', 'popup-anything-on-click'); ?></label>
								</th>
								<td>
									<input type="text" name="<?php echo esc_attr( $prefix ); ?>content[slide_in_text]" value="<?php echo esc_attr( $slide_in_text ); ?>" class="paoc-text large-text paoc-slide-in-text" id="paoc-slide-in-text" /><br/>
									<span class="description"><?php esc_html_e('Enter slide in text. Also you can use HTML tag. e.g. <i class="fa fa-envelope"></i>', 'popup-anything-on-click'); ?></span>
								</td>
							</tr>
						</tbody>
					</table>
				</td>
			</tr>
			<!-- End - Slide In Popup Settings -->

			<!-- Start - Collect Lead Settings -->
			<tr class="paoc-show-hide-row-goal paoc-show-if-goal-email-lists" style="<?php if( $popup_goal != 'email-lists' ) { echo 'display: none;'; } ?>">
				<td colspan="2" class="paoc-no-padding">
					<table class="form-table">
						<tbody>
							<tr>
								<th colspan="2">
									<div class="paoc-sub-sett-title"><i class="dashicons dashicons-admin-generic"></i> <?php esc_html_e('Collect Lead Settings', 'popup-anything-on-click'); ?></div>
								</th>
							</tr>
							<tr>
								<th>
									<label for="paoc-field-btn"><?php esc_html_e('Button Text', 'popup-anything-on-click'); ?></label>
								</th>
								<td>
									<input type="text" name="<?php echo esc_attr( $prefix ); ?>content[submit_btn_txt]" value="<?php echo esc_attr( $submit_btn_txt ); ?>" class="paoc-text large-text paoc-field-btn" id="paoc-field-btn">
									<span class="description"><?php esc_html_e('Enter form submit button text.', 'popup-anything-on-click'); ?></span>
								</td>
							</tr>
							<tr>
								<th>
									<label for="paoc-thanks-msg"><?php esc_html_e('Thank You Message', 'popup-anything-on-click'); ?></label>
								</th>
								<td>
									<?php wp_editor( $thanks_msg, 'paoc-thanks-msg', array('textarea_name' => $prefix.'content[thanks_msg]', 'textarea_rows' => 6, 'media_buttons' => true) ); ?>
									<span class="description"><?php echo sprintf( esc_html__('Enter thank you message once the form is submitted. Available template tags are %s.', 'popup-anything-on-click'), '<a href="javascript:void(0)" class="paoc-open-popup" title="'.esc_html__('Popup Tags', 'popup-anything-on-click').'" data-id="form_fields_tags">'.esc_html__('here', 'popup-anything-on-click').'</a>' ); ?></span>
								</td>
							</tr>
						</tbody>
					</table>
				</td>
			</tr>
			<!-- End - Collect Lead Settings -->

			<!-- Start - Target URL Settings -->
			<tr class="paoc-show-hide-row-goal paoc-show-if-goal-target-url" style="<?php if( $popup_goal != 'target-url' ) { echo 'display: none;'; } ?>">
				<td colspan="2" class="paoc-no-padding">
					<table class="form-table">
						<tbody>
							<tr>
								<th colspan="2">
									<div class="paoc-sub-sett-title"><i class="dashicons dashicons-admin-generic"></i> <?php esc_html_e('Target URL Settings', 'popup-anything-on-click'); ?></div>
								</th>
							</tr>
							<tr>
								<th>
									<label for="paoc-url-btn1-txt"><?php esc_html_e('Button 1 Text', 'popup-anything-on-click'); ?></label>
								</th>
								<td>
									<input type="text" name="<?php echo esc_attr( $prefix ); ?>content[target_url][btn1_text]" value="<?php echo esc_attr( $btn1_text ); ?>" class="paoc-medium-text paoc-text paoc-url-btn1-txt" id="paoc-url-btn1-txt" /><br/>
									<span class="description"><?php esc_html_e('Enter button 1 text.', 'popup-anything-on-click'); ?></span>
								</td>
							</tr>
							<tr>
								<th>
									<label for="paoc-url-btn1-link"><?php esc_html_e('Button 1 Link', 'popup-anything-on-click'); ?></label>
								</th>
								<td>
									<input type="text" name="<?php echo esc_attr( $prefix ); ?>content[target_url][btn1_link]" value="<?php echo esc_url( $btn1_link ); ?>" class="paoc-medium-text paoc-text paoc-url-btn1-link" id="paoc-url-btn1-link" /><br/>
									<span class="description"><?php esc_html_e('Enter button 1 link.', 'popup-anything-on-click'); ?></span>
								</td>
							</tr>
							<tr>
								<th>
									<label for="paoc-url-btn1-target"><?php esc_html_e('Button 1 Link Target', 'popup-anything-on-click'); ?></label>
								</th>
								<td>
									<select name="<?php echo esc_attr( $prefix ); ?>content[target_url][btn1_target]" class="paoc-select paoc-url-btn1-target" id="paoc-url-btn1-target">
										<option value="_self" <?php selected( $btn1_target, '_self' ); ?>><?php esc_html_e('Same Tab', 'popup-anything-on-click'); ?></option>
										<option value="_blank" <?php selected( $btn1_target, '_blank' ); ?>><?php esc_html_e('New Tab', 'popup-anything-on-click'); ?></option>
									</select><br/>
									<span class="description"><?php esc_html_e('Select button 1 link target.', 'popup-anything-on-click'); ?></span>
								</td>
							</tr>

							<tr>
								<th>
									<label for="paoc-url-btn2-txt"><?php esc_html_e('Button 2 Text', 'popup-anything-on-click'); ?></label>
								</th>
								<td>
									<input type="text" name="<?php echo esc_attr( $prefix ); ?>content[target_url][btn2_text]" value="<?php echo esc_attr( $btn2_text ); ?>" class="paoc-medium-text paoc-text paoc-url-btn2-txt" id="paoc-url-btn2-txt" /><br/>
									<span class="description"><?php esc_html_e('Enter button 2 text.', 'popup-anything-on-click'); ?></span>
								</td>
							</tr>
							<tr>
								<th>
									<label for="paoc-url-btn2-link"><?php esc_html_e('Button 2 Link', 'popup-anything-on-click'); ?></label>
								</th>
								<td>
									<input type="text" name="<?php echo esc_attr( $prefix ); ?>content[target_url][btn2_link]" value="<?php echo esc_url( $btn2_link ); ?>" class="paoc-medium-text paoc-text paoc-url-btn2-link" id="paoc-url-btn2-link" /><br/>
									<span class="description"><?php esc_html_e('Enter button 2 link. Leave it blank to close the popup on click.', 'popup-anything-on-click'); ?></span>
								</td>
							</tr>
							<tr>
								<th>
									<label for="paoc-url-btn2-target"><?php esc_html_e('Button 2 Link Target', 'popup-anything-on-click'); ?></label>
								</th>
								<td>
									<select name="<?php echo esc_attr( $prefix ); ?>content[target_url][btn2_target]" class="paoc-select paoc-url-btn2-target" id="paoc-url-btn2-target">
										<option value="_self" <?php selected( $btn2_target, '_self' ); ?>><?php esc_html_e('Same Tab', 'popup-anything-on-click'); ?></option>
										<option value="_blank" <?php selected( $btn2_target, '_blank' ); ?>><?php esc_html_e('New Tab', 'popup-anything-on-click'); ?></option>
									</select><br/>
									<span class="description"><?php esc_html_e('Select button 2 link target.', 'popup-anything-on-click'); ?></span>
								</td>
							</tr>
						</tbody>
					</table>
				</td>
			</tr>
			<!-- End - Target URL Settings -->

			<!-- Start - Phone Calls Settings -->
			<tr class="paoc-show-hide-row-goal paoc-show-if-goal-phone-calls" style="<?php if( $popup_goal != 'phone-calls' ) { echo 'display: none;'; } ?>">
				<td colspan="2" class="paoc-no-padding">
					<table class="form-table">
						<tbody>
							<tr>
								<th colspan="2">
									<div class="paoc-sub-sett-title"><i class="dashicons dashicons-admin-generic"></i> <?php esc_html_e('Phone Calls Settings', 'popup-anything-on-click'); ?></div>
								</th>
							</tr>
							<tr>
								<th>
									<label for="paoc-call-btn-txt"><?php esc_html_e('Button Text', 'popup-anything-on-click'); ?></label>
								</th>
								<td>
									<input type="text" name="<?php echo esc_attr( $prefix ); ?>content[phone_calls][btn_txt]" value="<?php echo esc_attr( $btn_txt ); ?>" class="paoc-medium-text paoc-text paoc-call-btn-txt" id="paoc-call-btn-txt" /><br/>
									<span class="description"><?php esc_html_e('Enter Button Text.', 'popup-anything-on-click'); ?></span>
								</td>
							</tr>
							<tr>
								<th>
									<label for="paoc-call-number"><?php esc_html_e('Phone Number', 'popup-anything-on-click'); ?></label>
								</th>
								<td>
									<input type="text" name="<?php echo esc_attr( $prefix ); ?>content[phone_calls][phone_num]" value="<?php echo esc_attr( $phone_num ); ?>" class="paoc-medium-text paoc-text paoc-call-number" id="paoc-call-number" /><br/>
									<span class="description"><?php esc_html_e('Enter Phone nmumber. e.g. 447911123456 Note : Please do not include plus (+) sign.', 'popup-anything-on-click'); ?></span>
								</td>
							</tr>
						</tbody>
					</table>
				</td>				
			</tr>
			<!-- End - Phone Calls Settings -->
		</tbody>
	</table>
</div><!-- end .paoc-content-sett -->