<?php
/**
 * Handles Cookie Popup Setting metabox HTML
 * 
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// Taking some variable
$cookie_params	= ! empty( $advance['cookie_params'] )	? $advance['cookie_params']	: '';
$cookie_enable	= ! empty( $advance['cookie_enable'] )	? 1 : 0;
?>

<div id="paoc_cookie_sett" class="paoc-vtab-cnt paoc-cookie-sett paoc-clearfix">

	<div class="paoc-tab-info-wrap">
		<div class="paoc-tab-title"><?php esc_html_e('Cookie Popup Settings', 'popup-anything-on-click'); ?></div>
		<span class="paoc-tab-desc"><?php esc_html_e('Choose cookie popup settings.', 'popup-anything-on-click'); ?></span>
	</div>

	<table class="form-table paoc-tbl">
		<tbody>
			<tr>
				<th>
					<label for="paoc-cookie-enable"><?php esc_html_e('Enable', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="checkbox" name="<?php echo esc_attr( $prefix ); ?>advance[cookie_enable]" value="1" <?php checked( $cookie_enable, 1 ); ?> class="paoc-checkbox paoc-cookie-enable" id="paoc-cookie-enable" /><br/>
					<span class="description"><?php esc_html_e('Check this box if you want to enable cookie based popup.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<tr>
				<th>
					<label for="paoc-cookie-params"><?php esc_html_e('Cookie Params', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<textarea id="paoc-cookie-params" name="<?php echo esc_attr( $prefix ); ?>advance[cookie_params]" class="large-text paoc-textarea paoc-cookie-params"><?php echo esc_textarea( $cookie_params ); ?></textarea>
					<span class="description"><?php esc_html_e('Enter one cookie params fragment per line. Popup will be displayed if visitor browser have cookie set. Example: cookie_key | cookie_value. You can enter only cookie key also.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
		</tbody>
	</table>
</div><!-- End .paoc-cookie-sett -->