<?php
/**
 * Handles Design Setting metabox HTML
 * 
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// Taking some function data
$bar_design_data		= paoc_pro_bar_popup_designs();
$design_data			= paoc_pro_popup_designs();
$effect_data			= paoc_pro_popup_effects();
$mn_position_data		= paoc_pro_mn_position_options();
$bar_position_data		= paoc_pro_bar_position_options();

// Take some variables
$design					= paoc_pro_get_meta( $post->ID, $prefix.'design' );
$template				= isset( $design['template'] )				? $design['template']				: '';
$bar_template			= ! empty( $design['bar_template'] )		? $design['bar_template']			: $template;
$fullscreen_popup		= ! empty( $design['fullscreen_popup'] )	? 1									: 0;
$speed_in				= ! empty( $design['speed_in'] )			? $design['speed_in']				: 0.5;
$speed_out				= ! empty( $design['speed_out'] )			? $design['speed_out']				: 0.25;
$height					= isset( $design['height'] )				? $design['height']					: '';
$width					= isset( $design['width'] )					? $design['width']					: '';
$effect					= isset( $design['effect'] )				? $design['effect']					: 'fadein';
$mn_position			= isset( $design['mn_position'] )			? $design['mn_position']			: 'center-center';
$bar_position			= isset( $design['bar_position'] )			? $design['bar_position']			: 'top';
$loader_color			= isset( $design['loader_color'] )			? $design['loader_color']			: '';
$overlay_img			= isset( $design['overlay_img'] )			? $design['overlay_img']			: '';
$overlay_color			= isset( $design['overlay_color'] )			? $design['overlay_color']			: '';
$overlay_opacity		= isset( $design['overlay_opacity'] )		? $design['overlay_opacity']		: '';
$popup_img				= isset( $design['popup_img'] )				? $design['popup_img']				: '';
$bg_color				= isset( $design['bg_color'] )				? $design['bg_color']				: '';
$mheading_fontsize		= isset( $design['mheading_fontsize'] )		? $design['mheading_fontsize']		: '';
$mheading_txtcolor		= isset( $design['mheading_txtcolor'] )		? $design['mheading_txtcolor']		: '';
$sheading_fontsize		= isset( $design['sheading_fontsize'] )		? $design['sheading_fontsize']		: '';
$sheading_txtcolor		= isset( $design['sheading_txtcolor'] )		? $design['sheading_txtcolor']		: '';
$content_color			= isset( $design['content_color'] )			? $design['content_color']			: '';
$secondary_cnt_clr		= isset( $design['secondary_cnt_clr'] )		? $design['secondary_cnt_clr']		: '';
$custom_close_txtclr	= isset( $design['custom_close_txtclr'] )	? $design['custom_close_txtclr']	: '';
$snote_txtcolor			= isset( $design['snote_txtcolor'] )		? $design['snote_txtcolor']			: '';

// Collect Lead settings data
$form_field_lbl_clr		= isset( $design['email_lists']['field_lbl_clr'] )	? $design['email_lists']['field_lbl_clr']	: '';
$form_field_bg_clr		= isset( $design['email_lists']['field_bg_clr'] )	? $design['email_lists']['field_bg_clr']	: '';
$form_field_txt_clr		= isset( $design['email_lists']['field_txt_clr'] )	? $design['email_lists']['field_txt_clr']	: '';
$form_btn_bg_clr		= isset( $design['email_lists']['btn_bg_clr'] )		? $design['email_lists']['btn_bg_clr']		: '';
$form_btn_hbg_clr		= isset( $design['email_lists']['btn_hbg_clr'] )	? $design['email_lists']['btn_hbg_clr']		: '';
$form_btn_txt_clr		= isset( $design['email_lists']['btn_txt_clr'] )	? $design['email_lists']['btn_txt_clr']		: '';
$form_btn_htxt_clr		= isset( $design['email_lists']['btn_htxt_clr'] )	? $design['email_lists']['btn_htxt_clr']	: '';

// Target URL settings data
$btn1_bg_clr			= isset( $design['target_url']['btn1_bg_clr'] )		? $design['target_url']['btn1_bg_clr']		: '';
$btn1_hbg_clr			= isset( $design['target_url']['btn1_hbg_clr'] )	? $design['target_url']['btn1_hbg_clr']		: '';
$btn1_txt_clr			= isset( $design['target_url']['btn1_txt_clr'] )	? $design['target_url']['btn1_txt_clr']		: '';
$btn1_htxt_clr			= isset( $design['target_url']['btn1_htxt_clr'] )	? $design['target_url']['btn1_htxt_clr']	: '';
$btn2_bg_clr			= isset( $design['target_url']['btn2_bg_clr'] )		? $design['target_url']['btn2_bg_clr']		: '';
$btn2_hbg_clr			= isset( $design['target_url']['btn2_hbg_clr'] )	? $design['target_url']['btn2_hbg_clr']		: '';
$btn2_txt_clr			= isset( $design['target_url']['btn2_txt_clr'] )	? $design['target_url']['btn2_txt_clr']		: '';
$btn2_htxt_clr			= isset( $design['target_url']['btn2_htxt_clr'] )	? $design['target_url']['btn2_htxt_clr']	: '';

// Phone Calls settings data
$call_btn_bg_clr		= isset( $design['phone_calls']['btn_bg_clr'] )		? $design['phone_calls']['btn_bg_clr']		: '';
$call_btn_hbg_clr		= isset( $design['phone_calls']['btn_hbg_clr'] )	? $design['phone_calls']['btn_hbg_clr']		: '';
$call_btn_txt_clr		= isset( $design['phone_calls']['btn_txt_clr'] )	? $design['phone_calls']['btn_txt_clr']		: '';
$call_btn_htxt_clr		= isset( $design['phone_calls']['btn_htxt_clr'] )	? $design['phone_calls']['btn_htxt_clr']	: '';
?>

<div id="paoc_design_sett" class="paoc-vtab-cnt paoc-design-sett paoc-clearfix">

	<div class="paoc-tab-info-wrap">
		<div class="paoc-tab-title"><?php esc_html_e('Design Settings', 'popup-anything-on-click'); ?></div>
		<span class="paoc-tab-desc"><?php esc_html_e('Set various popup design settings.', 'popup-anything-on-click'); ?></span>
	</div>

	<table class="form-table paoc-tbl">
		<tbody>
			<tr class="paoc-show-hide-row-type paoc-show-if-type-bar" style="<?php if( $display_type != 'bar' ) { echo 'display: none;'; } ?>">
				<th>
					<label for="paoc-design-bar-temp"><?php esc_html_e('Template', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<select name="<?php echo esc_attr( $prefix ); ?>design[bar_template]" class="paoc-select paoc-design-bar-temp" id="paoc-design-bar-temp">
						<?php foreach ( $bar_design_data as $bar_design_key => $bar_design_val ) { ?>
							<option value="<?php echo esc_attr( $bar_design_key ); ?>" <?php selected( $bar_template, $bar_design_key ); ?>><?php echo esc_html( $bar_design_val ); ?></option>
						<?php } ?>
					</select>
					<br />
					<span class="description"><?php esc_html_e('Select bar popup template.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<tr class="paoc-show-hide-row-type paoc-show-if-type-modal paoc-show-if-type-push-notification paoc-show-if-type-slide-in" style="<?php if( $display_type == 'bar' ) { echo 'display: none;'; } ?>">
				<th>
					<label for="paoc-design-mps-temp"><?php esc_html_e('Template', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<select name="<?php echo esc_attr( $prefix ); ?>design[template]" class="paoc-select paoc-design-mps-temp" id="paoc-design-mps-temp">
						<?php foreach ( $design_data as $design_key => $design_val ) { ?>
							<option value="<?php echo esc_attr( $design_key ); ?>" <?php selected( $template, $design_key ); ?>><?php echo esc_html( $design_val ); ?></option>
						<?php } ?>
					</select>
					<br />
					<span class="description"><?php esc_html_e('Select Modal, Push Notification, SlideIn popup template.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<tr>
				<th>
					<label for="paoc-fullscreen"><?php esc_html_e('Full Screen Popup', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="checkbox" name="<?php echo esc_attr( $prefix ); ?>design[fullscreen_popup]" value="1" <?php checked( $fullscreen_popup, 1 ); ?> class="paoc-checkbox paoc-show-hide paoc-fullscreen" id="paoc-fullscreen" data-label="screen" data-prefix="full" /><br />
					<span class="description"><?php esc_html_e('Check this box if you want to display full screen popup.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<tr class="paoc-show-hide-row-full paoc-hide-if-full-screen" style="<?php if( $fullscreen_popup == '1' ) { echo 'display: none;'; } ?>">
				<td class="paoc-no-padding" colspan="2">
					<table class="form-table paoc-tbl">
						<tr>
							<th>
								<label for="paoc-popup-width"><?php esc_html_e('Popup Width', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[width]" value="<?php echo esc_attr( $width ); ?>" class="paoc-medium-text paoc-popup-width" id="paoc-popup-width" /><br/>
								<span class="description"><?php esc_html_e('Set popup width. e.g. 800px or 80%. Leave empty for default width.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>

						<tr>
							<th>
								<label for="paoc-popup-height"><?php esc_html_e('Popup Height', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[height]" value="<?php echo esc_attr( $height ); ?>" class="paoc-medium-text paoc-number paoc-popup-height" id="paoc-popup-height" /> <?php esc_html_e('PX', 'popup-anything-on-click'); ?><br />
								<span class="description"><?php esc_html_e('Set popup height in PX. Leave empty for default height.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>

						<tr class="paoc-show-hide-row-type paoc-show-if-type-modal paoc-show-if-type-push-notification paoc-show-if-type-slide-in" style="<?php if( $display_type == 'bar' ) { echo 'display: none;'; } ?>">
							<th>
								<label for="paoc-popup-mn-position"><?php esc_html_e('Popup Position', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<select name="<?php echo esc_attr( $prefix ); ?>design[mn_position]" class="paoc-select paoc-popup-mn-position" id="paoc-popup-mn-position">
									<?php foreach ( $mn_position_data as $mn_position_key => $mn_position_val ) { ?>
										<option value="<?php echo esc_attr( $mn_position_key ); ?>" <?php selected( $mn_position, $mn_position_key ); ?>><?php echo esc_html( $mn_position_val ); ?></option>
									<?php } ?>
								</select>
							</td>
						</tr>

						<tr class="paoc-show-hide-row-type paoc-show-if-type-bar" style="<?php if( $display_type == 'modal' || $display_type == 'push-notification' || $display_type == 'slide-in' ) { echo 'display: none;'; } ?>">
							<th>
								<label for="paoc-popup-bar-position"><?php esc_html_e('Popup Position', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<select name="<?php echo esc_attr( $prefix ); ?>design[bar_position]" class="paoc-select paoc-popup-bar-position" id="paoc-popup-bar-position">
									<?php foreach ( $bar_position_data as $bar_position_key => $bar_position_val ) { ?>
										<option value="<?php echo esc_attr( $bar_position_key ); ?>" <?php selected( $bar_position, $bar_position_key ); ?>><?php echo esc_html( $bar_position_val ); ?></option>
									<?php } ?>
								</select>
							</td>
						</tr>
					</table>
				</td>
			</tr>

			<tr class="paoc-show-hide-row-type paoc-show-if-type-modal paoc-show-if-type-push-notification paoc-show-if-type-bar" style="<?php if( $display_type == 'slide-in' ) { echo 'display: none;'; } ?>">
				<th>
					<label for="paoc-popup-effect"><?php esc_html_e('Popup Effect', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<select name="<?php echo esc_attr( $prefix ); ?>design[effect]" class="paoc-select paoc-popup-effect" id="paoc-popup-effect">
						<?php foreach ( $effect_data as $effect_key => $effect_val ) { ?>
							<option value="<?php echo esc_attr( $effect_key ); ?>" <?php selected( $effect, $effect_key ); ?>><?php echo esc_html( $effect_val ); ?></option>
						<?php } ?>
					</select>
				</td>
			</tr>

			<tr>
				<th>
					<label for="paoc-speed-in"><?php esc_html_e('Speed In', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[speed_in]" value="<?php echo esc_attr( $speed_in ); ?>" id="paoc-speed-in" class="paoc-medium-text paoc-number paoc-speed-in" /> <?php esc_html_e('Sec', 'popup-anything-on-click'); ?><br/>
					<span class="description"><?php esc_html_e('Enter the popup opening animation speed. Default value is 0.5 Sec.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<tr>
				<th>
					<label for="paoc-speed-out"><?php esc_html_e('Speed Out', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[speed_out]" value="<?php echo esc_attr( $speed_out ); ?>" id="paoc-speed-out" class="paoc-medium-text paoc-number paoc-speed-out" /> <?php esc_html_e('Sec', 'popup-anything-on-click'); ?><br/>
					<span class="description"><?php esc_html_e('Enter the popup closing animation speed. Default value is 0.25 Sec.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<tr class="paoc-show-hide-row-overlay paoc-hide-if-overlay-1" style="<?php if( ! empty( $hide_overlay ) ) { echo 'display: none;'; } ?>">
				<th>
					<label for="paoc-loader-clr"><?php esc_html_e('Loader Color', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[loader_color]" value="<?php echo esc_attr( $loader_color ); ?>" id="paoc-loader-clr" class="paoc-colorpicker paoc-loader-clr" /><br/>
					<span class="description"><?php esc_html_e('Choose popup loader color.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<tr>
				<th colspan="2">
					<div class="paoc-sub-sett-title"><i class="dashicons dashicons-admin-generic"></i> <?php esc_html_e('Image & Color Settings', 'popup-anything-on-click'); ?></div>
				</th>
			</tr>

			<tr>
				<th>
					<label for="paoc-popup-img"><?php esc_html_e('Popup Image', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[popup_img]" value="<?php echo esc_attr( $popup_img ); ?>" class="regular-text paoc-url paoc-popup-img paoc-img-upload-input" id="paoc-popup-img" />
					<input type="button" name="paoc_popup_img" class="button button-secondary paoc-image-upload" value="<?php esc_attr_e( 'Upload Image', 'popup-anything-on-click'); ?>" />
					<input type="button" name="paoc_popup_img_clear" class="button button-secondary paoc-image-clear" value="<?php esc_attr_e( 'Clear', 'popup-anything-on-click'); ?>" /> <br>
					<span class="description"><?php esc_html_e('Set popup background image.', 'popup-anything-on-click'); ?></span><br>
					<div class="paoc-img-view">
						<?php if( $popup_img != '' ) {
							echo '<img src="'.esc_url( $popup_img ).'" alt="" />';
						} ?>
					</div>
				</td>
			</tr>

			<tr>
				<th>
					<label for="paoc-bg-color"><?php esc_html_e('Popup Background Color', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[bg_color]" value="<?php echo esc_attr( $bg_color ); ?>" class="paoc-colorpicker paoc-bg-color" id="paoc-bg-color" data-alpha="true" /><br />
					<span class="description"><?php esc_html_e('Choose popup background color.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<tr>
				<th>
					<label for="paoc-overlay-img"><?php esc_html_e('Popup Overlay Image', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[overlay_img]" value="<?php echo esc_attr( $overlay_img ); ?>" class="regular-text paoc-url paoc-overlay-img paoc-img-upload-input" id="paoc-overlay-img" />
					<input type="button" name="paoc_overlay_img" class="button button-secondary paoc-image-upload" value="<?php esc_attr_e( 'Upload Image', 'popup-anything-on-click'); ?>" />
					<input type="button" name="paoc_overlay_img_clear" class="button button-secondary paoc-image-clear" value="<?php esc_attr_e( 'Clear', 'popup-anything-on-click'); ?>" /> <br>
					<span class="description"><?php esc_html_e('Set popup overlay background image.', 'popup-anything-on-click'); ?></span><br>
					<div class="paoc-img-view">
						<?php if( $overlay_img != '' ) {
							echo '<img src="'.esc_url( $overlay_img ).'" alt="" />';
						} ?>
					</div>
				</td>
			</tr>

			<tr>
				<th>
					<label for="paoc-overlay-color"><?php esc_html_e('Popup Overlay Color', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[overlay_color]" value="<?php echo esc_attr( $overlay_color ); ?>" class="paoc-colorpicker paoc-overlay-color" id="paoc-overlay-color" data-alpha="true" /><br />
					<span class="description"><?php esc_html_e('Choose overlay background color. Leave empty for default color.', 'popup-anything-on-click'); ?></span><br/>
					<span class="description"><?php esc_html_e('Note: This will only work when overlay background image is not there or image is transparent.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<tr>
				<th colspan="2">
					<div class="paoc-sub-sett-title"><i class="dashicons dashicons-admin-generic"></i> <?php esc_html_e('Heading Settings', 'popup-anything-on-click'); ?></div>
				</th>
			</tr>
			<tr>
				<th>
					<label for="paoc-mheading-fontsize"><?php esc_html_e('Main Heading Font Size', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[mheading_fontsize]" value="<?php echo esc_attr( $mheading_fontsize ); ?>" class="paoc-medium-text paoc-number paoc-mheading-fontsize" id="paoc-mheading-fontsize" /> <?php esc_html_e('PX', 'popup-anything-on-click'); ?><br />
					<span class="description"><?php esc_html_e('Enter main heading font size.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-sheading-fontsize"><?php esc_html_e('Sub Heading Font Size', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[sheading_fontsize]" value="<?php echo esc_attr( $sheading_fontsize ); ?>" class="paoc-medium-text paoc-number paoc-sheading-fontsize" id="paoc-sheading-fontsize" /> <?php esc_html_e('PX', 'popup-anything-on-click'); ?><br />
					<span class="description"><?php esc_html_e('Enter sub heading font size.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-mheading-txtclr"><?php esc_html_e('Main Heading Text Color', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[mheading_txtcolor]" value="<?php echo esc_attr( $mheading_txtcolor ); ?>" class="paoc-colorpicker paoc-mheading-txtclr" id="paoc-mheading-txtclr" /><br />
					<span class="description"><?php esc_html_e('Choose main heading text color.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-sheading-txtcolor"><?php esc_html_e('Sub Heading Text Color', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[sheading_txtcolor]" value="<?php echo esc_attr( $sheading_txtcolor ); ?>" class="paoc-colorpicker paoc-sheading-txtcolor" id="paoc-sheading-txtcolor"><br />
					<span class="description"><?php esc_html_e('Choose sub heading text color.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<th colspan="2">
					<div class="paoc-sub-sett-title"><i class="dashicons dashicons-admin-generic"></i> <?php esc_html_e('Other Settings', 'popup-anything-on-click'); ?></div>
				</th>
			</tr>
			<tr>
				<th>
					<label for="paoc-content-color"><?php esc_html_e('Content Color', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[content_color]" value="<?php echo esc_attr( $content_color ); ?>" class="paoc-colorpicker paoc-content-color" id="paoc-content-color"><br />
					<span class="description"><?php esc_html_e('Choose content text color.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-secondary-con-clr"><?php esc_html_e('Secondary Content Color', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[secondary_cnt_clr]" value="<?php echo esc_attr( $secondary_cnt_clr ); ?>" class="paoc-colorpicker paoc-secondary-con-clr" id="paoc-secondary-con-clr"><br />
					<span class="description"><?php esc_html_e('Choose secondary content text color.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-cus-close-txt-clr"><?php esc_html_e('Custom Close Text Color', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[custom_close_txtclr]" value="<?php echo esc_attr( $custom_close_txtclr ); ?>" class="paoc-colorpicker paoc-cus-close-txt-clr" id="paoc-cus-close-txt-clr"><br />
					<span class="description"><?php esc_html_e('Choose custom close text color.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-secur-note-color"><?php esc_html_e('Security Note Text Color', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[snote_txtcolor]" value="<?php echo esc_attr( $snote_txtcolor ); ?>" class="paoc-colorpicker paoc-secur-note-color" id="paoc-secur-note-color"><br />
					<span class="description"><?php esc_html_e('Choose security note text color.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<!-- Start - Collect Lead Settings -->
			<tr class="paoc-show-hide-row-goal paoc-show-if-goal-email-lists" style="<?php if( $popup_goal != 'email-lists' ) { echo 'display: none;'; } ?>">
				<td colspan="2" class="paoc-no-padding">
					<table class="form-table">
						<tr>
							<th colspan="2">
								<div class="paoc-sub-sett-title"><i class="dashicons dashicons-admin-generic"></i> <?php esc_html_e('Collect Lead Settings', 'popup-anything-on-click'); ?></div>
							</th>
						</tr>
						<tr>
							<th>
								<label for="paoc-field-lbl-clr"><?php esc_html_e('Field Label Color', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[email_lists][field_lbl_clr]" value="<?php echo esc_attr( $form_field_lbl_clr ); ?>" class="paoc-colorpicker paoc-field-lbl-clr" id="paoc-field-lbl-clr"><br />
								<span class="description"><?php esc_html_e('Choose field label color.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr>
							<th>
								<label for="paoc-field-bg-clr"><?php esc_html_e('Field BG Color', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[email_lists][field_bg_clr]" value="<?php echo esc_attr( $form_field_bg_clr ); ?>" class="paoc-colorpicker paoc-field-bg-clr" id="paoc-field-bg-clr"><br />
								<span class="description"><?php esc_html_e('Choose field background color.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr>
							<th>
								<label for="paoc-field-txt-clr"><?php esc_html_e('Field Text Color', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[email_lists][field_txt_clr]" value="<?php echo esc_attr( $form_field_txt_clr ); ?>" class="paoc-colorpicker paoc-field-txt-clr" id="paoc-field-txt-clr"><br />
								<span class="description"><?php esc_html_e('Choose field text color.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr>
							<th>
								<label for="paoc-field-btn-bg-clr"><?php esc_html_e('Button BG Color', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[email_lists][btn_bg_clr]" value="<?php echo esc_attr( $form_btn_bg_clr ); ?>" class="paoc-colorpicker paoc-field-btn-bg-clr" id="paoc-field-btn-bg-clr"><br />
								<span class="description"><?php esc_html_e('Choose button background color.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr>
							<th>
								<label for="paoc-field-btn-txt-clr"><?php esc_html_e('Button Text Color', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[email_lists][btn_txt_clr]" value="<?php echo esc_attr( $form_btn_txt_clr ); ?>" class="paoc-colorpicker paoc-field-btn-txt-clr" id="paoc-field-btn-txt-clr"><br />
								<span class="description"><?php esc_html_e('Choose button text color.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr>
							<th>
								<label for="paoc-field-btn-hbg-clr"><?php esc_html_e('Button BG Hover Color', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[email_lists][btn_hbg_clr]" value="<?php echo esc_attr( $form_btn_hbg_clr ); ?>" class="paoc-colorpicker paoc-field-btn-hbg-clr" id="paoc-field-btn-hbg-clr"><br />
								<span class="description"><?php esc_html_e('Choose button background hover color.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr>
							<th>
								<label for="paoc-field-btn-htxt-clr"><?php esc_html_e('Button Text Hover Color', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[email_lists][btn_htxt_clr]" value="<?php echo esc_attr( $form_btn_htxt_clr ); ?>" class="paoc-colorpicker paoc-field-btn-htxt-clr" id="paoc-field-btn-htxt-clr"><br />
								<span class="description"><?php esc_html_e('Choose button text hover color.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<!-- End - Collect Lead Settings -->

			<!-- Start - Target URL Settings -->
			<tr class="paoc-show-hide-row-goal paoc-show-if-goal-target-url" style="<?php if( $popup_goal != 'target-url' ) { echo 'display: none;'; } ?>">
				<td colspan="2" class="paoc-no-padding">
					<table class="form-table">
						<tr>
							<th colspan="2">
								<div class="paoc-sub-sett-title"><i class="dashicons dashicons-admin-generic"></i> <?php esc_html_e('Target URL Settings', 'popup-anything-on-click'); ?></div>
							</th>
						</tr>
						<tr>
							<th>
								<label for="paoc-url-btn1-bg-clr"><?php esc_html_e('Button 1 BG Color', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[target_url][btn1_bg_clr]" value="<?php echo esc_attr( $btn1_bg_clr ); ?>" class="paoc-colorpicker paoc-url-btn1-bg-clr" id="paoc-url-btn1-bg-clr" /><br />
								<span class="description"><?php esc_html_e('Choose button 1 backgournd color.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr>
							<th>
								<label for="paoc-url-btn1-txt-clr"><?php esc_html_e('Button 1 Text Color', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[target_url][btn1_txt_clr]" value="<?php echo esc_attr( $btn1_txt_clr ); ?>" class="paoc-colorpicker paoc-url-btn1-txt-clr" id="paoc-url-btn1-txt-clr" /><br />
								<span class="description"><?php esc_html_e('Choose button 1 text color.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr>
							<th>
								<label for="paoc-url-btn1-hbg-clr"><?php esc_html_e('Button 1 BG Hover Color', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[target_url][btn1_hbg_clr]" value="<?php echo esc_attr( $btn1_hbg_clr ); ?>" class="paoc-colorpicker paoc-url-btn1-hbg-clr" id="paoc-url-btn1-hbg-clr" /><br />
								<span class="description"><?php esc_html_e('Choose button 1 backgournd hover color.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr>
							<th>
								<label for="paoc-url-btn1-htxt-clr"><?php esc_html_e('Button 1 Text Hover Color', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[target_url][btn1_htxt_clr]" value="<?php echo esc_attr( $btn1_htxt_clr ); ?>" class="paoc-colorpicker paoc-url-btn1-htxt-clr" id="paoc-url-btn1-htxt-clr" /><br />
								<span class="description"><?php esc_html_e('Choose button 1 text hover color.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr>
							<th>
								<label for="paoc-url-btn2-bg-clr"><?php esc_html_e('Button 2 BG Color', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[target_url][btn2_bg_clr]" value="<?php echo esc_attr( $btn2_bg_clr ); ?>" class="paoc-colorpicker paoc-url-btn2-bg-clr" id="paoc-url-btn2-bg-clr" /><br />
								<span class="description"><?php esc_html_e('Choose button 2 backgournd color.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr>
							<th>
								<label for="paoc-url-btn2-txt-clr"><?php esc_html_e('Button 2 Text Color', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[target_url][btn2_txt_clr]" value="<?php echo esc_attr( $btn2_txt_clr ); ?>" class="paoc-colorpicker paoc-url-btn2-txt-clr" id="paoc-url-btn2-txt-clr" /><br />
								<span class="description"><?php esc_html_e('Choose button 2 text color.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr>
							<th>
								<label for="paoc-url-btn2-hbg-clr"><?php esc_html_e('Button 2 BG Hover Color', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[target_url][btn2_hbg_clr]" value="<?php echo esc_attr( $btn2_hbg_clr ); ?>" class="paoc-colorpicker paoc-url-btn2-hbg-clr" id="paoc-url-btn2-hbg-clr" /><br />
								<span class="description"><?php esc_html_e('Choose button 2 backgournd hover color.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr>
							<th>
								<label for="paoc-url-btn2-htxt-clr"><?php esc_html_e('Button 2 Text Hover Color', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[target_url][btn2_htxt_clr]" value="<?php echo esc_attr( $btn2_htxt_clr ); ?>" class="paoc-colorpicker paoc-url-btn2-htxt-clr" id="paoc-url-btn2-htxt-clr" /><br />
								<span class="description"><?php esc_html_e('Choose button 2 text hover color.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<!-- End - Target URL Settings -->

			<!-- Start - Phone Calls Settings -->
			<tr class="paoc-show-hide-row-goal paoc-show-if-goal-phone-calls" style="<?php if( $popup_goal != 'phone-calls' ) { echo 'display: none;'; } ?>">
				<td colspan="2" class="paoc-no-padding">
					<table class="form-table">
						<tr>
							<th colspan="2">
								<div class="paoc-sub-sett-title"><i class="dashicons dashicons-admin-generic"></i> <?php esc_html_e('Phone Calls Settings', 'popup-anything-on-click'); ?></div>
							</th>
						</tr>
						<tr>
							<th>
								<label for="paoc-call-btn-bg-clr"><?php esc_html_e('Button BG Color', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[phone_calls][btn_bg_clr]" value="<?php echo esc_attr( $call_btn_bg_clr ); ?>" class="paoc-colorpicker paoc-call-btn-bg-clr" id="paoc-call-btn-bg-clr" /><br />
								<span class="description"><?php esc_html_e('Choose button background color.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr>
							<th>
								<label for="paoc-call-btn-txt-clr"><?php esc_html_e('Button Text Color', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[phone_calls][btn_txt_clr]" value="<?php echo esc_attr( $call_btn_txt_clr ); ?>" class="paoc-colorpicker paoc-call-btn-txt-clr" id="paoc-call-btn-txt-clr" /><br />
								<span class="description"><?php esc_html_e('Choose button text color.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr>
							<th>
								<label for="paoc-call-btn-hbg-clr"><?php esc_html_e('Button BG Hover Color', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[phone_calls][btn_hbg_clr]" value="<?php echo esc_attr( $call_btn_hbg_clr ); ?>" class="paoc-colorpicker paoc-call-btn-hbg-clr" id="paoc-call-btn-hbg-clr" /><br />
								<span class="description"><?php esc_html_e('Choose button background hover color.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
						<tr>
							<th>
								<label for="paoc-call-btn-htxt-clr"><?php esc_html_e('Button Text Hover Color', 'popup-anything-on-click'); ?></label>
							</th>
							<td>
								<input type="text" name="<?php echo esc_attr( $prefix ); ?>design[phone_calls][btn_htxt_clr]" value="<?php echo esc_attr( $call_btn_htxt_clr ); ?>" class="paoc-colorpicker paoc-call-btn-htxt-clr" id="paoc-call-btn-htxt-clr" /><br />
								<span class="description"><?php esc_html_e('Choose button text hover color.', 'popup-anything-on-click'); ?></span>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<!-- End - Phone Calls Settings -->
		</tbody>
	</table>
</div><!-- end .paoc-design-sett -->