<?php
/**
 * Handles Form Fields Setting metabox HTML
 * 
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// Taking some variable
$field_type_data = paoc_pro_form_field_type_options();

// Form field settings data
$pre_form_data	= array(
						0 => array(
								'type'          => __( 'email', 'popup-anything-on-click' ),
								'label'         => __( 'Email', 'popup-anything-on-click' ),
								'placeholder'   => __( 'Enter Your Email', 'popup-anything-on-click' ),
								'require'       => 1,
							),
					);
$form_fields	= ! empty( $content['form_fields'] ) ? $content['form_fields'] : $pre_form_data;
?>

<div id="paoc_form_fields_sett" class="paoc-vtab-cnt paoc-form-fields-sett paoc-clearfix">

	<div class="paoc-tab-info-wrap">
		<div class="paoc-tab-title"><?php esc_html_e('Form Field Settings', 'popup-anything-on-click'); ?></div>
		<span class="paoc-tab-desc"><?php esc_html_e('Choose Popup form field settings.', 'popup-anything-on-click'); ?></span>
	</div>

	<table class="form-table paoc-tbl">
		<tbody>
			<tr>
				<td colspan="2" class="paoc-form-field-row-wrp paoc-no-lr-padding">
					<?php foreach ( $form_fields as $field_key => $form_field_data ) {

						$type           = isset( $form_field_data['type'] )         ? $form_field_data['type']          : '';
						$label          = isset( $form_field_data['label'] )        ? $form_field_data['label']         : '';
						$placeholder    = isset( $form_field_data['placeholder'] )  ? $form_field_data['placeholder']   : '';
						$choices        = isset( $form_field_data['choices'] )      ? $form_field_data['choices']       : '';
						$multiple       = ! empty( $form_field_data['multiple'] )   ? 1 : 0;
						$require        = ! empty( $form_field_data['require'] )    ? 1 : 0;
					?>
						<table class="form-table paoc-form-field-row" data-key="<?php echo esc_attr( $field_key ); ?>">
							<tbody>
								<tr>
									<th><label for="paoc-field-type-<?php echo esc_attr( $field_key ); ?>"><?php esc_html_e('Field Type', 'popup-anything-on-click'); ?></label></th>
									<td>
										<select name="<?php echo esc_attr( $prefix ); ?>content[form_fields][<?php echo esc_attr( $field_key ); ?>][type]" class="paoc-select paoc-field-type" id="paoc-field-type-<?php echo esc_attr( $field_key ); ?>">
											<?php foreach ( $field_type_data as $field_type_key => $field_type_val ) {
												$field_label = ! empty( $field_type_val['label'] ) ? $field_type_val['label'] : $field_type_key;
											?>
												<option value="<?php echo esc_attr( $field_type_key ); ?>" <?php selected( $type, $field_type_key ); ?>><?php echo esc_html( $field_label ); ?></option>
											<?php } ?>
										</select><br/>
										<span class="description paoc-email-fields"><?php esc_html_e('Select form field type.', 'popup-anything-on-click'); ?></span>
									</td>
									<td align="right" style="width: 100px; vertical-align: top;">
										<span class="paoc-action-btn paoc-action-add-btn paoc-add-form-field-row paoc-tooltip" title="<?php esc_attr_e('Add', 'popup-anything-on-click'); ?>"><i class="dashicons dashicons-plus-alt"></i></span>
										<span class="paoc-action-btn paoc-action-del-btn paoc-del-form-field-row paoc-tooltip" title="<?php esc_attr_e('Delete', 'popup-anything-on-click'); ?>"><i class="dashicons dashicons-trash"></i></span>
										<span class="paoc-action-btn paoc-action-drag-btn paoc-drag-form-field-row paoc-tooltip" title="<?php esc_attr_e('Drag', 'popup-anything-on-click'); ?>"><i class="dashicons dashicons-move"></i></span>
									</td>
								</tr>
								<tr>
									<th><label for="paoc-field-label-<?php echo esc_attr( $field_key ); ?>"><?php esc_html_e('Field Label', 'popup-anything-on-click'); ?></label></th>
									<td>
										<input type="text" name="<?php echo esc_attr( $prefix ); ?>content[form_fields][<?php echo esc_attr( $field_key ) ?>][label]" value="<?php echo esc_attr( $label ); ?>" class="paoc-text large-text paoc-field-label" id="paoc-field-label-<?php echo esc_attr( $field_key ); ?>">
										<span class="description paoc-email-fields"><?php esc_html_e('Enter form field label.', 'popup-anything-on-click'); ?></span>
									</td>
								</tr>
								<tr class="paoc-field-show paoc-field-hide-checkbox paoc-field-hide-date paoc-field-hide-math_captcha" style="<?php if( $type == 'checkbox' || $type == 'date' || $type == 'math_captcha' ) { echo 'display : none;'; } ?>">
									<th><label for="paoc-field-plch-<?php echo esc_attr( $field_key ); ?>"><?php esc_html_e('Field Placeholder', 'popup-anything-on-click'); ?></label></th>
									<td>
										<input type="text" name="<?php echo esc_attr( $prefix ); ?>content[form_fields][<?php echo esc_attr( $field_key ) ?>][placeholder]" value="<?php echo esc_attr( $placeholder ); ?>" class="paoc-text large-text paoc-field-placeholder" id="paoc-field-plch-<?php echo esc_attr( $field_key ); ?>" />
										<span class="description paoc-email-fields"><?php esc_html_e('Enter form field placeholder.', 'popup-anything-on-click'); ?></span>
									</td>
								</tr>
								<tr class="paoc-field-hide paoc-field-show-dropdown" style="<?php if( $type != 'dropdown' ) { echo 'display: none;'; } ?>">
									<th><label for="paoc-field-choices-<?php echo esc_attr( $field_key ); ?>"><?php esc_html_e('Choices', 'popup-anything-on-click'); ?></label></th>
									<td>
										<textarea id="paoc-field-choices-<?php echo esc_attr( $field_key ); ?>" name="<?php echo esc_attr( $prefix ); ?>content[form_fields][<?php echo esc_attr( $field_key ) ?>][choices]" class="large-text paoc-textarea paoc-field-choices"><?php echo esc_textarea( $choices ); ?></textarea>
										<span class="description"><?php esc_html_e('Enter each choice on a new line. For more control, you may specify both a value and label like this: red | Red', 'popup-anything-on-click'); ?></span>
									</td>
								</tr>
								<tr class="paoc-field-hide paoc-field-show-dropdown" style="<?php if( $type != 'dropdown' ) { echo 'display: none;'; } ?>">
									<th><label for="paoc-field-mul-<?php echo esc_attr( $field_key ); ?>"><?php esc_html_e('Multiple', 'popup-anything-on-click'); ?></label></th>
									<td>
										<input type="checkbox" name="<?php echo esc_attr( $prefix ); ?>content[form_fields][<?php echo esc_attr( $field_key ) ?>][multiple]" value="1" <?php checked( $multiple, 1 ); ?> class="paoc-checkbox paoc-field-mul" id="paoc-field-mul-<?php echo esc_attr( $field_key ); ?>" /><br/>
										<span class="description paoc-email-fields"><?php esc_html_e('Check this check box to enable multiple field.', 'popup-anything-on-click'); ?></span>
									</td>
								</tr>
								<tr class="paoc-field-show paoc-field-hide-math_captcha" style="<?php if( $type == 'math_captcha' ) { echo 'display: none;'; } ?>">
									<th><label for="paoc-field-require-<?php echo esc_attr( $field_key ); ?>"><?php esc_html_e('Required', 'popup-anything-on-click'); ?></label></th>
									<td>
										<input type="checkbox" name="<?php echo esc_attr( $prefix ); ?>content[form_fields][<?php echo esc_attr( $field_key ) ?>][require]" value="1" <?php checked( $require, 1 ); ?> class="paoc-checkbox paoc-field-require" id="paoc-field-require-<?php echo esc_attr( $field_key ); ?>" /><br/>
										<span class="description paoc-email-fields"><?php esc_html_e('Check this check box to enable required field.', 'popup-anything-on-click'); ?></span>
									</td>
								</tr>
								<tr class="paoc-field-hide paoc-field-show-math_captcha" style="<?php if( $type != 'math_captcha' ) { echo 'display: none;'; } ?>">
									<th><label for="paoc-field-require-<?php echo esc_attr( $field_key ); ?>"><?php esc_html_e('Required', 'popup-anything-on-click'); ?></label></th>
									<td>
										<?php esc_html_e('Yes', 'popup-anything-on-click'); ?>
									</td>
								</tr>
								<tr>
									<th><label><?php esc_html_e('Field Key', 'popup-anything-on-click'); ?></label></th>
									<td>
										<?php echo esc_attr( $field_key ); ?>
									</td>
								</tr>
								<tr>
									<th colspan="3"><hr/></th>
								</tr>
							</tbody>
						</table><!-- end email form fields -->
					<?php } // End for each ?>
				</td>
			</tr>
		</tbody>
	</table>
</div><!-- .paoc-form-fields-sett -->

<script type="text/html" id="tmpl-paoc-form-field-tmpl">
	<table class="form-table paoc-form-field-row" data-key="1">
		<tbody>
			<tr>
				<th><label for="paoc-field-type-1"><?php esc_html_e('Field Type', 'popup-anything-on-click'); ?></label></th>
				<td>
					<select name="<?php echo esc_attr( $prefix ); ?>content[form_fields][1][type]" class="paoc-select paoc-field-type" id="paoc-field-type-1">
						<?php foreach ( $field_type_data as $field_type_key => $field_type_val ) {
							$field_label = ! empty( $field_type_val['label'] ) ? $field_type_val['label'] : $field_type_key;
						?>
							<option value="<?php echo esc_attr( $field_type_key ); ?>"><?php echo esc_html( $field_label ); ?></option>
						<?php } ?>
					</select><br/>
					<span class="description paoc-email-fields"><?php esc_html_e('Select form field type.', 'popup-anything-on-click'); ?></span>
				</td>
				<td align="right" class="paoc-action-btn-wrp" style="width: 100px;">
					<span class="paoc-action-btn paoc-action-add-btn paoc-add-form-field-row paoc-tooltip" title="<?php esc_attr_e('Add', 'popup-anything-on-click'); ?>"><i class="dashicons dashicons-plus-alt"></i></span>
					<span class="paoc-action-btn paoc-action-del-btn paoc-del-form-field-row paoc-tooltip" title="<?php esc_attr_e('Delete', 'popup-anything-on-click'); ?>"><i class="dashicons dashicons-trash"></i></span>
					<span class="paoc-action-btn paoc-action-drag-btn paoc-drag-form-field-row paoc-tooltip" title="<?php esc_attr_e('Drag', 'popup-anything-on-click'); ?>"><i class="dashicons dashicons-move"></i></span>
				</td>
			</tr>
			<tr>
				<th><label for="paoc-field-label-1"><?php esc_html_e('Field Label', 'popup-anything-on-click'); ?></label></th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>content[form_fields][1][label]" value="" class="paoc-text large-text paoc-field-label" id="paoc-field-label-1">
					<span class="description paoc-email-fields"><?php esc_html_e('Enter form field label.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr class="paoc-field-show paoc-field-hide-checkbox paoc-field-hide-date paoc-field-hide-math_captcha">
				<th><label for="paoc-field-plch-1"><?php esc_html_e('Field Placeholder', 'popup-anything-on-click'); ?></label></th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>content[form_fields][1][placeholder]" value="" class="paoc-text large-text paoc-field-placeholder" id="paoc-field-plch-1" />
					<span class="description paoc-email-fields"><?php esc_html_e('Enter form field placeholder.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr class="paoc-field-hide paoc-field-show-dropdown" style="display: none;">
				<th><label for="paoc-field-choices-1"><?php esc_html_e('Choices', 'popup-anything-on-click'); ?></label></th>
				<td>
					<textarea id="paoc-field-choices-1" name="<?php echo esc_attr( $prefix ); ?>content[form_fields][1][choices]" class="large-text paoc-textarea paoc-field-choices"></textarea><br/>
					<span class="description"><?php esc_html_e('Enter each choice on a new line. For more control, you may specify both a value and label like this: red | Red', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr class="paoc-field-hide paoc-field-show-dropdown" style="display: none;">
				<th><label for="paoc-field-mul-1"><?php esc_html_e('Multiple', 'popup-anything-on-click'); ?></label></th>
				<td>
					<input type="checkbox" name="<?php echo esc_attr( $prefix ); ?>content[form_fields][1][multiple]" value="1" class="paoc-checkbox regular-text paoc-field-mul" id="paoc-field-mul-1" /><br/>
					<span class="description paoc-email-fields"><?php esc_html_e('Check this check box to enable multiple field.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr class="paoc-field-show paoc-field-hide-math_captcha">
				<th><label for="paoc-field-require-1"><?php esc_html_e('Required', 'popup-anything-on-click'); ?></label></th>
				<td>
					<input type="checkbox" name="<?php echo esc_attr( $prefix ); ?>content[form_fields][1][require]" value="1" class="paoc-text regular-text paoc-field-require" id="paoc-field-require-1" /><br/>
					<span class="description paoc-email-fields"><?php esc_html_e('Check this check box to enable required field.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr class="paoc-field-hide paoc-field-show-math_captcha" style="display: none;">
				<th><label for="paoc-field-require-1"><?php esc_html_e('Required', 'popup-anything-on-click'); ?></label></th>
				<td>
					<?php esc_html_e('Yes', 'popup-anything-on-click'); ?>
				</td>
			</tr>
			<tr>
				<th><label><?php esc_html_e('Field Key', 'popup-anything-on-click'); ?></label></th>
				<td>
					{{data.field_key}}
				</td>
			</tr>
			<tr>
				<th colspan="3"><hr/></th>
			</tr>
		</tbody>
	</table>
</script>