<?php
/**
 * Handles Geolocation Setting metabox HTML
 * 
 * @package Popup Anything on Click Pro
 * @since 2.0.7
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// Taking some variable
$countries_data = paoc_pro_countries();
$geo_enable		= paoc_pro_get_option( 'geo_enable' );
$geo_countries	= ! empty( $advance['geo_countries'] ) ? $advance['geo_countries'] : array();
$general_sett	= add_query_arg( array( 'post_type' => PAOC_PRO_POST_TYPE, 'page' => 'paoc-pro-settings' ), admin_url('edit.php') );
?>

<div id="paoc_geolocation_sett" class="paoc-vtab-cnt paoc-geolocation-sett paoc-clearfix">

	<div class="paoc-tab-info-wrap">
		<div class="paoc-tab-title"><?php esc_html_e('Geolocation Settings', 'popup-anything-on-click'); ?></div>
		<span class="paoc-tab-desc"><?php esc_html_e('Choose popup geolocation settings.', 'popup-anything-on-click'); ?></span>
	</div>

	<table class="form-table paoc-tbl">
		<tbody>
			<?php if( empty( $geo_enable ) ) { ?>
			<tr>
				<td colspan="2" class="paoc-no-lr-padding">
					<div class="paoc-notice">
						<?php esc_html_e('Geolocation is not enabled.', 'popup-anything-on-click'); ?>
						<?php if ( current_user_can( 'manage_options' ) ) {
							echo sprintf( __('Please enable it from %shere%s.', 'popup-anything-on-click'), '<a href="'.esc_url( $general_sett ).'" target="_blank">', '</a>' );
						} else {
							esc_html_e('Please enable it from plugin setting page.', 'popup-anything-on-click');
						} ?>
					</div>
				</td>
			</tr>
			<?php } ?>
			
			<tr>
				<th>
					<label for="paoc-countries"><?php esc_html_e('Countries', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<select name="<?php echo esc_attr( $prefix ); ?>advance[geo_countries][]" class="paoc-select2-mul paoc-select2 paoc-countries" id="paoc-countries" data-placeholder="<?php esc_html_e('Select Countries', 'popup-anything-on-click'); ?>" multiple="multiple" style="width: 100%;" />
						<?php if( ! empty( $countries_data ) ) {
							foreach( $countries_data as $country_key => $country_val ) {
								$country_key = strtolower( $country_key );
						?>
								<option value="<?php echo esc_attr( $country_key ); ?>" <?php selected( in_array( $country_key, $geo_countries ), true ); ?>><?php echo esc_html( $country_val ); ?></option>
							<?php }
						} ?>
					</select><br/>
					<span class="description"><?php esc_html_e('Select countries to display popup. Leave it empty to display popup in all countries. Hold Ctrl key to select multiple countries at a time.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
		</tbody>
	</table>
</div>