<?php
/**
 * Handles Integration Setting metabox HTML
 * 
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// Taking some variable
$mc_api_key		= paoc_pro_get_option( 'mc_api_key' );
$mc_acc_lists	= paoc_pro_integration_info( 'mailchimp' );
$mc_enable		= ! empty( $integration['mc_enable'] )	? 1 : 0;
$mc_lists		= ! empty( $integration['mc_lists'] )	? $integration['mc_lists']	: array( 0 => array() );
$form_fields	= ! empty( $content['form_fields'] )	? $content['form_fields']	: array();
$intgs_page		= add_query_arg( array( 'post_type' => PAOC_PRO_POST_TYPE, 'page' => 'paoc-pro-settings', 'tab' => 'integration' ), admin_url('edit.php') );
?>

<div id="paoc_integration_sett" class="paoc-vtab-cnt paoc-integration-sett paoc-clearfix">

	<div class="paoc-tab-info-wrap">
		<div class="paoc-tab-title"><?php esc_html_e('Integration Settings', 'popup-anything-on-click'); ?></div>
		<span class="paoc-tab-desc"><?php esc_html_e('Choose popup email integration settings.', 'popup-anything-on-click'); ?></span>
	</div>

	<table class="form-table paoc-tbl">
		<tbody>
			<tr>
				<th colspan="2">
					<div class="paoc-sub-sett-title"><i class="dashicons dashicons-admin-generic"></i> <?php esc_html_e('MailChimp Integration', 'popup-anything-on-click'); ?></div>
				</th>
			</tr>

			<tr>
				<th>
					<label for="paoc-mc-enable"><?php esc_html_e('Enable','popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="checkbox" name="<?php echo esc_attr( $prefix ); ?>integration[mc_enable]" value="1" <?php checked( $mc_enable, 1 ); ?> class="paoc-checkbox paoc-mc-enable" id="paoc-mc-enable" /><br/>
					<span class="description"><?php esc_html_e('Check this box to enable MailChimp integration.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<tr class="paoc-acc-wrap">
				<td class="paoc-no-padding paoc-clone-ele-wrap" colspan="2">
					<?php if( $mc_acc_lists && $mc_api_key ) {
						foreach ( $mc_lists as $mc_list_key => $mc_lists_data ) {

							$list_id			= ! empty( $mc_lists_data['list_id'] )			? $mc_lists_data['list_id']								: '';
							$list_name			= ! empty( $mc_acc_lists[$list_id]['name'] )	? $mc_acc_lists[$list_id]['name']						: '';
							$syn_mc_fields		= ! empty( $mc_lists_data['syn_mc_fields'] )	? maybe_unserialize( $mc_lists_data['syn_mc_fields'] )	: array();
							$fields				= ! empty( $mc_lists_data['fields'] )			? $mc_lists_data['fields']								: array( 0 => '' );
							$mc_tags			= ! empty( $mc_lists_data['mc_tags'] )			? $mc_lists_data['mc_tags']								: '';
							$mc_double_optin	= ! empty( $mc_lists_data['mc_double_optin'] )	? 1 : 0;
						?>

						<div class="paoc-accordion-row paoc-clone-row" data-key="<?php echo esc_attr( $mc_list_key ) ?>">
							<div class="paoc-accordion-header">
								<span class="paoc-accordion-actions">
									<span class="paoc-accordion-act-btn paoc-accordion-toggle paoc-accordion-row-sett paoc-tooltip" data-tooltip-text="<?php esc_html_e('Show / Hide settings', 'popup-anything-on-click'); ?>"><i class="dashicons dashicons-admin-generic"></i></span>
									<span class="paoc-accordion-act-btn paoc-add-clone-btn paoc-tooltip" data-tooltip-text="<?php esc_html_e('Add', 'popup-anything-on-click'); ?>" data-clone-type="integration"><i class="dashicons dashicons-plus-alt"></i></span>
									<span class="paoc-accordion-act-btn paoc-del-clone-btn paoc-tooltip" data-tooltip-text="<?php esc_html_e('Delete', 'popup-anything-on-click'); ?>"><i class="dashicons dashicons-trash"></i></span>
								</span>
								<div class="paoc-accordion-toggle paoc-accordion-title">
									<?php echo esc_html_e('MailChimp List', 'popup-anything-on-click'); ?> #<span class="paoc-clone-list-no"><?php echo esc_attr( $mc_list_key ); ?></span> <span class="paoc-intgs-list-name"><?php if( $list_name ) { echo ' - '.esc_html( $list_name ); } ?></span>
								</div>
							</div>

							<div class="paoc-accordion-data-wrap">
								<table class="form-table paoc-tbl">
									<tbody>
										<tr>
											<th>
												<label for="paoc-mailchimp-list-<?php echo esc_attr( $mc_list_key ); ?>"><?php esc_html_e('MailChimp Lists', 'popup-anything-on-click'); ?></label>
											</th>
											<td colspan="2">
												<select name="<?php echo esc_attr( $prefix ); ?>integration[mc_lists][<?php echo esc_attr( $mc_list_key ) ?>][list_id]" class="paoc-select paoc-mailchimp-list" id="paoc-mailchimp-list-<?php echo esc_attr( $mc_list_key ); ?>">
													<option value=""><?php esc_html_e('Select MailChimp List', 'popup-anything-on-click'); ?></option>
													<?php foreach ( $mc_acc_lists as $mc_lists_info ) { ?>
														<option value="<?php echo esc_attr( $mc_lists_info['id'] ); ?>" <?php selected( $list_id, $mc_lists_info['id'] ); ?>><?php echo esc_html( $mc_lists_info['name'] ); ?></option>
													<?php } ?>
												</select>
												<button type="button" class="button button-secondary paoc-btn paoc-mc-field-syn" data-nonce="<?php echo wp_create_nonce( "paoc-mc-list-syn-{$post->ID}" ); ?>"><?php esc_html_e('Synchronize', 'popup-anything-on-click'); ?></button>
												<span class="spinner paoc-no-float paoc-spinner"></span>
												<br/>
												<span class="description"><?php esc_html_e('Select MailChimp list for the entries.', 'popup-anything-on-click'); ?></span><br />
												<span class="description">
													<?php if ( current_user_can( 'manage_options' ) ) {
														echo sprintf( __('Note: Did not find your list? Please refresh the account from %shere%s.', 'popup-anything-on-click'), '<a href="'.esc_url( $intgs_page ).'" target="_blank">', '</a>' );
													} else {
														esc_html_e('Note: Did not find your list? Please refresh the account from plugin setting page.', 'popup-anything-on-click');
													} ?>
												</span>
											</td>
										</tr>

										<tr>
											<th>
												<label for="paoc-mc-double-optin-<?php echo esc_attr( $mc_list_key ); ?>"><?php esc_html_e('Double Opt-in','popup-anything-on-click'); ?></label>
											</th>
											<td>
												<input type="checkbox" name="<?php echo esc_attr( $prefix ); ?>integration[mc_lists][<?php echo esc_attr( $mc_list_key ) ?>][mc_double_optin]" value="1" <?php checked( $mc_double_optin, 1 ); ?> class="paoc-checkbox paoc-mc-double-optin" id="paoc-mc-double-optin-<?php echo esc_attr( $mc_list_key ); ?>" /><br />
												<span class="description"><?php esc_html_e('Check this box to enable double opt-in MailChimp integration.', 'popup-anything-on-click'); ?></span>
											</td>
										</tr>

										<tr>
											<th>
												<label for="paoc-mc-tags-<?php echo esc_attr( $mc_list_key ); ?>"><?php esc_html_e('Tags','popup-anything-on-click'); ?></label>
											</th>
											<td>
												<input type="text" name="<?php echo esc_attr( $prefix ); ?>integration[mc_lists][<?php echo esc_attr( $mc_list_key ) ?>][mc_tags]" value="<?php echo esc_attr( $mc_tags ); ?>" class="paoc-text large-text paoc-mc-tags" id="paoc-mc-tags-<?php echo esc_attr( $mc_list_key ); ?>" /><br />
												<span class="description"><?php echo sprintf( __('Enter tags for members. You can enter multiple tags by comma separated. Know more about tags from <a href="%s" target="_blank">here</a>.', 'popup-anything-on-click'), 'https://mailchimp.com/help/getting-started-tags/' ); ?></span>
											</td>
										</tr>

										<tr>
											<th>
												<label><?php esc_html_e('Form Fields Mapping', 'popup-anything-on-click'); ?></label>
											</th>
											<td colspan="2" class="paoc-no-padding">
												<table class="form-table fixed paoc-tbl paoc-fields-wrap paoc-clone-ele-wrap">
													<tbody>
														<?php if( ! empty( $fields ) ) {
															foreach( $fields as $field_key => $field_val ) { ?>

																<tr class="paoc-mc-field-inr paoc-clone-row" data-key="<?php echo esc_attr( $mc_list_key ); ?>" data-input="0">
																	<td class="paoc-mc-fields-wrap">
																		<select name="<?php echo esc_attr( $prefix ); ?>integration[mc_lists][<?php echo esc_attr( $mc_list_key ) ?>][mc_fields][]" class="paoc-select-full paoc-empty-select paoc-mc-fields">
																			<option value=""><?php esc_html_e('Select Mailchimp Field', 'popup-anything-on-click'); ?></option>
																			<?php if( ! empty( $syn_mc_fields ) ) {
																				foreach( $syn_mc_fields as $mc_field_key => $mc_field_val ) { ?>
																					<option value="<?php echo esc_attr( $mc_field_val['tag'] ); ?>" <?php selected( $field_key, $mc_field_val['tag'] ); ?>><?php echo esc_html( $mc_field_val['name'] ); ?></option>
																				<?php }
																			} ?>
																		</select>
																	</td>

																	<td class="paoc-center" style="width:40px; font-size:22px;">&#8646;</td>

																	<td class="paoc-form-fields-wrap">
																		<select name="<?php echo esc_attr( $prefix ); ?>integration[mc_lists][<?php echo esc_attr( $mc_list_key ) ?>][form_fields][]" class="paoc-select-full paoc-form-fields">
																				<option value=""><?php esc_html_e('Select Form Field', 'popup-anything-on-click'); ?></option>
																				<?php
																				if( ! empty( $form_fields ) ) {
																					foreach ( $form_fields as $form_field_key => $form_field_data ) {

																						if ( ! empty( $form_field_data['type'] ) && $form_field_data['type'] == 'math_captcha' ) {
																							continue;
																						}

																						$label = ( isset( $form_field_data['label'] ) && $form_field_data['label'] != '' ) ? $form_field_data['label'] : esc_html__('Field', 'popup-anything-on-click') .' - '. $form_field_key;
																					?>
																						<option value="<?php echo esc_attr( $form_field_key ); ?>" <?php selected( $field_val, $form_field_key ); ?>><?php echo esc_html( $label ); ?></option>
																				<?php } } ?>
																		</select>
																	</td>
																	<td align="right" style="width: 100px;">
																		<span class="paoc-field-btn paoc-field-add-btn paoc-add-clone-btn paoc-tooltip" data-update-name="0" data-tooltip-text="<?php esc_html_e('Add', 'popup-anything-on-click'); ?>"><i class="dashicons dashicons-plus-alt"></i></span>
																		<span class="paoc-field-btn paoc-field-del-btn paoc-del-clone-btn paoc-tooltip" data-tooltip-text="<?php esc_html_e('Delete', 'popup-anything-on-click'); ?>"><i class="dashicons dashicons-trash"></i></span>
																	</td>
																</tr>

															<?php }
														} ?>
													</tbody>
												</table>
											</td>
										</tr>
									</tbody>
								</table>
								<input type="hidden" name="<?php echo esc_attr( $prefix ); ?>integration[mc_lists][<?php echo esc_attr( $mc_list_key ) ?>][syn_mc_fields]" value="<?php echo esc_attr( serialize( $syn_mc_fields ) ); ?>" class="paoc-intgs-hidden-fields" />
							</div>
						</div>
					<?php }
				} else { ?>
					<tr>
						<td colspan="2">
							<div class="paoc-notice">
								<?php esc_html_e('MailChimp account is not connected.', 'popup-anything-on-click'); ?>
								<?php if ( current_user_can( 'manage_options' ) ) {
									echo sprintf( __('Please configure it from %shere%s.', 'popup-anything-on-click'), '<a href="'.esc_url( $intgs_page ).'" target="_blank">', '</a>' );
								} else {
									esc_html_e('Please configure it from plugin setting page.', 'popup-anything-on-click');
								} ?>
							</div>
						</td>
					</tr>
				<?php } ?>
				</td>
			</tr>
		</tbody>
	</table>
</div><!-- end .paoc-integration-sett -->