<?php
/**
 * Handles Notification Setting metabox HTML
 * 
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// Taking some variable
$notification = get_post_meta( $post->ID, $prefix.'notification', true );

// Taking some variables
$enable_email	= ! empty( $notification['enable_email'] )	? 1 : 0;
$email_to		= ! empty( $notification['email_to'] )		? $notification['email_to']			: get_option('admin_email');
$email_subject	= ! empty( $notification['email_subject'] )	? $notification['email_subject']	: __('New submission received!', 'popup-anything-on-click');
$email_heading	= ! empty( $notification['email_heading'] )	? $notification['email_heading']	: __('New Submission Received', 'popup-anything-on-click');
$email_msg		= ! empty( $notification['email_msg'] )		? $notification['email_msg'] 		: __('Hi,<br/><br/>You have received a new submission. Form data is as follows.<br/><br/>{all_fields}', 'popup-anything-on-click');

$enable_user_email	= ! empty( $notification['enable_user_email'] )		? 1 : 0;
$user_email_subject	= ! empty( $notification['user_email_subject'] )	? $notification['user_email_subject']	: __('Hey! Thanks for your submission. Your entry has been received.', 'popup-anything-on-click');
$user_email_heading	= ! empty( $notification['user_email_heading'] )	? $notification['user_email_heading']	: __('Thanks for your submission', 'popup-anything-on-click');
$user_email_msg		= ! empty( $notification['user_email_msg'] )		? $notification['user_email_msg'] 		: __('Hi,<br/><br/>Thanks for your submission. Your entry has been received. Form data is as follows.<br/><br/>{all_fields}', 'popup-anything-on-click');
?>

<div id="paoc_notification_sett" class="paoc-vtab-cnt paoc-notification-sett paoc-clearfix">

	<div class="paoc-tab-info-wrap">
		<div class="paoc-tab-title"><?php esc_html_e('Notification Settings', 'popup-anything-on-click'); ?></div>
		<span class="paoc-tab-desc"><?php esc_html_e('Choose popup notification settings.', 'popup-anything-on-click'); ?></span>
	</div>

	<table class="form-table paoc-tbl">
		<tbody>
			<tr>
				<th>
					<label for="paoc-enable-email"><?php esc_html_e('Enable', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="checkbox" name="<?php echo esc_attr( $prefix ); ?>notification[enable_email]" value="1" <?php checked( $enable_email, 1 ); ?> class="paoc-checkbox paoc-enable-email" id="paoc-enable-email" /><br />
					<span class="description"><?php esc_html_e('Check this box to enable admin email notification.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-email-to"><?php esc_html_e('Mail To', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>notification[email_to]" value="<?php echo esc_attr( $email_to ); ?>" class="paoc-text large-text paoc-email-to" id="paoc-email-to" />
					<span class="description"><?php esc_html_e('Enter notification email address. You can enter multiple email address by comma separated.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-email-subject"><?php esc_html_e('Subject', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>notification[email_subject]" value="<?php echo esc_attr( $email_subject ); ?>" class="paoc-text large-text paoc-email-subject" id="paoc-email-subject" />
					<span class="description"><?php esc_html_e('Enter notification admin email subject. Available template tags are', 'popup-anything-on-click'); ?></span><br/>
					<div class="paoc-code-tag-wrap">
						<code class="paoc-copy-clipboard">{ID}</code> - <span class="description"><?php esc_html_e('Display popup ID.', 'popup-anything-on-click'); ?></span>
					</div>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-email-heading"><?php esc_html_e('Heading', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>notification[email_heading]" value="<?php echo esc_attr( $email_heading ); ?>" class="paoc-text large-text paoc-email-heading" id="paoc-email-heading" />
					<span class="description"><?php esc_html_e('Enter notification admin email heading.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-email-msg"><?php esc_html_e('Message', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<?php wp_editor( $email_msg, 'paoc-email-msg', array('textarea_name' => $prefix.'notification[email_msg]', 'textarea_rows' => 8, 'media_buttons' => true, 'class' => 'paoc-email-msg') ); ?>
					<span class="description"><?php echo sprintf( esc_html__('Enter notification admin email message. Available template tags are %s.', 'popup-anything-on-click'), '<a href="javascript:void(0)" class="paoc-open-popup" title="'.esc_attr__('Popup Tags', 'popup-anything-on-click').'" data-id="form_fields_tags">'.esc_html__('here', 'popup-anything-on-click').'</a>' ); ?></span>
				</td>
			</tr>

			<tr>
				<th colspan="2">
					<div class="paoc-sub-sett-title"><i class="dashicons dashicons-admin-generic"></i> <?php esc_html_e('User Email Settings', 'popup-anything-on-click'); ?></div>
				</th>
			</tr>

			<tr>
				<th>
					<label for="paoc-enable-user-email"><?php esc_html_e('Enable', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="checkbox" name="<?php echo esc_attr( $prefix ); ?>notification[enable_user_email]" value="1" <?php checked( $enable_user_email, 1 ); ?> class="paoc-checkbox paoc-enable-user-email" id="paoc-enable-user-email" /><br />
					<span class="description"><?php esc_html_e('Check this box to enable user email notification.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-user-email-subject"><?php esc_html_e('Subject', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>notification[user_email_subject]" value="<?php echo esc_attr( $user_email_subject ); ?>" class="paoc-text large-text paoc-user-email-subject" id="paoc-user-email-subject" />
					<span class="description"><?php esc_html_e('Enter notification user email subject. Available template tags are', 'popup-anything-on-click'); ?></span><br/>
					<div class="paoc-code-tag-wrap">
						<code class="paoc-copy-clipboard">{name}</code> - <span class="description"><?php esc_html_e('Display user full name.', 'popup-anything-on-click'); ?></span>
					</div>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-user-email-heading"><?php esc_html_e('Heading', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="text" name="<?php echo esc_attr( $prefix ); ?>notification[user_email_heading]" value="<?php echo esc_attr( $user_email_heading ); ?>" class="paoc-text large-text paoc-user-email-heading" id="paoc-user-email-heading" />
					<span class="description"><?php esc_html_e('Enter notification user email heading.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<th>
					<label for="paoc-user-email-msg"><?php esc_html_e('Message', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<?php wp_editor( $user_email_msg, 'paoc-user-email-msg', array('textarea_name' => $prefix.'notification[user_email_msg]', 'textarea_rows' => 8, 'media_buttons' => true, 'class' => 'paoc-user-email-msg') ); ?>
					<span class="description"><?php echo sprintf( esc_html__('Enter notification user email message. Available template tags are %s.', 'popup-anything-on-click'), '<a href="javascript:void(0)" class="paoc-open-popup" title="'.esc_html__('Popup Tags', 'popup-anything-on-click').'" data-id="form_fields_tags">'.esc_attr__('here', 'popup-anything-on-click').'</a>' ); ?></span>
				</td>
			</tr>
		</tbody>
	</table>
</div><!-- end .paoc-notification-sett -->