<?php
/**
 * Handles Post Type Setting metabox HTML
 *
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post;

// Taking some variables
$prefix			= PAOC_PRO_META_PREFIX;
$welcome_popup	= get_post_meta( $post->ID, $prefix.'welcome_popup', true );
$exit_popup		= get_post_meta( $post->ID, $prefix.'exit_popup', true );
$general_popup	= get_post_meta( $post->ID, $prefix.'general_popup', true );
$pre_data		= array( 'id' => -1, 'text' => esc_html__('No Popup', 'popup-anything-on-click') );

// Get Popup Post Argument
$general_args = array(
	'post_type'			=> PAOC_PRO_POST_TYPE,
	'post__in'			=> $general_popup,
	'posts_per_page'	=> -1,
);

// Getting Some Data
$welcome_popup_post 	= ! empty( $welcome_popup )						? get_post( $welcome_popup )		: '';
$welcome_popup_title	= ! empty( $welcome_popup_post->post_title )	? $welcome_popup_post->post_title	: __('Post', 'popup-anything-on-click');
$exit_popup_post		= ! empty( $exit_popup )						? get_post( $exit_popup )			: '';
$exit_popup_title		= ! empty( $exit_popup_post->post_title )		? $exit_popup_post->post_title		: __('Post', 'popup-anything-on-click');
$general_popup_post		= ! empty( $general_popup )						? get_posts( $general_args )		: array();

$welcome_meta_data	= paoc_pro_sugg_meta_data( 'welcome' );
$exit_meta_data		= paoc_pro_sugg_meta_data( 'exit' );
$general_meta_data	= paoc_pro_sugg_meta_data( 'general' );
?>

<table class="form-table paoc-tbl paoc-post-table">
	<tbody>
		<tr>
			<th>
				<label for="paoc-welcome-popup"><?php esc_html_e('Welcome Popup', 'popup-anything-on-click'); ?></label>
			</th>
			<td>
				<select id="paoc-welcome-popup" class="paoc-post-title-sugg paoc-welcome-popup" name="<?php echo esc_attr( $prefix ); ?>welcome_popup" data-placeholder="<?php esc_html_e('Select Welcome Popup', 'popup-anything-on-click'); ?>" data-nonce="<?php echo wp_create_nonce('paoc-post-title-sugg'); ?>" data-post-type="<?php echo esc_attr( PAOC_PRO_POST_TYPE ); ?>" data-meta='<?php echo esc_attr( json_encode( $welcome_meta_data ) ); ?>' data-predefined='<?php echo json_encode( $pre_data ); ?>'>
					<option></option>
					<?php if( $welcome_popup == -1 ) { ?>
						<option value="-1" selected="selected"><?php esc_html_e('No Popup', 'popup-anything-on-click'); ?></option>
					<?php }
					elseif( $welcome_popup_post && $welcome_popup_post->post_status == 'publish' && $welcome_popup_post->post_type == PAOC_PRO_POST_TYPE ) { ?>
						<option value="<?php echo esc_attr( $welcome_popup_post->ID ); ?>" selected="selected"><?php echo esc_html( $welcome_popup_title ." - (#{$welcome_popup_post->ID})" ); ?></option>
					<?php } ?>
				</select><br/>
				<span class="description"><?php esc_html_e('Select welcome popup to display. You can search popup by its name or ID.', 'popup-anything-on-click'); ?></span><br/>
				<span class="description"><?php esc_html_e('Note : Type No Popup and choose it to do not display any popup on this page.', 'popup-anything-on-click'); ?></span>
			</td>
		</tr>

		<tr>
			<th>
				<label for="paoc-exit-popup"><?php esc_html_e('Exit Popup', 'popup-anything-on-click'); ?></label>
			</th>
			<td>
				<select id="paoc-exit-popup" class="paoc-post-title-sugg paoc-exit-popup" name="<?php echo esc_attr( $prefix ); ?>exit_popup" data-placeholder="<?php esc_html_e('Select Exit Popup', 'popup-anything-on-click'); ?>" data-nonce="<?php echo wp_create_nonce('paoc-post-title-sugg'); ?>" data-post-type="<?php echo esc_attr( PAOC_PRO_POST_TYPE ); ?>" data-meta='<?php echo esc_attr( json_encode( $exit_meta_data ) ); ?>' data-predefined='<?php echo json_encode( $pre_data ); ?>'>
					<option></option>
					<?php if( $exit_popup == -1 ) { ?>
						<option value="-1" selected="selected"><?php esc_html_e('No Popup', 'popup-anything-on-click'); ?></option>
					<?php }
					elseif( $exit_popup_post && $exit_popup_post->post_status == 'publish' && $exit_popup_post->post_type == PAOC_PRO_POST_TYPE ) { ?>
						<option value="<?php echo esc_attr( $exit_popup_post->ID ) ?>" selected="selected"><?php echo esc_html( $exit_popup_title ." - (#{$exit_popup_post->ID})" ); ?></option>
					<?php } ?>
				</select><br/>
				<span class="description"><?php esc_html_e('Select exit popup to display. You can search popup by its name or ID.', 'popup-anything-on-click'); ?></span><br/>
				<span class="description"><?php esc_html_e('Note : Type No Popup and choose it to do not display any popup on this page.', 'popup-anything-on-click'); ?></span>
			</td>
		</tr>

		<tr>
			<th>
				<label for="paoc-general-popup"><?php esc_html_e('General Popup', 'popup-anything-on-click'); ?></label>
			</th>
			<td>
				<select id="paoc-general-popup" class="paoc-select2-mul paoc-post-title-sugg paoc-general-popup" name="<?php echo esc_attr( $prefix ); ?>general_popup[]" data-placeholder="<?php esc_html_e('Select General Popup', 'popup-anything-on-click'); ?>" data-nonce="<?php echo wp_create_nonce('paoc-post-title-sugg'); ?>" data-post-type="<?php echo esc_attr( PAOC_PRO_POST_TYPE ); ?>" data-meta='<?php echo esc_attr( json_encode( $general_meta_data ) ); ?>' data-predefined='<?php echo json_encode( $pre_data ); ?>' multiple="multiple" style="width: 100%;">
					<option></option>
					<?php if( ! empty( $general_popup ) && $general_popup[0] == -1 ) { ?>
						<option value="-1" selected="selected"><?php esc_html_e('No Popup', 'popup-anything-on-click'); ?></option>
					<?php }
					elseif( $general_popup_post ) {
						foreach ( $general_popup_post as $general_popup_key => $general_popup_val ) { ?>
							<option value="<?php echo esc_attr( $general_popup_val->ID ); ?>" <?php selected( in_array( $general_popup_val->ID, $general_popup ), true ); ?>><?php echo esc_html( $general_popup_val->post_title ) ." - (#{$general_popup_val->ID})"; ?></option>
						<?php }
					} ?>
				</select><br/>
				<span class="description"><?php esc_html_e('Select General popup to display. You can search popup by its name or ID.', 'popup-anything-on-click'); ?></span><br/>
				<span class="description"><?php esc_html_e('Note : Type No Popup and choose it to do not display any popup on this page.', 'popup-anything-on-click'); ?></span>
			</td>
		</tr>
	</tbody>
</table>